package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Specifies a subnet for a load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * SourceNatIpv6Prefix sourceNatIpv6Prefix;
 * Subnet subnet;
 * SubnetMapping subnetMapping = SubnetMapping.builder()
 *         .subnet(subnet)
 *         // the properties below are optional
 *         .allocationId("allocationId")
 *         .ipv6Address("ipv6Address")
 *         .privateIpv4Address("privateIpv4Address")
 *         .sourceNatIpv6Prefix(sourceNatIpv6Prefix)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:15.561Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.SubnetMapping")
@software.amazon.jsii.Jsii.Proxy(SubnetMapping.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetMapping extends software.amazon.jsii.JsiiSerializable {

    /**
     * The subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet getSubnet();

    /**
     * The allocation ID of the Elastic IP address for an internet-facing load balancer.
     * <p>
     * Default: undefined - AWS default is to allocate a new IP address for internet-facing load balancers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllocationId() {
        return null;
    }

    /**
     * The IPv6 address.
     * <p>
     * Default: undefined - AWS default is to allocate an IPv6 address from the subnet's pool
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6Address() {
        return null;
    }

    /**
     * The private IPv4 address for an internal load balancer.
     * <p>
     * Default: undefined - AWS default is to allocate a private IPv4 address from the subnet's pool
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpv4Address() {
        return null;
    }

    /**
     * The IPv6 prefix to use for source NAT for a dual-stack network load balancer with UDP listeners.
     * <p>
     * Specify an IPv6 prefix (/80 netmask) from the subnet CIDR block
     * or <code>SourceNatIpv6Prefix.autoAssigned()</code> to use an IPv6 prefix selected at random from the subnet CIDR block.
     * <p>
     * Default: undefined - AWS default is `SourceNatIpv6Prefix.autoAssigned()` for IPv6 load balancers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix getSourceNatIpv6Prefix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SubnetMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubnetMapping> {
        software.amazon.awscdk.services.ec2.ISubnet subnet;
        java.lang.String allocationId;
        java.lang.String ipv6Address;
        java.lang.String privateIpv4Address;
        software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix sourceNatIpv6Prefix;

        /**
         * Sets the value of {@link SubnetMapping#getSubnet}
         * @param subnet The subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnet(software.amazon.awscdk.services.ec2.ISubnet subnet) {
            this.subnet = subnet;
            return this;
        }

        /**
         * Sets the value of {@link SubnetMapping#getAllocationId}
         * @param allocationId The allocation ID of the Elastic IP address for an internet-facing load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationId(java.lang.String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        /**
         * Sets the value of {@link SubnetMapping#getIpv6Address}
         * @param ipv6Address The IPv6 address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Address(java.lang.String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        /**
         * Sets the value of {@link SubnetMapping#getPrivateIpv4Address}
         * @param privateIpv4Address The private IPv4 address for an internal load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpv4Address(java.lang.String privateIpv4Address) {
            this.privateIpv4Address = privateIpv4Address;
            return this;
        }

        /**
         * Sets the value of {@link SubnetMapping#getSourceNatIpv6Prefix}
         * @param sourceNatIpv6Prefix The IPv6 prefix to use for source NAT for a dual-stack network load balancer with UDP listeners.
         *                            Specify an IPv6 prefix (/80 netmask) from the subnet CIDR block
         *                            or <code>SourceNatIpv6Prefix.autoAssigned()</code> to use an IPv6 prefix selected at random from the subnet CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceNatIpv6Prefix(software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix sourceNatIpv6Prefix) {
            this.sourceNatIpv6Prefix = sourceNatIpv6Prefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetMapping}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubnetMapping build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubnetMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetMapping {
        private final software.amazon.awscdk.services.ec2.ISubnet subnet;
        private final java.lang.String allocationId;
        private final java.lang.String ipv6Address;
        private final java.lang.String privateIpv4Address;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix sourceNatIpv6Prefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subnet = software.amazon.jsii.Kernel.get(this, "subnet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class));
            this.allocationId = software.amazon.jsii.Kernel.get(this, "allocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6Address = software.amazon.jsii.Kernel.get(this, "ipv6Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateIpv4Address = software.amazon.jsii.Kernel.get(this, "privateIpv4Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceNatIpv6Prefix = software.amazon.jsii.Kernel.get(this, "sourceNatIpv6Prefix", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subnet = java.util.Objects.requireNonNull(builder.subnet, "subnet is required");
            this.allocationId = builder.allocationId;
            this.ipv6Address = builder.ipv6Address;
            this.privateIpv4Address = builder.privateIpv4Address;
            this.sourceNatIpv6Prefix = builder.sourceNatIpv6Prefix;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISubnet getSubnet() {
            return this.subnet;
        }

        @Override
        public final java.lang.String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final java.lang.String getIpv6Address() {
            return this.ipv6Address;
        }

        @Override
        public final java.lang.String getPrivateIpv4Address() {
            return this.privateIpv4Address;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix getSourceNatIpv6Prefix() {
            return this.sourceNatIpv6Prefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subnet", om.valueToTree(this.getSubnet()));
            if (this.getAllocationId() != null) {
                data.set("allocationId", om.valueToTree(this.getAllocationId()));
            }
            if (this.getIpv6Address() != null) {
                data.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
            }
            if (this.getPrivateIpv4Address() != null) {
                data.set("privateIpv4Address", om.valueToTree(this.getPrivateIpv4Address()));
            }
            if (this.getSourceNatIpv6Prefix() != null) {
                data.set("sourceNatIpv6Prefix", om.valueToTree(this.getSourceNatIpv6Prefix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.SubnetMapping"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetMapping.Jsii$Proxy that = (SubnetMapping.Jsii$Proxy) o;

            if (!subnet.equals(that.subnet)) return false;
            if (this.allocationId != null ? !this.allocationId.equals(that.allocationId) : that.allocationId != null) return false;
            if (this.ipv6Address != null ? !this.ipv6Address.equals(that.ipv6Address) : that.ipv6Address != null) return false;
            if (this.privateIpv4Address != null ? !this.privateIpv4Address.equals(that.privateIpv4Address) : that.privateIpv4Address != null) return false;
            return this.sourceNatIpv6Prefix != null ? this.sourceNatIpv6Prefix.equals(that.sourceNatIpv6Prefix) : that.sourceNatIpv6Prefix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.subnet.hashCode();
            result = 31 * result + (this.allocationId != null ? this.allocationId.hashCode() : 0);
            result = 31 * result + (this.ipv6Address != null ? this.ipv6Address.hashCode() : 0);
            result = 31 * result + (this.privateIpv4Address != null ? this.privateIpv4Address.hashCode() : 0);
            result = 31 * result + (this.sourceNatIpv6Prefix != null ? this.sourceNatIpv6Prefix.hashCode() : 0);
            return result;
        }
    }
}
