package software.amazon.awscdk.services.emr;

/**
 * Properties for defining a <code>CfnInstanceGroupConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * ConfigurationProperty configurationProperty_;
 * CfnInstanceGroupConfigProps cfnInstanceGroupConfigProps = CfnInstanceGroupConfigProps.builder()
 *         .instanceCount(123)
 *         .instanceRole("instanceRole")
 *         .instanceType("instanceType")
 *         .jobFlowId("jobFlowId")
 *         // the properties below are optional
 *         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
 *                 .constraints(ScalingConstraintsProperty.builder()
 *                         .maxCapacity(123)
 *                         .minCapacity(123)
 *                         .build())
 *                 .rules(List.of(ScalingRuleProperty.builder()
 *                         .action(ScalingActionProperty.builder()
 *                                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
 *                                         .scalingAdjustment(123)
 *                                         // the properties below are optional
 *                                         .adjustmentType("adjustmentType")
 *                                         .coolDown(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .market("market")
 *                                 .build())
 *                         .name("name")
 *                         .trigger(ScalingTriggerProperty.builder()
 *                                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
 *                                         .comparisonOperator("comparisonOperator")
 *                                         .metricName("metricName")
 *                                         .period(123)
 *                                         .threshold(123)
 *                                         // the properties below are optional
 *                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                 .key("key")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .evaluationPeriods(123)
 *                                         .namespace("namespace")
 *                                         .statistic("statistic")
 *                                         .unit("unit")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .build())
 *         .bidPrice("bidPrice")
 *         .configurations(List.of(ConfigurationProperty.builder()
 *                 .classification("classification")
 *                 .configurationProperties(Map.of(
 *                         "configurationPropertiesKey", "configurationProperties"))
 *                 .configurations(List.of(configurationProperty_))
 *                 .build()))
 *         .customAmiId("customAmiId")
 *         .ebsConfiguration(EbsConfigurationProperty.builder()
 *                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                         .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                 .sizeInGb(123)
 *                                 .volumeType("volumeType")
 *                                 // the properties below are optional
 *                                 .iops(123)
 *                                 .throughput(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .volumesPerInstance(123)
 *                         .build()))
 *                 .ebsOptimized(false)
 *                 .build())
 *         .market("market")
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:15.696Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceGroupConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceGroupConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Target number of instances for the instance group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancecount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

    /**
     * The role of the instance group in the cluster.
     * <p>
     * <em>Allowed Values</em> : TASK
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancerole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceRole();

    /**
     * The Amazon EC2 instance type for all instances in the instance group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * The ID of an Amazon EMR cluster that you want to associate this instance group with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-jobflowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-jobflowid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobFlowId();

    /**
     * <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> .
     * <p>
     * <code>AutoScalingPolicy</code> defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html">Using Automatic Scaling in Amazon EMR</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-autoscalingpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-autoscalingpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoScalingPolicy() {
        return null;
    }

    /**
     * If specified, indicates that the instance group uses Spot Instances.
     * <p>
     * This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-bidprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-bidprice</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
        return null;
    }

    /**
     * <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
     * <p>
     * The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-configurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
        return null;
    }

    /**
     * The custom AMI ID to use for the provisioned instance group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-customamiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-customamiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
        return null;
    }

    /**
     * <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-ebsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-ebsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEbsConfiguration() {
        return null;
    }

    /**
     * Market type of the Amazon EC2 instances used to create a cluster node.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-market">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-market</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMarket() {
        return null;
    }

    /**
     * Friendly name given to the instance group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceGroupConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceGroupConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceGroupConfigProps> {
        java.lang.Number instanceCount;
        java.lang.String instanceRole;
        java.lang.String instanceType;
        java.lang.String jobFlowId;
        java.lang.Object autoScalingPolicy;
        java.lang.String bidPrice;
        java.lang.Object configurations;
        java.lang.String customAmiId;
        java.lang.Object ebsConfiguration;
        java.lang.String market;
        java.lang.String name;

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getInstanceCount}
         * @param instanceCount Target number of instances for the instance group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceCount(java.lang.Number instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getInstanceRole}
         * @param instanceRole The role of the instance group in the cluster. This parameter is required.
         *                     <em>Allowed Values</em> : TASK
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRole(java.lang.String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getInstanceType}
         * @param instanceType The Amazon EC2 instance type for all instances in the instance group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getJobFlowId}
         * @param jobFlowId The ID of an Amazon EMR cluster that you want to associate this instance group with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobFlowId(java.lang.String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getAutoScalingPolicy}
         * @param autoScalingPolicy <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> .
         *                          <code>AutoScalingPolicy</code> defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html">Using Automatic Scaling in Amazon EMR</a> in the <em>Amazon EMR Management Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingPolicy(software.amazon.awscdk.IResolvable autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getAutoScalingPolicy}
         * @param autoScalingPolicy <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> .
         *                          <code>AutoScalingPolicy</code> defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html">Using Automatic Scaling in Amazon EMR</a> in the <em>Amazon EMR Management Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingPolicy(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.AutoScalingPolicyProperty autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getBidPrice}
         * @param bidPrice If specified, indicates that the instance group uses Spot Instances.
         *                 This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bidPrice(java.lang.String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getConfigurations}
         * @param configurations <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
         *                       The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(software.amazon.awscdk.IResolvable configurations) {
            this.configurations = configurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getConfigurations}
         * @param configurations <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
         *                       The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
            this.configurations = configurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getCustomAmiId}
         * @param customAmiId The custom AMI ID to use for the provisioned instance group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAmiId(java.lang.String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getEbsConfiguration}
         * @param ebsConfiguration <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsConfiguration(software.amazon.awscdk.IResolvable ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getEbsConfiguration}
         * @param ebsConfiguration <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsConfiguration(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.EbsConfigurationProperty ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getMarket}
         * @param market Market type of the Amazon EC2 instances used to create a cluster node.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder market(java.lang.String market) {
            this.market = market;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceGroupConfigProps#getName}
         * @param name Friendly name given to the instance group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceGroupConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceGroupConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceGroupConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceGroupConfigProps {
        private final java.lang.Number instanceCount;
        private final java.lang.String instanceRole;
        private final java.lang.String instanceType;
        private final java.lang.String jobFlowId;
        private final java.lang.Object autoScalingPolicy;
        private final java.lang.String bidPrice;
        private final java.lang.Object configurations;
        private final java.lang.String customAmiId;
        private final java.lang.Object ebsConfiguration;
        private final java.lang.String market;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instanceRole = software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobFlowId = software.amazon.jsii.Kernel.get(this, "jobFlowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoScalingPolicy = software.amazon.jsii.Kernel.get(this, "autoScalingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bidPrice = software.amazon.jsii.Kernel.get(this, "bidPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customAmiId = software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ebsConfiguration = software.amazon.jsii.Kernel.get(this, "ebsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.market = software.amazon.jsii.Kernel.get(this, "market", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
            this.instanceRole = java.util.Objects.requireNonNull(builder.instanceRole, "instanceRole is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.jobFlowId = java.util.Objects.requireNonNull(builder.jobFlowId, "jobFlowId is required");
            this.autoScalingPolicy = builder.autoScalingPolicy;
            this.bidPrice = builder.bidPrice;
            this.configurations = builder.configurations;
            this.customAmiId = builder.customAmiId;
            this.ebsConfiguration = builder.ebsConfiguration;
            this.market = builder.market;
            this.name = builder.name;
        }

        @Override
        public final java.lang.Number getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final java.lang.String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final java.lang.Object getAutoScalingPolicy() {
            return this.autoScalingPolicy;
        }

        @Override
        public final java.lang.String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final java.lang.Object getConfigurations() {
            return this.configurations;
        }

        @Override
        public final java.lang.String getCustomAmiId() {
            return this.customAmiId;
        }

        @Override
        public final java.lang.Object getEbsConfiguration() {
            return this.ebsConfiguration;
        }

        @Override
        public final java.lang.String getMarket() {
            return this.market;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
            data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("jobFlowId", om.valueToTree(this.getJobFlowId()));
            if (this.getAutoScalingPolicy() != null) {
                data.set("autoScalingPolicy", om.valueToTree(this.getAutoScalingPolicy()));
            }
            if (this.getBidPrice() != null) {
                data.set("bidPrice", om.valueToTree(this.getBidPrice()));
            }
            if (this.getConfigurations() != null) {
                data.set("configurations", om.valueToTree(this.getConfigurations()));
            }
            if (this.getCustomAmiId() != null) {
                data.set("customAmiId", om.valueToTree(this.getCustomAmiId()));
            }
            if (this.getEbsConfiguration() != null) {
                data.set("ebsConfiguration", om.valueToTree(this.getEbsConfiguration()));
            }
            if (this.getMarket() != null) {
                data.set("market", om.valueToTree(this.getMarket()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceGroupConfigProps.Jsii$Proxy that = (CfnInstanceGroupConfigProps.Jsii$Proxy) o;

            if (!instanceCount.equals(that.instanceCount)) return false;
            if (!instanceRole.equals(that.instanceRole)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (!jobFlowId.equals(that.jobFlowId)) return false;
            if (this.autoScalingPolicy != null ? !this.autoScalingPolicy.equals(that.autoScalingPolicy) : that.autoScalingPolicy != null) return false;
            if (this.bidPrice != null ? !this.bidPrice.equals(that.bidPrice) : that.bidPrice != null) return false;
            if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
            if (this.customAmiId != null ? !this.customAmiId.equals(that.customAmiId) : that.customAmiId != null) return false;
            if (this.ebsConfiguration != null ? !this.ebsConfiguration.equals(that.ebsConfiguration) : that.ebsConfiguration != null) return false;
            if (this.market != null ? !this.market.equals(that.market) : that.market != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceCount.hashCode();
            result = 31 * result + (this.instanceRole.hashCode());
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.jobFlowId.hashCode());
            result = 31 * result + (this.autoScalingPolicy != null ? this.autoScalingPolicy.hashCode() : 0);
            result = 31 * result + (this.bidPrice != null ? this.bidPrice.hashCode() : 0);
            result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
            result = 31 * result + (this.customAmiId != null ? this.customAmiId.hashCode() : 0);
            result = 31 * result + (this.ebsConfiguration != null ? this.ebsConfiguration.hashCode() : 0);
            result = 31 * result + (this.market != null ? this.market.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
