package software.amazon.awscdk.services.fsx;

/**
 * Properties for defining a <code>CfnS3AccessPointAttachment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * Object policy;
 * CfnS3AccessPointAttachmentProps cfnS3AccessPointAttachmentProps = CfnS3AccessPointAttachmentProps.builder()
 *         .name("name")
 *         .openZfsConfiguration(S3AccessPointOpenZFSConfigurationProperty.builder()
 *                 .fileSystemIdentity(OpenZFSFileSystemIdentityProperty.builder()
 *                         .posixUser(OpenZFSPosixFileSystemUserProperty.builder()
 *                                 .gid(123)
 *                                 .uid(123)
 *                                 // the properties below are optional
 *                                 .secondaryGids(List.of(FileSystemGIDProperty.builder()
 *                                         .gid(123)
 *                                         .build()))
 *                                 .build())
 *                         .type("type")
 *                         .build())
 *                 .volumeId("volumeId")
 *                 .build())
 *         .type("type")
 *         // the properties below are optional
 *         .s3AccessPoint(S3AccessPointProperty.builder()
 *                 .alias("alias")
 *                 .policy(policy)
 *                 .resourceArn("resourceArn")
 *                 .vpcConfiguration(S3AccessPointVpcConfigurationProperty.builder()
 *                         .vpcId("vpcId")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:16.098Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnS3AccessPointAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnS3AccessPointAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnS3AccessPointAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the S3 access point attachment;
     * <p>
     * also used for the name of the S3 access point.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html#cfn-fsx-s3accesspointattachment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html#cfn-fsx-s3accesspointattachment-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The OpenZFSConfiguration of the S3 access point attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html#cfn-fsx-s3accesspointattachment-openzfsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html#cfn-fsx-s3accesspointattachment-openzfsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOpenZfsConfiguration();

    /**
     * The type of Amazon FSx volume that the S3 access point is attached to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html#cfn-fsx-s3accesspointattachment-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html#cfn-fsx-s3accesspointattachment-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The S3 access point configuration of the S3 access point attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html#cfn-fsx-s3accesspointattachment-s3accesspoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-s3accesspointattachment.html#cfn-fsx-s3accesspointattachment-s3accesspoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3AccessPoint() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnS3AccessPointAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnS3AccessPointAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnS3AccessPointAttachmentProps> {
        java.lang.String name;
        java.lang.Object openZfsConfiguration;
        java.lang.String type;
        java.lang.Object s3AccessPoint;

        /**
         * Sets the value of {@link CfnS3AccessPointAttachmentProps#getName}
         * @param name The name of the S3 access point attachment;. This parameter is required.
         *             also used for the name of the S3 access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnS3AccessPointAttachmentProps#getOpenZfsConfiguration}
         * @param openZfsConfiguration The OpenZFSConfiguration of the S3 access point attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(software.amazon.awscdk.IResolvable openZfsConfiguration) {
            this.openZfsConfiguration = openZfsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnS3AccessPointAttachmentProps#getOpenZfsConfiguration}
         * @param openZfsConfiguration The OpenZFSConfiguration of the S3 access point attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(software.amazon.awscdk.services.fsx.CfnS3AccessPointAttachment.S3AccessPointOpenZFSConfigurationProperty openZfsConfiguration) {
            this.openZfsConfiguration = openZfsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnS3AccessPointAttachmentProps#getType}
         * @param type The type of Amazon FSx volume that the S3 access point is attached to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnS3AccessPointAttachmentProps#getS3AccessPoint}
         * @param s3AccessPoint The S3 access point configuration of the S3 access point attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3AccessPoint(software.amazon.awscdk.IResolvable s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnS3AccessPointAttachmentProps#getS3AccessPoint}
         * @param s3AccessPoint The S3 access point configuration of the S3 access point attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3AccessPoint(software.amazon.awscdk.services.fsx.CfnS3AccessPointAttachment.S3AccessPointProperty s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnS3AccessPointAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnS3AccessPointAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnS3AccessPointAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnS3AccessPointAttachmentProps {
        private final java.lang.String name;
        private final java.lang.Object openZfsConfiguration;
        private final java.lang.String type;
        private final java.lang.Object s3AccessPoint;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.openZfsConfiguration = software.amazon.jsii.Kernel.get(this, "openZfsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3AccessPoint = software.amazon.jsii.Kernel.get(this, "s3AccessPoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.openZfsConfiguration = java.util.Objects.requireNonNull(builder.openZfsConfiguration, "openZfsConfiguration is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.s3AccessPoint = builder.s3AccessPoint;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOpenZfsConfiguration() {
            return this.openZfsConfiguration;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getS3AccessPoint() {
            return this.s3AccessPoint;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("openZfsConfiguration", om.valueToTree(this.getOpenZfsConfiguration()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getS3AccessPoint() != null) {
                data.set("s3AccessPoint", om.valueToTree(this.getS3AccessPoint()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnS3AccessPointAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnS3AccessPointAttachmentProps.Jsii$Proxy that = (CfnS3AccessPointAttachmentProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!openZfsConfiguration.equals(that.openZfsConfiguration)) return false;
            if (!type.equals(that.type)) return false;
            return this.s3AccessPoint != null ? this.s3AccessPoint.equals(that.s3AccessPoint) : that.s3AccessPoint == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.openZfsConfiguration.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.s3AccessPoint != null ? this.s3AccessPoint.hashCode() : 0);
            return result;
        }
    }
}
