package software.amazon.awscdk.services.globalaccelerator;

/**
 * The construct for the Listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create an Accelerator
 * Accelerator accelerator = new Accelerator(this, "Accelerator");
 * // Create a Listener
 * Listener listener = accelerator.addListener("Listener", ListenerOptions.builder()
 *         .portRanges(List.of(PortRange.builder().fromPort(80).build(), PortRange.builder().fromPort(443).build()))
 *         .build());
 * // Import the Load Balancers
 * INetworkLoadBalancer nlb1 = NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(this, "NLB1", NetworkLoadBalancerAttributes.builder()
 *         .loadBalancerArn("arn:aws:elasticloadbalancing:us-west-2:111111111111:loadbalancer/app/my-load-balancer1/e16bef66805b")
 *         .build());
 * INetworkLoadBalancer nlb2 = NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(this, "NLB2", NetworkLoadBalancerAttributes.builder()
 *         .loadBalancerArn("arn:aws:elasticloadbalancing:ap-south-1:111111111111:loadbalancer/app/my-load-balancer2/5513dc2ea8a1")
 *         .build());
 * // Add one EndpointGroup for each Region we are targeting
 * listener.addEndpointGroup("Group1", EndpointGroupOptions.builder()
 *         .endpoints(List.of(new NetworkLoadBalancerEndpoint(nlb1)))
 *         .build());
 * listener.addEndpointGroup("Group2", EndpointGroupOptions.builder()
 *         // Imported load balancers automatically calculate their Region from the ARN.
 *         // If you are load balancing to other resources, you must also pass a `region`
 *         // parameter here.
 *         .endpoints(List.of(new NetworkLoadBalancerEndpoint(nlb2)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:16.246Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.Listener")
public class Listener extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.globalaccelerator.IListener {

    protected Listener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Listener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.globalaccelerator.Listener.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Listener(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.ListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * import from ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param listenerArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.IListener fromListenerArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String listenerArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.globalaccelerator.Listener.class, "fromListenerArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.IListener.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(listenerArn, "listenerArn is required") });
    }

    /**
     * Add a new endpoint group to this listener.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.EndpointGroup addEndpointGroup(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.globalaccelerator.EndpointGroupOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addEndpointGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.EndpointGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Add a new endpoint group to this listener.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.EndpointGroup addEndpointGroup(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addEndpointGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.EndpointGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of the listener.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getListenerArn() {
        return software.amazon.jsii.Kernel.get(this, "listenerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getListenerName() {
        return software.amazon.jsii.Kernel.get(this, "listenerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.globalaccelerator.Listener}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.globalaccelerator.Listener> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.globalaccelerator.ListenerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.globalaccelerator.ListenerProps.Builder();
        }

        /**
         * The list of port ranges for the connections from clients to the accelerator.
         * <p>
         * @return {@code this}
         * @param portRanges The list of port ranges for the connections from clients to the accelerator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portRanges(final java.util.List<? extends software.amazon.awscdk.services.globalaccelerator.PortRange> portRanges) {
            this.props.portRanges(portRanges);
            return this;
        }

        /**
         * Client affinity to direct all requests from a user to the same endpoint.
         * <p>
         * If you have stateful applications, client affinity lets you direct all
         * requests from a user to the same endpoint.
         * <p>
         * By default, each connection from each client is routed to seperate
         * endpoints. Set client affinity to SOURCE_IP to route all connections from
         * a single client to the same endpoint.
         * <p>
         * Default: ClientAffinity.NONE
         * <p>
         * @return {@code this}
         * @param clientAffinity Client affinity to direct all requests from a user to the same endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientAffinity(final software.amazon.awscdk.services.globalaccelerator.ClientAffinity clientAffinity) {
            this.props.clientAffinity(clientAffinity);
            return this;
        }

        /**
         * Name of the listener.
         * <p>
         * Default: - logical ID of the resource
         * <p>
         * @return {@code this}
         * @param listenerName Name of the listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerName(final java.lang.String listenerName) {
            this.props.listenerName(listenerName);
            return this;
        }

        /**
         * The protocol for the connections from clients to the accelerator.
         * <p>
         * Default: ConnectionProtocol.TCP
         * <p>
         * @return {@code this}
         * @param protocol The protocol for the connections from clients to the accelerator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.globalaccelerator.ConnectionProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * The accelerator for this listener.
         * <p>
         * @return {@code this}
         * @param accelerator The accelerator for this listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerator(final software.amazon.awscdk.services.globalaccelerator.IAccelerator accelerator) {
            this.props.accelerator(accelerator);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.globalaccelerator.Listener}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.globalaccelerator.Listener build() {
            return new software.amazon.awscdk.services.globalaccelerator.Listener(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
