package software.amazon.awscdk.services.globalaccelerator.endpoints;

/**
 * Use an EC2 Instance as a Global Accelerator Endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Listener listener;
 * CfnEIP eip;
 * listener.addEndpointGroup("Group", EndpointGroupOptions.builder()
 *         .endpoints(List.of(
 *             CfnEipEndpoint.Builder.create(eip)
 *                     .weight(128)
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:16.250Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator_endpoints.CfnEipEndpoint")
public class CfnEipEndpoint extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.globalaccelerator.IEndpoint {

    protected CfnEipEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEipEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param eip This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEipEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnEIP eip, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpointProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(eip, "eip is required"), options });
    }

    /**
     * @param eip This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEipEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnEIP eip) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(eip, "eip is required") });
    }

    /**
     * Render the endpoint to an endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object renderEndpointConfiguration() {
        return software.amazon.jsii.Kernel.call(this, "renderEndpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The region where the endpoint is located.
     * <p>
     * If the region cannot be determined, <code>undefined</code> is returned
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param eip This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.ec2.CfnEIP eip) {
            return new Builder(eip);
        }

        private final software.amazon.awscdk.services.ec2.CfnEIP eip;
        private software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpointProps.Builder options;

        private Builder(final software.amazon.awscdk.services.ec2.CfnEIP eip) {
            this.eip = eip;
        }

        /**
         * Endpoint weight across all endpoints in the group.
         * <p>
         * Must be a value between 0 and 255.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param weight Endpoint weight across all endpoints in the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(final java.lang.Number weight) {
            this.options().weight(weight);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpoint build() {
            return new software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpoint(
                this.eip,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpointProps.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.globalaccelerator.endpoints.CfnEipEndpointProps.Builder();
            }
            return this.options;
        }
    }
}
