package software.amazon.awscdk.services.invoicing;

/**
 * Properties for defining a <code>CfnInvoiceUnit</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.invoicing.*;
 * CfnInvoiceUnitProps cfnInvoiceUnitProps = CfnInvoiceUnitProps.builder()
 *         .invoiceReceiver("invoiceReceiver")
 *         .name("name")
 *         .rule(RuleProperty.builder()
 *                 .linkedAccounts(List.of("linkedAccounts"))
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .resourceTags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taxInheritanceDisabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:16.816Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_invoicing.CfnInvoiceUnitProps")
@software.amazon.jsii.Jsii.Proxy(CfnInvoiceUnitProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInvoiceUnitProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The account that receives invoices related to the invoice unit.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-invoicereceiver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-invoicereceiver</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInvoiceReceiver();

    /**
     * A unique name that is distinctive within your AWS .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An <code>InvoiceUnitRule</code> object used the categorize invoice units.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-rule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRule();

    /**
     * The assigned description for an invoice unit.
     * <p>
     * This information can't be modified or deleted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The tag structure that contains a tag key and value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-resourcetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.ResourceTagProperty> getResourceTags() {
        return null;
    }

    /**
     * Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-taxinheritancedisabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-invoicing-invoiceunit.html#cfn-invoicing-invoiceunit-taxinheritancedisabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTaxInheritanceDisabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInvoiceUnitProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInvoiceUnitProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInvoiceUnitProps> {
        java.lang.String invoiceReceiver;
        java.lang.String name;
        java.lang.Object rule;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.ResourceTagProperty> resourceTags;
        java.lang.Object taxInheritanceDisabled;

        /**
         * Sets the value of {@link CfnInvoiceUnitProps#getInvoiceReceiver}
         * @param invoiceReceiver The account that receives invoices related to the invoice unit. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invoiceReceiver(java.lang.String invoiceReceiver) {
            this.invoiceReceiver = invoiceReceiver;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvoiceUnitProps#getName}
         * @param name A unique name that is distinctive within your AWS . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvoiceUnitProps#getRule}
         * @param rule An <code>InvoiceUnitRule</code> object used the categorize invoice units. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(software.amazon.awscdk.IResolvable rule) {
            this.rule = rule;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvoiceUnitProps#getRule}
         * @param rule An <code>InvoiceUnitRule</code> object used the categorize invoice units. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.RuleProperty rule) {
            this.rule = rule;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvoiceUnitProps#getDescription}
         * @param description The assigned description for an invoice unit.
         *                    This information can't be modified or deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvoiceUnitProps#getResourceTags}
         * @param resourceTags The tag structure that contains a tag key and value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resourceTags(java.util.List<? extends software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.ResourceTagProperty> resourceTags) {
            this.resourceTags = (java.util.List<software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.ResourceTagProperty>)resourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvoiceUnitProps#getTaxInheritanceDisabled}
         * @param taxInheritanceDisabled Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taxInheritanceDisabled(java.lang.Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnInvoiceUnitProps#getTaxInheritanceDisabled}
         * @param taxInheritanceDisabled Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taxInheritanceDisabled(software.amazon.awscdk.IResolvable taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInvoiceUnitProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInvoiceUnitProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInvoiceUnitProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInvoiceUnitProps {
        private final java.lang.String invoiceReceiver;
        private final java.lang.String name;
        private final java.lang.Object rule;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.ResourceTagProperty> resourceTags;
        private final java.lang.Object taxInheritanceDisabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.invoiceReceiver = software.amazon.jsii.Kernel.get(this, "invoiceReceiver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rule = software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.ResourceTagProperty.class)));
            this.taxInheritanceDisabled = software.amazon.jsii.Kernel.get(this, "taxInheritanceDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.invoiceReceiver = java.util.Objects.requireNonNull(builder.invoiceReceiver, "invoiceReceiver is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.rule = java.util.Objects.requireNonNull(builder.rule, "rule is required");
            this.description = builder.description;
            this.resourceTags = (java.util.List<software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.ResourceTagProperty>)builder.resourceTags;
            this.taxInheritanceDisabled = builder.taxInheritanceDisabled;
        }

        @Override
        public final java.lang.String getInvoiceReceiver() {
            return this.invoiceReceiver;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRule() {
            return this.rule;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.invoicing.CfnInvoiceUnit.ResourceTagProperty> getResourceTags() {
            return this.resourceTags;
        }

        @Override
        public final java.lang.Object getTaxInheritanceDisabled() {
            return this.taxInheritanceDisabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("invoiceReceiver", om.valueToTree(this.getInvoiceReceiver()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("rule", om.valueToTree(this.getRule()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getResourceTags() != null) {
                data.set("resourceTags", om.valueToTree(this.getResourceTags()));
            }
            if (this.getTaxInheritanceDisabled() != null) {
                data.set("taxInheritanceDisabled", om.valueToTree(this.getTaxInheritanceDisabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_invoicing.CfnInvoiceUnitProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInvoiceUnitProps.Jsii$Proxy that = (CfnInvoiceUnitProps.Jsii$Proxy) o;

            if (!invoiceReceiver.equals(that.invoiceReceiver)) return false;
            if (!name.equals(that.name)) return false;
            if (!rule.equals(that.rule)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.resourceTags != null ? !this.resourceTags.equals(that.resourceTags) : that.resourceTags != null) return false;
            return this.taxInheritanceDisabled != null ? this.taxInheritanceDisabled.equals(that.taxInheritanceDisabled) : that.taxInheritanceDisabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.invoiceReceiver.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.rule.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
            result = 31 * result + (this.taxInheritanceDisabled != null ? this.taxInheritanceDisabled.hashCode() : 0);
            return result;
        }
    }
}
