package software.amazon.awscdk.services.iotsitewise;

/**
 * Properties for defining a <code>CfnComputationModel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * ComputationModelDataBindingValueProperty computationModelDataBindingValueProperty_;
 * CfnComputationModelProps cfnComputationModelProps = CfnComputationModelProps.builder()
 *         .computationModelConfiguration(ComputationModelConfigurationProperty.builder()
 *                 .anomalyDetection(AnomalyDetectionComputationModelConfigurationProperty.builder()
 *                         .inputProperties("inputProperties")
 *                         .resultProperty("resultProperty")
 *                         .build())
 *                 .build())
 *         .computationModelDataBinding(Map.of(
 *                 "computationModelDataBindingKey", ComputationModelDataBindingValueProperty.builder()
 *                         .assetModelProperty(AssetModelPropertyBindingValueProperty.builder()
 *                                 .assetModelId("assetModelId")
 *                                 .propertyId("propertyId")
 *                                 .build())
 *                         .assetProperty(AssetPropertyBindingValueProperty.builder()
 *                                 .assetId("assetId")
 *                                 .propertyId("propertyId")
 *                                 .build())
 *                         .list(List.of(computationModelDataBindingValueProperty_))
 *                         .build()))
 *         .computationModelName("computationModelName")
 *         // the properties below are optional
 *         .computationModelDescription("computationModelDescription")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.164Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnComputationModelProps")
@software.amazon.jsii.Jsii.Proxy(CfnComputationModelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnComputationModelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComputationModelConfiguration();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldatabinding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldatabinding</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComputationModelDataBinding();

    /**
     * The name of the computation model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComputationModelName();

    /**
     * A description about the computation model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputationModelDescription() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnComputationModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnComputationModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnComputationModelProps> {
        java.lang.Object computationModelConfiguration;
        java.lang.Object computationModelDataBinding;
        java.lang.String computationModelName;
        java.lang.String computationModelDescription;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnComputationModelProps#getComputationModelConfiguration}
         * @param computationModelConfiguration the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelConfiguration(software.amazon.awscdk.IResolvable computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputationModelProps#getComputationModelConfiguration}
         * @param computationModelConfiguration the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelConfiguration(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.ComputationModelConfigurationProperty computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputationModelProps#getComputationModelDataBinding}
         * @param computationModelDataBinding the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelDataBinding(software.amazon.awscdk.IResolvable computationModelDataBinding) {
            this.computationModelDataBinding = computationModelDataBinding;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputationModelProps#getComputationModelDataBinding}
         * @param computationModelDataBinding the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelDataBinding(java.util.Map<java.lang.String, ? extends java.lang.Object> computationModelDataBinding) {
            this.computationModelDataBinding = computationModelDataBinding;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputationModelProps#getComputationModelName}
         * @param computationModelName The name of the computation model. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelName(java.lang.String computationModelName) {
            this.computationModelName = computationModelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputationModelProps#getComputationModelDescription}
         * @param computationModelDescription A description about the computation model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelDescription(java.lang.String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputationModelProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnComputationModelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnComputationModelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnComputationModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnComputationModelProps {
        private final java.lang.Object computationModelConfiguration;
        private final java.lang.Object computationModelDataBinding;
        private final java.lang.String computationModelName;
        private final java.lang.String computationModelDescription;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computationModelConfiguration = software.amazon.jsii.Kernel.get(this, "computationModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.computationModelDataBinding = software.amazon.jsii.Kernel.get(this, "computationModelDataBinding", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.computationModelName = software.amazon.jsii.Kernel.get(this, "computationModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computationModelDescription = software.amazon.jsii.Kernel.get(this, "computationModelDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computationModelConfiguration = java.util.Objects.requireNonNull(builder.computationModelConfiguration, "computationModelConfiguration is required");
            this.computationModelDataBinding = java.util.Objects.requireNonNull(builder.computationModelDataBinding, "computationModelDataBinding is required");
            this.computationModelName = java.util.Objects.requireNonNull(builder.computationModelName, "computationModelName is required");
            this.computationModelDescription = builder.computationModelDescription;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getComputationModelConfiguration() {
            return this.computationModelConfiguration;
        }

        @Override
        public final java.lang.Object getComputationModelDataBinding() {
            return this.computationModelDataBinding;
        }

        @Override
        public final java.lang.String getComputationModelName() {
            return this.computationModelName;
        }

        @Override
        public final java.lang.String getComputationModelDescription() {
            return this.computationModelDescription;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computationModelConfiguration", om.valueToTree(this.getComputationModelConfiguration()));
            data.set("computationModelDataBinding", om.valueToTree(this.getComputationModelDataBinding()));
            data.set("computationModelName", om.valueToTree(this.getComputationModelName()));
            if (this.getComputationModelDescription() != null) {
                data.set("computationModelDescription", om.valueToTree(this.getComputationModelDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnComputationModelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnComputationModelProps.Jsii$Proxy that = (CfnComputationModelProps.Jsii$Proxy) o;

            if (!computationModelConfiguration.equals(that.computationModelConfiguration)) return false;
            if (!computationModelDataBinding.equals(that.computationModelDataBinding)) return false;
            if (!computationModelName.equals(that.computationModelName)) return false;
            if (this.computationModelDescription != null ? !this.computationModelDescription.equals(that.computationModelDescription) : that.computationModelDescription != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computationModelConfiguration.hashCode();
            result = 31 * result + (this.computationModelDataBinding.hashCode());
            result = 31 * result + (this.computationModelName.hashCode());
            result = 31 * result + (this.computationModelDescription != null ? this.computationModelDescription.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
