package software.amazon.awscdk.services.iotwireless;

/**
 * Properties for defining a <code>CfnPartnerAccount</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnPartnerAccountProps cfnPartnerAccountProps = CfnPartnerAccountProps.builder()
 *         .accountLinked(false)
 *         .partnerAccountId("partnerAccountId")
 *         .partnerType("partnerType")
 *         .sidewalk(SidewalkAccountInfoProperty.builder()
 *                 .appServerPrivateKey("appServerPrivateKey")
 *                 .build())
 *         .sidewalkResponse(SidewalkAccountInfoWithFingerprintProperty.builder()
 *                 .amazonId("amazonId")
 *                 .arn("arn")
 *                 .fingerprint("fingerprint")
 *                 .build())
 *         .sidewalkUpdate(SidewalkUpdateAccountProperty.builder()
 *                 .appServerPrivateKey("appServerPrivateKey")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.238Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnPartnerAccountProps")
@software.amazon.jsii.Jsii.Proxy(CfnPartnerAccountProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPartnerAccountProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the partner account is linked to the AWS account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-accountlinked">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-accountlinked</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccountLinked() {
        return null;
    }

    /**
     * The ID of the partner account to update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-partneraccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-partneraccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPartnerAccountId() {
        return null;
    }

    /**
     * The partner type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-partnertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-partnertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPartnerType() {
        return null;
    }

    /**
     * The Sidewalk account credentials.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalk</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSidewalk() {
        return null;
    }

    /**
     * Information about a Sidewalk account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkresponse</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSidewalkResponse() {
        return null;
    }

    /**
     * Sidewalk update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkupdate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSidewalkUpdate() {
        return null;
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     * <p>
     * Tags can have a minimum of 0 and a maximum of 50 items.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPartnerAccountProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPartnerAccountProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPartnerAccountProps> {
        java.lang.Object accountLinked;
        java.lang.String partnerAccountId;
        java.lang.String partnerType;
        java.lang.Object sidewalk;
        java.lang.Object sidewalkResponse;
        java.lang.Object sidewalkUpdate;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getAccountLinked}
         * @param accountLinked Whether the partner account is linked to the AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountLinked(java.lang.Boolean accountLinked) {
            this.accountLinked = accountLinked;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getAccountLinked}
         * @param accountLinked Whether the partner account is linked to the AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountLinked(software.amazon.awscdk.IResolvable accountLinked) {
            this.accountLinked = accountLinked;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getPartnerAccountId}
         * @param partnerAccountId The ID of the partner account to update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerAccountId(java.lang.String partnerAccountId) {
            this.partnerAccountId = partnerAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getPartnerType}
         * @param partnerType The partner type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerType(java.lang.String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getSidewalk}
         * @param sidewalk The Sidewalk account credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalk(software.amazon.awscdk.IResolvable sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getSidewalk}
         * @param sidewalk The Sidewalk account credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalk(software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkAccountInfoProperty sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getSidewalkResponse}
         * @param sidewalkResponse Information about a Sidewalk account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalkResponse(software.amazon.awscdk.IResolvable sidewalkResponse) {
            this.sidewalkResponse = sidewalkResponse;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getSidewalkResponse}
         * @param sidewalkResponse Information about a Sidewalk account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalkResponse(software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkAccountInfoWithFingerprintProperty sidewalkResponse) {
            this.sidewalkResponse = sidewalkResponse;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getSidewalkUpdate}
         * @param sidewalkUpdate Sidewalk update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalkUpdate(software.amazon.awscdk.IResolvable sidewalkUpdate) {
            this.sidewalkUpdate = sidewalkUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getSidewalkUpdate}
         * @param sidewalkUpdate Sidewalk update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalkUpdate(software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkUpdateAccountProperty sidewalkUpdate) {
            this.sidewalkUpdate = sidewalkUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAccountProps#getTags}
         * @param tags The tags are an array of key-value pairs to attach to the specified resource.
         *             Tags can have a minimum of 0 and a maximum of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPartnerAccountProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPartnerAccountProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPartnerAccountProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPartnerAccountProps {
        private final java.lang.Object accountLinked;
        private final java.lang.String partnerAccountId;
        private final java.lang.String partnerType;
        private final java.lang.Object sidewalk;
        private final java.lang.Object sidewalkResponse;
        private final java.lang.Object sidewalkUpdate;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountLinked = software.amazon.jsii.Kernel.get(this, "accountLinked", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.partnerAccountId = software.amazon.jsii.Kernel.get(this, "partnerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.partnerType = software.amazon.jsii.Kernel.get(this, "partnerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sidewalk = software.amazon.jsii.Kernel.get(this, "sidewalk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sidewalkResponse = software.amazon.jsii.Kernel.get(this, "sidewalkResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sidewalkUpdate = software.amazon.jsii.Kernel.get(this, "sidewalkUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountLinked = builder.accountLinked;
            this.partnerAccountId = builder.partnerAccountId;
            this.partnerType = builder.partnerType;
            this.sidewalk = builder.sidewalk;
            this.sidewalkResponse = builder.sidewalkResponse;
            this.sidewalkUpdate = builder.sidewalkUpdate;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAccountLinked() {
            return this.accountLinked;
        }

        @Override
        public final java.lang.String getPartnerAccountId() {
            return this.partnerAccountId;
        }

        @Override
        public final java.lang.String getPartnerType() {
            return this.partnerType;
        }

        @Override
        public final java.lang.Object getSidewalk() {
            return this.sidewalk;
        }

        @Override
        public final java.lang.Object getSidewalkResponse() {
            return this.sidewalkResponse;
        }

        @Override
        public final java.lang.Object getSidewalkUpdate() {
            return this.sidewalkUpdate;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountLinked() != null) {
                data.set("accountLinked", om.valueToTree(this.getAccountLinked()));
            }
            if (this.getPartnerAccountId() != null) {
                data.set("partnerAccountId", om.valueToTree(this.getPartnerAccountId()));
            }
            if (this.getPartnerType() != null) {
                data.set("partnerType", om.valueToTree(this.getPartnerType()));
            }
            if (this.getSidewalk() != null) {
                data.set("sidewalk", om.valueToTree(this.getSidewalk()));
            }
            if (this.getSidewalkResponse() != null) {
                data.set("sidewalkResponse", om.valueToTree(this.getSidewalkResponse()));
            }
            if (this.getSidewalkUpdate() != null) {
                data.set("sidewalkUpdate", om.valueToTree(this.getSidewalkUpdate()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnPartnerAccountProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPartnerAccountProps.Jsii$Proxy that = (CfnPartnerAccountProps.Jsii$Proxy) o;

            if (this.accountLinked != null ? !this.accountLinked.equals(that.accountLinked) : that.accountLinked != null) return false;
            if (this.partnerAccountId != null ? !this.partnerAccountId.equals(that.partnerAccountId) : that.partnerAccountId != null) return false;
            if (this.partnerType != null ? !this.partnerType.equals(that.partnerType) : that.partnerType != null) return false;
            if (this.sidewalk != null ? !this.sidewalk.equals(that.sidewalk) : that.sidewalk != null) return false;
            if (this.sidewalkResponse != null ? !this.sidewalkResponse.equals(that.sidewalkResponse) : that.sidewalkResponse != null) return false;
            if (this.sidewalkUpdate != null ? !this.sidewalkUpdate.equals(that.sidewalkUpdate) : that.sidewalkUpdate != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountLinked != null ? this.accountLinked.hashCode() : 0;
            result = 31 * result + (this.partnerAccountId != null ? this.partnerAccountId.hashCode() : 0);
            result = 31 * result + (this.partnerType != null ? this.partnerType.hashCode() : 0);
            result = 31 * result + (this.sidewalk != null ? this.sidewalk.hashCode() : 0);
            result = 31 * result + (this.sidewalkResponse != null ? this.sidewalkResponse.hashCode() : 0);
            result = 31 * result + (this.sidewalkUpdate != null ? this.sidewalkUpdate.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
