package software.amazon.awscdk.services.kendra;

/**
 * Properties for defining a <code>CfnIndex</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kendra.*;
 * CfnIndexProps cfnIndexProps = CfnIndexProps.builder()
 *         .edition("edition")
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .capacityUnits(CapacityUnitsConfigurationProperty.builder()
 *                 .queryCapacityUnits(123)
 *                 .storageCapacityUnits(123)
 *                 .build())
 *         .description("description")
 *         .documentMetadataConfigurations(List.of(DocumentMetadataConfigurationProperty.builder()
 *                 .name("name")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .relevance(RelevanceProperty.builder()
 *                         .duration("duration")
 *                         .freshness(false)
 *                         .importance(123)
 *                         .rankOrder("rankOrder")
 *                         .valueImportanceItems(List.of(ValueImportanceItemProperty.builder()
 *                                 .key("key")
 *                                 .value(123)
 *                                 .build()))
 *                         .build())
 *                 .search(SearchProperty.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                 .build()))
 *         .serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userContextPolicy("userContextPolicy")
 *         .userTokenConfigurations(List.of(UserTokenConfigurationProperty.builder()
 *                 .jsonTokenTypeConfiguration(JsonTokenTypeConfigurationProperty.builder()
 *                         .groupAttributeField("groupAttributeField")
 *                         .userNameAttributeField("userNameAttributeField")
 *                         .build())
 *                 .jwtTokenTypeConfiguration(JwtTokenTypeConfigurationProperty.builder()
 *                         .keyLocation("keyLocation")
 *                         // the properties below are optional
 *                         .claimRegex("claimRegex")
 *                         .groupAttributeField("groupAttributeField")
 *                         .issuer("issuer")
 *                         .secretManagerArn("secretManagerArn")
 *                         .url("url")
 *                         .userNameAttributeField("userNameAttributeField")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.397Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndexProps")
@software.amazon.jsii.Jsii.Proxy(CfnIndexProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIndexProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether the index is a Enterprise Edition index, a Developer Edition index, or a GenAI Enterprise Edition index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEdition();

    /**
     * The name of the index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics.
     * <p>
     * This is also the role used when you use the <a href="https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html">BatchPutDocument</a> operation to index documents from an Amazon S3 bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Specifies additional capacity units configured for your Enterprise Edition index.
     * <p>
     * You can add and remove capacity units to fit your usage requirements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityUnits() {
        return null;
    }

    /**
     * A description for the index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies the properties of an index field.
     * <p>
     * You can add either a custom or a built-in field. You can add and remove built-in fields at any time. When a built-in field is removed it's configuration reverts to the default for the field. Custom fields can't be removed from an index after they are added.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentMetadataConfigurations() {
        return null;
    }

    /**
     * The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
     * <p>
     * Amazon Kendra doesn't support asymmetric CMKs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The user context policy.
     * <p>
     * ATTRIBUTE_FILTER
     * <p>
     * <ul>
     * <li>All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code> .</li>
     * </ul>
     * <p>
     * USER_TOKEN
     * <p>
     * <ul>
     * <li>Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserContextPolicy() {
        return null;
    }

    /**
     * Defines the type of user token used for the index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserTokenConfigurations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIndexProps> {
        java.lang.String edition;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.Object capacityUnits;
        java.lang.String description;
        java.lang.Object documentMetadataConfigurations;
        java.lang.Object serverSideEncryptionConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String userContextPolicy;
        java.lang.Object userTokenConfigurations;

        /**
         * Sets the value of {@link CfnIndexProps#getEdition}
         * @param edition Indicates whether the index is a Enterprise Edition index, a Developer Edition index, or a GenAI Enterprise Edition index. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edition(java.lang.String edition) {
            this.edition = edition;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getName}
         * @param name The name of the index. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getRoleArn}
         * @param roleArn An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This parameter is required.
         *                This is also the role used when you use the <a href="https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html">BatchPutDocument</a> operation to index documents from an Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getCapacityUnits}
         * @param capacityUnits Specifies additional capacity units configured for your Enterprise Edition index.
         *                      You can add and remove capacity units to fit your usage requirements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityUnits(software.amazon.awscdk.IResolvable capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getCapacityUnits}
         * @param capacityUnits Specifies additional capacity units configured for your Enterprise Edition index.
         *                      You can add and remove capacity units to fit your usage requirements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityUnits(software.amazon.awscdk.services.kendra.CfnIndex.CapacityUnitsConfigurationProperty capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getDescription}
         * @param description A description for the index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getDocumentMetadataConfigurations}
         * @param documentMetadataConfigurations Specifies the properties of an index field.
         *                                       You can add either a custom or a built-in field. You can add and remove built-in fields at any time. When a built-in field is removed it's configuration reverts to the default for the field. Custom fields can't be removed from an index after they are added.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentMetadataConfigurations(software.amazon.awscdk.IResolvable documentMetadataConfigurations) {
            this.documentMetadataConfigurations = documentMetadataConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getDocumentMetadataConfigurations}
         * @param documentMetadataConfigurations Specifies the properties of an index field.
         *                                       You can add either a custom or a built-in field. You can add and remove built-in fields at any time. When a built-in field is removed it's configuration reverts to the default for the field. Custom fields can't be removed from an index after they are added.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentMetadataConfigurations(java.util.List<? extends java.lang.Object> documentMetadataConfigurations) {
            this.documentMetadataConfigurations = documentMetadataConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getServerSideEncryptionConfiguration}
         * @param serverSideEncryptionConfiguration The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
         *                                          Amazon Kendra doesn't support asymmetric CMKs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.IResolvable serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getServerSideEncryptionConfiguration}
         * @param serverSideEncryptionConfiguration The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
         *                                          Amazon Kendra doesn't support asymmetric CMKs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.services.kendra.CfnIndex.ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getUserContextPolicy}
         * @param userContextPolicy The user context policy.
         *                          ATTRIBUTE_FILTER
         *                          <p>
         *                          <ul>
         *                          <li>All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code> .</li>
         *                          </ul>
         *                          <p>
         *                          USER_TOKEN
         *                          <p>
         *                          <ul>
         *                          <li>Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userContextPolicy(java.lang.String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getUserTokenConfigurations}
         * @param userTokenConfigurations Defines the type of user token used for the index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userTokenConfigurations(software.amazon.awscdk.IResolvable userTokenConfigurations) {
            this.userTokenConfigurations = userTokenConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getUserTokenConfigurations}
         * @param userTokenConfigurations Defines the type of user token used for the index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userTokenConfigurations(java.util.List<? extends java.lang.Object> userTokenConfigurations) {
            this.userTokenConfigurations = userTokenConfigurations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIndexProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIndexProps {
        private final java.lang.String edition;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.Object capacityUnits;
        private final java.lang.String description;
        private final java.lang.Object documentMetadataConfigurations;
        private final java.lang.Object serverSideEncryptionConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String userContextPolicy;
        private final java.lang.Object userTokenConfigurations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.edition = software.amazon.jsii.Kernel.get(this, "edition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.capacityUnits = software.amazon.jsii.Kernel.get(this, "capacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.documentMetadataConfigurations = software.amazon.jsii.Kernel.get(this, "documentMetadataConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serverSideEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userContextPolicy = software.amazon.jsii.Kernel.get(this, "userContextPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userTokenConfigurations = software.amazon.jsii.Kernel.get(this, "userTokenConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.edition = java.util.Objects.requireNonNull(builder.edition, "edition is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.capacityUnits = builder.capacityUnits;
            this.description = builder.description;
            this.documentMetadataConfigurations = builder.documentMetadataConfigurations;
            this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userContextPolicy = builder.userContextPolicy;
            this.userTokenConfigurations = builder.userTokenConfigurations;
        }

        @Override
        public final java.lang.String getEdition() {
            return this.edition;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getCapacityUnits() {
            return this.capacityUnits;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getDocumentMetadataConfigurations() {
            return this.documentMetadataConfigurations;
        }

        @Override
        public final java.lang.Object getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUserContextPolicy() {
            return this.userContextPolicy;
        }

        @Override
        public final java.lang.Object getUserTokenConfigurations() {
            return this.userTokenConfigurations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("edition", om.valueToTree(this.getEdition()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getCapacityUnits() != null) {
                data.set("capacityUnits", om.valueToTree(this.getCapacityUnits()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDocumentMetadataConfigurations() != null) {
                data.set("documentMetadataConfigurations", om.valueToTree(this.getDocumentMetadataConfigurations()));
            }
            if (this.getServerSideEncryptionConfiguration() != null) {
                data.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserContextPolicy() != null) {
                data.set("userContextPolicy", om.valueToTree(this.getUserContextPolicy()));
            }
            if (this.getUserTokenConfigurations() != null) {
                data.set("userTokenConfigurations", om.valueToTree(this.getUserTokenConfigurations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndexProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIndexProps.Jsii$Proxy that = (CfnIndexProps.Jsii$Proxy) o;

            if (!edition.equals(that.edition)) return false;
            if (!name.equals(that.name)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.capacityUnits != null ? !this.capacityUnits.equals(that.capacityUnits) : that.capacityUnits != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.documentMetadataConfigurations != null ? !this.documentMetadataConfigurations.equals(that.documentMetadataConfigurations) : that.documentMetadataConfigurations != null) return false;
            if (this.serverSideEncryptionConfiguration != null ? !this.serverSideEncryptionConfiguration.equals(that.serverSideEncryptionConfiguration) : that.serverSideEncryptionConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.userContextPolicy != null ? !this.userContextPolicy.equals(that.userContextPolicy) : that.userContextPolicy != null) return false;
            return this.userTokenConfigurations != null ? this.userTokenConfigurations.equals(that.userTokenConfigurations) : that.userTokenConfigurations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.edition.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.capacityUnits != null ? this.capacityUnits.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.documentMetadataConfigurations != null ? this.documentMetadataConfigurations.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userContextPolicy != null ? this.userContextPolicy.hashCode() : 0);
            result = 31 * result + (this.userTokenConfigurations != null ? this.userTokenConfigurations.hashCode() : 0);
            return result;
        }
    }
}
