package software.amazon.awscdk.services.kms;

/**
 * The <code>AWS::KMS::Key</code> resource specifies an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys">KMS key</a> in AWS Key Management Service . You can use this resource to create symmetric encryption KMS keys, asymmetric KMS keys for encryption or signing, and symmetric HMAC KMS keys. You can use <code>AWS::KMS::Key</code> to create <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-primary-key">multi-Region primary keys</a> of all supported types. To replicate a multi-Region key, use the <code>AWS::KMS::ReplicaKey</code> resource.
 * <p>
 * <blockquote>
 * <p>
 * If you change the value of the <code>KeySpec</code> , <code>KeyUsage</code> , <code>Origin</code> , or <code>MultiRegion</code> properties of an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing any of its immutable property values. &gt; AWS KMS replaced the term <em>customer master key (CMK)</em> with <em>AWS KMS key</em> and <em>KMS key</em> . The concept has not changed. To prevent breaking changes, AWS KMS is keeping some variations of this term.
 * <p>
 * </blockquote>
 * <p>
 * You can use symmetric encryption KMS keys to encrypt and decrypt small amounts of data, but they are more commonly used to generate data keys and data key pairs. You can also use a symmetric encryption KMS key to encrypt data stored in AWS services that are <a href="https://docs.aws.amazon.com//kms/features/#AWS_Service_Integration">integrated with AWS KMS</a> . For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks">Symmetric encryption KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
 * <p>
 * You can use asymmetric KMS keys to encrypt and decrypt data or sign messages and verify signatures. To create an asymmetric key, you must specify an asymmetric <code>KeySpec</code> value and a <code>KeyUsage</code> value. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
 * <p>
 * You can use HMAC KMS keys (which are also symmetric keys) to generate and verify hash-based message authentication codes. To create an HMAC key, you must specify an HMAC <code>KeySpec</code> value and a <code>KeyUsage</code> value of <code>GENERATE_VERIFY_MAC</code> . For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
 * <p>
 * You can also create symmetric encryption, asymmetric, and HMAC multi-Region primary keys. To create a multi-Region primary key, set the <code>MultiRegion</code> property to <code>true</code> . For information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
 * <p>
 * You cannot use the <code>AWS::KMS::Key</code> resource to specify a KMS key with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a> or a KMS key in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> .
 * <p>
 * <em>Regions</em>
 * <p>
 * AWS KMS CloudFormation resources are available in all Regions in which AWS KMS and AWS CloudFormation are supported. You can use the <code>AWS::KMS::Key</code> resource to create and manage all KMS key types that are supported in a Region.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * Key kmsKey = new Key(this, "myKMSKey");
 * Bucket myBucket = Bucket.Builder.create(this, "mySSEKMSEncryptedBucket")
 *         .encryption(BucketEncryption.KMS)
 *         .encryptionKey(kmsKey)
 *         .objectOwnership(ObjectOwnership.BUCKET_OWNER_ENFORCED)
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(S3BucketOrigin.withOriginAccessControl(myBucket))
 *                 .build())
 *         .build();
 * // Add the following to scope down the key policy
 * Map&lt;String, Object&gt; scopedDownKeyPolicy = Map.of(
 *         "Version", "2012-10-17",
 *         "Statement", List.of(Map.of(
 *                 "Effect", "Allow",
 *                 "Principal", Map.of(
 *                         "AWS", "arn:aws:iam::111122223333:root"),
 *                 "Action", "kms:*",
 *                 "Resource", "*"), Map.of(
 *                 "Effect", "Allow",
 *                 "Principal", Map.of(
 *                         "Service", "cloudfront.amazonaws.com"),
 *                 "Action", List.of("kms:Decrypt", "kms:Encrypt", "kms:GenerateDataKey*"),
 *                 "Resource", "*",
 *                 "Condition", Map.of(
 *                         "StringEquals", Map.of(
 *                                 "AWS:SourceArn", "arn:aws:cloudfront::111122223333:distribution/&lt;CloudFront distribution ID&gt;")))));
 * CfnKey cfnKey = ((CfnKey)kmsKey.getNode().getDefaultChild());
 * cfnKey.getKeyPolicy() = scopedDownKeyPolicy;
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.651Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.CfnKey")
public class CfnKey extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kms.CfnKey.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.CfnKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the KMS key, such as <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> .
     * <p>
     * For information about the key ARN of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">Key ARN</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The key ID of the KMS key, such as <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> .
     * <p>
     * For information about the key ID of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key ID</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKeyId() {
        return software.amazon.jsii.Kernel.get(this, "attrKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Skips ("bypasses") the key policy lockout safety check.
     * <p>
     * The default value is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBypassPolicyLockoutSafetyCheck() {
        return software.amazon.jsii.Kernel.get(this, "bypassPolicyLockoutSafetyCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Skips ("bypasses") the key policy lockout safety check.
     * <p>
     * The default value is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBypassPolicyLockoutSafetyCheck(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "bypassPolicyLockoutSafetyCheck", value);
    }

    /**
     * Skips ("bypasses") the key policy lockout safety check.
     * <p>
     * The default value is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBypassPolicyLockoutSafetyCheck(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bypassPolicyLockoutSafetyCheck", value);
    }

    /**
     * A description of the KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies whether the KMS key is enabled.
     * <p>
     * Disabled KMS keys cannot be used in cryptographic operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the KMS key is enabled.
     * <p>
     * Disabled KMS keys cannot be used in cryptographic operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Specifies whether the KMS key is enabled.
     * <p>
     * Disabled KMS keys cannot be used in cryptographic operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Enables automatic rotation of the key material for the specified KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableKeyRotation() {
        return software.amazon.jsii.Kernel.get(this, "enableKeyRotation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables automatic rotation of the key material for the specified KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableKeyRotation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableKeyRotation", value);
    }

    /**
     * Enables automatic rotation of the key material for the specified KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableKeyRotation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableKeyRotation", value);
    }

    /**
     * The key policy to attach to the KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKeyPolicy() {
        return software.amazon.jsii.Kernel.get(this, "keyPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The key policy to attach to the KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyPolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "keyPolicy", value);
    }

    /**
     * Specifies the type of KMS key to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeySpec() {
        return software.amazon.jsii.Kernel.get(this, "keySpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the type of KMS key to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeySpec(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keySpec", value);
    }

    /**
     * Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code> . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyUsage() {
        return software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code> . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyUsage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyUsage", value);
    }

    /**
     * Creates a multi-Region primary key that you can replicate in other AWS Regions .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegion() {
        return software.amazon.jsii.Kernel.get(this, "multiRegion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Creates a multi-Region primary key that you can replicate in other AWS Regions .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegion(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiRegion", value);
    }

    /**
     * Creates a multi-Region primary key that you can replicate in other AWS Regions .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiRegion", value);
    }

    /**
     * The source of the key material for the KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOrigin() {
        return software.amazon.jsii.Kernel.get(this, "origin", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The source of the key material for the KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrigin(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "origin", value);
    }

    /**
     * Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPendingWindowInDays() {
        return software.amazon.jsii.Kernel.get(this, "pendingWindowInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPendingWindowInDays(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "pendingWindowInDays", value);
    }

    /**
     * Specifies a custom period of time between each rotation date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRotationPeriodInDays() {
        return software.amazon.jsii.Kernel.get(this, "rotationPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies a custom period of time between each rotation date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationPeriodInDays(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "rotationPeriodInDays", value);
    }

    /**
     * Assigns one or more tags to the replica key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Assigns one or more tags to the replica key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kms.CfnKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kms.CfnKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.kms.CfnKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Skips ("bypasses") the key policy lockout safety check. The default value is false.
         * <p>
         * <blockquote>
         * <p>
         * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-bypasspolicylockoutsafetycheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-bypasspolicylockoutsafetycheck</a>
         * @param bypassPolicyLockoutSafetyCheck Skips ("bypasses") the key policy lockout safety check. The default value is false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutSafetyCheck(final java.lang.Boolean bypassPolicyLockoutSafetyCheck) {
            this.props().bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
            return this;
        }
        /**
         * Skips ("bypasses") the key policy lockout safety check. The default value is false.
         * <p>
         * <blockquote>
         * <p>
         * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-bypasspolicylockoutsafetycheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-bypasspolicylockoutsafetycheck</a>
         * @param bypassPolicyLockoutSafetyCheck Skips ("bypasses") the key policy lockout safety check. The default value is false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutSafetyCheck(final software.amazon.awscdk.IResolvable bypassPolicyLockoutSafetyCheck) {
            this.props().bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
            return this;
        }

        /**
         * A description of the KMS key.
         * <p>
         * Use a description that helps you to distinguish this KMS key from others in the account, such as its intended use.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-description</a>
         * @param description A description of the KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
         * <p>
         * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
         * <p>
         * The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
         * <p>
         * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enabled</a>
         * @param enabled Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }
        /**
         * Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
         * <p>
         * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
         * <p>
         * The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
         * <p>
         * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enabled</a>
         * @param enabled Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final software.amazon.awscdk.IResolvable enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * Enables automatic rotation of the key material for the specified KMS key.
         * <p>
         * By default, automatic key rotation is not enabled.
         * <p>
         * AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys, HMAC KMS keys, and KMS keys with Origin <code>EXTERNAL</code> , omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
         * <p>
         * To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enablekeyrotation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enablekeyrotation</a>
         * @param enableKeyRotation Enables automatic rotation of the key material for the specified KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(final java.lang.Boolean enableKeyRotation) {
            this.props().enableKeyRotation(enableKeyRotation);
            return this;
        }
        /**
         * Enables automatic rotation of the key material for the specified KMS key.
         * <p>
         * By default, automatic key rotation is not enabled.
         * <p>
         * AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys, HMAC KMS keys, and KMS keys with Origin <code>EXTERNAL</code> , omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
         * <p>
         * To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enablekeyrotation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enablekeyrotation</a>
         * @param enableKeyRotation Enables automatic rotation of the key material for the specified KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(final software.amazon.awscdk.IResolvable enableKeyRotation) {
            this.props().enableKeyRotation(enableKeyRotation);
            return this;
        }

        /**
         * The key policy to attach to the KMS key.
         * <p>
         * If you provide a key policy, it must meet the following criteria:
         * <p>
         * <ul>
         * <li>The key policy must allow the caller to make a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> . (To omit this condition, set <code>BypassPolicyLockoutSafetyCheck</code> to true.)</li>
         * <li>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS . When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS . For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <em>AWS Identity and Access Management User Guide</em> .</li>
         * </ul>
         * <p>
         * If you do not provide a key policy, AWS KMS attaches a default key policy to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * A key policy document can include only the following characters:
         * <p>
         * <ul>
         * <li>Printable ASCII characters</li>
         * <li>Printable characters in the Basic Latin and Latin-1 Supplement character set</li>
         * <li>The tab ( <code>\u0009</code> ), line feed ( <code>\u000A</code> ), and carriage return ( <code>\u000D</code> ) special characters</li>
         * </ul>
         * <p>
         * <em>Minimum</em> : <code>1</code>
         * <p>
         * <em>Maximum</em> : <code>32768</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keypolicy</a>
         * @param keyPolicy The key policy to attach to the KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPolicy(final java.lang.Object keyPolicy) {
            this.props().keyPolicy(keyPolicy);
            return this;
        }

        /**
         * Specifies the type of KMS key to create.
         * <p>
         * The default value, <code>SYMMETRIC_DEFAULT</code> , creates a KMS key with a 256-bit symmetric key for encryption and decryption. In China Regions, <code>SYMMETRIC_DEFAULT</code> creates a 128-bit symmetric key that uses SM4 encryption. You can't change the <code>KeySpec</code> value after the KMS key is created. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">Choosing a KMS key type</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * The <code>KeySpec</code> property determines the type of key material in the KMS key and the algorithms that the KMS key supports. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms">AWS KMS condition keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you change the value of the <code>KeySpec</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value. &gt; <a href="https://docs.aws.amazon.com/kms/features/#AWS_Service_Integration">AWS services that are integrated with AWS KMS</a> use symmetric encryption KMS keys to protect your data. These services do not support encryption with asymmetric KMS keys. For help determining whether a KMS key is asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying asymmetric KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * AWS KMS supports the following key specs for KMS keys:
         * <p>
         * <ul>
         * <li>Symmetric encryption key (default)</li>
         * <li><code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</li>
         * <li>HMAC keys (symmetric)</li>
         * <li><code>HMAC_224</code></li>
         * <li><code>HMAC_256</code></li>
         * <li><code>HMAC_384</code></li>
         * <li><code>HMAC_512</code></li>
         * <li>Asymmetric RSA key pairs (encryption and decryption <em>or</em> signing and verification)</li>
         * <li><code>RSA_2048</code></li>
         * <li><code>RSA_3072</code></li>
         * <li><code>RSA_4096</code></li>
         * <li>Asymmetric NIST-recommended elliptic curve key pairs (signing and verification <em>or</em> deriving shared secrets)</li>
         * <li><code>ECC_NIST_P256</code> (secp256r1)</li>
         * <li><code>ECC_NIST_P384</code> (secp384r1)</li>
         * <li><code>ECC_NIST_P521</code> (secp521r1)</li>
         * <li>Other asymmetric elliptic curve key pairs (signing and verification)</li>
         * <li><code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</li>
         * <li>Asymmetric ML-DSA key pairs (signing and verification)</li>
         * <li><code>ML_DSA_44</code></li>
         * <li><code>ML_DSA_65</code></li>
         * <li><code>ML_DSA_87</code></li>
         * <li>SM2 key pairs (encryption and decryption <em>or</em> signing and verification <em>or</em> deriving shared secrets)</li>
         * <li><code>SM2</code> (China Regions only)</li>
         * </ul>
         * <p>
         * Default: - "SYMMETRIC_DEFAULT"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keyspec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keyspec</a>
         * @param keySpec Specifies the type of KMS key to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySpec(final java.lang.String keySpec) {
            this.props().keySpec(keySpec);
            return this;
        }

        /**
         * Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code> . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created.
         * <p>
         * <blockquote>
         * <p>
         * If you change the value of the <code>KeyUsage</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value.
         * <p>
         * </blockquote>
         * <p>
         * Select only one valid value.
         * <p>
         * <ul>
         * <li>For symmetric encryption KMS keys, omit the parameter or specify <code>ENCRYPT_DECRYPT</code> .</li>
         * <li>For HMAC KMS keys (symmetric), specify <code>GENERATE_VERIFY_MAC</code> .</li>
         * <li>For asymmetric KMS keys with RSA key pairs, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code> .</li>
         * <li>For asymmetric KMS keys with NIST-recommended elliptic curve key pairs, specify <code>SIGN_VERIFY</code> or <code>KEY_AGREEMENT</code> .</li>
         * <li>For asymmetric KMS keys with <code>ECC_SECG_P256K1</code> key pairs, specify <code>SIGN_VERIFY</code> .</li>
         * <li>For asymmetric KMS keys with ML-DSA key pairs, specify <code>SIGN_VERIFY</code> .</li>
         * <li>For asymmetric KMS keys with SM2 key pairs (China Regions only), specify <code>ENCRYPT_DECRYPT</code> , <code>SIGN_VERIFY</code> , or <code>KEY_AGREEMENT</code> .</li>
         * </ul>
         * <p>
         * Default: - "ENCRYPT_DECRYPT"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keyusage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keyusage</a>
         * @param keyUsage Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code> . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyUsage(final java.lang.String keyUsage) {
            this.props().keyUsage(keyUsage);
            return this;
        }

        /**
         * Creates a multi-Region primary key that you can replicate in other AWS Regions .
         * <p>
         * You can't change the <code>MultiRegion</code> value after the KMS key is created.
         * <p>
         * For a list of AWS Regions in which multi-Region keys are supported, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in AWS KMS</a> in the ** .
         * <p>
         * <blockquote>
         * <p>
         * If you change the value of the <code>MultiRegion</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value.
         * <p>
         * </blockquote>
         * <p>
         * For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
         * <p>
         * <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
         * <p>
         * To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-multiregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-multiregion</a>
         * @param multiRegion Creates a multi-Region primary key that you can replicate in other AWS Regions . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegion(final java.lang.Boolean multiRegion) {
            this.props().multiRegion(multiRegion);
            return this;
        }
        /**
         * Creates a multi-Region primary key that you can replicate in other AWS Regions .
         * <p>
         * You can't change the <code>MultiRegion</code> value after the KMS key is created.
         * <p>
         * For a list of AWS Regions in which multi-Region keys are supported, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in AWS KMS</a> in the ** .
         * <p>
         * <blockquote>
         * <p>
         * If you change the value of the <code>MultiRegion</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value.
         * <p>
         * </blockquote>
         * <p>
         * For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
         * <p>
         * <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
         * <p>
         * To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-multiregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-multiregion</a>
         * @param multiRegion Creates a multi-Region primary key that you can replicate in other AWS Regions . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegion(final software.amazon.awscdk.IResolvable multiRegion) {
            this.props().multiRegion(multiRegion);
            return this;
        }

        /**
         * The source of the key material for the KMS key.
         * <p>
         * You cannot change the origin after you create the KMS key. The default is <code>AWS_KMS</code> , which means that AWS KMS creates the key material.
         * <p>
         * To <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-create-cmk.html">create a KMS key with no key material</a> (for imported key material), set this value to <code>EXTERNAL</code> . For more information about importing key material into AWS KMS , see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * You can ignore <code>ENABLED</code> when Origin is <code>EXTERNAL</code> . When a KMS key with Origin <code>EXTERNAL</code> is created, the key state is <code>PENDING_IMPORT</code> and <code>ENABLED</code> is <code>false</code> . After you import the key material, <code>ENABLED</code> updated to <code>true</code> . The KMS key can then be used for Cryptographic Operations.
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>AWS CloudFormation doesn't support creating an <code>Origin</code> parameter of the <code>AWS_CLOUDHSM</code> or <code>EXTERNAL_KEY_STORE</code> values.</li>
         * <li><code>EXTERNAL</code> is not supported for ML-DSA keys.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * Default: - "AWS_KMS"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-origin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-origin</a>
         * @param origin The source of the key material for the KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder origin(final java.lang.String origin) {
            this.props().origin(origin);
            return this;
        }

        /**
         * Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack.
         * <p>
         * Enter a value between 7 and 30 days. The default value is 30 days.
         * <p>
         * When you remove a KMS key from a CloudFormation stack, AWS KMS schedules the KMS key for deletion and starts the mandatory waiting period. The <code>PendingWindowInDays</code> property determines the length of waiting period. During the waiting period, the key state of KMS key is <code>Pending Deletion</code> or <code>Pending Replica Deletion</code> , which prevents the KMS key from being used in cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the KMS key.
         * <p>
         * AWS KMS will not delete a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">multi-Region primary key</a> that has replica keys. If you remove a multi-Region primary key from a CloudFormation stack, its key state changes to <code>PendingReplicaDeletion</code> so it cannot be replicated or used in cryptographic operations. This state can persist indefinitely. When the last of its replica keys is deleted, the key state of the primary key changes to <code>PendingDeletion</code> and the waiting period specified by <code>PendingWindowInDays</code> begins. When this waiting period expires, AWS KMS deletes the primary key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * You cannot use a CloudFormation template to cancel deletion of the KMS key after you remove it from the stack, regardless of the waiting period. If you specify a KMS key in your template, even one with the same name, CloudFormation creates a new KMS key. To cancel deletion of a KMS key, use the AWS KMS console or the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CancelKeyDeletion.html">CancelKeyDeletion</a> operation.
         * <p>
         * For information about the <code>Pending Deletion</code> and <code>Pending Replica Deletion</code> key states, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> . For more information about deleting KMS keys, see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operation in the <em>AWS Key Management Service API Reference</em> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays</a>
         * @param pendingWindowInDays Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pendingWindowInDays(final java.lang.Number pendingWindowInDays) {
            this.props().pendingWindowInDays(pendingWindowInDays);
            return this;
        }

        /**
         * Specifies a custom period of time between each rotation date.
         * <p>
         * If no value is specified, the default value is 365 days.
         * <p>
         * The rotation period defines the number of days after you enable automatic key rotation that AWS KMS will rotate your key material, and the number of days between each automatic rotation thereafter.
         * <p>
         * You can use the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/conditions-kms.html#conditions-kms-rotation-period-in-days"><code>kms:RotationPeriodInDays</code></a> condition key to further constrain the values that principals can specify in the <code>RotationPeriodInDays</code> parameter.
         * <p>
         * For more information about rotating KMS keys and automatic rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * Default: - 365
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-rotationperiodindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-rotationperiodindays</a>
         * @param rotationPeriodInDays Specifies a custom period of time between each rotation date. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationPeriodInDays(final java.lang.Number rotationPeriodInDays) {
            this.props().rotationPeriodInDays(rotationPeriodInDays);
            return this;
        }

        /**
         * Assigns one or more tags to the replica key.
         * <p>
         * <blockquote>
         * <p>
         * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC for AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * For information about tags in AWS KMS , see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a> in the <em>AWS Key Management Service Developer Guide</em> . For information about tags in CloudFormation, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-tags</a>
         * @param tags Assigns one or more tags to the replica key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kms.CfnKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kms.CfnKey build() {
            return new software.amazon.awscdk.services.kms.CfnKey(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kms.CfnKeyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kms.CfnKeyProps.Builder();
            }
            return this.props;
        }
    }
}
