package software.amazon.awscdk.services.lakeformation;

/**
 * The <code>AWS::LakeFormation::DataLakeSettings</code> resource is an AWS Lake Formation resource type that manages the data lake settings for your account.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.glue.alpha.S3Table;
 * import software.amazon.awscdk.services.glue.alpha.Database;
 * import software.amazon.awscdk.services.glue.alpha.DataFormat;
 * import software.amazon.awscdk.services.glue.alpha.Schema;
 * import software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings;
 * import software.amazon.awscdk.services.lakeformation.CfnTag;
 * import software.amazon.awscdk.services.lakeformation.CfnTagAssociation;
 * Stack stack;
 * String accountId;
 * String tagKey = "aws";
 * String[] tagValues = List.of("dev");
 * Database database = new Database(this, "Database");
 * S3Table table = S3Table.Builder.create(this, "Table")
 *         .database(database)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build(), Column.builder()
 *                 .name("col2")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.CSV)
 *         .build();
 * DefaultStackSynthesizer synthesizer = (DefaultStackSynthesizer)stack.getSynthesizer();
 * CfnDataLakeSettings.Builder.create(this, "DataLakeSettings")
 *         .admins(List.of(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier(stack.formatArn(ArnComponents.builder()
 *                         .service("iam")
 *                         .resource("role")
 *                         .region("")
 *                         .account(accountId)
 *                         .resourceName("Admin")
 *                         .build()))
 *                 .build(), DataLakePrincipalProperty.builder()
 *                 // The CDK cloudformation execution role.
 *                 .dataLakePrincipalIdentifier(synthesizer.cloudFormationExecutionRoleArn.replace("${AWS::Partition}", "aws"))
 *                 .build()))
 *         .build();
 * CfnTag tag = CfnTag.Builder.create(this, "Tag")
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * LFTagPairProperty lfTagPairProperty = LFTagPairProperty.builder()
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * CfnTagAssociation tagAssociation = CfnTagAssociation.Builder.create(this, "TagAssociation")
 *         .lfTags(List.of(lfTagPairProperty))
 *         .resource(ResourceProperty.builder()
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .databaseName(database.getDatabaseName())
 *                         .columnNames(List.of("col1", "col2"))
 *                         .catalogId(accountId)
 *                         .name(table.getTableName())
 *                         .build())
 *                 .build())
 *         .build();
 * tagAssociation.node.addDependency(tag);
 * tagAssociation.node.addDependency(table);
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.694Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnDataLakeSettings")
public class CfnDataLakeSettings extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataLakeSettings(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataLakeSettings(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataLakeSettings(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lakeformation.CfnDataLakeSettingsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataLakeSettings(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of AWS Lake Formation principals.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdmins() {
        return software.amazon.jsii.Kernel.get(this, "admins", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of AWS Lake Formation principals.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdmins(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "admins", value);
    }

    /**
     * A list of AWS Lake Formation principals.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdmins(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.DataLakePrincipalProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.DataLakePrincipalProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "admins", value);
    }

    /**
     * Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowExternalDataFiltering() {
        return software.amazon.jsii.Kernel.get(this, "allowExternalDataFiltering", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowExternalDataFiltering(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowExternalDataFiltering", value);
    }

    /**
     * Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowExternalDataFiltering(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowExternalDataFiltering", value);
    }

    /**
     * Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowFullTableExternalDataAccess() {
        return software.amazon.jsii.Kernel.get(this, "allowFullTableExternalDataAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowFullTableExternalDataAccess(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowFullTableExternalDataAccess", value);
    }

    /**
     * Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowFullTableExternalDataAccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowFullTableExternalDataAccess", value);
    }

    /**
     * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizedSessionTagValueList() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "authorizedSessionTagValueList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizedSessionTagValueList(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "authorizedSessionTagValueList", value);
    }

    /**
     * Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCreateDatabaseDefaultPermissions() {
        return software.amazon.jsii.Kernel.get(this, "createDatabaseDefaultPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreateDatabaseDefaultPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "createDatabaseDefaultPermissions", value);
    }

    /**
     * Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreateDatabaseDefaultPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.PrincipalPermissionsProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.PrincipalPermissionsProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "createDatabaseDefaultPermissions", value);
    }

    /**
     * Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCreateTableDefaultPermissions() {
        return software.amazon.jsii.Kernel.get(this, "createTableDefaultPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreateTableDefaultPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "createTableDefaultPermissions", value);
    }

    /**
     * Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreateTableDefaultPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.PrincipalPermissionsProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.PrincipalPermissionsProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "createTableDefaultPermissions", value);
    }

    /**
     * A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExternalDataFilteringAllowList() {
        return software.amazon.jsii.Kernel.get(this, "externalDataFilteringAllowList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExternalDataFilteringAllowList(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "externalDataFilteringAllowList", value);
    }

    /**
     * A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExternalDataFilteringAllowList(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.DataLakePrincipalProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.DataLakePrincipalProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "externalDataFilteringAllowList", value);
    }

    /**
     * Specifies whether the data lake settings are updated by adding new values to the current settings ( <code>APPEND</code> ) or by replacing the current settings with new settings ( <code>REPLACE</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMutationType() {
        return software.amazon.jsii.Kernel.get(this, "mutationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether the data lake settings are updated by adding new values to the current settings ( <code>APPEND</code> ) or by replacing the current settings with new settings ( <code>REPLACE</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMutationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "mutationType", value);
    }

    /**
     * A key-value map that provides an additional configuration on your data lake.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A key-value map that provides an additional configuration on your data lake.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * An array of UTF-8 strings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedResourceOwners() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "trustedResourceOwners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of UTF-8 strings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrustedResourceOwners(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "trustedResourceOwners", value);
    }
    /**
     * The Lake Formation principal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * DataLakePrincipalProperty dataLakePrincipalProperty = DataLakePrincipalProperty.builder()
     *         .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-datalakeprincipal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-datalakeprincipal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnDataLakeSettings.DataLakePrincipalProperty")
    @software.amazon.jsii.Jsii.Proxy(DataLakePrincipalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataLakePrincipalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the Lake Formation principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-datalakeprincipal.html#cfn-lakeformation-datalakesettings-datalakeprincipal-datalakeprincipalidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-datalakeprincipal.html#cfn-lakeformation-datalakesettings-datalakeprincipal-datalakeprincipalidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataLakePrincipalIdentifier();

        /**
         * @return a {@link Builder} of {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataLakePrincipalProperty> {
            java.lang.String dataLakePrincipalIdentifier;

            /**
             * Sets the value of {@link DataLakePrincipalProperty#getDataLakePrincipalIdentifier}
             * @param dataLakePrincipalIdentifier An identifier for the Lake Formation principal. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataLakePrincipalIdentifier(java.lang.String dataLakePrincipalIdentifier) {
                this.dataLakePrincipalIdentifier = dataLakePrincipalIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataLakePrincipalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataLakePrincipalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataLakePrincipalProperty {
            private final java.lang.String dataLakePrincipalIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataLakePrincipalIdentifier = software.amazon.jsii.Kernel.get(this, "dataLakePrincipalIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataLakePrincipalIdentifier = java.util.Objects.requireNonNull(builder.dataLakePrincipalIdentifier, "dataLakePrincipalIdentifier is required");
            }

            @Override
            public final java.lang.String getDataLakePrincipalIdentifier() {
                return this.dataLakePrincipalIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataLakePrincipalIdentifier", om.valueToTree(this.getDataLakePrincipalIdentifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnDataLakeSettings.DataLakePrincipalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataLakePrincipalProperty.Jsii$Proxy that = (DataLakePrincipalProperty.Jsii$Proxy) o;

                return this.dataLakePrincipalIdentifier.equals(that.dataLakePrincipalIdentifier);
            }

            @Override
            public final int hashCode() {
                int result = this.dataLakePrincipalIdentifier.hashCode();
                return result;
            }
        }
    }
    /**
     * Permissions granted to a principal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * PrincipalPermissionsProperty principalPermissionsProperty = PrincipalPermissionsProperty.builder()
     *         .permissions(List.of("permissions"))
     *         .principal(DataLakePrincipalProperty.builder()
     *                 .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-principalpermissions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-principalpermissions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnDataLakeSettings.PrincipalPermissionsProperty")
    @software.amazon.jsii.Jsii.Proxy(PrincipalPermissionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrincipalPermissionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The permissions that are granted to the principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-principalpermissions.html#cfn-lakeformation-datalakesettings-principalpermissions-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-principalpermissions.html#cfn-lakeformation-datalakesettings-principalpermissions-permissions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPermissions();

        /**
         * The principal who is granted permissions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-principalpermissions.html#cfn-lakeformation-datalakesettings-principalpermissions-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-principalpermissions.html#cfn-lakeformation-datalakesettings-principalpermissions-principal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrincipal();

        /**
         * @return a {@link Builder} of {@link PrincipalPermissionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrincipalPermissionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrincipalPermissionsProperty> {
            java.util.List<java.lang.String> permissions;
            java.lang.Object principal;

            /**
             * Sets the value of {@link PrincipalPermissionsProperty#getPermissions}
             * @param permissions The permissions that are granted to the principal. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permissions(java.util.List<java.lang.String> permissions) {
                this.permissions = permissions;
                return this;
            }

            /**
             * Sets the value of {@link PrincipalPermissionsProperty#getPrincipal}
             * @param principal The principal who is granted permissions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(software.amazon.awscdk.IResolvable principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Sets the value of {@link PrincipalPermissionsProperty#getPrincipal}
             * @param principal The principal who is granted permissions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings.DataLakePrincipalProperty principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrincipalPermissionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrincipalPermissionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrincipalPermissionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrincipalPermissionsProperty {
            private final java.util.List<java.lang.String> permissions;
            private final java.lang.Object principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.permissions = java.util.Objects.requireNonNull(builder.permissions, "permissions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            }

            @Override
            public final java.util.List<java.lang.String> getPermissions() {
                return this.permissions;
            }

            @Override
            public final java.lang.Object getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("permissions", om.valueToTree(this.getPermissions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnDataLakeSettings.PrincipalPermissionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrincipalPermissionsProperty.Jsii$Proxy that = (PrincipalPermissionsProperty.Jsii$Proxy) o;

                if (!permissions.equals(that.permissions)) return false;
                return this.principal.equals(that.principal);
            }

            @Override
            public final int hashCode() {
                int result = this.permissions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.lakeformation.CfnDataLakeSettingsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A list of AWS Lake Formation principals.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-admins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-admins</a>
         * @param admins A list of AWS Lake Formation principals. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder admins(final software.amazon.awscdk.IResolvable admins) {
            this.props().admins(admins);
            return this;
        }
        /**
         * A list of AWS Lake Formation principals.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-admins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-admins</a>
         * @param admins A list of AWS Lake Formation principals. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder admins(final java.util.List<? extends java.lang.Object> admins) {
            this.props().admins(admins);
            return this;
        }

        /**
         * Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation .
         * <p>
         * If set to true, you allow Amazon EMR clusters or other third-party engines to access data in Amazon S3 locations that are registered with Lake Formation .
         * <p>
         * If false or null, no third-party query engines will be able to access data in Amazon S3 locations that are registered with Lake Formation.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/initial-LF-setup.html#external-data-filter">External data filtering setting</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowexternaldatafiltering">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowexternaldatafiltering</a>
         * @param allowExternalDataFiltering Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowExternalDataFiltering(final java.lang.Boolean allowExternalDataFiltering) {
            this.props().allowExternalDataFiltering(allowExternalDataFiltering);
            return this;
        }
        /**
         * Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation .
         * <p>
         * If set to true, you allow Amazon EMR clusters or other third-party engines to access data in Amazon S3 locations that are registered with Lake Formation .
         * <p>
         * If false or null, no third-party query engines will be able to access data in Amazon S3 locations that are registered with Lake Formation.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/initial-LF-setup.html#external-data-filter">External data filtering setting</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowexternaldatafiltering">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowexternaldatafiltering</a>
         * @param allowExternalDataFiltering Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowExternalDataFiltering(final software.amazon.awscdk.IResolvable allowExternalDataFiltering) {
            this.props().allowExternalDataFiltering(allowExternalDataFiltering);
            return this;
        }

        /**
         * Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access.
         * <p>
         * It provides query engines and applications performance benefits as well as simplifies data access. Amazon EMR on Amazon EC2 is able to leverage this setting.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/using-cred-vending.html"></a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowfulltableexternaldataaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowfulltableexternaldataaccess</a>
         * @param allowFullTableExternalDataAccess Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowFullTableExternalDataAccess(final java.lang.Boolean allowFullTableExternalDataAccess) {
            this.props().allowFullTableExternalDataAccess(allowFullTableExternalDataAccess);
            return this;
        }
        /**
         * Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access.
         * <p>
         * It provides query engines and applications performance benefits as well as simplifies data access. Amazon EMR on Amazon EC2 is able to leverage this setting.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/using-cred-vending.html"></a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowfulltableexternaldataaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowfulltableexternaldataaccess</a>
         * @param allowFullTableExternalDataAccess Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowFullTableExternalDataAccess(final software.amazon.awscdk.IResolvable allowFullTableExternalDataAccess) {
            this.props().allowFullTableExternalDataAccess(allowFullTableExternalDataAccess);
            return this;
        }

        /**
         * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
         * <p>
         * Lake Formation will publish the acceptable key-value pair, for example key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the temporary security credentials that will be used to call Lake Formation 's administrative API operations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-authorizedsessiontagvaluelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-authorizedsessiontagvaluelist</a>
         * @param authorizedSessionTagValueList Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizedSessionTagValueList(final java.util.List<java.lang.String> authorizedSessionTagValueList) {
            this.props().authorizedSessionTagValueList(authorizedSessionTagValueList);
            return this;
        }

        /**
         * Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
         * <p>
         * A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicates that the user's IAM permissions determine the access to the database. This is referred to as the setting "Use only IAM access control," and is to support backward compatibility with the AWS Glue permission model implemented by IAM permissions.
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> to <code>IAM_ALLOWED_PRINCIPALS</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createdatabasedefaultpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createdatabasedefaultpermissions</a>
         * @param createDatabaseDefaultPermissions Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createDatabaseDefaultPermissions(final software.amazon.awscdk.IResolvable createDatabaseDefaultPermissions) {
            this.props().createDatabaseDefaultPermissions(createDatabaseDefaultPermissions);
            return this;
        }
        /**
         * Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
         * <p>
         * A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicates that the user's IAM permissions determine the access to the database. This is referred to as the setting "Use only IAM access control," and is to support backward compatibility with the AWS Glue permission model implemented by IAM permissions.
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> to <code>IAM_ALLOWED_PRINCIPALS</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createdatabasedefaultpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createdatabasedefaultpermissions</a>
         * @param createDatabaseDefaultPermissions Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createDatabaseDefaultPermissions(final java.util.List<? extends java.lang.Object> createDatabaseDefaultPermissions) {
            this.props().createDatabaseDefaultPermissions(createDatabaseDefaultPermissions);
            return this;
        }

        /**
         * Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
         * <p>
         * A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicate that the user's IAM permissions determine the access to the table. This is referred to as the setting "Use only IAM access control," and is to support the backward compatibility with the AWS Glue permission model implemented by IAM permissions.
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> permissions to <code>IAM_ALLOWED_PRINCIPALS</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createtabledefaultpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createtabledefaultpermissions</a>
         * @param createTableDefaultPermissions Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createTableDefaultPermissions(final software.amazon.awscdk.IResolvable createTableDefaultPermissions) {
            this.props().createTableDefaultPermissions(createTableDefaultPermissions);
            return this;
        }
        /**
         * Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
         * <p>
         * A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicate that the user's IAM permissions determine the access to the table. This is referred to as the setting "Use only IAM access control," and is to support the backward compatibility with the AWS Glue permission model implemented by IAM permissions.
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> permissions to <code>IAM_ALLOWED_PRINCIPALS</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createtabledefaultpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createtabledefaultpermissions</a>
         * @param createTableDefaultPermissions Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createTableDefaultPermissions(final java.util.List<? extends java.lang.Object> createTableDefaultPermissions) {
            this.props().createTableDefaultPermissions(createTableDefaultPermissions);
            return this;
        }

        /**
         * A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-externaldatafilteringallowlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-externaldatafilteringallowlist</a>
         * @param externalDataFilteringAllowList A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalDataFilteringAllowList(final software.amazon.awscdk.IResolvable externalDataFilteringAllowList) {
            this.props().externalDataFilteringAllowList(externalDataFilteringAllowList);
            return this;
        }
        /**
         * A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-externaldatafilteringallowlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-externaldatafilteringallowlist</a>
         * @param externalDataFilteringAllowList A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalDataFilteringAllowList(final java.util.List<? extends java.lang.Object> externalDataFilteringAllowList) {
            this.props().externalDataFilteringAllowList(externalDataFilteringAllowList);
            return this;
        }

        /**
         * Specifies whether the data lake settings are updated by adding new values to the current settings ( <code>APPEND</code> ) or by replacing the current settings with new settings ( <code>REPLACE</code> ).
         * <p>
         * <blockquote>
         * <p>
         * If you choose <code>REPLACE</code> , your current data lake settings will be replaced with the new values in your template.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-mutationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-mutationtype</a>
         * @param mutationType Specifies whether the data lake settings are updated by adding new values to the current settings ( <code>APPEND</code> ) or by replacing the current settings with new settings ( <code>REPLACE</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutationType(final java.lang.String mutationType) {
            this.props().mutationType(mutationType);
            return this;
        }

        /**
         * A key-value map that provides an additional configuration on your data lake.
         * <p>
         * <code>CrossAccountVersion</code> is the key you can configure in the <code>Parameters</code> field. Accepted values for the <code>CrossAccountVersion</code> key are 1, 2, 3, and 4.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-parameters</a>
         * @param parameters A key-value map that provides an additional configuration on your data lake. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.lang.Object parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * An array of UTF-8 strings.
         * <p>
         * A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log. You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-trustedresourceowners">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-trustedresourceowners</a>
         * @param trustedResourceOwners An array of UTF-8 strings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustedResourceOwners(final java.util.List<java.lang.String> trustedResourceOwners) {
            this.props().trustedResourceOwners(trustedResourceOwners);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings build() {
            return new software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.lakeformation.CfnDataLakeSettingsProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.lakeformation.CfnDataLakeSettingsProps.Builder();
            }
            return this.props;
        }
    }
}
