package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a <code>CfnVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnVersionProps cfnVersionProps = CfnVersionProps.builder()
 *         .functionName("functionName")
 *         // the properties below are optional
 *         .codeSha256("codeSha256")
 *         .description("description")
 *         .provisionedConcurrencyConfig(ProvisionedConcurrencyConfigurationProperty.builder()
 *                 .provisionedConcurrentExecutions(123)
 *                 .build())
 *         .runtimePolicy(RuntimePolicyProperty.builder()
 *                 .updateRuntimeOn("updateRuntimeOn")
 *                 // the properties below are optional
 *                 .runtimeVersionArn("runtimeVersionArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.827Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name or ARN of the Lambda function.
     * <p>
     * <strong>Name formats</strong> - <em>Function name</em> - <code>MyFunction</code> .
     * <p>
     * <ul>
     * <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code> .</li>
     * <li><em>Partial ARN</em> - <code>123456789012:function:MyFunction</code> .</li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * Only publish a version if the hash value matches the value that's specified.
     * <p>
     * Use this option to avoid publishing a version if the function code has changed since you last updated it. Updates are not supported for this property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCodeSha256() {
        return null;
    }

    /**
     * A description for the version to override the description in the function configuration.
     * <p>
     * Updates are not supported for this property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies a provisioned concurrency configuration for a function's version.
     * <p>
     * Updates are not supported for this property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedConcurrencyConfig() {
        return null;
    }

    /**
     * Runtime Management Config of a function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-runtimepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-runtimepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimePolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVersionProps> {
        java.lang.String functionName;
        java.lang.String codeSha256;
        java.lang.String description;
        java.lang.Object provisionedConcurrencyConfig;
        java.lang.Object runtimePolicy;

        /**
         * Sets the value of {@link CfnVersionProps#getFunctionName}
         * @param functionName The name or ARN of the Lambda function. This parameter is required.
         *                     <strong>Name formats</strong> - <em>Function name</em> - <code>MyFunction</code> .
         *                     <p>
         *                     <ul>
         *                     <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code> .</li>
         *                     <li><em>Partial ARN</em> - <code>123456789012:function:MyFunction</code> .</li>
         *                     </ul>
         *                     <p>
         *                     The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVersionProps#getCodeSha256}
         * @param codeSha256 Only publish a version if the hash value matches the value that's specified.
         *                   Use this option to avoid publishing a version if the function code has changed since you last updated it. Updates are not supported for this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSha256(java.lang.String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        /**
         * Sets the value of {@link CfnVersionProps#getDescription}
         * @param description A description for the version to override the description in the function configuration.
         *                    Updates are not supported for this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnVersionProps#getProvisionedConcurrencyConfig}
         * @param provisionedConcurrencyConfig Specifies a provisioned concurrency configuration for a function's version.
         *                                     Updates are not supported for this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(software.amazon.awscdk.IResolvable provisionedConcurrencyConfig) {
            this.provisionedConcurrencyConfig = provisionedConcurrencyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnVersionProps#getProvisionedConcurrencyConfig}
         * @param provisionedConcurrencyConfig Specifies a provisioned concurrency configuration for a function's version.
         *                                     Updates are not supported for this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(software.amazon.awscdk.services.lambda.CfnVersion.ProvisionedConcurrencyConfigurationProperty provisionedConcurrencyConfig) {
            this.provisionedConcurrencyConfig = provisionedConcurrencyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnVersionProps#getRuntimePolicy}
         * @param runtimePolicy Runtime Management Config of a function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePolicy(software.amazon.awscdk.IResolvable runtimePolicy) {
            this.runtimePolicy = runtimePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnVersionProps#getRuntimePolicy}
         * @param runtimePolicy Runtime Management Config of a function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePolicy(software.amazon.awscdk.services.lambda.CfnVersion.RuntimePolicyProperty runtimePolicy) {
            this.runtimePolicy = runtimePolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVersionProps {
        private final java.lang.String functionName;
        private final java.lang.String codeSha256;
        private final java.lang.String description;
        private final java.lang.Object provisionedConcurrencyConfig;
        private final java.lang.Object runtimePolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeSha256 = software.amazon.jsii.Kernel.get(this, "codeSha256", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisionedConcurrencyConfig = software.amazon.jsii.Kernel.get(this, "provisionedConcurrencyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.runtimePolicy = software.amazon.jsii.Kernel.get(this, "runtimePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            this.codeSha256 = builder.codeSha256;
            this.description = builder.description;
            this.provisionedConcurrencyConfig = builder.provisionedConcurrencyConfig;
            this.runtimePolicy = builder.runtimePolicy;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getProvisionedConcurrencyConfig() {
            return this.provisionedConcurrencyConfig;
        }

        @Override
        public final java.lang.Object getRuntimePolicy() {
            return this.runtimePolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionName", om.valueToTree(this.getFunctionName()));
            if (this.getCodeSha256() != null) {
                data.set("codeSha256", om.valueToTree(this.getCodeSha256()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getProvisionedConcurrencyConfig() != null) {
                data.set("provisionedConcurrencyConfig", om.valueToTree(this.getProvisionedConcurrencyConfig()));
            }
            if (this.getRuntimePolicy() != null) {
                data.set("runtimePolicy", om.valueToTree(this.getRuntimePolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVersionProps.Jsii$Proxy that = (CfnVersionProps.Jsii$Proxy) o;

            if (!functionName.equals(that.functionName)) return false;
            if (this.codeSha256 != null ? !this.codeSha256.equals(that.codeSha256) : that.codeSha256 != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.provisionedConcurrencyConfig != null ? !this.provisionedConcurrencyConfig.equals(that.provisionedConcurrencyConfig) : that.provisionedConcurrencyConfig != null) return false;
            return this.runtimePolicy != null ? this.runtimePolicy.equals(that.runtimePolicy) : that.runtimePolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionName.hashCode();
            result = 31 * result + (this.codeSha256 != null ? this.codeSha256.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.provisionedConcurrencyConfig != null ? this.provisionedConcurrencyConfig.hashCode() : 0);
            result = 31 * result + (this.runtimePolicy != null ? this.runtimePolicy.hashCode() : 0);
            return result;
        }
    }
}
