package software.amazon.awscdk.services.lambda;

/**
 * Specific schema validation configuration settings that tell Lambda the message attributes you want to validate and filter using your schema registry.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry;
 * import software.amazon.awscdk.services.secretsmanager.Secret;
 * // Your MSK cluster arn
 * String clusterArn;
 * Function myFunction;
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * Secret secret = Secret.Builder.create(this, "Secret").secretName("AmazonMSK_KafkaSecret").build();
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(3)
 *                 .build())
 *         .schemaRegistryConfig(ConfluentSchemaRegistry.Builder.create()
 *                 .schemaRegistryUri("https://example.com")
 *                 .eventRecordFormat(EventRecordFormat.JSON)
 *                 .authenticationType(KafkaSchemaRegistryAccessConfigType.BASIC_AUTH)
 *                 .secret(secret)
 *                 .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder().attribute(KafkaSchemaValidationAttribute.KEY).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.914Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.KafkaSchemaValidationAttribute")
public class KafkaSchemaValidationAttribute extends software.amazon.jsii.JsiiObject {

    protected KafkaSchemaValidationAttribute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KafkaSchemaValidationAttribute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute.class, "KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute.class));
        VALUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute.class, "VALUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute.class));
    }

    /**
     * A custom schema validation attribute property.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute of(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * De-serialize the key field of the parload to target function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute KEY;

    /**
     * De-serialize the value field of the parload to target function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute VALUE;

    /**
     * The enum to use in <code>SchemaRegistryConfig.SchemaValidationConfigs.Attribute</code> property in CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
