package software.amazon.awscdk.services.lambda;

/**
 * Identification of an account (or organization) that is allowed to access a Lambda Layer Version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LayerVersion layer = LayerVersion.Builder.create(stack, "MyLayer")
 *         .code(Code.fromAsset(join(__dirname, "layer-code")))
 *         .compatibleRuntimes(List.of(Runtime.NODEJS_LATEST))
 *         .license("Apache-2.0")
 *         .description("A layer to test the L2 construct")
 *         .build();
 * // To grant usage by other AWS accounts
 * layer.addPermission("remote-account-grant", LayerVersionPermission.builder().accountId(awsAccountId).build());
 * // To grant usage to all accounts in some AWS Ogranization
 * // layer.grantUsage({ accountId: '*', organizationId });
 * // To grant usage to all accounts in some AWS Ogranization
 * // layer.grantUsage({ accountId: '*', organizationId });
 * Function.Builder.create(stack, "MyLayeredLambda")
 *         .code(new InlineCode("foo"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .layers(List.of(layer))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.917Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.LayerVersionPermission")
@software.amazon.jsii.Jsii.Proxy(LayerVersionPermission.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LayerVersionPermission extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS Account id of the account that is authorized to use a Lambda Layer Version.
     * <p>
     * The wild-card <code>'*'</code> can be
     * used to grant access to "any" account (or any account in an organization when <code>organizationId</code> is specified).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccountId();

    /**
     * The ID of the AWS Organization to which the grant is restricted.
     * <p>
     * Can only be specified if <code>accountId</code> is <code>'*'</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LayerVersionPermission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LayerVersionPermission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LayerVersionPermission> {
        java.lang.String accountId;
        java.lang.String organizationId;

        /**
         * Sets the value of {@link LayerVersionPermission#getAccountId}
         * @param accountId The AWS Account id of the account that is authorized to use a Lambda Layer Version. This parameter is required.
         *                  The wild-card <code>'*'</code> can be
         *                  used to grant access to "any" account (or any account in an organization when <code>organizationId</code> is specified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(java.lang.String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Sets the value of {@link LayerVersionPermission#getOrganizationId}
         * @param organizationId The ID of the AWS Organization to which the grant is restricted.
         *                       Can only be specified if <code>accountId</code> is <code>'*'</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationId(java.lang.String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LayerVersionPermission}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LayerVersionPermission build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LayerVersionPermission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LayerVersionPermission {
        private final java.lang.String accountId;
        private final java.lang.String organizationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationId = software.amazon.jsii.Kernel.get(this, "organizationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountId = java.util.Objects.requireNonNull(builder.accountId, "accountId is required");
            this.organizationId = builder.organizationId;
        }

        @Override
        public final java.lang.String getAccountId() {
            return this.accountId;
        }

        @Override
        public final java.lang.String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accountId", om.valueToTree(this.getAccountId()));
            if (this.getOrganizationId() != null) {
                data.set("organizationId", om.valueToTree(this.getOrganizationId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.LayerVersionPermission"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LayerVersionPermission.Jsii$Proxy that = (LayerVersionPermission.Jsii$Proxy) o;

            if (!accountId.equals(that.accountId)) return false;
            return this.organizationId != null ? this.organizationId.equals(that.organizationId) : that.organizationId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountId.hashCode();
            result = 31 * result + (this.organizationId != null ? this.organizationId.hashCode() : 0);
            return result;
        }
    }
}
