package software.amazon.awscdk.services.lambda;

/**
 * Parameters and Secrets Extension versions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.secretsmanager.*;
 * import software.amazon.awscdk.services.ssm.*;
 * Secret secret = new Secret(this, "Secret");
 * StringParameter parameter = StringParameter.Builder.create(this, "Parameter")
 *         .parameterName("mySsmParameterName")
 *         .stringValue("mySsmParameterValue")
 *         .build();
 * ParamsAndSecretsLayerVersion paramsAndSecrets = ParamsAndSecretsLayerVersion.fromVersion(ParamsAndSecretsVersions.V1_0_103, ParamsAndSecretsOptions.builder()
 *         .cacheSize(500)
 *         .logLevel(ParamsAndSecretsLogLevel.DEBUG)
 *         .build());
 * Function lambdaFunction = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .architecture(Architecture.ARM_64)
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .paramsAndSecrets(paramsAndSecrets)
 *         .build();
 * secret.grantRead(lambdaFunction);
 * parameter.grantRead(lambdaFunction);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:17.921Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.ParamsAndSecretsVersions")
public enum ParamsAndSecretsVersions {
    /**
     * Version 1.0.103.
     * <p>
     * Note: This is the latest version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V1_0_103,
}
