package software.amazon.awscdk.services.lambda.nodejs;

/**
 * Output format for the generated JavaScript files.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .bundling(BundlingOptions.builder()
 *                 .minify(true) // minify code, defaults to false
 *                 .sourceMap(true) // include source map, defaults to false
 *                 .sourceMapMode(SourceMapMode.INLINE) // defaults to SourceMapMode.DEFAULT
 *                 .sourcesContent(false) // do not include original source into source map, defaults to true
 *                 .target("es2020") // target environment for the generated JavaScript code
 *                 .loader(Map.of( // Use the 'dataurl' loader for '.png' files
 *                         ".png", "dataurl"))
 *                 .define(Map.of( // Replace strings during build time
 *                         "process.env.API_KEY", JSON.stringify("xxx-xxxx-xxx"),
 *                         "process.env.PRODUCTION", JSON.stringify(true),
 *                         "process.env.NUMBER", JSON.stringify(123)))
 *                 .logLevel(LogLevel.ERROR) // defaults to LogLevel.WARNING
 *                 .keepNames(true) // defaults to false
 *                 .tsconfig("custom-tsconfig.json") // use custom-tsconfig.json instead of default,
 *                 .metafile(true) // include meta file, defaults to false
 *                 .banner("/* comments *&#47;") // requires esbuild &gt;= 0.9.0, defaults to none
 *                 .footer("/* comments *&#47;") // requires esbuild &gt;= 0.9.0, defaults to none
 *                 .charset(Charset.UTF8) // do not escape non-ASCII characters, defaults to Charset.ASCII
 *                 .format(OutputFormat.ESM) // ECMAScript module output format, defaults to OutputFormat.CJS (OutputFormat.ESM requires Node.js &gt;= 14)
 *                 .mainFields(List.of("module", "main")) // prefer ECMAScript versions of dependencies
 *                 .inject(List.of("./my-shim.js", "./other-shim.js")) // allows to automatically replace a global variable with an import from another file
 *                 .esbuildArgs(Map.of( // Pass additional arguments to esbuild
 *                         "--log-limit", "0",
 *                         "--splitting", true))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:18.010Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_nodejs.OutputFormat")
public enum OutputFormat {
    /**
     * CommonJS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CJS,
    /**
     * ECMAScript module.
     * <p>
     * Requires a running environment that supports <code>import</code> and <code>export</code> syntax.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ESM,
}
