package software.amazon.awscdk.services.lightsail;

/**
 * The <code>AWS::Lightsail::Bucket</code> resource specifies a bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnBucket cfnBucket = CfnBucket.Builder.create(this, "MyCfnBucket")
 *         .bucketName("bucketName")
 *         .bundleId("bundleId")
 *         // the properties below are optional
 *         .accessRules(AccessRulesProperty.builder()
 *                 .allowPublicOverrides(false)
 *                 .objectAccess("objectAccess")
 *                 .build())
 *         .objectVersioning(false)
 *         .readOnlyAccessAccounts(List.of("readOnlyAccessAccounts"))
 *         .resourcesReceivingAccess(List.of("resourcesReceivingAccess"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:18.139Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnBucket")
public class CfnBucket extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnBucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lightsail.CfnBucket.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBucket(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A Boolean value indicating whether the bundle that is currently applied to your distribution can be changed to another bundle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAbleToUpdateBundle() {
        return software.amazon.jsii.Kernel.get(this, "attrAbleToUpdateBundle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBucketArn() {
        return software.amazon.jsii.Kernel.get(this, "attrBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketName() {
        return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucketName", java.util.Objects.requireNonNull(value, "bucketName is required"));
    }

    /**
     * The bundle ID for the bucket (for example, <code>small_1_0</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBundleId() {
        return software.amazon.jsii.Kernel.get(this, "bundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The bundle ID for the bucket (for example, <code>small_1_0</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBundleId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bundleId", java.util.Objects.requireNonNull(value, "bundleId is required"));
    }

    /**
     * An object that describes the access rules for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessRules() {
        return software.amazon.jsii.Kernel.get(this, "accessRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that describes the access rules for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accessRules", value);
    }

    /**
     * An object that describes the access rules for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lightsail.CfnBucket.AccessRulesProperty value) {
        software.amazon.jsii.Kernel.set(this, "accessRules", value);
    }

    /**
     * Indicates whether object versioning is enabled for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getObjectVersioning() {
        return software.amazon.jsii.Kernel.get(this, "objectVersioning", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether object versioning is enabled for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectVersioning(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "objectVersioning", value);
    }

    /**
     * Indicates whether object versioning is enabled for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectVersioning(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "objectVersioning", value);
    }

    /**
     * An array of AWS account IDs that have read-only access to the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReadOnlyAccessAccounts() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "readOnlyAccessAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of AWS account IDs that have read-only access to the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReadOnlyAccessAccounts(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "readOnlyAccessAccounts", value);
    }

    /**
     * An array of Lightsail instances that have access to the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourcesReceivingAccess() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resourcesReceivingAccess", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of Lightsail instances that have access to the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcesReceivingAccess(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resourcesReceivingAccess", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * <code>AccessRules</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html">AWS::Lightsail::Bucket</a> resource. It describes access rules for a bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * AccessRulesProperty accessRulesProperty = AccessRulesProperty.builder()
     *         .allowPublicOverrides(false)
     *         .objectAccess("objectAccess")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-bucket-accessrules.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-bucket-accessrules.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnBucket.AccessRulesProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessRulesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessRulesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean value indicating whether the access control list (ACL) permissions that are applied to individual objects override the <code>GetObject</code> option that is currently specified.
         * <p>
         * When this is true, you can use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html">PutObjectAcl</a> Amazon S3 API operation to set individual objects to public (read-only) or private, using either the <code>public-read</code> ACL or the <code>private</code> ACL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-bucket-accessrules.html#cfn-lightsail-bucket-accessrules-allowpublicoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-bucket-accessrules.html#cfn-lightsail-bucket-accessrules-allowpublicoverrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowPublicOverrides() {
            return null;
        }

        /**
         * Specifies the anonymous access to all objects in a bucket.
         * <p>
         * The following options can be specified:
         * <p>
         * <ul>
         * <li><code>public</code> - Sets all objects in the bucket to public (read-only), making them readable by everyone on the internet.</li>
         * </ul>
         * <p>
         * If the <code>GetObject</code> value is set to <code>public</code> , then all objects in the bucket default to public regardless of the <code>allowPublicOverrides</code> value.
         * <p>
         * <ul>
         * <li><code>private</code> - Sets all objects in the bucket to private, making them readable only by you and anyone that you grant access to.</li>
         * </ul>
         * <p>
         * If the <code>GetObject</code> value is set to <code>private</code> , and the <code>allowPublicOverrides</code> value is set to <code>true</code> , then all objects in the bucket default to private unless they are configured with a <code>public-read</code> ACL. Individual objects with a <code>public-read</code> ACL are readable by everyone on the internet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-bucket-accessrules.html#cfn-lightsail-bucket-accessrules-getobject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-bucket-accessrules.html#cfn-lightsail-bucket-accessrules-getobject</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectAccess() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessRulesProperty> {
            java.lang.Object allowPublicOverrides;
            java.lang.String objectAccess;

            /**
             * Sets the value of {@link AccessRulesProperty#getAllowPublicOverrides}
             * @param allowPublicOverrides A Boolean value indicating whether the access control list (ACL) permissions that are applied to individual objects override the <code>GetObject</code> option that is currently specified.
             *                             When this is true, you can use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html">PutObjectAcl</a> Amazon S3 API operation to set individual objects to public (read-only) or private, using either the <code>public-read</code> ACL or the <code>private</code> ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowPublicOverrides(java.lang.Boolean allowPublicOverrides) {
                this.allowPublicOverrides = allowPublicOverrides;
                return this;
            }

            /**
             * Sets the value of {@link AccessRulesProperty#getAllowPublicOverrides}
             * @param allowPublicOverrides A Boolean value indicating whether the access control list (ACL) permissions that are applied to individual objects override the <code>GetObject</code> option that is currently specified.
             *                             When this is true, you can use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html">PutObjectAcl</a> Amazon S3 API operation to set individual objects to public (read-only) or private, using either the <code>public-read</code> ACL or the <code>private</code> ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowPublicOverrides(software.amazon.awscdk.IResolvable allowPublicOverrides) {
                this.allowPublicOverrides = allowPublicOverrides;
                return this;
            }

            /**
             * Sets the value of {@link AccessRulesProperty#getObjectAccess}
             * @param objectAccess Specifies the anonymous access to all objects in a bucket.
             *                     The following options can be specified:
             *                     <p>
             *                     <ul>
             *                     <li><code>public</code> - Sets all objects in the bucket to public (read-only), making them readable by everyone on the internet.</li>
             *                     </ul>
             *                     <p>
             *                     If the <code>GetObject</code> value is set to <code>public</code> , then all objects in the bucket default to public regardless of the <code>allowPublicOverrides</code> value.
             *                     <p>
             *                     <ul>
             *                     <li><code>private</code> - Sets all objects in the bucket to private, making them readable only by you and anyone that you grant access to.</li>
             *                     </ul>
             *                     <p>
             *                     If the <code>GetObject</code> value is set to <code>private</code> , and the <code>allowPublicOverrides</code> value is set to <code>true</code> , then all objects in the bucket default to private unless they are configured with a <code>public-read</code> ACL. Individual objects with a <code>public-read</code> ACL are readable by everyone on the internet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectAccess(java.lang.String objectAccess) {
                this.objectAccess = objectAccess;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessRulesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessRulesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessRulesProperty {
            private final java.lang.Object allowPublicOverrides;
            private final java.lang.String objectAccess;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowPublicOverrides = software.amazon.jsii.Kernel.get(this, "allowPublicOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.objectAccess = software.amazon.jsii.Kernel.get(this, "objectAccess", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowPublicOverrides = builder.allowPublicOverrides;
                this.objectAccess = builder.objectAccess;
            }

            @Override
            public final java.lang.Object getAllowPublicOverrides() {
                return this.allowPublicOverrides;
            }

            @Override
            public final java.lang.String getObjectAccess() {
                return this.objectAccess;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowPublicOverrides() != null) {
                    data.set("allowPublicOverrides", om.valueToTree(this.getAllowPublicOverrides()));
                }
                if (this.getObjectAccess() != null) {
                    data.set("objectAccess", om.valueToTree(this.getObjectAccess()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnBucket.AccessRulesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessRulesProperty.Jsii$Proxy that = (AccessRulesProperty.Jsii$Proxy) o;

                if (this.allowPublicOverrides != null ? !this.allowPublicOverrides.equals(that.allowPublicOverrides) : that.allowPublicOverrides != null) return false;
                return this.objectAccess != null ? this.objectAccess.equals(that.objectAccess) : that.objectAccess == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowPublicOverrides != null ? this.allowPublicOverrides.hashCode() : 0;
                result = 31 * result + (this.objectAccess != null ? this.objectAccess.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lightsail.CfnBucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lightsail.CfnBucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lightsail.CfnBucketProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lightsail.CfnBucketProps.Builder();
        }

        /**
         * The name of the bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-bucketname</a>
         * @param bucketName The name of the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props.bucketName(bucketName);
            return this;
        }

        /**
         * The bundle ID for the bucket (for example, <code>small_1_0</code> ).
         * <p>
         * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-bundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-bundleid</a>
         * @param bundleId The bundle ID for the bucket (for example, <code>small_1_0</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleId(final java.lang.String bundleId) {
            this.props.bundleId(bundleId);
            return this;
        }

        /**
         * An object that describes the access rules for the bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-accessrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-accessrules</a>
         * @param accessRules An object that describes the access rules for the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRules(final software.amazon.awscdk.IResolvable accessRules) {
            this.props.accessRules(accessRules);
            return this;
        }
        /**
         * An object that describes the access rules for the bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-accessrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-accessrules</a>
         * @param accessRules An object that describes the access rules for the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRules(final software.amazon.awscdk.services.lightsail.CfnBucket.AccessRulesProperty accessRules) {
            this.props.accessRules(accessRules);
            return this;
        }

        /**
         * Indicates whether object versioning is enabled for the bucket.
         * <p>
         * The following options can be configured:
         * <p>
         * <ul>
         * <li><code>Enabled</code> - Object versioning is enabled.</li>
         * <li><code>Suspended</code> - Object versioning was previously enabled but is currently suspended. Existing object versions are retained.</li>
         * <li><code>NeverEnabled</code> - Object versioning has never been enabled.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-objectversioning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-objectversioning</a>
         * @param objectVersioning Indicates whether object versioning is enabled for the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectVersioning(final java.lang.Boolean objectVersioning) {
            this.props.objectVersioning(objectVersioning);
            return this;
        }
        /**
         * Indicates whether object versioning is enabled for the bucket.
         * <p>
         * The following options can be configured:
         * <p>
         * <ul>
         * <li><code>Enabled</code> - Object versioning is enabled.</li>
         * <li><code>Suspended</code> - Object versioning was previously enabled but is currently suspended. Existing object versions are retained.</li>
         * <li><code>NeverEnabled</code> - Object versioning has never been enabled.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-objectversioning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-objectversioning</a>
         * @param objectVersioning Indicates whether object versioning is enabled for the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectVersioning(final software.amazon.awscdk.IResolvable objectVersioning) {
            this.props.objectVersioning(objectVersioning);
            return this;
        }

        /**
         * An array of AWS account IDs that have read-only access to the bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-readonlyaccessaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-readonlyaccessaccounts</a>
         * @param readOnlyAccessAccounts An array of AWS account IDs that have read-only access to the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnlyAccessAccounts(final java.util.List<java.lang.String> readOnlyAccessAccounts) {
            this.props.readOnlyAccessAccounts(readOnlyAccessAccounts);
            return this;
        }

        /**
         * An array of Lightsail instances that have access to the bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-resourcesreceivingaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-resourcesreceivingaccess</a>
         * @param resourcesReceivingAccess An array of Lightsail instances that have access to the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesReceivingAccess(final java.util.List<java.lang.String> resourcesReceivingAccess) {
            this.props.resourcesReceivingAccess(resourcesReceivingAccess);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lightsail.CfnBucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lightsail.CfnBucket build() {
            return new software.amazon.awscdk.services.lightsail.CfnBucket(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
