package software.amazon.awscdk.services.location;

/**
 * Properties for defining a <code>CfnTrackerConsumer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnTrackerConsumerProps cfnTrackerConsumerProps = CfnTrackerConsumerProps.builder()
 *         .consumerArn("consumerArn")
 *         .trackerName("trackerName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:18.324Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnTrackerConsumerProps")
@software.amazon.jsii.Jsii.Proxy(CfnTrackerConsumerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrackerConsumerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource.
     * <p>
     * Used when you need to specify a resource across all AWS .
     * <p>
     * <ul>
     * <li>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html#cfn-location-trackerconsumer-consumerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html#cfn-location-trackerconsumer-consumerarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConsumerArn();

    /**
     * The name for the tracker resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique tracker resource name.</li>
     * <li>No spaces allowed. For example, <code>ExampleTracker</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html#cfn-location-trackerconsumer-trackername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html#cfn-location-trackerconsumer-trackername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrackerName();

    /**
     * @return a {@link Builder} of {@link CfnTrackerConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrackerConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrackerConsumerProps> {
        java.lang.String consumerArn;
        java.lang.String trackerName;

        /**
         * Sets the value of {@link CfnTrackerConsumerProps#getConsumerArn}
         * @param consumerArn The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. This parameter is required.
         *                    Used when you need to specify a resource across all AWS .
         *                    <p>
         *                    <ul>
         *                    <li>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code></li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumerArn(java.lang.String consumerArn) {
            this.consumerArn = consumerArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerConsumerProps#getTrackerName}
         * @param trackerName The name for the tracker resource. This parameter is required.
         *                    Requirements:
         *                    <p>
         *                    <ul>
         *                    <li>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</li>
         *                    <li>Must be a unique tracker resource name.</li>
         *                    <li>No spaces allowed. For example, <code>ExampleTracker</code> .</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackerName(java.lang.String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrackerConsumerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrackerConsumerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTrackerConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrackerConsumerProps {
        private final java.lang.String consumerArn;
        private final java.lang.String trackerName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.consumerArn = software.amazon.jsii.Kernel.get(this, "consumerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trackerName = software.amazon.jsii.Kernel.get(this, "trackerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.consumerArn = java.util.Objects.requireNonNull(builder.consumerArn, "consumerArn is required");
            this.trackerName = java.util.Objects.requireNonNull(builder.trackerName, "trackerName is required");
        }

        @Override
        public final java.lang.String getConsumerArn() {
            return this.consumerArn;
        }

        @Override
        public final java.lang.String getTrackerName() {
            return this.trackerName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("consumerArn", om.valueToTree(this.getConsumerArn()));
            data.set("trackerName", om.valueToTree(this.getTrackerName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_location.CfnTrackerConsumerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrackerConsumerProps.Jsii$Proxy that = (CfnTrackerConsumerProps.Jsii$Proxy) o;

            if (!consumerArn.equals(that.consumerArn)) return false;
            return this.trackerName.equals(that.trackerName);
        }

        @Override
        public final int hashCode() {
            int result = this.consumerArn.hashCode();
            result = 31 * result + (this.trackerName.hashCode());
            return result;
        }
    }
}
