package software.amazon.awscdk.services.logs;

/**
 * Properties for creating field index policies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FieldIndexPolicy fieldIndexPolicy = FieldIndexPolicy.Builder.create()
 *         .fields(List.of("Operation", "RequestId"))
 *         .build();
 * LogGroup.Builder.create(this, "LogGroup")
 *         .logGroupName("cdkIntegLogGroup")
 *         .fieldIndexPolicies(List.of(fieldIndexPolicy))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:18.506Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.FieldIndexPolicyProps")
@software.amazon.jsii.Jsii.Proxy(FieldIndexPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FieldIndexPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of fields to index in log events.
     * <p>
     * Default: no fields
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getFields();

    /**
     * @return a {@link Builder} of {@link FieldIndexPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FieldIndexPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FieldIndexPolicyProps> {
        java.util.List<java.lang.String> fields;

        /**
         * Sets the value of {@link FieldIndexPolicyProps#getFields}
         * @param fields List of fields to index in log events. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(java.util.List<java.lang.String> fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FieldIndexPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FieldIndexPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FieldIndexPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldIndexPolicyProps {
        private final java.util.List<java.lang.String> fields;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fields = software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fields = java.util.Objects.requireNonNull(builder.fields, "fields is required");
        }

        @Override
        public final java.util.List<java.lang.String> getFields() {
            return this.fields;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fields", om.valueToTree(this.getFields()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.FieldIndexPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FieldIndexPolicyProps.Jsii$Proxy that = (FieldIndexPolicyProps.Jsii$Proxy) o;

            return this.fields.equals(that.fields);
        }

        @Override
        public final int hashCode() {
            int result = this.fields.hashCode();
            return result;
        }
    }
}
