package software.amazon.awscdk.services.logs;

/**
 * This processor takes a list of objects that contain key fields, and converts them into a map of target keys.
 * <p>
 * For more information about this processor including examples, see listToMap in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * ListToMapProperty listToMapProperty = ListToMapProperty.builder()
 *         .key("key")
 *         .source("source")
 *         // the properties below are optional
 *         .flatten(false)
 *         .flattenedElement("flattenedElement")
 *         .target("target")
 *         .valueKey("valueKey")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:18.544Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.ListToMapProperty")
@software.amazon.jsii.Jsii.Proxy(ListToMapProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ListToMapProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key of the field to be extracted as keys in the generated map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKey();

    /**
     * The key in the log event that has a list of objects that will be converted to a map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * A Boolean value to indicate whether the list will be flattened into single items.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFlatten() {
        return null;
    }

    /**
     * If you set flatten to true, use flattenedElement to specify which element, first or last, to keep.
     * <p>
     * You must specify this parameter if flatten is true.
     * <p>
     * Default: - Must be specified if flatten is true and if flatten is false, has no effect
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFlattenedElement() {
        return null;
    }

    /**
     * The key of the field that will hold the generated map.
     * <p>
     * Default: - Stored at the root of the log event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
        return null;
    }

    /**
     * If this is specified, the values that you specify in this parameter will be extracted from the source objects and put into the values of the generated map.
     * <p>
     * Default: - Original objects in the source list will be put into the values of the generated map
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getValueKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ListToMapProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ListToMapProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ListToMapProperty> {
        java.lang.String key;
        java.lang.String source;
        java.lang.Boolean flatten;
        java.lang.String flattenedElement;
        java.lang.String target;
        java.lang.String valueKey;

        /**
         * Sets the value of {@link ListToMapProperty#getKey}
         * @param key The key of the field to be extracted as keys in the generated map. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link ListToMapProperty#getSource}
         * @param source The key in the log event that has a list of objects that will be converted to a map. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link ListToMapProperty#getFlatten}
         * @param flatten A Boolean value to indicate whether the list will be flattened into single items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flatten(java.lang.Boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        /**
         * Sets the value of {@link ListToMapProperty#getFlattenedElement}
         * @param flattenedElement If you set flatten to true, use flattenedElement to specify which element, first or last, to keep.
         *                         You must specify this parameter if flatten is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flattenedElement(java.lang.String flattenedElement) {
            this.flattenedElement = flattenedElement;
            return this;
        }

        /**
         * Sets the value of {@link ListToMapProperty#getTarget}
         * @param target The key of the field that will hold the generated map.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link ListToMapProperty#getValueKey}
         * @param valueKey If this is specified, the values that you specify in this parameter will be extracted from the source objects and put into the values of the generated map.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder valueKey(java.lang.String valueKey) {
            this.valueKey = valueKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ListToMapProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ListToMapProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ListToMapProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListToMapProperty {
        private final java.lang.String key;
        private final java.lang.String source;
        private final java.lang.Boolean flatten;
        private final java.lang.String flattenedElement;
        private final java.lang.String target;
        private final java.lang.String valueKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flatten = software.amazon.jsii.Kernel.get(this, "flatten", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.flattenedElement = software.amazon.jsii.Kernel.get(this, "flattenedElement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.valueKey = software.amazon.jsii.Kernel.get(this, "valueKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.flatten = builder.flatten;
            this.flattenedElement = builder.flattenedElement;
            this.target = builder.target;
            this.valueKey = builder.valueKey;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.Boolean getFlatten() {
            return this.flatten;
        }

        @Override
        public final java.lang.String getFlattenedElement() {
            return this.flattenedElement;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getValueKey() {
            return this.valueKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("source", om.valueToTree(this.getSource()));
            if (this.getFlatten() != null) {
                data.set("flatten", om.valueToTree(this.getFlatten()));
            }
            if (this.getFlattenedElement() != null) {
                data.set("flattenedElement", om.valueToTree(this.getFlattenedElement()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getValueKey() != null) {
                data.set("valueKey", om.valueToTree(this.getValueKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.ListToMapProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ListToMapProperty.Jsii$Proxy that = (ListToMapProperty.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!source.equals(that.source)) return false;
            if (this.flatten != null ? !this.flatten.equals(that.flatten) : that.flatten != null) return false;
            if (this.flattenedElement != null ? !this.flattenedElement.equals(that.flattenedElement) : that.flattenedElement != null) return false;
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            return this.valueKey != null ? this.valueKey.equals(that.valueKey) : that.valueKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.flatten != null ? this.flatten.hashCode() : 0);
            result = 31 * result + (this.flattenedElement != null ? this.flattenedElement.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.valueKey != null ? this.valueKey.hashCode() : 0);
            return result;
        }
    }
}
