package software.amazon.awscdk.services.logs;

/**
 * This processor matches a key's value against a regular expression and replaces all matches with a replacement string.
 * <p>
 * For more information about this processor including examples, see substituteString in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * SubstituteStringProperty substituteStringProperty = SubstituteStringProperty.builder()
 *         .entries(List.of(SubstituteStringEntryProperty.builder()
 *                 .from("from")
 *                 .source("source")
 *                 .to("to")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:18.595Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.SubstituteStringProperty")
@software.amazon.jsii.Jsii.Proxy(SubstituteStringProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubstituteStringProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of objects, where each object contains information about one key to match and replace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.logs.SubstituteStringEntryProperty> getEntries();

    /**
     * @return a {@link Builder} of {@link SubstituteStringProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubstituteStringProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubstituteStringProperty> {
        java.util.List<software.amazon.awscdk.services.logs.SubstituteStringEntryProperty> entries;

        /**
         * Sets the value of {@link SubstituteStringProperty#getEntries}
         * @param entries An array of objects, where each object contains information about one key to match and replace. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder entries(java.util.List<? extends software.amazon.awscdk.services.logs.SubstituteStringEntryProperty> entries) {
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.SubstituteStringEntryProperty>)entries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubstituteStringProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubstituteStringProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubstituteStringProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubstituteStringProperty {
        private final java.util.List<software.amazon.awscdk.services.logs.SubstituteStringEntryProperty> entries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SubstituteStringEntryProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.SubstituteStringEntryProperty>)java.util.Objects.requireNonNull(builder.entries, "entries is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.logs.SubstituteStringEntryProperty> getEntries() {
            return this.entries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("entries", om.valueToTree(this.getEntries()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.SubstituteStringProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubstituteStringProperty.Jsii$Proxy that = (SubstituteStringProperty.Jsii$Proxy) o;

            return this.entries.equals(that.entries);
        }

        @Override
        public final int hashCode() {
            int result = this.entries.hashCode();
            return result;
        }
    }
}
