package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnFlowEntitlement</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlowEntitlementProps cfnFlowEntitlementProps = CfnFlowEntitlementProps.builder()
 *         .description("description")
 *         .flowArn("flowArn")
 *         .name("name")
 *         .subscribers(List.of("subscribers"))
 *         // the properties below are optional
 *         .dataTransferSubscriberFeePercent(123)
 *         .encryption(EncryptionProperty.builder()
 *                 .algorithm("algorithm")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .constantInitializationVector("constantInitializationVector")
 *                 .deviceId("deviceId")
 *                 .keyType("keyType")
 *                 .region("region")
 *                 .resourceId("resourceId")
 *                 .secretArn("secretArn")
 *                 .url("url")
 *                 .build())
 *         .entitlementStatus("entitlementStatus")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:18.838Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowEntitlementProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowEntitlementProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowEntitlementProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the entitlement.
     * <p>
     * This description appears only on the MediaConnect console and is not visible outside of the current AWS account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The Amazon Resource Name (ARN) of the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-flowarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFlowArn();

    /**
     * The name of the entitlement.
     * <p>
     * This value must be unique within the current flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The AWS account IDs that you want to share your content with.
     * <p>
     * The receiving accounts (subscribers) will be allowed to create their own flows using your content as the source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-subscribers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-subscribers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubscribers();

    /**
     * The percentage of the entitlement data transfer fee that you want the subscriber to be responsible for.
     * <p>
     * Default: - 0
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-datatransfersubscriberfeepercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-datatransfersubscriberfeepercent</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDataTransferSubscriberFeePercent() {
        return null;
    }

    /**
     * Information about the encryption of the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
        return null;
    }

    /**
     * An indication of whether the new entitlement should be enabled or disabled as soon as it is created.
     * <p>
     * If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-entitlementstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-entitlementstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEntitlementStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowEntitlementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowEntitlementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowEntitlementProps> {
        java.lang.String description;
        java.lang.String flowArn;
        java.lang.String name;
        java.util.List<java.lang.String> subscribers;
        java.lang.Number dataTransferSubscriberFeePercent;
        java.lang.Object encryption;
        java.lang.String entitlementStatus;

        /**
         * Sets the value of {@link CfnFlowEntitlementProps#getDescription}
         * @param description A description of the entitlement. This parameter is required.
         *                    This description appears only on the MediaConnect console and is not visible outside of the current AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowEntitlementProps#getFlowArn}
         * @param flowArn The Amazon Resource Name (ARN) of the flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowArn(java.lang.String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowEntitlementProps#getName}
         * @param name The name of the entitlement. This parameter is required.
         *             This value must be unique within the current flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowEntitlementProps#getSubscribers}
         * @param subscribers The AWS account IDs that you want to share your content with. This parameter is required.
         *                    The receiving accounts (subscribers) will be allowed to create their own flows using your content as the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribers(java.util.List<java.lang.String> subscribers) {
            this.subscribers = subscribers;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowEntitlementProps#getDataTransferSubscriberFeePercent}
         * @param dataTransferSubscriberFeePercent The percentage of the entitlement data transfer fee that you want the subscriber to be responsible for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTransferSubscriberFeePercent(java.lang.Number dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowEntitlementProps#getEncryption}
         * @param encryption Information about the encryption of the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowEntitlementProps#getEncryption}
         * @param encryption Information about the encryption of the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement.EncryptionProperty encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowEntitlementProps#getEntitlementStatus}
         * @param entitlementStatus An indication of whether the new entitlement should be enabled or disabled as soon as it is created.
         *                          If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entitlementStatus(java.lang.String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowEntitlementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowEntitlementProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowEntitlementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowEntitlementProps {
        private final java.lang.String description;
        private final java.lang.String flowArn;
        private final java.lang.String name;
        private final java.util.List<java.lang.String> subscribers;
        private final java.lang.Number dataTransferSubscriberFeePercent;
        private final java.lang.Object encryption;
        private final java.lang.String entitlementStatus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flowArn = software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscribers = software.amazon.jsii.Kernel.get(this, "subscribers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dataTransferSubscriberFeePercent = software.amazon.jsii.Kernel.get(this, "dataTransferSubscriberFeePercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.entitlementStatus = software.amazon.jsii.Kernel.get(this, "entitlementStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.flowArn = java.util.Objects.requireNonNull(builder.flowArn, "flowArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.subscribers = java.util.Objects.requireNonNull(builder.subscribers, "subscribers is required");
            this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
            this.encryption = builder.encryption;
            this.entitlementStatus = builder.entitlementStatus;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getSubscribers() {
            return this.subscribers;
        }

        @Override
        public final java.lang.Number getDataTransferSubscriberFeePercent() {
            return this.dataTransferSubscriberFeePercent;
        }

        @Override
        public final java.lang.Object getEncryption() {
            return this.encryption;
        }

        @Override
        public final java.lang.String getEntitlementStatus() {
            return this.entitlementStatus;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("flowArn", om.valueToTree(this.getFlowArn()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("subscribers", om.valueToTree(this.getSubscribers()));
            if (this.getDataTransferSubscriberFeePercent() != null) {
                data.set("dataTransferSubscriberFeePercent", om.valueToTree(this.getDataTransferSubscriberFeePercent()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEntitlementStatus() != null) {
                data.set("entitlementStatus", om.valueToTree(this.getEntitlementStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowEntitlementProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowEntitlementProps.Jsii$Proxy that = (CfnFlowEntitlementProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!flowArn.equals(that.flowArn)) return false;
            if (!name.equals(that.name)) return false;
            if (!subscribers.equals(that.subscribers)) return false;
            if (this.dataTransferSubscriberFeePercent != null ? !this.dataTransferSubscriberFeePercent.equals(that.dataTransferSubscriberFeePercent) : that.dataTransferSubscriberFeePercent != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            return this.entitlementStatus != null ? this.entitlementStatus.equals(that.entitlementStatus) : that.entitlementStatus == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.flowArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.subscribers.hashCode());
            result = 31 * result + (this.dataTransferSubscriberFeePercent != null ? this.dataTransferSubscriberFeePercent.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.entitlementStatus != null ? this.entitlementStatus.hashCode() : 0);
            return result;
        }
    }
}
