package software.amazon.awscdk.services.msk;

/**
 * Properties for defining a <code>CfnServerlessCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.msk.*;
 * CfnServerlessClusterProps cfnServerlessClusterProps = CfnServerlessClusterProps.builder()
 *         .clientAuthentication(ClientAuthenticationProperty.builder()
 *                 .sasl(SaslProperty.builder()
 *                         .iam(IamProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .clusterName("clusterName")
 *         .vpcConfigs(List.of(VpcConfigProperty.builder()
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .securityGroups(List.of("securityGroups"))
 *                 .build()))
 *         // the properties below are optional
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:19.913Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnServerlessClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnServerlessClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServerlessClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Includes all client authentication related information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html#cfn-msk-serverlesscluster-clientauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html#cfn-msk-serverlesscluster-clientauthentication</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getClientAuthentication();

    /**
     * The name of the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html#cfn-msk-serverlesscluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html#cfn-msk-serverlesscluster-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * VPC configuration information for the serverless cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html#cfn-msk-serverlesscluster-vpcconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html#cfn-msk-serverlesscluster-vpcconfigs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVpcConfigs();

    /**
     * An arbitrary set of tags (key-value pairs) for the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html#cfn-msk-serverlesscluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-serverlesscluster.html#cfn-msk-serverlesscluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServerlessClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServerlessClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServerlessClusterProps> {
        java.lang.Object clientAuthentication;
        java.lang.String clusterName;
        java.lang.Object vpcConfigs;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnServerlessClusterProps#getClientAuthentication}
         * @param clientAuthentication Includes all client authentication related information. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientAuthentication(software.amazon.awscdk.IResolvable clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessClusterProps#getClientAuthentication}
         * @param clientAuthentication Includes all client authentication related information. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientAuthentication(software.amazon.awscdk.services.msk.CfnServerlessCluster.ClientAuthenticationProperty clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessClusterProps#getClusterName}
         * @param clusterName The name of the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessClusterProps#getVpcConfigs}
         * @param vpcConfigs VPC configuration information for the serverless cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfigs(software.amazon.awscdk.IResolvable vpcConfigs) {
            this.vpcConfigs = vpcConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessClusterProps#getVpcConfigs}
         * @param vpcConfigs VPC configuration information for the serverless cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfigs(java.util.List<? extends java.lang.Object> vpcConfigs) {
            this.vpcConfigs = vpcConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerlessClusterProps#getTags}
         * @param tags An arbitrary set of tags (key-value pairs) for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServerlessClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServerlessClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServerlessClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServerlessClusterProps {
        private final java.lang.Object clientAuthentication;
        private final java.lang.String clusterName;
        private final java.lang.Object vpcConfigs;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientAuthentication = software.amazon.jsii.Kernel.get(this, "clientAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcConfigs = software.amazon.jsii.Kernel.get(this, "vpcConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientAuthentication = java.util.Objects.requireNonNull(builder.clientAuthentication, "clientAuthentication is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.vpcConfigs = java.util.Objects.requireNonNull(builder.vpcConfigs, "vpcConfigs is required");
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getClientAuthentication() {
            return this.clientAuthentication;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.Object getVpcConfigs() {
            return this.vpcConfigs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientAuthentication", om.valueToTree(this.getClientAuthentication()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("vpcConfigs", om.valueToTree(this.getVpcConfigs()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnServerlessClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServerlessClusterProps.Jsii$Proxy that = (CfnServerlessClusterProps.Jsii$Proxy) o;

            if (!clientAuthentication.equals(that.clientAuthentication)) return false;
            if (!clusterName.equals(that.clusterName)) return false;
            if (!vpcConfigs.equals(that.vpcConfigs)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientAuthentication.hashCode();
            result = 31 * result + (this.clusterName.hashCode());
            result = 31 * result + (this.vpcConfigs.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
