package software.amazon.awscdk.services.neptune;

/**
 * Properties for defining a <code>CfnDBCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.neptune.*;
 * CfnDBClusterProps cfnDBClusterProps = CfnDBClusterProps.builder()
 *         .associatedRoles(List.of(DBClusterRoleProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .featureName("featureName")
 *                 .build()))
 *         .availabilityZones(List.of("availabilityZones"))
 *         .backupRetentionPeriod(123)
 *         .copyTagsToSnapshot(false)
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbClusterParameterGroupName("dbClusterParameterGroupName")
 *         .dbInstanceParameterGroupName("dbInstanceParameterGroupName")
 *         .dbPort(123)
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .deletionProtection(false)
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .engineVersion("engineVersion")
 *         .iamAuthEnabled(false)
 *         .kmsKeyId("kmsKeyId")
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .restoreToTime("restoreToTime")
 *         .restoreType("restoreType")
 *         .serverlessScalingConfiguration(ServerlessScalingConfigurationProperty.builder()
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .build())
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .storageEncrypted(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useLatestRestorableTime(false)
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:19.929Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_neptune.CfnDBClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon services on your behalf.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-associatedroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-associatedroles</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return null;
    }

    /**
     * Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-availabilityzones">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-availabilityzones</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return null;
    }

    /**
     * Specifies the number of days for which automatic DB snapshots are retained.
     * <p>
     * An update may require some interruption. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-instances.html#ModifyDBInstance">ModifyDBInstance</a> in the Amazon Neptune User Guide for more information.
     * <p>
     * Default: - 1
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-backupretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-backupretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return null;
    }

    /**
     * <em>If set to <code>true</code> , tags are copied to any snapshot of the DB cluster that is created.</em>.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-copytagstosnapshot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-copytagstosnapshot</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return null;
    }

    /**
     * Contains a user-supplied DB cluster identifier.
     * <p>
     * This identifier is the unique key that identifies a DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return null;
    }

    /**
     * Provides the name of the DB cluster parameter group.
     * <p>
     * An update may require some interruption. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-instances.html#ModifyDBInstance">ModifyDBInstance</a> in the Amazon Neptune User Guide for more information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbclusterparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbclusterparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterParameterGroupName() {
        return null;
    }

    /**
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     * <p>
     * Used only in case of a major engine version upgrade request
     * <p>
     * Note that when you apply a parameter group using <code>DBInstanceParameterGroupName</code> , parameter changes are applied immediately, not during the next maintenance window.
     * <p>
     * <strong>Constraints</strong> - The DB parameter group must be in the same DB parameter group family as the target DB cluster version.
     * <p>
     * <ul>
     * <li>The <code>DBInstanceParameterGroupName</code> parameter is only valid for major engine version upgrades.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbinstanceparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbinstanceparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceParameterGroupName() {
        return null;
    }

    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     * <p>
     * If not specified, the default port used is <code>8182</code> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Port</code> property will soon be deprecated. Please update existing templates to use the new <code>DBPort</code> property that has the same functionality.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDbPort() {
        return null;
    }

    /**
     * Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbsubnetgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-dbsubnetgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return null;
    }

    /**
     * Indicates whether or not the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-deletionprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return null;
    }

    /**
     * Specifies a list of log types that are enabled for export to CloudWatch Logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-enablecloudwatchlogsexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-enablecloudwatchlogsexports</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return null;
    }

    /**
     * Indicates the database engine version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-iamauthenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-iamauthenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIamAuthEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the database instances in the DB cluster, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
     * <p>
     * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code> .
     * <p>
     * An update may require some interruption.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-preferredbackupwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-preferredbackupwindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return null;
    }

    /**
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-preferredmaintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-restoretotime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-restoretotime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRestoreToTime() {
        return null;
    }

    /**
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
     * <p>
     * Default: - "full-copy"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-restoretype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-restoretype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRestoreType() {
        return null;
    }

    /**
     * Contains the scaling configuration of an Neptune Serverless DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-serverlessscalingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-serverlessscalingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServerlessScalingConfiguration() {
        return null;
    }

    /**
     * Specifies the identifier for a DB cluster snapshot. Must match the identifier of an existing snapshot.
     * <p>
     * After you restore a DB cluster using a <code>SnapshotIdentifier</code> , you must specify the same <code>SnapshotIdentifier</code> for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed.
     * <p>
     * However, if you don't specify the <code>SnapshotIdentifier</code> , an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the snapshot specified by the <code>SnapshotIdentifier</code> , and the original DB cluster is deleted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-snapshotidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-snapshotidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return null;
    }

    /**
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-sourcedbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-sourcedbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return null;
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption and set this property to <code>true</code> .
     * <p>
     * If you enable the <code>StorageEncrypted</code> property but don't specify the <code>KmsKeyId</code> property, then the default KMS key is used. If you specify the <code>KmsKeyId</code> property, then that KMS key is used to encrypt the database instances in the DB cluster.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, and don't specify this property or disable it, the value is inherited from the source DB cluster. If the source DB cluster is encrypted, the <code>KmsKeyId</code> property from the source cluster is used.
     * <p>
     * If you specify the <code>DBSnapshotIdentifier</code> and don't specify this property or disable it, the value is inherited from the snapshot and the specified <code>KmsKeyId</code> property from the snapshot is used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-storageencrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-storageencrypted</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return null;
    }

    /**
     * The tags assigned to this cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-uselatestrestorabletime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-uselatestrestorabletime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseLatestRestorableTime() {
        return null;
    }

    /**
     * Provides a list of VPC security groups that the DB cluster belongs to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-vpcsecuritygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptune-dbcluster.html#cfn-neptune-dbcluster-vpcsecuritygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBClusterProps> {
        java.lang.Object associatedRoles;
        java.util.List<java.lang.String> availabilityZones;
        java.lang.Number backupRetentionPeriod;
        java.lang.Object copyTagsToSnapshot;
        java.lang.String dbClusterIdentifier;
        java.lang.String dbClusterParameterGroupName;
        java.lang.String dbInstanceParameterGroupName;
        java.lang.Number dbPort;
        java.lang.String dbSubnetGroupName;
        java.lang.Object deletionProtection;
        java.util.List<java.lang.String> enableCloudwatchLogsExports;
        java.lang.String engineVersion;
        java.lang.Object iamAuthEnabled;
        java.lang.String kmsKeyId;
        java.lang.String preferredBackupWindow;
        java.lang.String preferredMaintenanceWindow;
        java.lang.String restoreToTime;
        java.lang.String restoreType;
        java.lang.Object serverlessScalingConfiguration;
        java.lang.String snapshotIdentifier;
        java.lang.String sourceDbClusterIdentifier;
        java.lang.Object storageEncrypted;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object useLatestRestorableTime;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnDBClusterProps#getAssociatedRoles}
         * @param associatedRoles Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB cluster.
         *                        IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon services on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(software.amazon.awscdk.IResolvable associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAssociatedRoles}
         * @param associatedRoles Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB cluster.
         *                        IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon services on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(java.util.List<? extends java.lang.Object> associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAvailabilityZones}
         * @param availabilityZones Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getBackupRetentionPeriod}
         * @param backupRetentionPeriod Specifies the number of days for which automatic DB snapshots are retained.
         *                              An update may require some interruption. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-instances.html#ModifyDBInstance">ModifyDBInstance</a> in the Amazon Neptune User Guide for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(java.lang.Number backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot <em>If set to <code>true</code> , tags are copied to any snapshot of the DB cluster that is created.</em>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(java.lang.Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot <em>If set to <code>true</code> , tags are copied to any snapshot of the DB cluster that is created.</em>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbClusterIdentifier}
         * @param dbClusterIdentifier Contains a user-supplied DB cluster identifier.
         *                            This identifier is the unique key that identifies a DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(java.lang.String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbClusterParameterGroupName}
         * @param dbClusterParameterGroupName Provides the name of the DB cluster parameter group.
         *                                    An update may require some interruption. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/api-instances.html#ModifyDBInstance">ModifyDBInstance</a> in the Amazon Neptune User Guide for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterParameterGroupName(java.lang.String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbInstanceParameterGroupName}
         * @param dbInstanceParameterGroupName The name of the DB parameter group to apply to all instances of the DB cluster.
         *                                     Used only in case of a major engine version upgrade request
         *                                     <p>
         *                                     Note that when you apply a parameter group using <code>DBInstanceParameterGroupName</code> , parameter changes are applied immediately, not during the next maintenance window.
         *                                     <p>
         *                                     <strong>Constraints</strong> - The DB parameter group must be in the same DB parameter group family as the target DB cluster version.
         *                                     <p>
         *                                     <ul>
         *                                     <li>The <code>DBInstanceParameterGroupName</code> parameter is only valid for major engine version upgrades.</li>
         *                                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceParameterGroupName(java.lang.String dbInstanceParameterGroupName) {
            this.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbPort}
         * @param dbPort The port number on which the DB instances in the DB cluster accept connections.
         *               If not specified, the default port used is <code>8182</code> .
         *               <p>
         *               <blockquote>
         *               <p>
         *               The <code>Port</code> property will soon be deprecated. Please update existing templates to use the new <code>DBPort</code> property that has the same functionality.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbPort(java.lang.Number dbPort) {
            this.dbPort = dbPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbSubnetGroupName}
         * @param dbSubnetGroupName Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(java.lang.String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDeletionProtection}
         * @param deletionProtection Indicates whether or not the DB cluster has deletion protection enabled.
         *                           The database can't be deleted when deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDeletionProtection}
         * @param deletionProtection Indicates whether or not the DB cluster has deletion protection enabled.
         *                           The database can't be deleted when deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(software.amazon.awscdk.IResolvable deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableCloudwatchLogsExports}
         * @param enableCloudwatchLogsExports Specifies a list of log types that are enabled for export to CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = enableCloudwatchLogsExports;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEngineVersion}
         * @param engineVersion Indicates the database engine version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getIamAuthEnabled}
         * @param iamAuthEnabled True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuthEnabled(java.lang.Boolean iamAuthEnabled) {
            this.iamAuthEnabled = iamAuthEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getIamAuthEnabled}
         * @param iamAuthEnabled True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuthEnabled(software.amazon.awscdk.IResolvable iamAuthEnabled) {
            this.iamAuthEnabled = iamAuthEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getKmsKeyId}
         * @param kmsKeyId The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the database instances in the DB cluster, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
         *                 If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPreferredBackupWindow}
         * @param preferredBackupWindow Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code> .
         *                              An update may require some interruption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getRestoreToTime}
         * @param restoreToTime Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
         *                      If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
         *                      <p>
         *                      If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreToTime(java.lang.String restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getRestoreType}
         * @param restoreType Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
         *                    If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
         *                    <p>
         *                    If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreType(java.lang.String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getServerlessScalingConfiguration}
         * @param serverlessScalingConfiguration Contains the scaling configuration of an Neptune Serverless DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessScalingConfiguration(software.amazon.awscdk.IResolvable serverlessScalingConfiguration) {
            this.serverlessScalingConfiguration = serverlessScalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getServerlessScalingConfiguration}
         * @param serverlessScalingConfiguration Contains the scaling configuration of an Neptune Serverless DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessScalingConfiguration(software.amazon.awscdk.services.neptune.CfnDBCluster.ServerlessScalingConfigurationProperty serverlessScalingConfiguration) {
            this.serverlessScalingConfiguration = serverlessScalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSnapshotIdentifier}
         * @param snapshotIdentifier Specifies the identifier for a DB cluster snapshot. Must match the identifier of an existing snapshot.
         *                           After you restore a DB cluster using a <code>SnapshotIdentifier</code> , you must specify the same <code>SnapshotIdentifier</code> for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed.
         *                           <p>
         *                           However, if you don't specify the <code>SnapshotIdentifier</code> , an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the snapshot specified by the <code>SnapshotIdentifier</code> , and the original DB cluster is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(java.lang.String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSourceDbClusterIdentifier}
         * @param sourceDbClusterIdentifier Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
         *                                  If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
         *                                  <p>
         *                                  If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(java.lang.String sourceDbClusterIdentifier) {
            this.sourceDbClusterIdentifier = sourceDbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getStorageEncrypted}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted.
         *                         If you specify the <code>KmsKeyId</code> property, then you must enable encryption and set this property to <code>true</code> .
         *                         <p>
         *                         If you enable the <code>StorageEncrypted</code> property but don't specify the <code>KmsKeyId</code> property, then the default KMS key is used. If you specify the <code>KmsKeyId</code> property, then that KMS key is used to encrypt the database instances in the DB cluster.
         *                         <p>
         *                         If you specify the <code>SourceDBClusterIdentifier</code> property, and don't specify this property or disable it, the value is inherited from the source DB cluster. If the source DB cluster is encrypted, the <code>KmsKeyId</code> property from the source cluster is used.
         *                         <p>
         *                         If you specify the <code>DBSnapshotIdentifier</code> and don't specify this property or disable it, the value is inherited from the snapshot and the specified <code>KmsKeyId</code> property from the snapshot is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getStorageEncrypted}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted.
         *                         If you specify the <code>KmsKeyId</code> property, then you must enable encryption and set this property to <code>true</code> .
         *                         <p>
         *                         If you enable the <code>StorageEncrypted</code> property but don't specify the <code>KmsKeyId</code> property, then the default KMS key is used. If you specify the <code>KmsKeyId</code> property, then that KMS key is used to encrypt the database instances in the DB cluster.
         *                         <p>
         *                         If you specify the <code>SourceDBClusterIdentifier</code> property, and don't specify this property or disable it, the value is inherited from the source DB cluster. If the source DB cluster is encrypted, the <code>KmsKeyId</code> property from the source cluster is used.
         *                         <p>
         *                         If you specify the <code>DBSnapshotIdentifier</code> and don't specify this property or disable it, the value is inherited from the snapshot and the specified <code>KmsKeyId</code> property from the snapshot is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(software.amazon.awscdk.IResolvable storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getTags}
         * @param tags The tags assigned to this cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getUseLatestRestorableTime}
         * @param useLatestRestorableTime Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
         *                                If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
         *                                <p>
         *                                If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(java.lang.Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getUseLatestRestorableTime}
         * @param useLatestRestorableTime Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
         *                                If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
         *                                <p>
         *                                If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(software.amazon.awscdk.IResolvable useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds Provides a list of VPC security groups that the DB cluster belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBClusterProps {
        private final java.lang.Object associatedRoles;
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Number backupRetentionPeriod;
        private final java.lang.Object copyTagsToSnapshot;
        private final java.lang.String dbClusterIdentifier;
        private final java.lang.String dbClusterParameterGroupName;
        private final java.lang.String dbInstanceParameterGroupName;
        private final java.lang.Number dbPort;
        private final java.lang.String dbSubnetGroupName;
        private final java.lang.Object deletionProtection;
        private final java.util.List<java.lang.String> enableCloudwatchLogsExports;
        private final java.lang.String engineVersion;
        private final java.lang.Object iamAuthEnabled;
        private final java.lang.String kmsKeyId;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.String restoreToTime;
        private final java.lang.String restoreType;
        private final java.lang.Object serverlessScalingConfiguration;
        private final java.lang.String snapshotIdentifier;
        private final java.lang.String sourceDbClusterIdentifier;
        private final java.lang.Object storageEncrypted;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object useLatestRestorableTime;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.associatedRoles = software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.backupRetentionPeriod = software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.copyTagsToSnapshot = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterParameterGroupName = software.amazon.jsii.Kernel.get(this, "dbClusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbInstanceParameterGroupName = software.amazon.jsii.Kernel.get(this, "dbInstanceParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbPort = software.amazon.jsii.Kernel.get(this, "dbPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dbSubnetGroupName = software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableCloudwatchLogsExports = software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamAuthEnabled = software.amazon.jsii.Kernel.get(this, "iamAuthEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreToTime = software.amazon.jsii.Kernel.get(this, "restoreToTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreType = software.amazon.jsii.Kernel.get(this, "restoreType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverlessScalingConfiguration = software.amazon.jsii.Kernel.get(this, "serverlessScalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotIdentifier = software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.useLatestRestorableTime = software.amazon.jsii.Kernel.get(this, "useLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.associatedRoles = builder.associatedRoles;
            this.availabilityZones = builder.availabilityZones;
            this.backupRetentionPeriod = builder.backupRetentionPeriod;
            this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
            this.dbClusterIdentifier = builder.dbClusterIdentifier;
            this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
            this.dbInstanceParameterGroupName = builder.dbInstanceParameterGroupName;
            this.dbPort = builder.dbPort;
            this.dbSubnetGroupName = builder.dbSubnetGroupName;
            this.deletionProtection = builder.deletionProtection;
            this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
            this.engineVersion = builder.engineVersion;
            this.iamAuthEnabled = builder.iamAuthEnabled;
            this.kmsKeyId = builder.kmsKeyId;
            this.preferredBackupWindow = builder.preferredBackupWindow;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.restoreToTime = builder.restoreToTime;
            this.restoreType = builder.restoreType;
            this.serverlessScalingConfiguration = builder.serverlessScalingConfiguration;
            this.snapshotIdentifier = builder.snapshotIdentifier;
            this.sourceDbClusterIdentifier = builder.sourceDbClusterIdentifier;
            this.storageEncrypted = builder.storageEncrypted;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.useLatestRestorableTime = builder.useLatestRestorableTime;
            this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        }

        @Override
        public final java.lang.Object getAssociatedRoles() {
            return this.associatedRoles;
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.Number getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final java.lang.Object getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final java.lang.String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final java.lang.String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final java.lang.String getDbInstanceParameterGroupName() {
            return this.dbInstanceParameterGroupName;
        }

        @Override
        public final java.lang.Number getDbPort() {
            return this.dbPort;
        }

        @Override
        public final java.lang.String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final java.lang.Object getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.Object getIamAuthEnabled() {
            return this.iamAuthEnabled;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.String getRestoreToTime() {
            return this.restoreToTime;
        }

        @Override
        public final java.lang.String getRestoreType() {
            return this.restoreType;
        }

        @Override
        public final java.lang.Object getServerlessScalingConfiguration() {
            return this.serverlessScalingConfiguration;
        }

        @Override
        public final java.lang.String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final java.lang.String getSourceDbClusterIdentifier() {
            return this.sourceDbClusterIdentifier;
        }

        @Override
        public final java.lang.Object getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssociatedRoles() != null) {
                data.set("associatedRoles", om.valueToTree(this.getAssociatedRoles()));
            }
            if (this.getAvailabilityZones() != null) {
                data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            }
            if (this.getBackupRetentionPeriod() != null) {
                data.set("backupRetentionPeriod", om.valueToTree(this.getBackupRetentionPeriod()));
            }
            if (this.getCopyTagsToSnapshot() != null) {
                data.set("copyTagsToSnapshot", om.valueToTree(this.getCopyTagsToSnapshot()));
            }
            if (this.getDbClusterIdentifier() != null) {
                data.set("dbClusterIdentifier", om.valueToTree(this.getDbClusterIdentifier()));
            }
            if (this.getDbClusterParameterGroupName() != null) {
                data.set("dbClusterParameterGroupName", om.valueToTree(this.getDbClusterParameterGroupName()));
            }
            if (this.getDbInstanceParameterGroupName() != null) {
                data.set("dbInstanceParameterGroupName", om.valueToTree(this.getDbInstanceParameterGroupName()));
            }
            if (this.getDbPort() != null) {
                data.set("dbPort", om.valueToTree(this.getDbPort()));
            }
            if (this.getDbSubnetGroupName() != null) {
                data.set("dbSubnetGroupName", om.valueToTree(this.getDbSubnetGroupName()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getEnableCloudwatchLogsExports() != null) {
                data.set("enableCloudwatchLogsExports", om.valueToTree(this.getEnableCloudwatchLogsExports()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getIamAuthEnabled() != null) {
                data.set("iamAuthEnabled", om.valueToTree(this.getIamAuthEnabled()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getRestoreToTime() != null) {
                data.set("restoreToTime", om.valueToTree(this.getRestoreToTime()));
            }
            if (this.getRestoreType() != null) {
                data.set("restoreType", om.valueToTree(this.getRestoreType()));
            }
            if (this.getServerlessScalingConfiguration() != null) {
                data.set("serverlessScalingConfiguration", om.valueToTree(this.getServerlessScalingConfiguration()));
            }
            if (this.getSnapshotIdentifier() != null) {
                data.set("snapshotIdentifier", om.valueToTree(this.getSnapshotIdentifier()));
            }
            if (this.getSourceDbClusterIdentifier() != null) {
                data.set("sourceDbClusterIdentifier", om.valueToTree(this.getSourceDbClusterIdentifier()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUseLatestRestorableTime() != null) {
                data.set("useLatestRestorableTime", om.valueToTree(this.getUseLatestRestorableTime()));
            }
            if (this.getVpcSecurityGroupIds() != null) {
                data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_neptune.CfnDBClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBClusterProps.Jsii$Proxy that = (CfnDBClusterProps.Jsii$Proxy) o;

            if (this.associatedRoles != null ? !this.associatedRoles.equals(that.associatedRoles) : that.associatedRoles != null) return false;
            if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
            if (this.backupRetentionPeriod != null ? !this.backupRetentionPeriod.equals(that.backupRetentionPeriod) : that.backupRetentionPeriod != null) return false;
            if (this.copyTagsToSnapshot != null ? !this.copyTagsToSnapshot.equals(that.copyTagsToSnapshot) : that.copyTagsToSnapshot != null) return false;
            if (this.dbClusterIdentifier != null ? !this.dbClusterIdentifier.equals(that.dbClusterIdentifier) : that.dbClusterIdentifier != null) return false;
            if (this.dbClusterParameterGroupName != null ? !this.dbClusterParameterGroupName.equals(that.dbClusterParameterGroupName) : that.dbClusterParameterGroupName != null) return false;
            if (this.dbInstanceParameterGroupName != null ? !this.dbInstanceParameterGroupName.equals(that.dbInstanceParameterGroupName) : that.dbInstanceParameterGroupName != null) return false;
            if (this.dbPort != null ? !this.dbPort.equals(that.dbPort) : that.dbPort != null) return false;
            if (this.dbSubnetGroupName != null ? !this.dbSubnetGroupName.equals(that.dbSubnetGroupName) : that.dbSubnetGroupName != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.enableCloudwatchLogsExports != null ? !this.enableCloudwatchLogsExports.equals(that.enableCloudwatchLogsExports) : that.enableCloudwatchLogsExports != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.iamAuthEnabled != null ? !this.iamAuthEnabled.equals(that.iamAuthEnabled) : that.iamAuthEnabled != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.restoreToTime != null ? !this.restoreToTime.equals(that.restoreToTime) : that.restoreToTime != null) return false;
            if (this.restoreType != null ? !this.restoreType.equals(that.restoreType) : that.restoreType != null) return false;
            if (this.serverlessScalingConfiguration != null ? !this.serverlessScalingConfiguration.equals(that.serverlessScalingConfiguration) : that.serverlessScalingConfiguration != null) return false;
            if (this.snapshotIdentifier != null ? !this.snapshotIdentifier.equals(that.snapshotIdentifier) : that.snapshotIdentifier != null) return false;
            if (this.sourceDbClusterIdentifier != null ? !this.sourceDbClusterIdentifier.equals(that.sourceDbClusterIdentifier) : that.sourceDbClusterIdentifier != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.useLatestRestorableTime != null ? !this.useLatestRestorableTime.equals(that.useLatestRestorableTime) : that.useLatestRestorableTime != null) return false;
            return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.associatedRoles != null ? this.associatedRoles.hashCode() : 0;
            result = 31 * result + (this.availabilityZones != null ? this.availabilityZones.hashCode() : 0);
            result = 31 * result + (this.backupRetentionPeriod != null ? this.backupRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.copyTagsToSnapshot != null ? this.copyTagsToSnapshot.hashCode() : 0);
            result = 31 * result + (this.dbClusterIdentifier != null ? this.dbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.dbClusterParameterGroupName != null ? this.dbClusterParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.dbInstanceParameterGroupName != null ? this.dbInstanceParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.dbPort != null ? this.dbPort.hashCode() : 0);
            result = 31 * result + (this.dbSubnetGroupName != null ? this.dbSubnetGroupName.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.enableCloudwatchLogsExports != null ? this.enableCloudwatchLogsExports.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.iamAuthEnabled != null ? this.iamAuthEnabled.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.restoreToTime != null ? this.restoreToTime.hashCode() : 0);
            result = 31 * result + (this.restoreType != null ? this.restoreType.hashCode() : 0);
            result = 31 * result + (this.serverlessScalingConfiguration != null ? this.serverlessScalingConfiguration.hashCode() : 0);
            result = 31 * result + (this.snapshotIdentifier != null ? this.snapshotIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceDbClusterIdentifier != null ? this.sourceDbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.useLatestRestorableTime != null ? this.useLatestRestorableTime.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
            return result;
        }
    }
}
