package software.amazon.awscdk.services.observabilityadmin;

/**
 * The AWS::ObservabilityAdmin::TelemetryRule resource defines a CloudWatch Observability Admin Telemetry Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.observabilityadmin.*;
 * CfnTelemetryRule cfnTelemetryRule = CfnTelemetryRule.Builder.create(this, "MyCfnTelemetryRule")
 *         .rule(TelemetryRuleProperty.builder()
 *                 .resourceType("resourceType")
 *                 .telemetryType("telemetryType")
 *                 // the properties below are optional
 *                 .destinationConfiguration(TelemetryDestinationConfigurationProperty.builder()
 *                         .destinationPattern("destinationPattern")
 *                         .destinationType("destinationType")
 *                         .retentionInDays(123)
 *                         .vpcFlowLogParameters(VPCFlowLogParametersProperty.builder()
 *                                 .logFormat("logFormat")
 *                                 .maxAggregationInterval(123)
 *                                 .trafficType("trafficType")
 *                                 .build())
 *                         .build())
 *                 .selectionCriteria("selectionCriteria")
 *                 .build())
 *         .ruleName("ruleName")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:20.120Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnTelemetryRule")
public class CfnTelemetryRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnTelemetryRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTelemetryRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTelemetryRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The arn of the telemetry rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The telemetry rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRule() {
        return software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The telemetry rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rule", java.util.Objects.requireNonNull(value, "rule is required"));
    }

    /**
     * The telemetry rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule.TelemetryRuleProperty value) {
        software.amazon.jsii.Kernel.set(this, "rule", java.util.Objects.requireNonNull(value, "rule is required"));
    }

    /**
     * The name of the telemetry rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleName() {
        return software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the telemetry rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleName", java.util.Objects.requireNonNull(value, "ruleName is required"));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The destination configuration for telemetry data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * TelemetryDestinationConfigurationProperty telemetryDestinationConfigurationProperty = TelemetryDestinationConfigurationProperty.builder()
     *         .destinationPattern("destinationPattern")
     *         .destinationType("destinationType")
     *         .retentionInDays(123)
     *         .vpcFlowLogParameters(VPCFlowLogParametersProperty.builder()
     *                 .logFormat("logFormat")
     *                 .maxAggregationInterval(123)
     *                 .trafficType("trafficType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnTelemetryRule.TelemetryDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TelemetryDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TelemetryDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Pattern for telemetry data destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html#cfn-observabilityadmin-telemetryrule-telemetrydestinationconfiguration-destinationpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html#cfn-observabilityadmin-telemetryrule-telemetrydestinationconfiguration-destinationpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPattern() {
            return null;
        }

        /**
         * Type of telemetry destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html#cfn-observabilityadmin-telemetryrule-telemetrydestinationconfiguration-destinationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html#cfn-observabilityadmin-telemetryrule-telemetrydestinationconfiguration-destinationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationType() {
            return null;
        }

        /**
         * Number of days to retain the telemetry data in the specified destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html#cfn-observabilityadmin-telemetryrule-telemetrydestinationconfiguration-retentionindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html#cfn-observabilityadmin-telemetryrule-telemetrydestinationconfiguration-retentionindays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionInDays() {
            return null;
        }

        /**
         * Telemetry parameters for VPC Flow logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html#cfn-observabilityadmin-telemetryrule-telemetrydestinationconfiguration-vpcflowlogparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetrydestinationconfiguration.html#cfn-observabilityadmin-telemetryrule-telemetrydestinationconfiguration-vpcflowlogparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcFlowLogParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TelemetryDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TelemetryDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TelemetryDestinationConfigurationProperty> {
            java.lang.String destinationPattern;
            java.lang.String destinationType;
            java.lang.Number retentionInDays;
            java.lang.Object vpcFlowLogParameters;

            /**
             * Sets the value of {@link TelemetryDestinationConfigurationProperty#getDestinationPattern}
             * @param destinationPattern Pattern for telemetry data destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPattern(java.lang.String destinationPattern) {
                this.destinationPattern = destinationPattern;
                return this;
            }

            /**
             * Sets the value of {@link TelemetryDestinationConfigurationProperty#getDestinationType}
             * @param destinationType Type of telemetry destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationType(java.lang.String destinationType) {
                this.destinationType = destinationType;
                return this;
            }

            /**
             * Sets the value of {@link TelemetryDestinationConfigurationProperty#getRetentionInDays}
             * @param retentionInDays Number of days to retain the telemetry data in the specified destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionInDays(java.lang.Number retentionInDays) {
                this.retentionInDays = retentionInDays;
                return this;
            }

            /**
             * Sets the value of {@link TelemetryDestinationConfigurationProperty#getVpcFlowLogParameters}
             * @param vpcFlowLogParameters Telemetry parameters for VPC Flow logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcFlowLogParameters(software.amazon.awscdk.IResolvable vpcFlowLogParameters) {
                this.vpcFlowLogParameters = vpcFlowLogParameters;
                return this;
            }

            /**
             * Sets the value of {@link TelemetryDestinationConfigurationProperty#getVpcFlowLogParameters}
             * @param vpcFlowLogParameters Telemetry parameters for VPC Flow logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcFlowLogParameters(software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule.VPCFlowLogParametersProperty vpcFlowLogParameters) {
                this.vpcFlowLogParameters = vpcFlowLogParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TelemetryDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TelemetryDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TelemetryDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TelemetryDestinationConfigurationProperty {
            private final java.lang.String destinationPattern;
            private final java.lang.String destinationType;
            private final java.lang.Number retentionInDays;
            private final java.lang.Object vpcFlowLogParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationPattern = software.amazon.jsii.Kernel.get(this, "destinationPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationType = software.amazon.jsii.Kernel.get(this, "destinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retentionInDays = software.amazon.jsii.Kernel.get(this, "retentionInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.vpcFlowLogParameters = software.amazon.jsii.Kernel.get(this, "vpcFlowLogParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationPattern = builder.destinationPattern;
                this.destinationType = builder.destinationType;
                this.retentionInDays = builder.retentionInDays;
                this.vpcFlowLogParameters = builder.vpcFlowLogParameters;
            }

            @Override
            public final java.lang.String getDestinationPattern() {
                return this.destinationPattern;
            }

            @Override
            public final java.lang.String getDestinationType() {
                return this.destinationType;
            }

            @Override
            public final java.lang.Number getRetentionInDays() {
                return this.retentionInDays;
            }

            @Override
            public final java.lang.Object getVpcFlowLogParameters() {
                return this.vpcFlowLogParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationPattern() != null) {
                    data.set("destinationPattern", om.valueToTree(this.getDestinationPattern()));
                }
                if (this.getDestinationType() != null) {
                    data.set("destinationType", om.valueToTree(this.getDestinationType()));
                }
                if (this.getRetentionInDays() != null) {
                    data.set("retentionInDays", om.valueToTree(this.getRetentionInDays()));
                }
                if (this.getVpcFlowLogParameters() != null) {
                    data.set("vpcFlowLogParameters", om.valueToTree(this.getVpcFlowLogParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnTelemetryRule.TelemetryDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TelemetryDestinationConfigurationProperty.Jsii$Proxy that = (TelemetryDestinationConfigurationProperty.Jsii$Proxy) o;

                if (this.destinationPattern != null ? !this.destinationPattern.equals(that.destinationPattern) : that.destinationPattern != null) return false;
                if (this.destinationType != null ? !this.destinationType.equals(that.destinationType) : that.destinationType != null) return false;
                if (this.retentionInDays != null ? !this.retentionInDays.equals(that.retentionInDays) : that.retentionInDays != null) return false;
                return this.vpcFlowLogParameters != null ? this.vpcFlowLogParameters.equals(that.vpcFlowLogParameters) : that.vpcFlowLogParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationPattern != null ? this.destinationPattern.hashCode() : 0;
                result = 31 * result + (this.destinationType != null ? this.destinationType.hashCode() : 0);
                result = 31 * result + (this.retentionInDays != null ? this.retentionInDays.hashCode() : 0);
                result = 31 * result + (this.vpcFlowLogParameters != null ? this.vpcFlowLogParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The telemetry rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * TelemetryRuleProperty telemetryRuleProperty = TelemetryRuleProperty.builder()
     *         .resourceType("resourceType")
     *         .telemetryType("telemetryType")
     *         // the properties below are optional
     *         .destinationConfiguration(TelemetryDestinationConfigurationProperty.builder()
     *                 .destinationPattern("destinationPattern")
     *                 .destinationType("destinationType")
     *                 .retentionInDays(123)
     *                 .vpcFlowLogParameters(VPCFlowLogParametersProperty.builder()
     *                         .logFormat("logFormat")
     *                         .maxAggregationInterval(123)
     *                         .trafficType("trafficType")
     *                         .build())
     *                 .build())
     *         .selectionCriteria("selectionCriteria")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnTelemetryRule.TelemetryRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(TelemetryRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TelemetryRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Resource Type associated with the Telemetry Rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html#cfn-observabilityadmin-telemetryrule-telemetryrule-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html#cfn-observabilityadmin-telemetryrule-telemetryrule-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

        /**
         * Telemetry Type associated with the Telemetry Rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html#cfn-observabilityadmin-telemetryrule-telemetryrule-telemetrytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html#cfn-observabilityadmin-telemetryrule-telemetryrule-telemetrytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTelemetryType();

        /**
         * The destination configuration for telemetry data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html#cfn-observabilityadmin-telemetryrule-telemetryrule-destinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html#cfn-observabilityadmin-telemetryrule-telemetryrule-destinationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfiguration() {
            return null;
        }

        /**
         * Selection Criteria on resource level for rule application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html#cfn-observabilityadmin-telemetryrule-telemetryrule-selectioncriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-telemetryrule.html#cfn-observabilityadmin-telemetryrule-telemetryrule-selectioncriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelectionCriteria() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TelemetryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TelemetryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TelemetryRuleProperty> {
            java.lang.String resourceType;
            java.lang.String telemetryType;
            java.lang.Object destinationConfiguration;
            java.lang.String selectionCriteria;

            /**
             * Sets the value of {@link TelemetryRuleProperty#getResourceType}
             * @param resourceType Resource Type associated with the Telemetry Rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TelemetryRuleProperty#getTelemetryType}
             * @param telemetryType Telemetry Type associated with the Telemetry Rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telemetryType(java.lang.String telemetryType) {
                this.telemetryType = telemetryType;
                return this;
            }

            /**
             * Sets the value of {@link TelemetryRuleProperty#getDestinationConfiguration}
             * @param destinationConfiguration The destination configuration for telemetry data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfiguration(software.amazon.awscdk.IResolvable destinationConfiguration) {
                this.destinationConfiguration = destinationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TelemetryRuleProperty#getDestinationConfiguration}
             * @param destinationConfiguration The destination configuration for telemetry data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfiguration(software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule.TelemetryDestinationConfigurationProperty destinationConfiguration) {
                this.destinationConfiguration = destinationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TelemetryRuleProperty#getSelectionCriteria}
             * @param selectionCriteria Selection Criteria on resource level for rule application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionCriteria(java.lang.String selectionCriteria) {
                this.selectionCriteria = selectionCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TelemetryRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TelemetryRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TelemetryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TelemetryRuleProperty {
            private final java.lang.String resourceType;
            private final java.lang.String telemetryType;
            private final java.lang.Object destinationConfiguration;
            private final java.lang.String selectionCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.telemetryType = software.amazon.jsii.Kernel.get(this, "telemetryType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationConfiguration = software.amazon.jsii.Kernel.get(this, "destinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selectionCriteria = software.amazon.jsii.Kernel.get(this, "selectionCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
                this.telemetryType = java.util.Objects.requireNonNull(builder.telemetryType, "telemetryType is required");
                this.destinationConfiguration = builder.destinationConfiguration;
                this.selectionCriteria = builder.selectionCriteria;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.lang.String getTelemetryType() {
                return this.telemetryType;
            }

            @Override
            public final java.lang.Object getDestinationConfiguration() {
                return this.destinationConfiguration;
            }

            @Override
            public final java.lang.String getSelectionCriteria() {
                return this.selectionCriteria;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceType", om.valueToTree(this.getResourceType()));
                data.set("telemetryType", om.valueToTree(this.getTelemetryType()));
                if (this.getDestinationConfiguration() != null) {
                    data.set("destinationConfiguration", om.valueToTree(this.getDestinationConfiguration()));
                }
                if (this.getSelectionCriteria() != null) {
                    data.set("selectionCriteria", om.valueToTree(this.getSelectionCriteria()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnTelemetryRule.TelemetryRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TelemetryRuleProperty.Jsii$Proxy that = (TelemetryRuleProperty.Jsii$Proxy) o;

                if (!resourceType.equals(that.resourceType)) return false;
                if (!telemetryType.equals(that.telemetryType)) return false;
                if (this.destinationConfiguration != null ? !this.destinationConfiguration.equals(that.destinationConfiguration) : that.destinationConfiguration != null) return false;
                return this.selectionCriteria != null ? this.selectionCriteria.equals(that.selectionCriteria) : that.selectionCriteria == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType.hashCode();
                result = 31 * result + (this.telemetryType.hashCode());
                result = 31 * result + (this.destinationConfiguration != null ? this.destinationConfiguration.hashCode() : 0);
                result = 31 * result + (this.selectionCriteria != null ? this.selectionCriteria.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Telemetry parameters for VPC Flow logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * VPCFlowLogParametersProperty vPCFlowLogParametersProperty = VPCFlowLogParametersProperty.builder()
     *         .logFormat("logFormat")
     *         .maxAggregationInterval(123)
     *         .trafficType("trafficType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-vpcflowlogparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-vpcflowlogparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnTelemetryRule.VPCFlowLogParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(VPCFlowLogParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VPCFlowLogParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The fields to include in the flow log record.
         * <p>
         * If you omit this parameter, the flow log is created using the default format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-vpcflowlogparameters.html#cfn-observabilityadmin-telemetryrule-vpcflowlogparameters-logformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-vpcflowlogparameters.html#cfn-observabilityadmin-telemetryrule-vpcflowlogparameters-logformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogFormat() {
            return null;
        }

        /**
         * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.
         * <p>
         * Default is 600s.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-vpcflowlogparameters.html#cfn-observabilityadmin-telemetryrule-vpcflowlogparameters-maxaggregationinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-vpcflowlogparameters.html#cfn-observabilityadmin-telemetryrule-vpcflowlogparameters-maxaggregationinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAggregationInterval() {
            return null;
        }

        /**
         * The type of traffic captured for the flow log.
         * <p>
         * Default is ALL
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-vpcflowlogparameters.html#cfn-observabilityadmin-telemetryrule-vpcflowlogparameters-traffictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-telemetryrule-vpcflowlogparameters.html#cfn-observabilityadmin-telemetryrule-vpcflowlogparameters-traffictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrafficType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VPCFlowLogParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VPCFlowLogParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VPCFlowLogParametersProperty> {
            java.lang.String logFormat;
            java.lang.Number maxAggregationInterval;
            java.lang.String trafficType;

            /**
             * Sets the value of {@link VPCFlowLogParametersProperty#getLogFormat}
             * @param logFormat The fields to include in the flow log record.
             *                  If you omit this parameter, the flow log is created using the default format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logFormat(java.lang.String logFormat) {
                this.logFormat = logFormat;
                return this;
            }

            /**
             * Sets the value of {@link VPCFlowLogParametersProperty#getMaxAggregationInterval}
             * @param maxAggregationInterval The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.
             *                               Default is 600s.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAggregationInterval(java.lang.Number maxAggregationInterval) {
                this.maxAggregationInterval = maxAggregationInterval;
                return this;
            }

            /**
             * Sets the value of {@link VPCFlowLogParametersProperty#getTrafficType}
             * @param trafficType The type of traffic captured for the flow log.
             *                    Default is ALL
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trafficType(java.lang.String trafficType) {
                this.trafficType = trafficType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VPCFlowLogParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VPCFlowLogParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VPCFlowLogParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VPCFlowLogParametersProperty {
            private final java.lang.String logFormat;
            private final java.lang.Number maxAggregationInterval;
            private final java.lang.String trafficType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logFormat = software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxAggregationInterval = software.amazon.jsii.Kernel.get(this, "maxAggregationInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.trafficType = software.amazon.jsii.Kernel.get(this, "trafficType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logFormat = builder.logFormat;
                this.maxAggregationInterval = builder.maxAggregationInterval;
                this.trafficType = builder.trafficType;
            }

            @Override
            public final java.lang.String getLogFormat() {
                return this.logFormat;
            }

            @Override
            public final java.lang.Number getMaxAggregationInterval() {
                return this.maxAggregationInterval;
            }

            @Override
            public final java.lang.String getTrafficType() {
                return this.trafficType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogFormat() != null) {
                    data.set("logFormat", om.valueToTree(this.getLogFormat()));
                }
                if (this.getMaxAggregationInterval() != null) {
                    data.set("maxAggregationInterval", om.valueToTree(this.getMaxAggregationInterval()));
                }
                if (this.getTrafficType() != null) {
                    data.set("trafficType", om.valueToTree(this.getTrafficType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnTelemetryRule.VPCFlowLogParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VPCFlowLogParametersProperty.Jsii$Proxy that = (VPCFlowLogParametersProperty.Jsii$Proxy) o;

                if (this.logFormat != null ? !this.logFormat.equals(that.logFormat) : that.logFormat != null) return false;
                if (this.maxAggregationInterval != null ? !this.maxAggregationInterval.equals(that.maxAggregationInterval) : that.maxAggregationInterval != null) return false;
                return this.trafficType != null ? this.trafficType.equals(that.trafficType) : that.trafficType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logFormat != null ? this.logFormat.hashCode() : 0;
                result = 31 * result + (this.maxAggregationInterval != null ? this.maxAggregationInterval.hashCode() : 0);
                result = 31 * result + (this.trafficType != null ? this.trafficType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRuleProps.Builder();
        }

        /**
         * The telemetry rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html#cfn-observabilityadmin-telemetryrule-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html#cfn-observabilityadmin-telemetryrule-rule</a>
         * @param rule The telemetry rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(final software.amazon.awscdk.IResolvable rule) {
            this.props.rule(rule);
            return this;
        }
        /**
         * The telemetry rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html#cfn-observabilityadmin-telemetryrule-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html#cfn-observabilityadmin-telemetryrule-rule</a>
         * @param rule The telemetry rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(final software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule.TelemetryRuleProperty rule) {
            this.props.rule(rule);
            return this;
        }

        /**
         * The name of the telemetry rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html#cfn-observabilityadmin-telemetryrule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html#cfn-observabilityadmin-telemetryrule-rulename</a>
         * @param ruleName The name of the telemetry rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html#cfn-observabilityadmin-telemetryrule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-telemetryrule.html#cfn-observabilityadmin-telemetryrule-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule build() {
            return new software.amazon.awscdk.services.observabilityadmin.CfnTelemetryRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
