package software.amazon.awscdk.services.opensearchservice;

/**
 * Properties for defining a <code>CfnApplication</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opensearchservice.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .appConfigs(List.of(AppConfigProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .dataSources(List.of(DataSourceProperty.builder()
 *                 .dataSourceArn("dataSourceArn")
 *                 // the properties below are optional
 *                 .dataSourceDescription("dataSourceDescription")
 *                 .build()))
 *         .endpoint("endpoint")
 *         .iamIdentityCenterOptions(IamIdentityCenterOptionsProperty.builder()
 *                 .enabled(false)
 *                 .iamIdentityCenterInstanceArn("iamIdentityCenterInstanceArn")
 *                 .iamRoleForIdentityCenterApplicationArn("iamRoleForIdentityCenterApplicationArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:20.212Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of an OpenSearch application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * List of application configurations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-appconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-appconfigs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAppConfigs() {
        return null;
    }

    /**
     * List of data sources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-datasources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-datasources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSources() {
        return null;
    }

    /**
     * The endpoint URL of an OpenSearch application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-endpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpoint() {
        return null;
    }

    /**
     * Settings container for integrating IAM Identity Center with OpenSearch UI applications, which enables enabling secure user authentication and access control across multiple data sources.
     * <p>
     * This setup supports single sign-on (SSO) through IAM Identity Center, allowing centralized user management.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-iamidentitycenteroptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-iamidentitycenteroptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIamIdentityCenterOptions() {
        return null;
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-application.html#cfn-opensearchservice-application-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.String name;
        java.lang.Object appConfigs;
        java.lang.Object dataSources;
        java.lang.String endpoint;
        java.lang.Object iamIdentityCenterOptions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnApplicationProps#getName}
         * @param name The name of an OpenSearch application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAppConfigs}
         * @param appConfigs List of application configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appConfigs(software.amazon.awscdk.IResolvable appConfigs) {
            this.appConfigs = appConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAppConfigs}
         * @param appConfigs List of application configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appConfigs(java.util.List<? extends java.lang.Object> appConfigs) {
            this.appConfigs = appConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getDataSources}
         * @param dataSources List of data sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSources(software.amazon.awscdk.IResolvable dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getDataSources}
         * @param dataSources List of data sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSources(java.util.List<? extends java.lang.Object> dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getEndpoint}
         * @param endpoint The endpoint URL of an OpenSearch application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getIamIdentityCenterOptions}
         * @param iamIdentityCenterOptions Settings container for integrating IAM Identity Center with OpenSearch UI applications, which enables enabling secure user authentication and access control across multiple data sources.
         *                                 This setup supports single sign-on (SSO) through IAM Identity Center, allowing centralized user management.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamIdentityCenterOptions(software.amazon.awscdk.IResolvable iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getIamIdentityCenterOptions}
         * @param iamIdentityCenterOptions Settings container for integrating IAM Identity Center with OpenSearch UI applications, which enables enabling secure user authentication and access control across multiple data sources.
         *                                 This setup supports single sign-on (SSO) through IAM Identity Center, allowing centralized user management.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamIdentityCenterOptions(software.amazon.awscdk.services.opensearchservice.CfnApplication.IamIdentityCenterOptionsProperty iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags An arbitrary set of tags (key-value pairs) for this application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.String name;
        private final java.lang.Object appConfigs;
        private final java.lang.Object dataSources;
        private final java.lang.String endpoint;
        private final java.lang.Object iamIdentityCenterOptions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appConfigs = software.amazon.jsii.Kernel.get(this, "appConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataSources = software.amazon.jsii.Kernel.get(this, "dataSources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamIdentityCenterOptions = software.amazon.jsii.Kernel.get(this, "iamIdentityCenterOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.appConfigs = builder.appConfigs;
            this.dataSources = builder.dataSources;
            this.endpoint = builder.endpoint;
            this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAppConfigs() {
            return this.appConfigs;
        }

        @Override
        public final java.lang.Object getDataSources() {
            return this.dataSources;
        }

        @Override
        public final java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.Object getIamIdentityCenterOptions() {
            return this.iamIdentityCenterOptions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAppConfigs() != null) {
                data.set("appConfigs", om.valueToTree(this.getAppConfigs()));
            }
            if (this.getDataSources() != null) {
                data.set("dataSources", om.valueToTree(this.getDataSources()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getIamIdentityCenterOptions() != null) {
                data.set("iamIdentityCenterOptions", om.valueToTree(this.getIamIdentityCenterOptions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.appConfigs != null ? !this.appConfigs.equals(that.appConfigs) : that.appConfigs != null) return false;
            if (this.dataSources != null ? !this.dataSources.equals(that.dataSources) : that.dataSources != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.iamIdentityCenterOptions != null ? !this.iamIdentityCenterOptions.equals(that.iamIdentityCenterOptions) : that.iamIdentityCenterOptions != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.appConfigs != null ? this.appConfigs.hashCode() : 0);
            result = 31 * result + (this.dataSources != null ? this.dataSources.hashCode() : 0);
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.iamIdentityCenterOptions != null ? this.iamIdentityCenterOptions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
