package software.amazon.awscdk.services.opensearchservice;

/**
 * Specifies zone awareness configuration options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_3)
 *         .ebs(EbsOptions.builder()
 *                 .volumeSize(10)
 *                 .volumeType(EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3)
 *                 .build())
 *         .zoneAwareness(ZoneAwarenessConfig.builder()
 *                 .enabled(true)
 *                 .availabilityZoneCount(3)
 *                 .build())
 *         .capacity(CapacityConfig.builder()
 *                 .multiAzWithStandbyEnabled(true)
 *                 .masterNodes(3)
 *                 .dataNodes(3)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:20.260Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.ZoneAwarenessConfig")
@software.amazon.jsii.Jsii.Proxy(ZoneAwarenessConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ZoneAwarenessConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.
     * <p>
     * Valid values are 2 and 3.
     * <p>
     * Default: - 2 if zone awareness is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAvailabilityZoneCount() {
        return null;
    }

    /**
     * Indicates whether to enable zone awareness for the Amazon OpenSearch Service domain.
     * <p>
     * When you enable zone awareness, Amazon OpenSearch Service allocates the nodes and replica
     * index shards that belong to a cluster across two Availability Zones (AZs)
     * in the same region to prevent data loss and minimize downtime in the event
     * of node or data center failure. Don't enable zone awareness if your cluster
     * has no replica index shards or is a single-node cluster. For more information,
     * see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a Multi-AZ Domain</a>
     * in the Amazon OpenSearch Service Developer Guide.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ZoneAwarenessConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ZoneAwarenessConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ZoneAwarenessConfig> {
        java.lang.Number availabilityZoneCount;
        java.lang.Boolean enabled;

        /**
         * Sets the value of {@link ZoneAwarenessConfig#getAvailabilityZoneCount}
         * @param availabilityZoneCount If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.
         *                              Valid values are 2 and 3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneCount(java.lang.Number availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
            return this;
        }

        /**
         * Sets the value of {@link ZoneAwarenessConfig#getEnabled}
         * @param enabled Indicates whether to enable zone awareness for the Amazon OpenSearch Service domain.
         *                When you enable zone awareness, Amazon OpenSearch Service allocates the nodes and replica
         *                index shards that belong to a cluster across two Availability Zones (AZs)
         *                in the same region to prevent data loss and minimize downtime in the event
         *                of node or data center failure. Don't enable zone awareness if your cluster
         *                has no replica index shards or is a single-node cluster. For more information,
         *                see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a Multi-AZ Domain</a>
         *                in the Amazon OpenSearch Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ZoneAwarenessConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ZoneAwarenessConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ZoneAwarenessConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZoneAwarenessConfig {
        private final java.lang.Number availabilityZoneCount;
        private final java.lang.Boolean enabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZoneCount = software.amazon.jsii.Kernel.get(this, "availabilityZoneCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZoneCount = builder.availabilityZoneCount;
            this.enabled = builder.enabled;
        }

        @Override
        public final java.lang.Number getAvailabilityZoneCount() {
            return this.availabilityZoneCount;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAvailabilityZoneCount() != null) {
                data.set("availabilityZoneCount", om.valueToTree(this.getAvailabilityZoneCount()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.ZoneAwarenessConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ZoneAwarenessConfig.Jsii$Proxy that = (ZoneAwarenessConfig.Jsii$Proxy) o;

            if (this.availabilityZoneCount != null ? !this.availabilityZoneCount.equals(that.availabilityZoneCount) : that.availabilityZoneCount != null) return false;
            return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZoneCount != null ? this.availabilityZoneCount.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            return result;
        }
    }
}
