package software.amazon.awscdk.services.pinpointemail;

/**
 * Properties for defining a <code>CfnConfigurationSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpointemail.*;
 * CfnConfigurationSetProps cfnConfigurationSetProps = CfnConfigurationSetProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .deliveryOptions(DeliveryOptionsProperty.builder()
 *                 .sendingPoolName("sendingPoolName")
 *                 .build())
 *         .reputationOptions(ReputationOptionsProperty.builder()
 *                 .reputationMetricsEnabled(false)
 *                 .build())
 *         .sendingOptions(SendingOptionsProperty.builder()
 *                 .sendingEnabled(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trackingOptions(TrackingOptionsProperty.builder()
 *                 .customRedirectDomain("customRedirectDomain")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:20.592Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnConfigurationSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigurationSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigurationSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the configuration set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-deliveryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-deliveryoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryOptions() {
        return null;
    }

    /**
     * An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-reputationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-reputationoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReputationOptions() {
        return null;
    }

    /**
     * An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-sendingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-sendingoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSendingOptions() {
        return null;
    }

    /**
     * An object that defines the tags (keys and values) that you want to associate with the configuration set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-trackingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html#cfn-pinpointemail-configurationset-trackingoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTrackingOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigurationSetProps> {
        java.lang.String name;
        java.lang.Object deliveryOptions;
        java.lang.Object reputationOptions;
        java.lang.Object sendingOptions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object trackingOptions;

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getName}
         * @param name The name of the configuration set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getDeliveryOptions}
         * @param deliveryOptions An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(software.amazon.awscdk.IResolvable deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getDeliveryOptions}
         * @param deliveryOptions An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.DeliveryOptionsProperty deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getReputationOptions}
         * @param reputationOptions An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(software.amazon.awscdk.IResolvable reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getReputationOptions}
         * @param reputationOptions An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.ReputationOptionsProperty reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getSendingOptions}
         * @param sendingOptions An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(software.amazon.awscdk.IResolvable sendingOptions) {
            this.sendingOptions = sendingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getSendingOptions}
         * @param sendingOptions An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.SendingOptionsProperty sendingOptions) {
            this.sendingOptions = sendingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getTags}
         * @param tags An object that defines the tags (keys and values) that you want to associate with the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getTrackingOptions}
         * @param trackingOptions An object that defines the open and click tracking options for emails that you send using the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(software.amazon.awscdk.IResolvable trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getTrackingOptions}
         * @param trackingOptions An object that defines the open and click tracking options for emails that you send using the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.TrackingOptionsProperty trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigurationSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationSetProps {
        private final java.lang.String name;
        private final java.lang.Object deliveryOptions;
        private final java.lang.Object reputationOptions;
        private final java.lang.Object sendingOptions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object trackingOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryOptions = software.amazon.jsii.Kernel.get(this, "deliveryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.reputationOptions = software.amazon.jsii.Kernel.get(this, "reputationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sendingOptions = software.amazon.jsii.Kernel.get(this, "sendingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.trackingOptions = software.amazon.jsii.Kernel.get(this, "trackingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.deliveryOptions = builder.deliveryOptions;
            this.reputationOptions = builder.reputationOptions;
            this.sendingOptions = builder.sendingOptions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.trackingOptions = builder.trackingOptions;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getDeliveryOptions() {
            return this.deliveryOptions;
        }

        @Override
        public final java.lang.Object getReputationOptions() {
            return this.reputationOptions;
        }

        @Override
        public final java.lang.Object getSendingOptions() {
            return this.sendingOptions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTrackingOptions() {
            return this.trackingOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getDeliveryOptions() != null) {
                data.set("deliveryOptions", om.valueToTree(this.getDeliveryOptions()));
            }
            if (this.getReputationOptions() != null) {
                data.set("reputationOptions", om.valueToTree(this.getReputationOptions()));
            }
            if (this.getSendingOptions() != null) {
                data.set("sendingOptions", om.valueToTree(this.getSendingOptions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTrackingOptions() != null) {
                data.set("trackingOptions", om.valueToTree(this.getTrackingOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpointemail.CfnConfigurationSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationSetProps.Jsii$Proxy that = (CfnConfigurationSetProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.deliveryOptions != null ? !this.deliveryOptions.equals(that.deliveryOptions) : that.deliveryOptions != null) return false;
            if (this.reputationOptions != null ? !this.reputationOptions.equals(that.reputationOptions) : that.reputationOptions != null) return false;
            if (this.sendingOptions != null ? !this.sendingOptions.equals(that.sendingOptions) : that.sendingOptions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.trackingOptions != null ? this.trackingOptions.equals(that.trackingOptions) : that.trackingOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.deliveryOptions != null ? this.deliveryOptions.hashCode() : 0);
            result = 31 * result + (this.reputationOptions != null ? this.reputationOptions.hashCode() : 0);
            result = 31 * result + (this.sendingOptions != null ? this.sendingOptions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trackingOptions != null ? this.trackingOptions.hashCode() : 0);
            return result;
        }
    }
}
