package software.amazon.awscdk.services.qbusiness;

/**
 * Creates a new data accessor for an ISV to access data from a Amazon Q Business application.
 * <p>
 * The data accessor is an entity that represents the ISV's access to the Amazon Q Business application's data. It includes the IAM role ARN for the ISV, a friendly name, and a set of action configurations that define the specific actions the ISV is allowed to perform and any associated data filters. When the data accessor is created, an IAM Identity Center application is also created to manage the ISV's identity and authentication for accessing the Amazon Q Business application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * AttributeFilterProperty attributeFilterProperty_;
 * CfnDataAccessor cfnDataAccessor = CfnDataAccessor.Builder.create(this, "MyCfnDataAccessor")
 *         .actionConfigurations(List.of(ActionConfigurationProperty.builder()
 *                 .action("action")
 *                 // the properties below are optional
 *                 .filterConfiguration(ActionFilterConfigurationProperty.builder()
 *                         .documentAttributeFilter(AttributeFilterProperty.builder()
 *                                 .andAllFilters(List.of(attributeFilterProperty_))
 *                                 .containsAll(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .containsAny(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .equalsTo(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .greaterThan(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .greaterThanOrEquals(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .lessThan(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .lessThanOrEquals(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .notFilter(attributeFilterProperty_)
 *                                 .orAllFilters(List.of(attributeFilterProperty_))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .applicationId("applicationId")
 *         .displayName("displayName")
 *         .principal("principal")
 *         // the properties below are optional
 *         .authenticationDetail(DataAccessorAuthenticationDetailProperty.builder()
 *                 .authenticationType("authenticationType")
 *                 // the properties below are optional
 *                 .authenticationConfiguration(DataAccessorAuthenticationConfigurationProperty.builder()
 *                         .idcTrustedTokenIssuerConfiguration(DataAccessorIdcTrustedTokenIssuerConfigurationProperty.builder()
 *                                 .idcTrustedTokenIssuerArn("idcTrustedTokenIssuerArn")
 *                                 .build())
 *                         .build())
 *                 .externalIds(List.of("externalIds"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:20.671Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor")
public class CfnDataAccessor extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDataAccessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataAccessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataAccessor(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.qbusiness.CfnDataAccessorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The timestamp when the data accessor was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataAccessorArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDataAccessorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataAccessorId() {
        return software.amazon.jsii.Kernel.get(this, "attrDataAccessorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the associated IAM Identity Center application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdcApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIdcApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the data accessor was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of action configurations specifying the allowed actions and any associated filters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getActionConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "actionConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of action configurations specifying the allowed actions and any associated filters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionConfigurations(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actionConfigurations", java.util.Objects.requireNonNull(value, "actionConfigurations is required"));
    }

    /**
     * A list of action configurations specifying the allowed actions and any associated filters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionConfigurations(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.qbusiness.CfnDataAccessor.ActionConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.qbusiness.CfnDataAccessor.ActionConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actionConfigurations", java.util.Objects.requireNonNull(value, "actionConfigurations is required"));
    }

    /**
     * The unique identifier of the Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationId", java.util.Objects.requireNonNull(value, "applicationId is required"));
    }

    /**
     * The friendly name of the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The friendly name of the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", java.util.Objects.requireNonNull(value, "displayName is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "principal", java.util.Objects.requireNonNull(value, "principal is required"));
    }

    /**
     * The authentication configuration details for the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationDetail() {
        return software.amazon.jsii.Kernel.get(this, "authenticationDetail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The authentication configuration details for the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationDetail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authenticationDetail", value);
    }

    /**
     * The authentication configuration details for the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationDetail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DataAccessorAuthenticationDetailProperty value) {
        software.amazon.jsii.Kernel.set(this, "authenticationDetail", value);
    }

    /**
     * The tags to associate with the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to associate with the data accessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Specifies an allowed action and its associated filter configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * AttributeFilterProperty attributeFilterProperty_;
     * ActionConfigurationProperty actionConfigurationProperty = ActionConfigurationProperty.builder()
     *         .action("action")
     *         // the properties below are optional
     *         .filterConfiguration(ActionFilterConfigurationProperty.builder()
     *                 .documentAttributeFilter(AttributeFilterProperty.builder()
     *                         .andAllFilters(List.of(attributeFilterProperty_))
     *                         .containsAll(DocumentAttributeProperty.builder()
     *                                 .name("name")
     *                                 .value(DocumentAttributeValueProperty.builder()
     *                                         .dateValue("dateValue")
     *                                         .longValue(123)
     *                                         .stringListValue(List.of("stringListValue"))
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 .build())
     *                         .containsAny(DocumentAttributeProperty.builder()
     *                                 .name("name")
     *                                 .value(DocumentAttributeValueProperty.builder()
     *                                         .dateValue("dateValue")
     *                                         .longValue(123)
     *                                         .stringListValue(List.of("stringListValue"))
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 .build())
     *                         .equalsTo(DocumentAttributeProperty.builder()
     *                                 .name("name")
     *                                 .value(DocumentAttributeValueProperty.builder()
     *                                         .dateValue("dateValue")
     *                                         .longValue(123)
     *                                         .stringListValue(List.of("stringListValue"))
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 .build())
     *                         .greaterThan(DocumentAttributeProperty.builder()
     *                                 .name("name")
     *                                 .value(DocumentAttributeValueProperty.builder()
     *                                         .dateValue("dateValue")
     *                                         .longValue(123)
     *                                         .stringListValue(List.of("stringListValue"))
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 .build())
     *                         .greaterThanOrEquals(DocumentAttributeProperty.builder()
     *                                 .name("name")
     *                                 .value(DocumentAttributeValueProperty.builder()
     *                                         .dateValue("dateValue")
     *                                         .longValue(123)
     *                                         .stringListValue(List.of("stringListValue"))
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 .build())
     *                         .lessThan(DocumentAttributeProperty.builder()
     *                                 .name("name")
     *                                 .value(DocumentAttributeValueProperty.builder()
     *                                         .dateValue("dateValue")
     *                                         .longValue(123)
     *                                         .stringListValue(List.of("stringListValue"))
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 .build())
     *                         .lessThanOrEquals(DocumentAttributeProperty.builder()
     *                                 .name("name")
     *                                 .value(DocumentAttributeValueProperty.builder()
     *                                         .dateValue("dateValue")
     *                                         .longValue(123)
     *                                         .stringListValue(List.of("stringListValue"))
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 .build())
     *                         .notFilter(attributeFilterProperty_)
     *                         .orAllFilters(List.of(attributeFilterProperty_))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor.ActionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Q Business action that is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionconfiguration.html#cfn-qbusiness-dataaccessor-actionconfiguration-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionconfiguration.html#cfn-qbusiness-dataaccessor-actionconfiguration-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The filter configuration for the action, if any.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionconfiguration.html#cfn-qbusiness-dataaccessor-actionconfiguration-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionconfiguration.html#cfn-qbusiness-dataaccessor-actionconfiguration-filterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionConfigurationProperty> {
            java.lang.String action;
            java.lang.Object filterConfiguration;

            /**
             * Sets the value of {@link ActionConfigurationProperty#getAction}
             * @param action The Amazon Q Business action that is allowed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ActionConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration The filter configuration for the action, if any.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ActionConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration The filter configuration for the action, if any.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.ActionFilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionConfigurationProperty {
            private final java.lang.String action;
            private final java.lang.Object filterConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.filterConfiguration = builder.filterConfiguration;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getFilterConfiguration() {
                return this.filterConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                if (this.getFilterConfiguration() != null) {
                    data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessor.ActionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionConfigurationProperty.Jsii$Proxy that = (ActionConfigurationProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                return this.filterConfiguration != null ? this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies filters to apply to an allowed action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * AttributeFilterProperty attributeFilterProperty_;
     * ActionFilterConfigurationProperty actionFilterConfigurationProperty = ActionFilterConfigurationProperty.builder()
     *         .documentAttributeFilter(AttributeFilterProperty.builder()
     *                 .andAllFilters(List.of(attributeFilterProperty_))
     *                 .containsAll(DocumentAttributeProperty.builder()
     *                         .name("name")
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .containsAny(DocumentAttributeProperty.builder()
     *                         .name("name")
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .equalsTo(DocumentAttributeProperty.builder()
     *                         .name("name")
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .greaterThan(DocumentAttributeProperty.builder()
     *                         .name("name")
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .greaterThanOrEquals(DocumentAttributeProperty.builder()
     *                         .name("name")
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .lessThan(DocumentAttributeProperty.builder()
     *                         .name("name")
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .lessThanOrEquals(DocumentAttributeProperty.builder()
     *                         .name("name")
     *                         .value(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .notFilter(attributeFilterProperty_)
     *                 .orAllFilters(List.of(attributeFilterProperty_))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionfilterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionfilterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor.ActionFilterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionFilterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionFilterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables filtering of responses based on document attributes or metadata fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionfilterconfiguration.html#cfn-qbusiness-dataaccessor-actionfilterconfiguration-documentattributefilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-actionfilterconfiguration.html#cfn-qbusiness-dataaccessor-actionfilterconfiguration-documentattributefilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDocumentAttributeFilter();

        /**
         * @return a {@link Builder} of {@link ActionFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionFilterConfigurationProperty> {
            java.lang.Object documentAttributeFilter;

            /**
             * Sets the value of {@link ActionFilterConfigurationProperty#getDocumentAttributeFilter}
             * @param documentAttributeFilter Enables filtering of responses based on document attributes or metadata fields. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentAttributeFilter(software.amazon.awscdk.IResolvable documentAttributeFilter) {
                this.documentAttributeFilter = documentAttributeFilter;
                return this;
            }

            /**
             * Sets the value of {@link ActionFilterConfigurationProperty#getDocumentAttributeFilter}
             * @param documentAttributeFilter Enables filtering of responses based on document attributes or metadata fields. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentAttributeFilter(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.AttributeFilterProperty documentAttributeFilter) {
                this.documentAttributeFilter = documentAttributeFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionFilterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionFilterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionFilterConfigurationProperty {
            private final java.lang.Object documentAttributeFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentAttributeFilter = software.amazon.jsii.Kernel.get(this, "documentAttributeFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentAttributeFilter = java.util.Objects.requireNonNull(builder.documentAttributeFilter, "documentAttributeFilter is required");
            }

            @Override
            public final java.lang.Object getDocumentAttributeFilter() {
                return this.documentAttributeFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentAttributeFilter", om.valueToTree(this.getDocumentAttributeFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessor.ActionFilterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionFilterConfigurationProperty.Jsii$Proxy that = (ActionFilterConfigurationProperty.Jsii$Proxy) o;

                return this.documentAttributeFilter.equals(that.documentAttributeFilter);
            }

            @Override
            public final int hashCode() {
                int result = this.documentAttributeFilter.hashCode();
                return result;
            }
        }
    }
    /**
     * Enables filtering of responses based on document attributes or metadata fields.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * AttributeFilterProperty attributeFilterProperty_;
     * AttributeFilterProperty attributeFilterProperty = AttributeFilterProperty.builder()
     *         .andAllFilters(List.of(attributeFilterProperty_))
     *         .containsAll(DocumentAttributeProperty.builder()
     *                 .name("name")
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .containsAny(DocumentAttributeProperty.builder()
     *                 .name("name")
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .equalsTo(DocumentAttributeProperty.builder()
     *                 .name("name")
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .greaterThan(DocumentAttributeProperty.builder()
     *                 .name("name")
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .greaterThanOrEquals(DocumentAttributeProperty.builder()
     *                 .name("name")
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .lessThan(DocumentAttributeProperty.builder()
     *                 .name("name")
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .lessThanOrEquals(DocumentAttributeProperty.builder()
     *                 .name("name")
     *                 .value(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .notFilter(attributeFilterProperty_)
     *         .orAllFilters(List.of(attributeFilterProperty_))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor.AttributeFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Performs a logical <code>AND</code> operation on all supplied filters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-andallfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-andallfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAndAllFilters() {
            return null;
        }

        /**
         * Returns <code>true</code> when a document contains all the specified document attributes or metadata fields.
         * <p>
         * Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>stringListValue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-containsall">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-containsall</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainsAll() {
            return null;
        }

        /**
         * Returns <code>true</code> when a document contains any of the specified document attributes or metadata fields.
         * <p>
         * Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>stringListValue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-containsany">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-containsany</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainsAny() {
            return null;
        }

        /**
         * Performs an equals operation on two document attributes or metadata fields.
         * <p>
         * Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> , <code>longValue</code> , <code>stringListValue</code> and <code>stringValue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-equalsto">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-equalsto</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEqualsTo() {
            return null;
        }

        /**
         * Performs a greater than operation on two document attributes or metadata fields.
         * <p>
         * Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-greaterthan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-greaterthan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGreaterThan() {
            return null;
        }

        /**
         * Performs a greater or equals than operation on two document attributes or metadata fields.
         * <p>
         * Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-greaterthanorequals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-greaterthanorequals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGreaterThanOrEquals() {
            return null;
        }

        /**
         * Performs a less than operation on two document attributes or metadata fields.
         * <p>
         * Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-lessthan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-lessthan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLessThan() {
            return null;
        }

        /**
         * Performs a less than or equals operation on two document attributes or metadata fields.Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value type</a> : <code>dateValue</code> and <code>longValue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-lessthanorequals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-lessthanorequals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLessThanOrEquals() {
            return null;
        }

        /**
         * Performs a logical <code>NOT</code> operation on all supplied filters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-notfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-notfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotFilter() {
            return null;
        }

        /**
         * Performs a logical <code>OR</code> operation on all supplied filters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-orallfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-attributefilter.html#cfn-qbusiness-dataaccessor-attributefilter-orallfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrAllFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeFilterProperty> {
            java.lang.Object andAllFilters;
            java.lang.Object containsAll;
            java.lang.Object containsAny;
            java.lang.Object equalsTo;
            java.lang.Object greaterThan;
            java.lang.Object greaterThanOrEquals;
            java.lang.Object lessThan;
            java.lang.Object lessThanOrEquals;
            java.lang.Object notFilter;
            java.lang.Object orAllFilters;

            /**
             * Sets the value of {@link AttributeFilterProperty#getAndAllFilters}
             * @param andAllFilters Performs a logical <code>AND</code> operation on all supplied filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andAllFilters(software.amazon.awscdk.IResolvable andAllFilters) {
                this.andAllFilters = andAllFilters;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getAndAllFilters}
             * @param andAllFilters Performs a logical <code>AND</code> operation on all supplied filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andAllFilters(java.util.List<? extends java.lang.Object> andAllFilters) {
                this.andAllFilters = andAllFilters;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getContainsAll}
             * @param containsAll Returns <code>true</code> when a document contains all the specified document attributes or metadata fields.
             *                    Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>stringListValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsAll(software.amazon.awscdk.IResolvable containsAll) {
                this.containsAll = containsAll;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getContainsAll}
             * @param containsAll Returns <code>true</code> when a document contains all the specified document attributes or metadata fields.
             *                    Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>stringListValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsAll(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DocumentAttributeProperty containsAll) {
                this.containsAll = containsAll;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getContainsAny}
             * @param containsAny Returns <code>true</code> when a document contains any of the specified document attributes or metadata fields.
             *                    Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>stringListValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsAny(software.amazon.awscdk.IResolvable containsAny) {
                this.containsAny = containsAny;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getContainsAny}
             * @param containsAny Returns <code>true</code> when a document contains any of the specified document attributes or metadata fields.
             *                    Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>stringListValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsAny(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DocumentAttributeProperty containsAny) {
                this.containsAny = containsAny;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getEqualsTo}
             * @param equalsTo Performs an equals operation on two document attributes or metadata fields.
             *                 Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> , <code>longValue</code> , <code>stringListValue</code> and <code>stringValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder equalsTo(software.amazon.awscdk.IResolvable equalsTo) {
                this.equalsTo = equalsTo;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getEqualsTo}
             * @param equalsTo Performs an equals operation on two document attributes or metadata fields.
             *                 Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> , <code>longValue</code> , <code>stringListValue</code> and <code>stringValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder equalsTo(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DocumentAttributeProperty equalsTo) {
                this.equalsTo = equalsTo;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getGreaterThan}
             * @param greaterThan Performs a greater than operation on two document attributes or metadata fields.
             *                    Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greaterThan(software.amazon.awscdk.IResolvable greaterThan) {
                this.greaterThan = greaterThan;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getGreaterThan}
             * @param greaterThan Performs a greater than operation on two document attributes or metadata fields.
             *                    Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greaterThan(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DocumentAttributeProperty greaterThan) {
                this.greaterThan = greaterThan;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getGreaterThanOrEquals}
             * @param greaterThanOrEquals Performs a greater or equals than operation on two document attributes or metadata fields.
             *                            Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greaterThanOrEquals(software.amazon.awscdk.IResolvable greaterThanOrEquals) {
                this.greaterThanOrEquals = greaterThanOrEquals;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getGreaterThanOrEquals}
             * @param greaterThanOrEquals Performs a greater or equals than operation on two document attributes or metadata fields.
             *                            Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greaterThanOrEquals(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DocumentAttributeProperty greaterThanOrEquals) {
                this.greaterThanOrEquals = greaterThanOrEquals;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getLessThan}
             * @param lessThan Performs a less than operation on two document attributes or metadata fields.
             *                 Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lessThan(software.amazon.awscdk.IResolvable lessThan) {
                this.lessThan = lessThan;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getLessThan}
             * @param lessThan Performs a less than operation on two document attributes or metadata fields.
             *                 Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value types</a> : <code>dateValue</code> and <code>longValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lessThan(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DocumentAttributeProperty lessThan) {
                this.lessThan = lessThan;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getLessThanOrEquals}
             * @param lessThanOrEquals Performs a less than or equals operation on two document attributes or metadata fields.Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value type</a> : <code>dateValue</code> and <code>longValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lessThanOrEquals(software.amazon.awscdk.IResolvable lessThanOrEquals) {
                this.lessThanOrEquals = lessThanOrEquals;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getLessThanOrEquals}
             * @param lessThanOrEquals Performs a less than or equals operation on two document attributes or metadata fields.Supported for the following <a href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html">document attribute value type</a> : <code>dateValue</code> and <code>longValue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lessThanOrEquals(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DocumentAttributeProperty lessThanOrEquals) {
                this.lessThanOrEquals = lessThanOrEquals;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getNotFilter}
             * @param notFilter Performs a logical <code>NOT</code> operation on all supplied filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notFilter(software.amazon.awscdk.IResolvable notFilter) {
                this.notFilter = notFilter;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getNotFilter}
             * @param notFilter Performs a logical <code>NOT</code> operation on all supplied filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notFilter(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.AttributeFilterProperty notFilter) {
                this.notFilter = notFilter;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getOrAllFilters}
             * @param orAllFilters Performs a logical <code>OR</code> operation on all supplied filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orAllFilters(software.amazon.awscdk.IResolvable orAllFilters) {
                this.orAllFilters = orAllFilters;
                return this;
            }

            /**
             * Sets the value of {@link AttributeFilterProperty#getOrAllFilters}
             * @param orAllFilters Performs a logical <code>OR</code> operation on all supplied filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orAllFilters(java.util.List<? extends java.lang.Object> orAllFilters) {
                this.orAllFilters = orAllFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeFilterProperty {
            private final java.lang.Object andAllFilters;
            private final java.lang.Object containsAll;
            private final java.lang.Object containsAny;
            private final java.lang.Object equalsTo;
            private final java.lang.Object greaterThan;
            private final java.lang.Object greaterThanOrEquals;
            private final java.lang.Object lessThan;
            private final java.lang.Object lessThanOrEquals;
            private final java.lang.Object notFilter;
            private final java.lang.Object orAllFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.andAllFilters = software.amazon.jsii.Kernel.get(this, "andAllFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.containsAll = software.amazon.jsii.Kernel.get(this, "containsAll", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.containsAny = software.amazon.jsii.Kernel.get(this, "containsAny", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.equalsTo = software.amazon.jsii.Kernel.get(this, "equalsTo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.greaterThan = software.amazon.jsii.Kernel.get(this, "greaterThan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.greaterThanOrEquals = software.amazon.jsii.Kernel.get(this, "greaterThanOrEquals", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lessThan = software.amazon.jsii.Kernel.get(this, "lessThan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lessThanOrEquals = software.amazon.jsii.Kernel.get(this, "lessThanOrEquals", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.notFilter = software.amazon.jsii.Kernel.get(this, "notFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.orAllFilters = software.amazon.jsii.Kernel.get(this, "orAllFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.andAllFilters = builder.andAllFilters;
                this.containsAll = builder.containsAll;
                this.containsAny = builder.containsAny;
                this.equalsTo = builder.equalsTo;
                this.greaterThan = builder.greaterThan;
                this.greaterThanOrEquals = builder.greaterThanOrEquals;
                this.lessThan = builder.lessThan;
                this.lessThanOrEquals = builder.lessThanOrEquals;
                this.notFilter = builder.notFilter;
                this.orAllFilters = builder.orAllFilters;
            }

            @Override
            public final java.lang.Object getAndAllFilters() {
                return this.andAllFilters;
            }

            @Override
            public final java.lang.Object getContainsAll() {
                return this.containsAll;
            }

            @Override
            public final java.lang.Object getContainsAny() {
                return this.containsAny;
            }

            @Override
            public final java.lang.Object getEqualsTo() {
                return this.equalsTo;
            }

            @Override
            public final java.lang.Object getGreaterThan() {
                return this.greaterThan;
            }

            @Override
            public final java.lang.Object getGreaterThanOrEquals() {
                return this.greaterThanOrEquals;
            }

            @Override
            public final java.lang.Object getLessThan() {
                return this.lessThan;
            }

            @Override
            public final java.lang.Object getLessThanOrEquals() {
                return this.lessThanOrEquals;
            }

            @Override
            public final java.lang.Object getNotFilter() {
                return this.notFilter;
            }

            @Override
            public final java.lang.Object getOrAllFilters() {
                return this.orAllFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAndAllFilters() != null) {
                    data.set("andAllFilters", om.valueToTree(this.getAndAllFilters()));
                }
                if (this.getContainsAll() != null) {
                    data.set("containsAll", om.valueToTree(this.getContainsAll()));
                }
                if (this.getContainsAny() != null) {
                    data.set("containsAny", om.valueToTree(this.getContainsAny()));
                }
                if (this.getEqualsTo() != null) {
                    data.set("equalsTo", om.valueToTree(this.getEqualsTo()));
                }
                if (this.getGreaterThan() != null) {
                    data.set("greaterThan", om.valueToTree(this.getGreaterThan()));
                }
                if (this.getGreaterThanOrEquals() != null) {
                    data.set("greaterThanOrEquals", om.valueToTree(this.getGreaterThanOrEquals()));
                }
                if (this.getLessThan() != null) {
                    data.set("lessThan", om.valueToTree(this.getLessThan()));
                }
                if (this.getLessThanOrEquals() != null) {
                    data.set("lessThanOrEquals", om.valueToTree(this.getLessThanOrEquals()));
                }
                if (this.getNotFilter() != null) {
                    data.set("notFilter", om.valueToTree(this.getNotFilter()));
                }
                if (this.getOrAllFilters() != null) {
                    data.set("orAllFilters", om.valueToTree(this.getOrAllFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessor.AttributeFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeFilterProperty.Jsii$Proxy that = (AttributeFilterProperty.Jsii$Proxy) o;

                if (this.andAllFilters != null ? !this.andAllFilters.equals(that.andAllFilters) : that.andAllFilters != null) return false;
                if (this.containsAll != null ? !this.containsAll.equals(that.containsAll) : that.containsAll != null) return false;
                if (this.containsAny != null ? !this.containsAny.equals(that.containsAny) : that.containsAny != null) return false;
                if (this.equalsTo != null ? !this.equalsTo.equals(that.equalsTo) : that.equalsTo != null) return false;
                if (this.greaterThan != null ? !this.greaterThan.equals(that.greaterThan) : that.greaterThan != null) return false;
                if (this.greaterThanOrEquals != null ? !this.greaterThanOrEquals.equals(that.greaterThanOrEquals) : that.greaterThanOrEquals != null) return false;
                if (this.lessThan != null ? !this.lessThan.equals(that.lessThan) : that.lessThan != null) return false;
                if (this.lessThanOrEquals != null ? !this.lessThanOrEquals.equals(that.lessThanOrEquals) : that.lessThanOrEquals != null) return false;
                if (this.notFilter != null ? !this.notFilter.equals(that.notFilter) : that.notFilter != null) return false;
                return this.orAllFilters != null ? this.orAllFilters.equals(that.orAllFilters) : that.orAllFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.andAllFilters != null ? this.andAllFilters.hashCode() : 0;
                result = 31 * result + (this.containsAll != null ? this.containsAll.hashCode() : 0);
                result = 31 * result + (this.containsAny != null ? this.containsAny.hashCode() : 0);
                result = 31 * result + (this.equalsTo != null ? this.equalsTo.hashCode() : 0);
                result = 31 * result + (this.greaterThan != null ? this.greaterThan.hashCode() : 0);
                result = 31 * result + (this.greaterThanOrEquals != null ? this.greaterThanOrEquals.hashCode() : 0);
                result = 31 * result + (this.lessThan != null ? this.lessThan.hashCode() : 0);
                result = 31 * result + (this.lessThanOrEquals != null ? this.lessThanOrEquals.hashCode() : 0);
                result = 31 * result + (this.notFilter != null ? this.notFilter.hashCode() : 0);
                result = 31 * result + (this.orAllFilters != null ? this.orAllFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A union type that contains the specific authentication configuration based on the authentication type selected.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DataAccessorAuthenticationConfigurationProperty dataAccessorAuthenticationConfigurationProperty = DataAccessorAuthenticationConfigurationProperty.builder()
     *         .idcTrustedTokenIssuerConfiguration(DataAccessorIdcTrustedTokenIssuerConfigurationProperty.builder()
     *                 .idcTrustedTokenIssuerArn("idcTrustedTokenIssuerArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DataAccessorAuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataAccessorAuthenticationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataAccessorAuthenticationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration for IAM Identity Center Trusted Token Issuer (TTI) authentication used when the authentication type is <code>AWS_IAM_IDC_TTI</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationconfiguration.html#cfn-qbusiness-dataaccessor-dataaccessorauthenticationconfiguration-idctrustedtokenissuerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationconfiguration.html#cfn-qbusiness-dataaccessor-dataaccessorauthenticationconfiguration-idctrustedtokenissuerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIdcTrustedTokenIssuerConfiguration();

        /**
         * @return a {@link Builder} of {@link DataAccessorAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataAccessorAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataAccessorAuthenticationConfigurationProperty> {
            java.lang.Object idcTrustedTokenIssuerConfiguration;

            /**
             * Sets the value of {@link DataAccessorAuthenticationConfigurationProperty#getIdcTrustedTokenIssuerConfiguration}
             * @param idcTrustedTokenIssuerConfiguration Configuration for IAM Identity Center Trusted Token Issuer (TTI) authentication used when the authentication type is <code>AWS_IAM_IDC_TTI</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idcTrustedTokenIssuerConfiguration(software.amazon.awscdk.IResolvable idcTrustedTokenIssuerConfiguration) {
                this.idcTrustedTokenIssuerConfiguration = idcTrustedTokenIssuerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataAccessorAuthenticationConfigurationProperty#getIdcTrustedTokenIssuerConfiguration}
             * @param idcTrustedTokenIssuerConfiguration Configuration for IAM Identity Center Trusted Token Issuer (TTI) authentication used when the authentication type is <code>AWS_IAM_IDC_TTI</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idcTrustedTokenIssuerConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DataAccessorIdcTrustedTokenIssuerConfigurationProperty idcTrustedTokenIssuerConfiguration) {
                this.idcTrustedTokenIssuerConfiguration = idcTrustedTokenIssuerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataAccessorAuthenticationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataAccessorAuthenticationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataAccessorAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataAccessorAuthenticationConfigurationProperty {
            private final java.lang.Object idcTrustedTokenIssuerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idcTrustedTokenIssuerConfiguration = software.amazon.jsii.Kernel.get(this, "idcTrustedTokenIssuerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idcTrustedTokenIssuerConfiguration = java.util.Objects.requireNonNull(builder.idcTrustedTokenIssuerConfiguration, "idcTrustedTokenIssuerConfiguration is required");
            }

            @Override
            public final java.lang.Object getIdcTrustedTokenIssuerConfiguration() {
                return this.idcTrustedTokenIssuerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("idcTrustedTokenIssuerConfiguration", om.valueToTree(this.getIdcTrustedTokenIssuerConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DataAccessorAuthenticationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataAccessorAuthenticationConfigurationProperty.Jsii$Proxy that = (DataAccessorAuthenticationConfigurationProperty.Jsii$Proxy) o;

                return this.idcTrustedTokenIssuerConfiguration.equals(that.idcTrustedTokenIssuerConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.idcTrustedTokenIssuerConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains the authentication configuration details for a data accessor.
     * <p>
     * This structure defines how the ISV authenticates when accessing data through the data accessor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DataAccessorAuthenticationDetailProperty dataAccessorAuthenticationDetailProperty = DataAccessorAuthenticationDetailProperty.builder()
     *         .authenticationType("authenticationType")
     *         // the properties below are optional
     *         .authenticationConfiguration(DataAccessorAuthenticationConfigurationProperty.builder()
     *                 .idcTrustedTokenIssuerConfiguration(DataAccessorIdcTrustedTokenIssuerConfigurationProperty.builder()
     *                         .idcTrustedTokenIssuerArn("idcTrustedTokenIssuerArn")
     *                         .build())
     *                 .build())
     *         .externalIds(List.of("externalIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DataAccessorAuthenticationDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(DataAccessorAuthenticationDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataAccessorAuthenticationDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of authentication to use for the data accessor.
         * <p>
         * This determines how the ISV authenticates when accessing data. You can use one of two authentication types:
         * <p>
         * <ul>
         * <li><code>AWS_IAM_IDC_TTI</code> - Authentication using IAM Identity Center Trusted Token Issuer (TTI). This authentication type allows the ISV to use a trusted token issuer to generate tokens for accessing the data.</li>
         * <li><code>AWS_IAM_IDC_AUTH_CODE</code> - Authentication using IAM Identity Center authorization code flow. This authentication type uses the standard OAuth 2.0 authorization code flow for authentication.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationdetail.html#cfn-qbusiness-dataaccessor-dataaccessorauthenticationdetail-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationdetail.html#cfn-qbusiness-dataaccessor-dataaccessorauthenticationdetail-authenticationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

        /**
         * The specific authentication configuration based on the authentication type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationdetail.html#cfn-qbusiness-dataaccessor-dataaccessorauthenticationdetail-authenticationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationdetail.html#cfn-qbusiness-dataaccessor-dataaccessorauthenticationdetail-authenticationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationConfiguration() {
            return null;
        }

        /**
         * A list of external identifiers associated with this authentication configuration.
         * <p>
         * These are used to correlate the data accessor with external systems.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationdetail.html#cfn-qbusiness-dataaccessor-dataaccessorauthenticationdetail-externalids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessorauthenticationdetail.html#cfn-qbusiness-dataaccessor-dataaccessorauthenticationdetail-externalids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExternalIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataAccessorAuthenticationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataAccessorAuthenticationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataAccessorAuthenticationDetailProperty> {
            java.lang.String authenticationType;
            java.lang.Object authenticationConfiguration;
            java.util.List<java.lang.String> externalIds;

            /**
             * Sets the value of {@link DataAccessorAuthenticationDetailProperty#getAuthenticationType}
             * @param authenticationType The type of authentication to use for the data accessor. This parameter is required.
             *                           This determines how the ISV authenticates when accessing data. You can use one of two authentication types:
             *                           <p>
             *                           <ul>
             *                           <li><code>AWS_IAM_IDC_TTI</code> - Authentication using IAM Identity Center Trusted Token Issuer (TTI). This authentication type allows the ISV to use a trusted token issuer to generate tokens for accessing the data.</li>
             *                           <li><code>AWS_IAM_IDC_AUTH_CODE</code> - Authentication using IAM Identity Center authorization code flow. This authentication type uses the standard OAuth 2.0 authorization code flow for authentication.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link DataAccessorAuthenticationDetailProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration The specific authentication configuration based on the authentication type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataAccessorAuthenticationDetailProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration The specific authentication configuration based on the authentication type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DataAccessorAuthenticationConfigurationProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataAccessorAuthenticationDetailProperty#getExternalIds}
             * @param externalIds A list of external identifiers associated with this authentication configuration.
             *                    These are used to correlate the data accessor with external systems.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalIds(java.util.List<java.lang.String> externalIds) {
                this.externalIds = externalIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataAccessorAuthenticationDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataAccessorAuthenticationDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataAccessorAuthenticationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataAccessorAuthenticationDetailProperty {
            private final java.lang.String authenticationType;
            private final java.lang.Object authenticationConfiguration;
            private final java.util.List<java.lang.String> externalIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.externalIds = software.amazon.jsii.Kernel.get(this, "externalIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
                this.authenticationConfiguration = builder.authenticationConfiguration;
                this.externalIds = builder.externalIds;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.Object getAuthenticationConfiguration() {
                return this.authenticationConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getExternalIds() {
                return this.externalIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                if (this.getAuthenticationConfiguration() != null) {
                    data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
                }
                if (this.getExternalIds() != null) {
                    data.set("externalIds", om.valueToTree(this.getExternalIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DataAccessorAuthenticationDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataAccessorAuthenticationDetailProperty.Jsii$Proxy that = (DataAccessorAuthenticationDetailProperty.Jsii$Proxy) o;

                if (!authenticationType.equals(that.authenticationType)) return false;
                if (this.authenticationConfiguration != null ? !this.authenticationConfiguration.equals(that.authenticationConfiguration) : that.authenticationConfiguration != null) return false;
                return this.externalIds != null ? this.externalIds.equals(that.externalIds) : that.externalIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationType.hashCode();
                result = 31 * result + (this.authenticationConfiguration != null ? this.authenticationConfiguration.hashCode() : 0);
                result = 31 * result + (this.externalIds != null ? this.externalIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration details for IAM Identity Center Trusted Token Issuer (TTI) authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DataAccessorIdcTrustedTokenIssuerConfigurationProperty dataAccessorIdcTrustedTokenIssuerConfigurationProperty = DataAccessorIdcTrustedTokenIssuerConfigurationProperty.builder()
     *         .idcTrustedTokenIssuerArn("idcTrustedTokenIssuerArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessoridctrustedtokenissuerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessoridctrustedtokenissuerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DataAccessorIdcTrustedTokenIssuerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataAccessorIdcTrustedTokenIssuerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataAccessorIdcTrustedTokenIssuerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the IAM Identity Center Trusted Token Issuer that will be used for authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessoridctrustedtokenissuerconfiguration.html#cfn-qbusiness-dataaccessor-dataaccessoridctrustedtokenissuerconfiguration-idctrustedtokenissuerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-dataaccessoridctrustedtokenissuerconfiguration.html#cfn-qbusiness-dataaccessor-dataaccessoridctrustedtokenissuerconfiguration-idctrustedtokenissuerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdcTrustedTokenIssuerArn();

        /**
         * @return a {@link Builder} of {@link DataAccessorIdcTrustedTokenIssuerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataAccessorIdcTrustedTokenIssuerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataAccessorIdcTrustedTokenIssuerConfigurationProperty> {
            java.lang.String idcTrustedTokenIssuerArn;

            /**
             * Sets the value of {@link DataAccessorIdcTrustedTokenIssuerConfigurationProperty#getIdcTrustedTokenIssuerArn}
             * @param idcTrustedTokenIssuerArn The Amazon Resource Name (ARN) of the IAM Identity Center Trusted Token Issuer that will be used for authentication. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idcTrustedTokenIssuerArn(java.lang.String idcTrustedTokenIssuerArn) {
                this.idcTrustedTokenIssuerArn = idcTrustedTokenIssuerArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataAccessorIdcTrustedTokenIssuerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataAccessorIdcTrustedTokenIssuerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataAccessorIdcTrustedTokenIssuerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataAccessorIdcTrustedTokenIssuerConfigurationProperty {
            private final java.lang.String idcTrustedTokenIssuerArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idcTrustedTokenIssuerArn = software.amazon.jsii.Kernel.get(this, "idcTrustedTokenIssuerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idcTrustedTokenIssuerArn = java.util.Objects.requireNonNull(builder.idcTrustedTokenIssuerArn, "idcTrustedTokenIssuerArn is required");
            }

            @Override
            public final java.lang.String getIdcTrustedTokenIssuerArn() {
                return this.idcTrustedTokenIssuerArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("idcTrustedTokenIssuerArn", om.valueToTree(this.getIdcTrustedTokenIssuerArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DataAccessorIdcTrustedTokenIssuerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataAccessorIdcTrustedTokenIssuerConfigurationProperty.Jsii$Proxy that = (DataAccessorIdcTrustedTokenIssuerConfigurationProperty.Jsii$Proxy) o;

                return this.idcTrustedTokenIssuerArn.equals(that.idcTrustedTokenIssuerArn);
            }

            @Override
            public final int hashCode() {
                int result = this.idcTrustedTokenIssuerArn.hashCode();
                return result;
            }
        }
    }
    /**
     * A document attribute or metadata field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DocumentAttributeProperty documentAttributeProperty = DocumentAttributeProperty.builder()
     *         .name("name")
     *         .value(DocumentAttributeValueProperty.builder()
     *                 .dateValue("dateValue")
     *                 .longValue(123)
     *                 .stringListValue(List.of("stringListValue"))
     *                 .stringValue("stringValue")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DocumentAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattribute.html#cfn-qbusiness-dataaccessor-documentattribute-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattribute.html#cfn-qbusiness-dataaccessor-documentattribute-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattribute.html#cfn-qbusiness-dataaccessor-documentattribute-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattribute.html#cfn-qbusiness-dataaccessor-documentattribute-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * @return a {@link Builder} of {@link DocumentAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentAttributeProperty> {
            java.lang.String name;
            java.lang.Object value;

            /**
             * Sets the value of {@link DocumentAttributeProperty#getName}
             * @param name The identifier for the attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeProperty#getValue}
             * @param value The value of the attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeProperty#getValue}
             * @param value The value of the attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DocumentAttributeValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentAttributeProperty {
            private final java.lang.String name;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DocumentAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentAttributeProperty.Jsii$Proxy that = (DocumentAttributeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The value of a document attribute.
     * <p>
     * You can only provide one value for a document attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * DocumentAttributeValueProperty documentAttributeValueProperty = DocumentAttributeValueProperty.builder()
     *         .dateValue("dateValue")
     *         .longValue(123)
     *         .stringListValue(List.of("stringListValue"))
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DocumentAttributeValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentAttributeValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentAttributeValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date expressed as an ISO 8601 string.
         * <p>
         * It's important for the time zone to be included in the ISO 8601 date-time format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html#cfn-qbusiness-dataaccessor-documentattributevalue-datevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html#cfn-qbusiness-dataaccessor-documentattributevalue-datevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateValue() {
            return null;
        }

        /**
         * A long integer value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html#cfn-qbusiness-dataaccessor-documentattributevalue-longvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html#cfn-qbusiness-dataaccessor-documentattributevalue-longvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLongValue() {
            return null;
        }

        /**
         * A list of strings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html#cfn-qbusiness-dataaccessor-documentattributevalue-stringlistvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html#cfn-qbusiness-dataaccessor-documentattributevalue-stringlistvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStringListValue() {
            return null;
        }

        /**
         * A string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html#cfn-qbusiness-dataaccessor-documentattributevalue-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-dataaccessor-documentattributevalue.html#cfn-qbusiness-dataaccessor-documentattributevalue-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentAttributeValueProperty> {
            java.lang.String dateValue;
            java.lang.Number longValue;
            java.util.List<java.lang.String> stringListValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getDateValue}
             * @param dateValue A date expressed as an ISO 8601 string.
             *                  It's important for the time zone to be included in the ISO 8601 date-time format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateValue(java.lang.String dateValue) {
                this.dateValue = dateValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getLongValue}
             * @param longValue A long integer value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder longValue(java.lang.Number longValue) {
                this.longValue = longValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getStringListValue}
             * @param stringListValue A list of strings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringListValue(java.util.List<java.lang.String> stringListValue) {
                this.stringListValue = stringListValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getStringValue}
             * @param stringValue A string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentAttributeValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentAttributeValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentAttributeValueProperty {
            private final java.lang.String dateValue;
            private final java.lang.Number longValue;
            private final java.util.List<java.lang.String> stringListValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateValue = software.amazon.jsii.Kernel.get(this, "dateValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.longValue = software.amazon.jsii.Kernel.get(this, "longValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stringListValue = software.amazon.jsii.Kernel.get(this, "stringListValue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateValue = builder.dateValue;
                this.longValue = builder.longValue;
                this.stringListValue = builder.stringListValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.String getDateValue() {
                return this.dateValue;
            }

            @Override
            public final java.lang.Number getLongValue() {
                return this.longValue;
            }

            @Override
            public final java.util.List<java.lang.String> getStringListValue() {
                return this.stringListValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateValue() != null) {
                    data.set("dateValue", om.valueToTree(this.getDateValue()));
                }
                if (this.getLongValue() != null) {
                    data.set("longValue", om.valueToTree(this.getLongValue()));
                }
                if (this.getStringListValue() != null) {
                    data.set("stringListValue", om.valueToTree(this.getStringListValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessor.DocumentAttributeValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentAttributeValueProperty.Jsii$Proxy that = (DocumentAttributeValueProperty.Jsii$Proxy) o;

                if (this.dateValue != null ? !this.dateValue.equals(that.dateValue) : that.dateValue != null) return false;
                if (this.longValue != null ? !this.longValue.equals(that.longValue) : that.longValue != null) return false;
                if (this.stringListValue != null ? !this.stringListValue.equals(that.stringListValue) : that.stringListValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateValue != null ? this.dateValue.hashCode() : 0;
                result = 31 * result + (this.longValue != null ? this.longValue.hashCode() : 0);
                result = 31 * result + (this.stringListValue != null ? this.stringListValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.qbusiness.CfnDataAccessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.qbusiness.CfnDataAccessor> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.qbusiness.CfnDataAccessorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.qbusiness.CfnDataAccessorProps.Builder();
        }

        /**
         * A list of action configurations specifying the allowed actions and any associated filters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-actionconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-actionconfigurations</a>
         * @param actionConfigurations A list of action configurations specifying the allowed actions and any associated filters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionConfigurations(final software.amazon.awscdk.IResolvable actionConfigurations) {
            this.props.actionConfigurations(actionConfigurations);
            return this;
        }
        /**
         * A list of action configurations specifying the allowed actions and any associated filters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-actionconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-actionconfigurations</a>
         * @param actionConfigurations A list of action configurations specifying the allowed actions and any associated filters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionConfigurations(final java.util.List<? extends java.lang.Object> actionConfigurations) {
            this.props.actionConfigurations(actionConfigurations);
            return this;
        }

        /**
         * The unique identifier of the Amazon Q Business application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-applicationid</a>
         * @param applicationId The unique identifier of the Amazon Q Business application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(final java.lang.String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        /**
         * The friendly name of the data accessor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-displayname</a>
         * @param displayName The friendly name of the data accessor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-principal</a>
         * @param principal The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(final java.lang.String principal) {
            this.props.principal(principal);
            return this;
        }

        /**
         * The authentication configuration details for the data accessor.
         * <p>
         * This specifies how the ISV authenticates when accessing data through this data accessor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-authenticationdetail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-authenticationdetail</a>
         * @param authenticationDetail The authentication configuration details for the data accessor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationDetail(final software.amazon.awscdk.IResolvable authenticationDetail) {
            this.props.authenticationDetail(authenticationDetail);
            return this;
        }
        /**
         * The authentication configuration details for the data accessor.
         * <p>
         * This specifies how the ISV authenticates when accessing data through this data accessor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-authenticationdetail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-authenticationdetail</a>
         * @param authenticationDetail The authentication configuration details for the data accessor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationDetail(final software.amazon.awscdk.services.qbusiness.CfnDataAccessor.DataAccessorAuthenticationDetailProperty authenticationDetail) {
            this.props.authenticationDetail(authenticationDetail);
            return this;
        }

        /**
         * The tags to associate with the data accessor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-tags</a>
         * @param tags The tags to associate with the data accessor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.qbusiness.CfnDataAccessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.qbusiness.CfnDataAccessor build() {
            return new software.amazon.awscdk.services.qbusiness.CfnDataAccessor(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
