package software.amazon.awscdk.services.rds;

/**
 * The <code>AWS::RDS::DBInstance</code> resource creates an Amazon DB instance.
 * <p>
 * The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster.
 * <p>
 * For more information about creating an RDS DB instance, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html">Creating an Amazon RDS DB instance</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * For more information about creating a DB instance in an Aurora DB cluster, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html">Creating an Amazon Aurora DB cluster</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
 * <p>
 * <blockquote>
 * <p>
 * If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">Prevent Updates to Stack Resources</a> .
 * <p>
 * </blockquote>
 * <p>
 * <em>Updating DB instances</em>
 * <p>
 * When properties labeled " <em>Update requires:</em> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">Replacement</a> " are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
 * <p>
 * <blockquote>
 * <p>
 * We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
 * <p>
 * <ul>
 * <li>Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.</li>
 * <li>Create a snapshot of the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html">Creating a DB Snapshot</a> .</li>
 * <li>If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the <code>DBSnapshotIdentifier</code> property with the ID of the DB snapshot that you want to use.</li>
 * </ul>
 * <p>
 * After you restore a DB instance with a <code>DBSnapshotIdentifier</code> property, you can delete the <code>DBSnapshotIdentifier</code> property. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the <code>DBSnapshotIdentifier</code> property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified <code>DBSnapshotIdentifier</code> property, and the original DB instance is deleted.
 * <p>
 * <ul>
 * <li>Update the stack.</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * For more information about updating other properties of this resource, see <code>[ModifyDBInstance](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBInstance.html)</code> . For more information about updating stacks, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">AWS CloudFormation Stacks Updates</a> .
 * <p>
 * <em>Deleting DB instances</em>
 * <p>
 * For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to <em>retain</em> the DB instance, to <em>delete</em> the DB instance, or to <em>create a snapshot</em> of the DB instance. The default AWS CloudFormation behavior depends on the <code>DBClusterIdentifier</code> property:
 * <p>
 * <ul>
 * <li>For <code>AWS::RDS::DBInstance</code> resources that don't specify the <code>DBClusterIdentifier</code> property, AWS CloudFormation saves a snapshot of the DB instance.</li>
 * <li>For <code>AWS::RDS::DBInstance</code> resources that do specify the <code>DBClusterIdentifier</code> property, AWS CloudFormation deletes the DB instance.</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy Attribute</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBInstance cfnDBInstance = CfnDBInstance.Builder.create(this, "MyCfnDBInstance")
 *         .allocatedStorage("allocatedStorage")
 *         .allowMajorVersionUpgrade(false)
 *         .applyImmediately(false)
 *         .associatedRoles(List.of(DBInstanceRoleProperty.builder()
 *                 .featureName("featureName")
 *                 .roleArn("roleArn")
 *                 .build()))
 *         .automaticBackupReplicationKmsKeyId("automaticBackupReplicationKmsKeyId")
 *         .automaticBackupReplicationRegion("automaticBackupReplicationRegion")
 *         .automaticBackupReplicationRetentionPeriod(123)
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZone("availabilityZone")
 *         .backupRetentionPeriod(123)
 *         .backupTarget("backupTarget")
 *         .caCertificateIdentifier("caCertificateIdentifier")
 *         .certificateRotationRestart(false)
 *         .characterSetName("characterSetName")
 *         .copyTagsToSnapshot(false)
 *         .customIamInstanceProfile("customIamInstanceProfile")
 *         .databaseInsightsMode("databaseInsightsMode")
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbClusterSnapshotIdentifier("dbClusterSnapshotIdentifier")
 *         .dbInstanceClass("dbInstanceClass")
 *         .dbInstanceIdentifier("dbInstanceIdentifier")
 *         .dbName("dbName")
 *         .dbParameterGroupName("dbParameterGroupName")
 *         .dbSecurityGroups(List.of("dbSecurityGroups"))
 *         .dbSnapshotIdentifier("dbSnapshotIdentifier")
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .dbSystemId("dbSystemId")
 *         .dedicatedLogVolume(false)
 *         .deleteAutomatedBackups(false)
 *         .deletionProtection(false)
 *         .domain("domain")
 *         .domainAuthSecretArn("domainAuthSecretArn")
 *         .domainDnsIps(List.of("domainDnsIps"))
 *         .domainFqdn("domainFqdn")
 *         .domainIamRoleName("domainIamRoleName")
 *         .domainOu("domainOu")
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .enableIamDatabaseAuthentication(false)
 *         .enablePerformanceInsights(false)
 *         .engine("engine")
 *         .engineLifecycleSupport("engineLifecycleSupport")
 *         .engineVersion("engineVersion")
 *         .iops(123)
 *         .kmsKeyId("kmsKeyId")
 *         .licenseModel("licenseModel")
 *         .manageMasterUserPassword(false)
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .masterUserSecret(MasterUserSecretProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .secretArn("secretArn")
 *                 .build())
 *         .maxAllocatedStorage(123)
 *         .monitoringInterval(123)
 *         .monitoringRoleArn("monitoringRoleArn")
 *         .multiAz(false)
 *         .ncharCharacterSetName("ncharCharacterSetName")
 *         .networkType("networkType")
 *         .optionGroupName("optionGroupName")
 *         .performanceInsightsKmsKeyId("performanceInsightsKmsKeyId")
 *         .performanceInsightsRetentionPeriod(123)
 *         .port("port")
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .processorFeatures(List.of(ProcessorFeatureProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .promotionTier(123)
 *         .publiclyAccessible(false)
 *         .replicaMode("replicaMode")
 *         .restoreTime("restoreTime")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .sourceDbInstanceAutomatedBackupsArn("sourceDbInstanceAutomatedBackupsArn")
 *         .sourceDbInstanceIdentifier("sourceDbInstanceIdentifier")
 *         .sourceDbiResourceId("sourceDbiResourceId")
 *         .sourceRegion("sourceRegion")
 *         .statusInfos(List.of(DBInstanceStatusInfoProperty.builder()
 *                 .message("message")
 *                 .normal(false)
 *                 .status("status")
 *                 .statusType("statusType")
 *                 .build()))
 *         .storageEncrypted(false)
 *         .storageThroughput(123)
 *         .storageType("storageType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tdeCredentialArn("tdeCredentialArn")
 *         .tdeCredentialPassword("tdeCredentialPassword")
 *         .timezone("timezone")
 *         .useDefaultProcessorFeatures(false)
 *         .useLatestRestorableTime(false)
 *         .vpcSecurityGroups(List.of("vpcSecurityGroups"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:22.490Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance")
public class CfnDBInstance extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDBInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBInstance.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time when a stopped DB instance is restarted automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAutomaticRestartTime() {
        return software.amazon.jsii.Kernel.get(this, "attrAutomaticRestartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The details of the DB instance’s server certificate.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <em>Amazon Aurora User Guide</em>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrCertificateDetails() {
        return software.amazon.jsii.Kernel.get(this, "attrCertificateDetails", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The CA identifier of the CA certificate used for the DB instance's server certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCertificateDetailsCaIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrCertificateDetailsCaIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The expiration date of the DB instance’s server certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCertificateDetailsValidTill() {
        return software.amazon.jsii.Kernel.get(this, "attrCertificateDetailsValidTill", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDbInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current state of this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbInstanceStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrDbInstanceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region-unique, immutable identifier for the DB instance.
     * <p>
     * This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbiResourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrDbiResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Oracle system ID (Oracle SID) for a container database (CDB).
     * <p>
     * The Oracle SID is also the name of the CDB.
     * <p>
     * This setting is valid for RDS Custom only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbSystemId() {
        return software.amazon.jsii.Kernel.get(this, "attrDbSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This data type represents the information you need to connect to an Amazon RDS DB instance.
     * <p>
     * This data type is used as a response element in the following actions:
     * <p>
     * <ul>
     * <li><code>CreateDBInstance</code></li>
     * <li><code>DescribeDBInstances</code></li>
     * <li><code>DeleteDBInstance</code></li>
     * </ul>
     * <p>
     * For the data structure that represents Amazon Aurora DB cluster endpoints, see <code>DBClusterEndpoint</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The connection endpoint for the database. For example: <code>mystack-mydb-1apw1j4phylrk.cg034hpkmmjt.us-east-2.rds.amazonaws.com</code>.
     * <p>
     * For Aurora Serverless DB clusters, the connection endpoint only applies to the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number on which the database accepts connections.
     * <p>
     * For example: <code>3306</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the DB instance was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInstanceCreateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrInstanceCreateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether an upgrade is recommended for the storage file system configuration on the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrIsStorageConfigUpgradeAvailable() {
        return software.amazon.jsii.Kernel.get(this, "attrIsStorageConfigUpgradeAvailable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The latest time to which a database in this DB instance can be restored with point-in-time restore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLatestRestorableTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This data type represents the information you need to connect to an Amazon RDS DB instance.
     * <p>
     * This data type is used as a response element in the following actions:
     * <p>
     * <ul>
     * <li><code>CreateDBInstance</code></li>
     * <li><code>DescribeDBInstances</code></li>
     * <li><code>DeleteDBInstance</code></li>
     * </ul>
     * <p>
     * For the data structure that represents Amazon Aurora DB cluster endpoints, see <code>DBClusterEndpoint</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrListenerEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrListenerEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Specifies the DNS address of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrListenerEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrListenerEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrListenerEndpointHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "attrListenerEndpointHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the port that the database engine is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrListenerEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrListenerEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the secret.
     * <p>
     * This parameter is a return value that you can retrieve using the <code>Fn::GetAtt</code> intrinsic function. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values">Return values</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMasterUserSecretSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMasterUserSecretSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The progress of the storage optimization operation as a percentage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPercentProgress() {
        return software.amazon.jsii.Kernel.get(this, "attrPercentProgress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrReadReplicaDbClusterIdentifiers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrReadReplicaDbClusterIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The identifiers of the read replicas associated with this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrReadReplicaDbInstanceIdentifiers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrReadReplicaDbInstanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The number of minutes to pause the automation.
     * <p>
     * When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResumeFullAutomationModeTime() {
        return software.amazon.jsii.Kernel.get(this, "attrResumeFullAutomationModeTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSecondaryAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "attrSecondaryAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of a read replica.
     * <p>
     * If the DB instance isn't a read replica, the value is blank.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrStatusInfos() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusInfos", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAllocatedStorage() {
        return software.amazon.jsii.Kernel.get(this, "allocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocatedStorage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "allocatedStorage", value);
    }

    /**
     * A value that indicates whether major version upgrades are allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowMajorVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "allowMajorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether major version upgrades are allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowMajorVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowMajorVersionUpgrade", value);
    }

    /**
     * A value that indicates whether major version upgrades are allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowMajorVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowMajorVersionUpgrade", value);
    }

    /**
     * Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApplyImmediately() {
        return software.amazon.jsii.Kernel.get(this, "applyImmediately", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplyImmediately(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "applyImmediately", value);
    }

    /**
     * Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplyImmediately(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "applyImmediately", value);
    }

    /**
     * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnDBInstance.DBInstanceRoleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.rds.CfnDBInstance.DBInstanceRoleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * The AWS KMS key identifier for encryption of the replicated automated backups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutomaticBackupReplicationKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "automaticBackupReplicationKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS KMS key identifier for encryption of the replicated automated backups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomaticBackupReplicationKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "automaticBackupReplicationKmsKeyId", value);
    }

    /**
     * The AWS Region associated with the automated backup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutomaticBackupReplicationRegion() {
        return software.amazon.jsii.Kernel.get(this, "automaticBackupReplicationRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region associated with the automated backup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomaticBackupReplicationRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "automaticBackupReplicationRegion", value);
    }

    /**
     * The retention period for automated backups in a different AWS Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticBackupReplicationRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "automaticBackupReplicationRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The retention period for automated backups in a different AWS Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomaticBackupReplicationRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "automaticBackupReplicationRetentionPeriod", value);
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * The Availability Zone (AZ) where the database will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone (AZ) where the database will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The number of days for which automated backups are retained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days for which automated backups are retained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backupRetentionPeriod", value);
    }

    /**
     * The location for storing automated backups and manual snapshots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBackupTarget() {
        return software.amazon.jsii.Kernel.get(this, "backupTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location for storing automated backups and manual snapshots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupTarget(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupTarget", value);
    }

    /**
     * The identifier of the CA certificate for this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCaCertificateIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "caCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the CA certificate for this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCaCertificateIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "caCertificateIdentifier", value);
    }

    /**
     * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCertificateRotationRestart() {
        return software.amazon.jsii.Kernel.get(this, "certificateRotationRestart", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateRotationRestart(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "certificateRotationRestart", value);
    }

    /**
     * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateRotationRestart(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "certificateRotationRestart", value);
    }

    /**
     * For supported engines, indicates that the DB instance should be associated with the specified character set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCharacterSetName() {
        return software.amazon.jsii.Kernel.get(this, "characterSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For supported engines, indicates that the DB instance should be associated with the specified character set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCharacterSetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "characterSetName", value);
    }

    /**
     * Specifies whether to copy tags from the DB instance to snapshots of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to copy tags from the DB instance to snapshots of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * Specifies whether to copy tags from the DB instance to snapshots of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomIamInstanceProfile() {
        return software.amazon.jsii.Kernel.get(this, "customIamInstanceProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomIamInstanceProfile(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customIamInstanceProfile", value);
    }

    /**
     * The mode of Database Insights to enable for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseInsightsMode() {
        return software.amazon.jsii.Kernel.get(this, "databaseInsightsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The mode of Database Insights to enable for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseInsightsMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseInsightsMode", value);
    }

    /**
     * The identifier of the DB cluster that this DB instance will belong to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the DB cluster that this DB instance will belong to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifier", value);
    }

    /**
     * The identifier for the Multi-AZ DB cluster snapshot to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterSnapshotIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterSnapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the Multi-AZ DB cluster snapshot to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterSnapshotIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterSnapshotIdentifier", value);
    }

    /**
     * The compute and memory capacity of the DB instance, for example <code>db.m5.large</code> . Not all DB instance classes are available in all AWS Regions , or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance classes</a> in the <em>Amazon RDS User Guide</em> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB instance classes</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceClass() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compute and memory capacity of the DB instance, for example <code>db.m5.large</code> . Not all DB instance classes are available in all AWS Regions , or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance classes</a> in the <em>Amazon RDS User Guide</em> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB instance classes</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbInstanceClass(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbInstanceClass", value);
    }

    /**
     * A name for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbInstanceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbInstanceIdentifier", value);
    }

    /**
     * The meaning of this parameter differs according to the database engine you use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbName() {
        return software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The meaning of this parameter differs according to the database engine you use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbName", value);
    }

    /**
     * The name of an existing DB parameter group or a reference to an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html">AWS::RDS::DBParameterGroup</a> resource created in the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of an existing DB parameter group or a reference to an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html">AWS::RDS::DBParameterGroup</a> resource created in the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbParameterGroupName", value);
    }

    /**
     * A list of the DB security groups to assign to the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dbSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of the DB security groups to assign to the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dbSecurityGroups", value);
    }

    /**
     * The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSnapshotIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbSnapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSnapshotIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSnapshotIdentifier", value);
    }

    /**
     * A DB subnet group to associate with the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A DB subnet group to associate with the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSubnetGroupName", value);
    }

    /**
     * The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSystemId() {
        return software.amazon.jsii.Kernel.get(this, "dbSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSystemId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSystemId", value);
    }

    /**
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDedicatedLogVolume() {
        return software.amazon.jsii.Kernel.get(this, "dedicatedLogVolume", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDedicatedLogVolume(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "dedicatedLogVolume", value);
    }

    /**
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDedicatedLogVolume(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dedicatedLogVolume", value);
    }

    /**
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeleteAutomatedBackups() {
        return software.amazon.jsii.Kernel.get(this, "deleteAutomatedBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteAutomatedBackups(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deleteAutomatedBackups", value);
    }

    /**
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteAutomatedBackups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deleteAutomatedBackups", value);
    }

    /**
     * Specifies whether the DB instance has deletion protection enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the DB instance has deletion protection enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * Specifies whether the DB instance has deletion protection enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The Active Directory directory ID to create the DB instance in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Active Directory directory ID to create the DB instance in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainAuthSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "domainAuthSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainAuthSecretArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainAuthSecretArn", value);
    }

    /**
     * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomainDnsIps() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "domainDnsIps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainDnsIps(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "domainDnsIps", value);
    }

    /**
     * The fully qualified domain name (FQDN) of an Active Directory domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainFqdn() {
        return software.amazon.jsii.Kernel.get(this, "domainFqdn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fully qualified domain name (FQDN) of an Active Directory domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainFqdn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainFqdn", value);
    }

    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainIamRoleName() {
        return software.amazon.jsii.Kernel.get(this, "domainIamRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainIamRoleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainIamRoleName", value);
    }

    /**
     * The Active Directory organizational unit for your DB instance to join.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainOu() {
        return software.amazon.jsii.Kernel.get(this, "domainOu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Active Directory organizational unit for your DB instance to join.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainOu(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainOu", value);
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableCloudwatchLogsExports(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "enableCloudwatchLogsExports", value);
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamDatabaseAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "enableIamDatabaseAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * Specifies whether to enable Performance Insights for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnablePerformanceInsights() {
        return software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to enable Performance Insights for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePerformanceInsights(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enablePerformanceInsights", value);
    }

    /**
     * Specifies whether to enable Performance Insights for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePerformanceInsights(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enablePerformanceInsights", value);
    }

    /**
     * The name of the database engine to use for this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database engine to use for this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     * The life cycle type for this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineLifecycleSupport() {
        return software.amazon.jsii.Kernel.get(this, "engineLifecycleSupport", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The life cycle type for this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineLifecycleSupport(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineLifecycleSupport", value);
    }

    /**
     * The version number of the database engine to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the database engine to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * The number of I/O operations per second (IOPS) that the database provisions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of I/O operations per second (IOPS) that the database provisions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIops(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "iops", value);
    }

    /**
     * The ARN of the AWS KMS key that's used to encrypt the DB instance, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the AWS KMS key that's used to encrypt the DB instance, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * License model information for this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLicenseModel() {
        return software.amazon.jsii.Kernel.get(this, "licenseModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * License model information for this DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLicenseModel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "licenseModel", value);
    }

    /**
     * Specifies whether to manage the master user password with AWS Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getManageMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "manageMasterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to manage the master user password with AWS Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManageMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "manageMasterUserPassword", value);
    }

    /**
     * Specifies whether to manage the master user password with AWS Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManageMasterUserPassword(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "manageMasterUserPassword", value);
    }

    /**
     * The master user name for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The master user name for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUsername", value);
    }

    /**
     * The password for the master user.
     * <p>
     * The password can include any printable ASCII character except "/", """, or "&#64;".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password for the master user.
     * <p>
     * The password can include any printable ASCII character except "/", """, or "&#64;".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUserPassword", value);
    }

    /**
     * The secret managed by RDS in AWS Secrets Manager for the master user password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMasterUserSecret() {
        return software.amazon.jsii.Kernel.get(this, "masterUserSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The secret managed by RDS in AWS Secrets Manager for the master user password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserSecret(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "masterUserSecret", value);
    }

    /**
     * The secret managed by RDS in AWS Secrets Manager for the master user password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserSecret(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBInstance.MasterUserSecretProperty value) {
        software.amazon.jsii.Kernel.set(this, "masterUserSecret", value);
    }

    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxAllocatedStorage() {
        return software.amazon.jsii.Kernel.get(this, "maxAllocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxAllocatedStorage(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxAllocatedStorage", value);
    }

    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMonitoringInterval() {
        return software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringInterval(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "monitoringInterval", value);
    }

    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMonitoringRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "monitoringRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoringRoleArn", value);
    }

    /**
     * Specifies whether the DB instance is a Multi-AZ deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiAz() {
        return software.amazon.jsii.Kernel.get(this, "multiAz", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the DB instance is a Multi-AZ deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiAz(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiAz", value);
    }

    /**
     * Specifies whether the DB instance is a Multi-AZ deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiAz(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiAz", value);
    }

    /**
     * The name of the NCHAR character set for the Oracle DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNcharCharacterSetName() {
        return software.amazon.jsii.Kernel.get(this, "ncharCharacterSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the NCHAR character set for the Oracle DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNcharCharacterSetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ncharCharacterSetName", value);
    }

    /**
     * The network type of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNetworkType() {
        return software.amazon.jsii.Kernel.get(this, "networkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The network type of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "networkType", value);
    }

    /**
     * Indicates that the DB instance should be associated with the specified option group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOptionGroupName() {
        return software.amazon.jsii.Kernel.get(this, "optionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates that the DB instance should be associated with the specified option group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "optionGroupName", value);
    }

    /**
     * The AWS KMS key identifier for encryption of Performance Insights data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPerformanceInsightsKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightsKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS KMS key identifier for encryption of Performance Insights data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceInsightsKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "performanceInsightsKmsKeyId", value);
    }

    /**
     * The number of days to retain Performance Insights data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPerformanceInsightsRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightsRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days to retain Performance Insights data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceInsightsRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "performanceInsightsRetentionPeriod", value);
    }

    /**
     * The port number on which the database accepts connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number on which the database accepts connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredBackupWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredBackupWindow", value);
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProcessorFeatures() {
        return software.amazon.jsii.Kernel.get(this, "processorFeatures", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessorFeatures(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "processorFeatures", value);
    }

    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessorFeatures(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnDBInstance.ProcessorFeatureProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.rds.CfnDBInstance.ProcessorFeatureProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "processorFeatures", value);
    }

    /**
     * The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPromotionTier() {
        return software.amazon.jsii.Kernel.get(this, "promotionTier", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPromotionTier(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "promotionTier", value);
    }

    /**
     * Indicates whether the DB instance is an internet-facing instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the DB instance is an internet-facing instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * Indicates whether the DB instance is an internet-facing instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * The open mode of an Oracle read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReplicaMode() {
        return software.amazon.jsii.Kernel.get(this, "replicaMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The open mode of an Oracle read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicaMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicaMode", value);
    }

    /**
     * The date and time to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRestoreTime() {
        return software.amazon.jsii.Kernel.get(this, "restoreTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restoreTime", value);
    }

    /**
     * The identifier of the Multi-AZ DB cluster that will act as the source for the read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Multi-AZ DB cluster that will act as the source for the read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbClusterIdentifier", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbInstanceAutomatedBackupsArn() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbInstanceAutomatedBackupsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbInstanceAutomatedBackupsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbInstanceAutomatedBackupsArn", value);
    }

    /**
     * If you want to create a read replica DB instance, specify the ID of the source DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbInstanceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you want to create a read replica DB instance, specify the ID of the source DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbInstanceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbInstanceIdentifier", value);
    }

    /**
     * The resource ID of the source DB instance from which to restore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbiResourceId() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbiResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource ID of the source DB instance from which to restore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbiResourceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbiResourceId", value);
    }

    /**
     * The ID of the region that contains the source DB instance for the read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceRegion() {
        return software.amazon.jsii.Kernel.get(this, "sourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the region that contains the source DB instance for the read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceRegion", value);
    }

    /**
     * The status of a read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStatusInfos() {
        return software.amazon.jsii.Kernel.get(this, "statusInfos", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The status of a read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatusInfos(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "statusInfos", value);
    }

    /**
     * The status of a read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatusInfos(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnDBInstance.DBInstanceStatusInfoProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.rds.CfnDBInstance.DBInstanceStatusInfoProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "statusInfos", value);
    }

    /**
     * A value that indicates whether the DB instance is encrypted.
     * <p>
     * By default, it isn't encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether the DB instance is encrypted.
     * <p>
     * By default, it isn't encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * A value that indicates whether the DB instance is encrypted.
     * <p>
     * By default, it isn't encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStorageThroughput() {
        return software.amazon.jsii.Kernel.get(this, "storageThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageThroughput(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "storageThroughput", value);
    }

    /**
     * The storage type to associate with the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The storage type to associate with the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", value);
    }

    /**
     * Tags to assign to the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags to assign to the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.String getTdeCredentialArn() {
        return software.amazon.jsii.Kernel.get(this, "tdeCredentialArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setTdeCredentialArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tdeCredentialArn", value);
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.String getTdeCredentialPassword() {
        return software.amazon.jsii.Kernel.get(this, "tdeCredentialPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setTdeCredentialPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tdeCredentialPassword", value);
    }

    /**
     * The time zone of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
        return software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time zone of the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimezone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "timezone", value);
    }

    /**
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseDefaultProcessorFeatures() {
        return software.amazon.jsii.Kernel.get(this, "useDefaultProcessorFeatures", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseDefaultProcessorFeatures(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useDefaultProcessorFeatures", value);
    }

    /**
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseDefaultProcessorFeatures(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useDefaultProcessorFeatures", value);
    }

    /**
     * Specifies whether the DB instance is restored from the latest backup time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseLatestRestorableTime() {
        return software.amazon.jsii.Kernel.get(this, "useLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the DB instance is restored from the latest backup time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseLatestRestorableTime(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useLatestRestorableTime", value);
    }

    /**
     * Specifies whether the DB instance is restored from the latest backup time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseLatestRestorableTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useLatestRestorableTime", value);
    }

    /**
     * A list of the VPC security group IDs to assign to the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of the VPC security group IDs to assign to the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroups", value);
    }
    /**
     * The details of the DB instance’s server certificate.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * CertificateDetailsProperty certificateDetailsProperty = CertificateDetailsProperty.builder()
     *         .caIdentifier("caIdentifier")
     *         .validTill("validTill")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-certificatedetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-certificatedetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.CertificateDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CA identifier of the CA certificate used for the DB instance's server certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-certificatedetails.html#cfn-rds-dbinstance-certificatedetails-caidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-certificatedetails.html#cfn-rds-dbinstance-certificatedetails-caidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCaIdentifier() {
            return null;
        }

        /**
         * The expiration date of the DB instance’s server certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-certificatedetails.html#cfn-rds-dbinstance-certificatedetails-validtill">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-certificatedetails.html#cfn-rds-dbinstance-certificatedetails-validtill</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidTill() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CertificateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateDetailsProperty> {
            java.lang.String caIdentifier;
            java.lang.String validTill;

            /**
             * Sets the value of {@link CertificateDetailsProperty#getCaIdentifier}
             * @param caIdentifier The CA identifier of the CA certificate used for the DB instance's server certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caIdentifier(java.lang.String caIdentifier) {
                this.caIdentifier = caIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link CertificateDetailsProperty#getValidTill}
             * @param validTill The expiration date of the DB instance’s server certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validTill(java.lang.String validTill) {
                this.validTill = validTill;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CertificateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateDetailsProperty {
            private final java.lang.String caIdentifier;
            private final java.lang.String validTill;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.caIdentifier = software.amazon.jsii.Kernel.get(this, "caIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validTill = software.amazon.jsii.Kernel.get(this, "validTill", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.caIdentifier = builder.caIdentifier;
                this.validTill = builder.validTill;
            }

            @Override
            public final java.lang.String getCaIdentifier() {
                return this.caIdentifier;
            }

            @Override
            public final java.lang.String getValidTill() {
                return this.validTill;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaIdentifier() != null) {
                    data.set("caIdentifier", om.valueToTree(this.getCaIdentifier()));
                }
                if (this.getValidTill() != null) {
                    data.set("validTill", om.valueToTree(this.getValidTill()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.CertificateDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateDetailsProperty.Jsii$Proxy that = (CertificateDetailsProperty.Jsii$Proxy) o;

                if (this.caIdentifier != null ? !this.caIdentifier.equals(that.caIdentifier) : that.caIdentifier != null) return false;
                return this.validTill != null ? this.validTill.equals(that.validTill) : that.validTill == null;
            }

            @Override
            public final int hashCode() {
                int result = this.caIdentifier != null ? this.caIdentifier.hashCode() : 0;
                result = 31 * result + (this.validTill != null ? this.validTill.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about an AWS Identity and Access Management (IAM) role that is associated with a DB instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * DBInstanceRoleProperty dBInstanceRoleProperty = DBInstanceRoleProperty.builder()
     *         .featureName("featureName")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.DBInstanceRoleProperty")
    @software.amazon.jsii.Jsii.Proxy(DBInstanceRoleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DBInstanceRoleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the feature associated with the AWS Identity and Access Management (IAM) role.
         * <p>
         * IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the <code>SupportedFeatureNames</code> description in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">DBEngineVersion</a> in the <em>Amazon RDS API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-featurename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-featurename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeatureName();

        /**
         * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link DBInstanceRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DBInstanceRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DBInstanceRoleProperty> {
            java.lang.String featureName;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link DBInstanceRoleProperty#getFeatureName}
             * @param featureName The name of the feature associated with the AWS Identity and Access Management (IAM) role. This parameter is required.
             *                    IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the <code>SupportedFeatureNames</code> description in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">DBEngineVersion</a> in the <em>Amazon RDS API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureName(java.lang.String featureName) {
                this.featureName = featureName;
                return this;
            }

            /**
             * Sets the value of {@link DBInstanceRoleProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DBInstanceRoleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DBInstanceRoleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DBInstanceRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBInstanceRoleProperty {
            private final java.lang.String featureName;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.featureName = software.amazon.jsii.Kernel.get(this, "featureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.featureName = java.util.Objects.requireNonNull(builder.featureName, "featureName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getFeatureName() {
                return this.featureName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("featureName", om.valueToTree(this.getFeatureName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.DBInstanceRoleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DBInstanceRoleProperty.Jsii$Proxy that = (DBInstanceRoleProperty.Jsii$Proxy) o;

                if (!featureName.equals(that.featureName)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.featureName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides a list of status information for a DB instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * DBInstanceStatusInfoProperty dBInstanceStatusInfoProperty = DBInstanceStatusInfoProperty.builder()
     *         .message("message")
     *         .normal(false)
     *         .status("status")
     *         .statusType("statusType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.DBInstanceStatusInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(DBInstanceStatusInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DBInstanceStatusInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details of the error if there is an error for the instance.
         * <p>
         * If the instance isn't in an error state, this value is blank.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html#cfn-rds-dbinstance-dbinstancestatusinfo-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html#cfn-rds-dbinstance-dbinstancestatusinfo-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
            return null;
        }

        /**
         * Indicates whether the instance is operating normally (TRUE) or is in an error state (FALSE).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html#cfn-rds-dbinstance-dbinstancestatusinfo-normal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html#cfn-rds-dbinstance-dbinstancestatusinfo-normal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNormal() {
            return null;
        }

        /**
         * The status of the DB instance.
         * <p>
         * For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html#cfn-rds-dbinstance-dbinstancestatusinfo-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html#cfn-rds-dbinstance-dbinstancestatusinfo-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * This value is currently "read replication.".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html#cfn-rds-dbinstance-dbinstancestatusinfo-statustype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancestatusinfo.html#cfn-rds-dbinstance-dbinstancestatusinfo-statustype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatusType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DBInstanceStatusInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DBInstanceStatusInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DBInstanceStatusInfoProperty> {
            java.lang.String message;
            java.lang.Object normal;
            java.lang.String status;
            java.lang.String statusType;

            /**
             * Sets the value of {@link DBInstanceStatusInfoProperty#getMessage}
             * @param message Details of the error if there is an error for the instance.
             *                If the instance isn't in an error state, this value is blank.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link DBInstanceStatusInfoProperty#getNormal}
             * @param normal Indicates whether the instance is operating normally (TRUE) or is in an error state (FALSE).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder normal(java.lang.Boolean normal) {
                this.normal = normal;
                return this;
            }

            /**
             * Sets the value of {@link DBInstanceStatusInfoProperty#getNormal}
             * @param normal Indicates whether the instance is operating normally (TRUE) or is in an error state (FALSE).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder normal(software.amazon.awscdk.IResolvable normal) {
                this.normal = normal;
                return this;
            }

            /**
             * Sets the value of {@link DBInstanceStatusInfoProperty#getStatus}
             * @param status The status of the DB instance.
             *               For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link DBInstanceStatusInfoProperty#getStatusType}
             * @param statusType This value is currently "read replication.".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusType(java.lang.String statusType) {
                this.statusType = statusType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DBInstanceStatusInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DBInstanceStatusInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DBInstanceStatusInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBInstanceStatusInfoProperty {
            private final java.lang.String message;
            private final java.lang.Object normal;
            private final java.lang.String status;
            private final java.lang.String statusType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.normal = software.amazon.jsii.Kernel.get(this, "normal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statusType = software.amazon.jsii.Kernel.get(this, "statusType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = builder.message;
                this.normal = builder.normal;
                this.status = builder.status;
                this.statusType = builder.statusType;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.Object getNormal() {
                return this.normal;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getStatusType() {
                return this.statusType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessage() != null) {
                    data.set("message", om.valueToTree(this.getMessage()));
                }
                if (this.getNormal() != null) {
                    data.set("normal", om.valueToTree(this.getNormal()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getStatusType() != null) {
                    data.set("statusType", om.valueToTree(this.getStatusType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.DBInstanceStatusInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DBInstanceStatusInfoProperty.Jsii$Proxy that = (DBInstanceStatusInfoProperty.Jsii$Proxy) o;

                if (this.message != null ? !this.message.equals(that.message) : that.message != null) return false;
                if (this.normal != null ? !this.normal.equals(that.normal) : that.normal != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.statusType != null ? this.statusType.equals(that.statusType) : that.statusType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message != null ? this.message.hashCode() : 0;
                result = 31 * result + (this.normal != null ? this.normal.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.statusType != null ? this.statusType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This data type represents the information you need to connect to an Amazon RDS DB instance.
     * <p>
     * This data type is used as a response element in the following actions:
     * <p>
     * <ul>
     * <li><code>CreateDBInstance</code></li>
     * <li><code>DescribeDBInstances</code></li>
     * <li><code>DeleteDBInstance</code></li>
     * </ul>
     * <p>
     * For the data structure that represents Amazon Aurora DB cluster endpoints, see <code>DBClusterEndpoint</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * EndpointProperty endpointProperty = EndpointProperty.builder()
     *         .address("address")
     *         .hostedZoneId("hostedZoneId")
     *         .port("port")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-endpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-endpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.EndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the DNS address of the DB instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-endpoint.html#cfn-rds-dbinstance-endpoint-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-endpoint.html#cfn-rds-dbinstance-endpoint-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-endpoint.html#cfn-rds-dbinstance-endpoint-hostedzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-endpoint.html#cfn-rds-dbinstance-endpoint-hostedzoneid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
            return null;
        }

        /**
         * Specifies the port that the database engine is listening on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-endpoint.html#cfn-rds-dbinstance-endpoint-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-endpoint.html#cfn-rds-dbinstance-endpoint-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointProperty> {
            java.lang.String address;
            java.lang.String hostedZoneId;
            java.lang.String port;

            /**
             * Sets the value of {@link EndpointProperty#getAddress}
             * @param address Specifies the DNS address of the DB instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getHostedZoneId}
             * @param hostedZoneId Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getPort}
             * @param port Specifies the port that the database engine is listening on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointProperty {
            private final java.lang.String address;
            private final java.lang.String hostedZoneId;
            private final java.lang.String port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
                this.hostedZoneId = builder.hostedZoneId;
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getHostedZoneId() != null) {
                    data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.EndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointProperty.Jsii$Proxy that = (EndpointProperty.Jsii$Proxy) o;

                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                if (this.hostedZoneId != null ? !this.hostedZoneId.equals(that.hostedZoneId) : that.hostedZoneId != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                result = 31 * result + (this.hostedZoneId != null ? this.hostedZoneId.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>MasterUserSecret</code> return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * MasterUserSecretProperty masterUserSecretProperty = MasterUserSecretProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-masterusersecret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-masterusersecret.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.MasterUserSecretProperty")
    @software.amazon.jsii.Jsii.Proxy(MasterUserSecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MasterUserSecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS KMS key identifier that is used to encrypt the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-masterusersecret.html#cfn-rds-dbinstance-masterusersecret-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-masterusersecret.html#cfn-rds-dbinstance-masterusersecret-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the secret.
         * <p>
         * This parameter is a return value that you can retrieve using the <code>Fn::GetAtt</code> intrinsic function. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values">Return values</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-masterusersecret.html#cfn-rds-dbinstance-masterusersecret-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-masterusersecret.html#cfn-rds-dbinstance-masterusersecret-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MasterUserSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MasterUserSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MasterUserSecretProperty> {
            java.lang.String kmsKeyId;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link MasterUserSecretProperty#getKmsKeyId}
             * @param kmsKeyId The AWS KMS key identifier that is used to encrypt the secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link MasterUserSecretProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of the secret.
             *                  This parameter is a return value that you can retrieve using the <code>Fn::GetAtt</code> intrinsic function. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values">Return values</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MasterUserSecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MasterUserSecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MasterUserSecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MasterUserSecretProperty {
            private final java.lang.String kmsKeyId;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
                this.secretArn = builder.secretArn;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.MasterUserSecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MasterUserSecretProperty.Jsii$Proxy that = (MasterUserSecretProperty.Jsii$Proxy) o;

                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                return this.secretArn != null ? this.secretArn.equals(that.secretArn) : that.secretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ProcessorFeature</code> property type specifies the processor features of a DB instance class.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * ProcessorFeatureProperty processorFeatureProperty = ProcessorFeatureProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.ProcessorFeatureProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessorFeatureProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessorFeatureProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the processor feature.
         * <p>
         * Valid names are <code>coreCount</code> and <code>threadsPerCore</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of a processor feature.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessorFeatureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessorFeatureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessorFeatureProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link ProcessorFeatureProperty#getName}
             * @param name The name of the processor feature.
             *             Valid names are <code>coreCount</code> and <code>threadsPerCore</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorFeatureProperty#getValue}
             * @param value The value of a processor feature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessorFeatureProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessorFeatureProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessorFeatureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorFeatureProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.ProcessorFeatureProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessorFeatureProperty.Jsii$Proxy that = (ProcessorFeatureProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.rds.CfnDBInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
         * <p>
         * <blockquote>
         * <p>
         * If any value is set in the <code>Iops</code> parameter, <code>AllocatedStorage</code> must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the <code>Iops</code> value (in 1,000 IOPS increments), then you must also increase the <code>AllocatedStorage</code> value (in 100-GiB increments).
         * <p>
         * </blockquote>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
         * <p>
         * <em>Db2</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp3): Must be an integer from 20 to 64000.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 64000.</li>
         * </ul>
         * <p>
         * <em>MySQL</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         * </ul>
         * <p>
         * <em>MariaDB</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         * </ul>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         * </ul>
         * <p>
         * <em>Oracle</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         * <li>Magnetic storage (standard): Must be an integer from 10 to 3072.</li>
         * </ul>
         * <p>
         * <em>SQL Server</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2):</li>
         * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
         * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
         * <li>Provisioned IOPS storage (io1):</li>
         * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
         * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
         * <li>Magnetic storage (standard):</li>
         * <li>Enterprise and Standard editions: Must be an integer from 20 to 1024.</li>
         * <li>Web and Express editions: Must be an integer from 20 to 1024.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allocatedstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allocatedstorage</a>
         * @param allocatedStorage The amount of storage in gibibytes (GiB) to be initially allocated for the database instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocatedStorage(final java.lang.String allocatedStorage) {
            this.props().allocatedStorage(allocatedStorage);
            return this;
        }

        /**
         * A value that indicates whether major version upgrades are allowed.
         * <p>
         * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         * <p>
         * Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allowmajorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allowmajorversionupgrade</a>
         * @param allowMajorVersionUpgrade A value that indicates whether major version upgrades are allowed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMajorVersionUpgrade(final java.lang.Boolean allowMajorVersionUpgrade) {
            this.props().allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }
        /**
         * A value that indicates whether major version upgrades are allowed.
         * <p>
         * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         * <p>
         * Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allowmajorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-allowmajorversionupgrade</a>
         * @param allowMajorVersionUpgrade A value that indicates whether major version upgrades are allowed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMajorVersionUpgrade(final software.amazon.awscdk.IResolvable allowMajorVersionUpgrade) {
            this.props().allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }

        /**
         * Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting.
         * <p>
         * If set to <code>false</code> , changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         * <p>
         * In addition to the settings described in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB instance</a> , this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         * <p>
         * Default: <code>true</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-applyimmediately">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-applyimmediately</a>
         * @param applyImmediately Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyImmediately(final java.lang.Boolean applyImmediately) {
            this.props().applyImmediately(applyImmediately);
            return this;
        }
        /**
         * Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting.
         * <p>
         * If set to <code>false</code> , changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         * <p>
         * In addition to the settings described in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB instance</a> , this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         * <p>
         * Default: <code>true</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-applyimmediately">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-applyimmediately</a>
         * @param applyImmediately Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the <code>PreferredMaintenanceWindow</code> setting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyImmediately(final software.amazon.awscdk.IResolvable applyImmediately) {
            this.props().applyImmediately(applyImmediately);
            return this;
        }

        /**
         * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The associated roles are managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-associatedroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-associatedroles</a>
         * @param associatedRoles The AWS Identity and Access Management (IAM) roles associated with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final software.amazon.awscdk.IResolvable associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }
        /**
         * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The associated roles are managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-associatedroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-associatedroles</a>
         * @param associatedRoles The AWS Identity and Access Management (IAM) roles associated with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final java.util.List<? extends java.lang.Object> associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }

        /**
         * The AWS KMS key identifier for encryption of the replicated automated backups.
         * <p>
         * The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region , for example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationkmskeyid</a>
         * @param automaticBackupReplicationKmsKeyId The AWS KMS key identifier for encryption of the replicated automated backups. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticBackupReplicationKmsKeyId(final java.lang.String automaticBackupReplicationKmsKeyId) {
            this.props().automaticBackupReplicationKmsKeyId(automaticBackupReplicationKmsKeyId);
            return this;
        }

        /**
         * The AWS Region associated with the automated backup.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationregion</a>
         * @param automaticBackupReplicationRegion The AWS Region associated with the automated backup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticBackupReplicationRegion(final java.lang.String automaticBackupReplicationRegion) {
            this.props().automaticBackupReplicationRegion(automaticBackupReplicationRegion);
            return this;
        }

        /**
         * The retention period for automated backups in a different AWS Region.
         * <p>
         * Use this parameter to set a unique retention period that only applies to cross-Region automated backups. To enable automated backups in a different Region, specify a positive value for the <code>AutomaticBackupReplicationRegion</code> parameter.
         * <p>
         * If not specified, this parameter defaults to the value of the <code>BackupRetentionPeriod</code> parameter. The maximum allowed value is 35.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-automaticbackupreplicationretentionperiod</a>
         * @param automaticBackupReplicationRetentionPeriod The retention period for automated backups in a different AWS Region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticBackupReplicationRetentionPeriod(final java.lang.Number automaticBackupReplicationRetentionPeriod) {
            this.props().automaticBackupReplicationRetentionPeriod(automaticBackupReplicationRetentionPeriod);
            return this;
        }

        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * <p>
         * By default, minor engine upgrades are applied automatically.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-autominorversionupgrade</a>
         * @param autoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }
        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * <p>
         * By default, minor engine upgrades are applied automatically.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-autominorversionupgrade</a>
         * @param autoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * The Availability Zone (AZ) where the database will be created.
         * <p>
         * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> .
         * <p>
         * For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
         * <p>
         * Default: A random, system-chosen Availability Zone in the endpoint's AWS Region .
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment.</li>
         * <li>The specified Availability Zone must be in the same AWS Region as the current endpoint.</li>
         * </ul>
         * <p>
         * Example: <code>us-east-1d</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-availabilityzone</a>
         * @param availabilityZone The Availability Zone (AZ) where the database will be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The number of days for which automated backups are retained.
         * <p>
         * Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The retention period for automated backups is managed by the DB cluster.
         * <p>
         * Default: 1
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be a value from 0 to 35</li>
         * <li>Can't be set to 0 if the DB instance is a source to read replicas</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-backupretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-backupretentionperiod</a>
         * @param backupRetentionPeriod The number of days for which automated backups are retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(final java.lang.Number backupRetentionPeriod) {
            this.props().backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        /**
         * The location for storing automated backups and manual snapshots.
         * <p>
         * Valid Values:
         * <p>
         * <ul>
         * <li><code>local</code> (Dedicated Local Zone)</li>
         * <li><code>outposts</code> ( AWS Outposts)</li>
         * <li><code>region</code> ( AWS Region )</li>
         * </ul>
         * <p>
         * Default: <code>region</code>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on AWS Outposts</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-backuptarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-backuptarget</a>
         * @param backupTarget The location for storing automated backups and manual snapshots. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupTarget(final java.lang.String backupTarget) {
            this.props().backupTarget(backupTarget);
            return this;
        }

        /**
         * The identifier of the CA certificate for this DB instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-cacertificateidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-cacertificateidentifier</a>
         * @param caCertificateIdentifier The identifier of the CA certificate for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificateIdentifier(final java.lang.String caCertificateIdentifier) {
            this.props().caCertificateIdentifier(caCertificateIdentifier);
            return this;
        }

        /**
         * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         * <p>
         * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
         * <p>
         * <blockquote>
         * <p>
         * Set this parameter only if you are <em>not</em> using SSL/TLS to connect to the DB instance.
         * <p>
         * </blockquote>
         * <p>
         * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
         * <p>
         * <ul>
         * <li>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate.</a> in the <em>Amazon RDS User Guide.</em></li>
         * <li>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon Aurora User Guide</em> .</li>
         * </ul>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-certificaterotationrestart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-certificaterotationrestart</a>
         * @param certificateRotationRestart Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateRotationRestart(final java.lang.Boolean certificateRotationRestart) {
            this.props().certificateRotationRestart(certificateRotationRestart);
            return this;
        }
        /**
         * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         * <p>
         * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
         * <p>
         * <blockquote>
         * <p>
         * Set this parameter only if you are <em>not</em> using SSL/TLS to connect to the DB instance.
         * <p>
         * </blockquote>
         * <p>
         * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
         * <p>
         * <ul>
         * <li>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate.</a> in the <em>Amazon RDS User Guide.</em></li>
         * <li>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon Aurora User Guide</em> .</li>
         * </ul>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-certificaterotationrestart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-certificaterotationrestart</a>
         * @param certificateRotationRestart Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateRotationRestart(final software.amazon.awscdk.IResolvable certificateRotationRestart) {
            this.props().certificateRotationRestart(certificateRotationRestart);
            return this;
        }

        /**
         * For supported engines, indicates that the DB instance should be associated with the specified character set.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The character set is managed by the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html">AWS::RDS::DBCluster</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-charactersetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-charactersetname</a>
         * @param characterSetName For supported engines, indicates that the DB instance should be associated with the specified character set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder characterSetName(final java.lang.String characterSetName) {
            this.props().characterSetName(characterSetName);
            return this;
        }

        /**
         * Specifies whether to copy tags from the DB instance to snapshots of the DB instance.
         * <p>
         * By default, tags are not copied.
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-copytagstosnapshot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-copytagstosnapshot</a>
         * @param copyTagsToSnapshot Specifies whether to copy tags from the DB instance to snapshots of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }
        /**
         * Specifies whether to copy tags from the DB instance to snapshots of the DB instance.
         * <p>
         * By default, tags are not copied.
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-copytagstosnapshot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-copytagstosnapshot</a>
         * @param copyTagsToSnapshot Specifies whether to copy tags from the DB instance to snapshots of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
         * <p>
         * This setting is required for RDS Custom.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>The profile must exist in your account.</li>
         * <li>The profile must have an IAM role that Amazon EC2 has permissions to assume.</li>
         * <li>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code> .</li>
         * </ul>
         * <p>
         * For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">Configure IAM and your VPC</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-customiaminstanceprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-customiaminstanceprofile</a>
         * @param customIamInstanceProfile The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customIamInstanceProfile(final java.lang.String customIamInstanceProfile) {
            this.props().customIamInstanceProfile(customIamInstanceProfile);
            return this;
        }

        /**
         * The mode of Database Insights to enable for the DB instance.
         * <p>
         * <blockquote>
         * <p>
         * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-databaseinsightsmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-databaseinsightsmode</a>
         * @param databaseInsightsMode The mode of Database Insights to enable for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInsightsMode(final java.lang.String databaseInsightsMode) {
            this.props().databaseInsightsMode(databaseInsightsMode);
            return this;
        }

        /**
         * The identifier of the DB cluster that this DB instance will belong to.
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbclusteridentifier</a>
         * @param dbClusterIdentifier The identifier of the DB cluster that this DB instance will belong to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(final java.lang.String dbClusterIdentifier) {
            this.props().dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        /**
         * The identifier for the Multi-AZ DB cluster snapshot to restore from.
         * <p>
         * For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB cluster deployments</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must match the identifier of an existing Multi-AZ DB cluster snapshot.</li>
         * <li>Can't be specified when <code>DBSnapshotIdentifier</code> is specified.</li>
         * <li>Must be specified when <code>DBSnapshotIdentifier</code> isn't specified.</li>
         * <li>If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the <code>DBClusterSnapshotIdentifier</code> must be the ARN of the shared snapshot.</li>
         * <li>Can't be the identifier of an Aurora DB cluster snapshot.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbclustersnapshotidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbclustersnapshotidentifier</a>
         * @param dbClusterSnapshotIdentifier The identifier for the Multi-AZ DB cluster snapshot to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterSnapshotIdentifier(final java.lang.String dbClusterSnapshotIdentifier) {
            this.props().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier);
            return this;
        }

        /**
         * The compute and memory capacity of the DB instance, for example <code>db.m5.large</code> . Not all DB instance classes are available in all AWS Regions , or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance classes</a> in the <em>Amazon RDS User Guide</em> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB instance classes</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbinstanceclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbinstanceclass</a>
         * @param dbInstanceClass The compute and memory capacity of the DB instance, for example <code>db.m5.large</code> . Not all DB instance classes are available in all AWS Regions , or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance classes</a> in the <em>Amazon RDS User Guide</em> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB instance classes</a> in the <em>Amazon Aurora User Guide</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceClass(final java.lang.String dbInstanceClass) {
            this.props().dbInstanceClass(dbInstanceClass);
            return this;
        }

        /**
         * A name for the DB instance.
         * <p>
         * If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbinstanceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbinstanceidentifier</a>
         * @param dbInstanceIdentifier A name for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceIdentifier(final java.lang.String dbInstanceIdentifier) {
            this.props().dbInstanceIdentifier(dbInstanceIdentifier);
            return this;
        }

        /**
         * The meaning of this parameter differs according to the database engine you use.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>[DBSnapshotIdentifier](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier)</code> property, this property only applies to RDS for Oracle.
         * <p>
         * </blockquote>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The database name is managed by the DB cluster.
         * <p>
         * <em>Db2</em>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1 to 64 letters or numbers.</li>
         * <li>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</li>
         * <li>Can't be a word reserved by the specified database engine.</li>
         * </ul>
         * <p>
         * <em>MySQL</em>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1 to 64 letters or numbers.</li>
         * <li>Can't be a word reserved by the specified database engine</li>
         * </ul>
         * <p>
         * <em>MariaDB</em>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1 to 64 letters or numbers.</li>
         * <li>Can't be a word reserved by the specified database engine</li>
         * </ul>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter is not specified, the default <code>postgres</code> database is created in the DB instance.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</li>
         * <li>Must contain 1 to 63 characters.</li>
         * <li>Can't be a word reserved by the specified database engine</li>
         * </ul>
         * <p>
         * <em>Oracle</em>
         * <p>
         * The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code> , the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code> .
         * <p>
         * Default: <code>ORCL</code>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Can't be longer than 8 characters</li>
         * </ul>
         * <p>
         * <em>SQL Server</em>
         * <p>
         * Not applicable. Must be null.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbname</a>
         * @param dbName The meaning of this parameter differs according to the database engine you use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(final java.lang.String dbName) {
            this.props().dbName(dbName);
            return this;
        }

        /**
         * The name of an existing DB parameter group or a reference to an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html">AWS::RDS::DBParameterGroup</a> resource created in the template.
         * <p>
         * To list all of the available DB parameter group names, use the following command:
         * <p>
         * <code>aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text</code>
         * <p>
         * <blockquote>
         * <p>
         * If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
         * <p>
         * </blockquote>
         * <p>
         * If you don't specify a value for <code>DBParameterGroupName</code> property, the default DB parameter group for the specified engine and engine version is used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbparametergroupname</a>
         * @param dbParameterGroupName The name of an existing DB parameter group or a reference to an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html">AWS::RDS::DBParameterGroup</a> resource created in the template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbParameterGroupName(final java.lang.String dbParameterGroupName) {
            this.props().dbParameterGroupName(dbParameterGroupName);
            return this;
        }

        /**
         * A list of the DB security groups to assign to the DB instance.
         * <p>
         * The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
         * <p>
         * If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
         * <p>
         * <blockquote>
         * <p>
         * If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
         * <p>
         * <ul>
         * <li><code>AllocatedStorage</code></li>
         * <li><code>AutoMinorVersionUpgrade</code></li>
         * <li><code>AvailabilityZone</code></li>
         * <li><code>BackupRetentionPeriod</code></li>
         * <li><code>CharacterSetName</code></li>
         * <li><code>DBInstanceClass</code></li>
         * <li><code>DBName</code></li>
         * <li><code>DBParameterGroupName</code></li>
         * <li><code>DBSecurityGroups</code></li>
         * <li><code>DBSubnetGroupName</code></li>
         * <li><code>Engine</code></li>
         * <li><code>EngineVersion</code></li>
         * <li><code>Iops</code></li>
         * <li><code>LicenseModel</code></li>
         * <li><code>MasterUsername</code></li>
         * <li><code>MasterUserPassword</code></li>
         * <li><code>MultiAZ</code></li>
         * <li><code>OptionGroupName</code></li>
         * <li><code>PreferredBackupWindow</code></li>
         * <li><code>PreferredMaintenanceWindow</code></li>
         * </ul>
         * <p>
         * All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as <code>StorageType</code> , <code>StorageEncrypted</code> , or <code>KmsKeyId</code> . If you're already using the <code>DBSecurityGroups</code> property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsecuritygroups</a>
         * @param dbSecurityGroups A list of the DB security groups to assign to the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroups(final java.util.List<java.lang.String> dbSecurityGroups) {
            this.props().dbSecurityGroups(dbSecurityGroups);
            return this;
        }

        /**
         * The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
         * <p>
         * If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
         * <p>
         * By specifying this property, you can create a DB instance from the specified DB snapshot. If the <code>DBSnapshotIdentifier</code> property is an empty string or the <code>AWS::RDS::DBInstance</code> declaration has no <code>DBSnapshotIdentifier</code> property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
         * <p>
         * Some DB instance properties aren't valid when you restore from a snapshot, such as the <code>MasterUsername</code> and <code>MasterUserPassword</code> properties, and the point-in-time recovery properties <code>RestoreTime</code> and <code>UseLatestRestorableTime</code> . For information about the properties that you can specify, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html"><code>RestoreDBInstanceFromDBSnapshot</code></a> action in the <em>Amazon RDS API Reference</em> .
         * <p>
         * After you restore a DB instance with a <code>DBSnapshotIdentifier</code> property, you must specify the same <code>DBSnapshotIdentifier</code> property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the <code>DBSnapshotIdentifier</code> property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified <code>DBSnapshotIdentifier</code> property, and the original DB instance is deleted.
         * <p>
         * If you specify the <code>DBSnapshotIdentifier</code> property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
         * <p>
         * <ul>
         * <li><code>CharacterSetName</code></li>
         * <li><code>DBClusterIdentifier</code></li>
         * <li><code>DBName</code></li>
         * <li><code>KmsKeyId</code></li>
         * <li><code>MasterUsername</code></li>
         * <li><code>MasterUserPassword</code></li>
         * <li><code>PromotionTier</code></li>
         * <li><code>SourceDBInstanceIdentifier</code></li>
         * <li><code>SourceRegion</code></li>
         * <li><code>StorageEncrypted</code> (for an unencrypted snapshot)</li>
         * <li><code>Timezone</code></li>
         * </ul>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Snapshot restore is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsnapshotidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsnapshotidentifier</a>
         * @param dbSnapshotIdentifier The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSnapshotIdentifier(final java.lang.String dbSnapshotIdentifier) {
            this.props().dbSnapshotIdentifier(dbSnapshotIdentifier);
            return this;
        }

        /**
         * A DB subnet group to associate with the DB instance.
         * <p>
         * If you update this value, the new subnet group must be a subnet group in a new VPC.
         * <p>
         * If you don't specify a DB subnet group, RDS uses the default DB subnet group if one exists. If a default DB subnet group does not exist, and you don't specify a <code>DBSubnetGroupName</code> , the DB instance fails to launch.
         * <p>
         * For more information about using Amazon RDS in a VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Amazon VPC and Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsubnetgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsubnetgroupname</a>
         * @param dbSubnetGroupName A DB subnet group to associate with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(final java.lang.String dbSubnetGroupName) {
            this.props().dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        /**
         * The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files.
         * <p>
         * In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to <code>RDSCDB</code> . The Oracle SID is also the name of your CDB.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dbsystemid</a>
         * @param dbSystemId The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSystemId(final java.lang.String dbSystemId) {
            this.props().dbSystemId(dbSystemId);
            return this;
        }

        /**
         * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dedicatedlogvolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dedicatedlogvolume</a>
         * @param dedicatedLogVolume Indicates whether the DB instance has a dedicated log volume (DLV) enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedLogVolume(final java.lang.Boolean dedicatedLogVolume) {
            this.props().dedicatedLogVolume(dedicatedLogVolume);
            return this;
        }
        /**
         * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dedicatedlogvolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-dedicatedlogvolume</a>
         * @param dedicatedLogVolume Indicates whether the DB instance has a dedicated log volume (DLV) enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedLogVolume(final software.amazon.awscdk.IResolvable dedicatedLogVolume) {
            this.props().dedicatedLogVolume(dedicatedLogVolume);
            return this;
        }

        /**
         * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
         * <p>
         * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deleteautomatedbackups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deleteautomatedbackups</a>
         * @param deleteAutomatedBackups A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(final java.lang.Boolean deleteAutomatedBackups) {
            this.props().deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }
        /**
         * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
         * <p>
         * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deleteautomatedbackups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deleteautomatedbackups</a>
         * @param deleteAutomatedBackups A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(final software.amazon.awscdk.IResolvable deleteAutomatedBackups) {
            this.props().deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }

        /**
         * Specifies whether the DB instance has deletion protection enabled.
         * <p>
         * The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deletionprotection</a>
         * @param deletionProtection Specifies whether the DB instance has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }
        /**
         * Specifies whether the DB instance has deletion protection enabled.
         * <p>
         * The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-deletionprotection</a>
         * @param deletionProtection Specifies whether the DB instance has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.IResolvable deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The Active Directory directory ID to create the DB instance in.
         * <p>
         * Currently, only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domain</a>
         * @param domain The Active Directory directory ID to create the DB instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props().domain(domain);
            return this;
        }

        /**
         * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         * <p>
         * Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainauthsecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainauthsecretarn</a>
         * @param domainAuthSecretArn The ARN for the Secrets Manager secret with the credentials for the user joining the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainAuthSecretArn(final java.lang.String domainAuthSecretArn) {
            this.props().domainAuthSecretArn(domainAuthSecretArn);
            return this;
        }

        /**
         * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.</li>
         * </ul>
         * <p>
         * Example: <code>123.124.125.126,234.235.236.237</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domaindnsips">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domaindnsips</a>
         * @param domainDnsIps The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainDnsIps(final java.util.List<java.lang.String> domainDnsIps) {
            this.props().domainDnsIps(domainDnsIps);
            return this;
        }

        /**
         * The fully qualified domain name (FQDN) of an Active Directory domain.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Can't be longer than 64 characters.</li>
         * </ul>
         * <p>
         * Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainfqdn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainfqdn</a>
         * @param domainFqdn The fully qualified domain name (FQDN) of an Active Directory domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainFqdn(final java.lang.String domainFqdn) {
            this.props().domainFqdn(domainFqdn);
            return this;
        }

        /**
         * The name of the IAM role to use when making API calls to the Directory Service.
         * <p>
         * This setting doesn't apply to the following DB instances:
         * <p>
         * <ul>
         * <li>Amazon Aurora (The domain is managed by the DB cluster.)</li>
         * <li>RDS Custom</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainiamrolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainiamrolename</a>
         * @param domainIamRoleName The name of the IAM role to use when making API calls to the Directory Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIamRoleName(final java.lang.String domainIamRoleName) {
            this.props().domainIamRoleName(domainIamRoleName);
            return this;
        }

        /**
         * The Active Directory organizational unit for your DB instance to join.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in the distinguished name format.</li>
         * <li>Can't be longer than 64 characters.</li>
         * </ul>
         * <p>
         * Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainou">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-domainou</a>
         * @param domainOu The Active Directory organizational unit for your DB instance to join. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainOu(final java.lang.String domainOu) {
            this.props().domainOu(domainOu);
            return this;
        }

        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * <p>
         * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Relational Database Service User Guide</em> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. CloudWatch Logs exports are managed by the DB cluster.
         * <p>
         * <em>Db2</em>
         * <p>
         * Valid values: <code>diag.log</code> , <code>notify.log</code>
         * <p>
         * <em>MariaDB</em>
         * <p>
         * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         * <p>
         * <em>Microsoft SQL Server</em>
         * <p>
         * Valid values: <code>agent</code> , <code>error</code>
         * <p>
         * <em>MySQL</em>
         * <p>
         * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         * <p>
         * <em>Oracle</em>
         * <p>
         * Valid values: <code>alert</code> , <code>audit</code> , <code>listener</code> , <code>trace</code> , <code>oemagent</code>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * Valid values: <code>postgresql</code> , <code>upgrade</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports</a>
         * @param enableCloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(final java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.props().enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        /**
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * By default, mapping is disabled.
         * <p>
         * This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MariaDB, MySQL, and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication</a>
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final java.lang.Boolean enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }
        /**
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * By default, mapping is disabled.
         * <p>
         * This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MariaDB, MySQL, and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication</a>
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final software.amazon.awscdk.IResolvable enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        /**
         * Specifies whether to enable Performance Insights for the DB instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableperformanceinsights">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableperformanceinsights</a>
         * @param enablePerformanceInsights Specifies whether to enable Performance Insights for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(final java.lang.Boolean enablePerformanceInsights) {
            this.props().enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }
        /**
         * Specifies whether to enable Performance Insights for the DB instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableperformanceinsights">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enableperformanceinsights</a>
         * @param enablePerformanceInsights Specifies whether to enable Performance Insights for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(final software.amazon.awscdk.IResolvable enablePerformanceInsights) {
            this.props().enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        /**
         * The name of the database engine to use for this DB instance.
         * <p>
         * Not every database engine is available in every AWS Region.
         * <p>
         * This property is required when creating a DB instance.
         * <p>
         * <blockquote>
         * <p>
         * You can convert an Oracle database from the non-CDB architecture to the container database (CDB) architecture by updating the <code>Engine</code> value in your templates from <code>oracle-ee</code> to <code>oracle-ee-cdb</code> or from <code>oracle-se2</code> to <code>oracle-se2-cdb</code> . Converting to the CDB architecture requires an interruption.
         * <p>
         * </blockquote>
         * <p>
         * Valid Values:
         * <p>
         * <ul>
         * <li><code>aurora-mysql</code> (for Aurora MySQL DB instances)</li>
         * <li><code>aurora-postgresql</code> (for Aurora PostgreSQL DB instances)</li>
         * <li><code>custom-oracle-ee</code> (for RDS Custom for Oracle DB instances)</li>
         * <li><code>custom-oracle-ee-cdb</code> (for RDS Custom for Oracle DB instances)</li>
         * <li><code>custom-sqlserver-ee</code> (for RDS Custom for SQL Server DB instances)</li>
         * <li><code>custom-sqlserver-se</code> (for RDS Custom for SQL Server DB instances)</li>
         * <li><code>custom-sqlserver-web</code> (for RDS Custom for SQL Server DB instances)</li>
         * <li><code>db2-ae</code></li>
         * <li><code>db2-se</code></li>
         * <li><code>mariadb</code></li>
         * <li><code>mysql</code></li>
         * <li><code>oracle-ee</code></li>
         * <li><code>oracle-ee-cdb</code></li>
         * <li><code>oracle-se2</code></li>
         * <li><code>oracle-se2-cdb</code></li>
         * <li><code>postgres</code></li>
         * <li><code>sqlserver-ee</code></li>
         * <li><code>sqlserver-se</code></li>
         * <li><code>sqlserver-ex</code></li>
         * <li><code>sqlserver-web</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-engine</a>
         * @param engine The name of the database engine to use for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props().engine(engine);
            return this;
        }

        /**
         * The life cycle type for this DB instance.
         * <p>
         * <blockquote>
         * <p>
         * By default, this value is set to <code>open-source-rds-extended-support</code> , which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code> . In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.
         * <p>
         * </blockquote>
         * <p>
         * This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
         * <p>
         * You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended Support with Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         * <p>
         * Default: <code>open-source-rds-extended-support</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enginelifecyclesupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-enginelifecyclesupport</a>
         * @param engineLifecycleSupport The life cycle type for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineLifecycleSupport(final java.lang.String engineLifecycleSupport) {
            this.props().engineLifecycleSupport(engineLifecycleSupport);
            return this;
        }

        /**
         * The version number of the database engine to use.
         * <p>
         * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
         * <p>
         * The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
         * <p>
         * <em>Db2</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt">Amazon RDS for Db2</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>MariaDB</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>Microsoft SQL Server</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>MySQL</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>Oracle</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions">Supported PostgreSQL Database Versions</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-engineversion</a>
         * @param engineVersion The version number of the database engine to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props().engineVersion(engineVersion);
            return this;
        }

        /**
         * The number of I/O operations per second (IOPS) that the database provisions.
         * <p>
         * The value must be equal to or greater than 1000.
         * <p>
         * If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>io1</code> for the <code>StorageType</code> property, then you must also specify the <code>Iops</code> property.
         * <p>
         * </blockquote>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.</li>
         * <li>For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-iops</a>
         * @param iops The number of I/O operations per second (IOPS) that the database provisions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(final java.lang.Number iops) {
            this.props().iops(iops);
            return this;
        }

        /**
         * The ARN of the AWS KMS key that's used to encrypt the DB instance, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
         * <p>
         * If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true.
         * <p>
         * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>SourceDbiResourceId</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used. However, if the source DB instance is in a different AWS Region, you must specify a KMS key ID.
         * <p>
         * If you specify the <code>SourceDBInstanceAutomatedBackupsArn</code> property, don't specify this property. The value is inherited from the source DB instance automated backup, and if the automated backup is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
         * <p>
         * If you specify the <code>DBSnapshotIdentifier</code> property, don't specify this property. The <code>StorageEncrypted</code> property value is inherited from the snapshot. If the DB instance is encrypted, the specified <code>KmsKeyId</code> property is also inherited from the snapshot.
         * <p>
         * If you specify <code>DBSecurityGroups</code> , AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The KMS key identifier is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-kmskeyid</a>
         * @param kmsKeyId The ARN of the AWS KMS key that's used to encrypt the DB instance, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * License model information for this DB instance.
         * <p>
         * Valid Values:
         * <p>
         * <ul>
         * <li>Aurora MySQL - <code>general-public-license</code></li>
         * <li>Aurora PostgreSQL - <code>postgresql-license</code></li>
         * <li>RDS for Db2 - <code>bring-your-own-license</code> . For more information about RDS for Db2 licensing, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html"></a> in the <em>Amazon RDS User Guide.</em></li>
         * <li>RDS for MariaDB - <code>general-public-license</code></li>
         * <li>RDS for Microsoft SQL Server - <code>license-included</code></li>
         * <li>RDS for MySQL - <code>general-public-license</code></li>
         * <li>RDS for Oracle - <code>bring-your-own-license</code> or <code>license-included</code></li>
         * <li>RDS for PostgreSQL - <code>postgresql-license</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you've specified <code>DBSecurityGroups</code> and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-licensemodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-licensemodel</a>
         * @param licenseModel License model information for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseModel(final java.lang.String licenseModel) {
            this.props().licenseModel(licenseModel);
            return this;
        }

        /**
         * Specifies whether to manage the master user password with AWS Secrets Manager.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Can't manage the master user password with AWS Secrets Manager if <code>MasterUserPassword</code> is specified.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-managemasteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-managemasteruserpassword</a>
         * @param manageMasterUserPassword Specifies whether to manage the master user password with AWS Secrets Manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageMasterUserPassword(final java.lang.Boolean manageMasterUserPassword) {
            this.props().manageMasterUserPassword(manageMasterUserPassword);
            return this;
        }
        /**
         * Specifies whether to manage the master user password with AWS Secrets Manager.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Can't manage the master user password with AWS Secrets Manager if <code>MasterUserPassword</code> is specified.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-managemasteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-managemasteruserpassword</a>
         * @param manageMasterUserPassword Specifies whether to manage the master user password with AWS Secrets Manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageMasterUserPassword(final software.amazon.awscdk.IResolvable manageMasterUserPassword) {
            this.props().manageMasterUserPassword(manageMasterUserPassword);
            return this;
        }

        /**
         * The master user name for the DB instance.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance or snapshot.
         * <p>
         * When migrating a self-managed Db2 database, we recommend that you use the same master username as your self-managed Db2 instance name.
         * <p>
         * </blockquote>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The name for the master user is managed by the DB cluster.
         * <p>
         * <em>RDS for Db2</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be 1 to 16 letters or numbers.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>RDS for MariaDB</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be 1 to 16 letters or numbers.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>RDS for Microsoft SQL Server</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be 1 to 128 letters or numbers.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>RDS for MySQL</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be 1 to 16 letters or numbers.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>RDS for Oracle</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be 1 to 30 letters or numbers.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>RDS for PostgreSQL</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be 1 to 63 letters or numbers.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusername</a>
         * @param masterUsername The master user name for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(final java.lang.String masterUsername) {
            this.props().masterUsername(masterUsername);
            return this;
        }

        /**
         * The password for the master user. The password can include any printable ASCII character except "/", """, or "&#64;".
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The password for the master user is managed by the DB cluster.
         * <p>
         * <em>RDS for Db2</em>
         * <p>
         * Must contain from 8 to 255 characters.
         * <p>
         * <em>RDS for MariaDB</em>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * <p>
         * <em>RDS for Microsoft SQL Server</em>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * <p>
         * <em>RDS for MySQL</em>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * <p>
         * <em>RDS for Oracle</em>
         * <p>
         * Constraints: Must contain from 8 to 30 characters.
         * <p>
         * <em>RDS for PostgreSQL</em>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masteruserpassword</a>
         * @param masterUserPassword The password for the master user. The password can include any printable ASCII character except "/", """, or "&#64;". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(final java.lang.String masterUserPassword) {
            this.props().masterUserPassword(masterUserPassword);
            return this;
        }

        /**
         * The secret managed by RDS in AWS Secrets Manager for the master user password.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusersecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusersecret</a>
         * @param masterUserSecret The secret managed by RDS in AWS Secrets Manager for the master user password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserSecret(final software.amazon.awscdk.IResolvable masterUserSecret) {
            this.props().masterUserSecret(masterUserSecret);
            return this;
        }
        /**
         * The secret managed by RDS in AWS Secrets Manager for the master user password.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusersecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-masterusersecret</a>
         * @param masterUserSecret The secret managed by RDS in AWS Secrets Manager for the master user password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserSecret(final software.amazon.awscdk.services.rds.CfnDBInstance.MasterUserSecretProperty masterUserSecret) {
            this.props().masterUserSecret(masterUserSecret);
            return this;
        }

        /**
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         * <p>
         * For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting doesn't apply to the following DB instances:
         * <p>
         * <ul>
         * <li>Amazon Aurora (Storage is managed by the DB cluster.)</li>
         * <li>RDS Custom</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-maxallocatedstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-maxallocatedstorage</a>
         * @param maxAllocatedStorage The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAllocatedStorage(final java.lang.Number maxAllocatedStorage) {
            this.props().maxAllocatedStorage(maxAllocatedStorage);
            return this;
        }

        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         * <p>
         * To disable collection of Enhanced Monitoring metrics, specify <code>0</code> .
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than <code>0</code> .
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         * <p>
         * Default: <code>0</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-monitoringinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-monitoringinterval</a>
         * @param monitoringInterval The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(final java.lang.Number monitoringInterval) {
            this.props().monitoringInterval(monitoringInterval);
            return this;
        }

        /**
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
         * <p>
         * For example, <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than <code>0</code> , then you must supply a <code>MonitoringRoleArn</code> value.
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-monitoringrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-monitoringrolearn</a>
         * @param monitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRoleArn(final java.lang.String monitoringRoleArn) {
            this.props().monitoringRoleArn(monitoringRoleArn);
            return this;
        }

        /**
         * Specifies whether the DB instance is a Multi-AZ deployment.
         * <p>
         * You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
         * <p>
         * This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-multiaz">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-multiaz</a>
         * @param multiAz Specifies whether the DB instance is a Multi-AZ deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(final java.lang.Boolean multiAz) {
            this.props().multiAz(multiAz);
            return this;
        }
        /**
         * Specifies whether the DB instance is a Multi-AZ deployment.
         * <p>
         * You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
         * <p>
         * This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-multiaz">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-multiaz</a>
         * @param multiAz Specifies whether the DB instance is a Multi-AZ deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(final software.amazon.awscdk.IResolvable multiAz) {
            this.props().multiAz(multiAz);
            return this;
        }

        /**
         * The name of the NCHAR character set for the Oracle DB instance.
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-ncharcharactersetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-ncharcharactersetname</a>
         * @param ncharCharacterSetName The name of the NCHAR character set for the Oracle DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ncharCharacterSetName(final java.lang.String ncharCharacterSetName) {
            this.props().ncharCharacterSetName(ncharCharacterSetName);
            return this;
        }

        /**
         * The network type of the DB instance.
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li><code>IPV4</code></li>
         * <li><code>DUAL</code></li>
         * </ul>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and IPv6 protocols ( <code>DUAL</code> ).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">Working with a DB instance in a VPC</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-networktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-networktype</a>
         * @param networkType The network type of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(final java.lang.String networkType) {
            this.props().networkType(networkType);
            return this;
        }

        /**
         * Indicates that the DB instance should be associated with the specified option group.
         * <p>
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-optiongroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-optiongroupname</a>
         * @param optionGroupName Indicates that the DB instance should be associated with the specified option group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroupName(final java.lang.String optionGroupName) {
            this.props().optionGroupName(optionGroupName);
            return this;
        }

        /**
         * The AWS KMS key identifier for encryption of Performance Insights data.
         * <p>
         * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * <p>
         * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
         * <p>
         * For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightskmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightskmskeyid</a>
         * @param performanceInsightsKmsKeyId The AWS KMS key identifier for encryption of Performance Insights data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsKmsKeyId(final java.lang.String performanceInsightsKmsKeyId) {
            this.props().performanceInsightsKmsKeyId(performanceInsightsKmsKeyId);
            return this;
        }

        /**
         * The number of days to retain Performance Insights data.
         * <p>
         * When creating a DB instance without enabling Performance Insights, you can't specify the parameter <code>PerformanceInsightsRetentionPeriod</code> .
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * Valid Values:
         * <p>
         * <ul>
         * <li><code>7</code></li>
         * <li><em>month</em> * 31, where <em>month</em> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</li>
         * <li><code>731</code></li>
         * </ul>
         * <p>
         * Default: <code>7</code> days
         * <p>
         * If you specify a retention period that isn't valid, such as <code>94</code> , Amazon RDS returns an error.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod</a>
         * @param performanceInsightsRetentionPeriod The number of days to retain Performance Insights data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsRetentionPeriod(final java.lang.Number performanceInsightsRetentionPeriod) {
            this.props().performanceInsightsRetentionPeriod(performanceInsightsRetentionPeriod);
            return this;
        }

        /**
         * The port number on which the database accepts connections.
         * <p>
         * This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
         * <p>
         * Valid Values: <code>1150-65535</code>
         * <p>
         * Default:
         * <p>
         * <ul>
         * <li>RDS for Db2 - <code>50000</code></li>
         * <li>RDS for MariaDB - <code>3306</code></li>
         * <li>RDS for Microsoft SQL Server - <code>1433</code></li>
         * <li>RDS for MySQL - <code>3306</code></li>
         * <li>RDS for Oracle - <code>1521</code></li>
         * <li>RDS for PostgreSQL - <code>5432</code></li>
         * </ul>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>For RDS for Microsoft SQL Server, the value can't be <code>1234</code> , <code>1434</code> , <code>3260</code> , <code>3343</code> , <code>3389</code> , <code>47001</code> , or <code>49152-49156</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-port</a>
         * @param port The port number on which the database accepts connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.String port) {
            this.props().port(port);
            return this;
        }

        /**
         * The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup Window</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
         * <li>Must be in Universal Coordinated Time (UTC).</li>
         * <li>Must not conflict with the preferred maintenance window.</li>
         * <li>Must be at least 30 minutes.</li>
         * </ul>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-preferredbackupwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-preferredbackupwindow</a>
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props().preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow">Maintaining a DB instance</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <blockquote>
         * <p>
         * This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
         * <p>
         * </blockquote>
         * <p>
         * Constraints: Minimum 30-minute window.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-preferredmaintenancewindow</a>
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props().preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-processorfeatures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-processorfeatures</a>
         * @param processorFeatures The number of CPU cores and the number of threads per core for the DB instance class of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorFeatures(final software.amazon.awscdk.IResolvable processorFeatures) {
            this.props().processorFeatures(processorFeatures);
            return this;
        }
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-processorfeatures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-processorfeatures</a>
         * @param processorFeatures The number of CPU cores and the number of threads per core for the DB instance class of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorFeatures(final java.util.List<? extends java.lang.Object> processorFeatures) {
            this.props().processorFeatures(processorFeatures);
            return this;
        }

        /**
         * The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance">Fault Tolerance for an Aurora DB Cluster</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * Default: <code>1</code>
         * <p>
         * Valid Values: <code>0 - 15</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-promotiontier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-promotiontier</a>
         * @param promotionTier The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promotionTier(final java.lang.Number promotionTier) {
            this.props().promotionTier(promotionTier);
            return this;
        }

        /**
         * Indicates whether the DB instance is an internet-facing instance.
         * <p>
         * If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
         * <p>
         * The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a> in the <em>Amazon RDS API Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-publiclyaccessible</a>
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * Indicates whether the DB instance is an internet-facing instance.
         * <p>
         * If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
         * <p>
         * The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a> in the <em>Amazon RDS API Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-publiclyaccessible</a>
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * The open mode of an Oracle read replica.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting is only supported in RDS for Oracle.
         * <p>
         * Default: <code>open-read-only</code>
         * <p>
         * Valid Values: <code>open-read-only</code> or <code>mounted</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-replicamode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-replicamode</a>
         * @param replicaMode The open mode of an Oracle read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaMode(final java.lang.String replicaMode) {
            this.props().replicaMode(replicaMode);
            return this;
        }

        /**
         * The date and time to restore from.
         * <p>
         * This parameter applies to point-in-time recovery. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html">Restoring a DB instance to a specified time</a> in the in the <em>Amazon RDS User Guide</em> .
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be a time in Universal Coordinated Time (UTC) format.</li>
         * <li>Must be before the latest restorable time for the DB instance.</li>
         * <li>Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled.</li>
         * </ul>
         * <p>
         * Example: <code>2009-09-07T23:45:00Z</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-restoretime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-restoretime</a>
         * @param restoreTime The date and time to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTime(final java.lang.String restoreTime) {
            this.props().restoreTime(restoreTime);
            return this;
        }

        /**
         * The identifier of the Multi-AZ DB cluster that will act as the source for the read replica.
         * <p>
         * Each DB cluster can have up to 15 read replicas.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be the identifier of an existing Multi-AZ DB cluster.</li>
         * <li>Can't be specified if the <code>SourceDBInstanceIdentifier</code> parameter is also specified.</li>
         * <li>The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.</li>
         * <li>The source DB cluster must be in the same AWS Region as the read replica. Cross-Region replication isn't supported.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbclusteridentifier</a>
         * @param sourceDbClusterIdentifier The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(final java.lang.String sourceDbClusterIdentifier) {
            this.props().sourceDbClusterIdentifier(sourceDbClusterIdentifier);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code> .
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbinstanceautomatedbackupsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbinstanceautomatedbackupsarn</a>
         * @param sourceDbInstanceAutomatedBackupsArn The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbInstanceAutomatedBackupsArn(final java.lang.String sourceDbInstanceAutomatedBackupsArn) {
            this.props().sourceDbInstanceAutomatedBackupsArn(sourceDbInstanceAutomatedBackupsArn);
            return this;
        }

        /**
         * If you want to create a read replica DB instance, specify the ID of the source DB instance.
         * <p>
         * Each DB instance can have a limited number of read replicas. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html">Working with Read Replicas</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * The <code>SourceDBInstanceIdentifier</code> property determines whether a DB instance is a read replica. If you remove the <code>SourceDBInstanceIdentifier</code> property from your template and then update your stack, AWS CloudFormation promotes the read replica to a standalone DB instance.
         * <p>
         * If you specify the <code>UseLatestRestorableTime</code> or <code>RestoreTime</code> properties in conjunction with the <code>SourceDBInstanceIdentifier</code> property, RDS restores the DB instance to the requested point in time, thereby creating a new DB instance.
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>If you specify a source DB instance that uses VPC security groups, we recommend that you specify the <code>VPCSecurityGroups</code> property. If you don't specify the property, the read replica inherits the value of the <code>VPCSecurityGroups</code> property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's <code>VPCSecurityGroups</code> property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.</li>
         * <li>Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.</li>
         * <li>If you specify <code>SourceDBInstanceIdentifier</code> , don't specify the <code>DBSnapshotIdentifier</code> property. You can't create a read replica from a snapshot.</li>
         * <li>Don't set the <code>BackupRetentionPeriod</code> , <code>DBName</code> , <code>MasterUsername</code> , <code>MasterUserPassword</code> , and <code>PreferredBackupWindow</code> properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.</li>
         * <li>If the source DB instance is in a different region than the read replica, specify the source region in <code>SourceRegion</code> , and specify an ARN for a valid DB instance in <code>SourceDBInstanceIdentifier</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN">Constructing a Amazon RDS Amazon Resource Name (ARN)</a> in the <em>Amazon RDS User Guide</em> .</li>
         * <li>For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier</a>
         * @param sourceDbInstanceIdentifier If you want to create a read replica DB instance, specify the ID of the source DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbInstanceIdentifier(final java.lang.String sourceDbInstanceIdentifier) {
            this.props().sourceDbInstanceIdentifier(sourceDbInstanceIdentifier);
            return this;
        }

        /**
         * The resource ID of the source DB instance from which to restore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbiresourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourcedbiresourceid</a>
         * @param sourceDbiResourceId The resource ID of the source DB instance from which to restore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbiResourceId(final java.lang.String sourceDbiResourceId) {
            this.props().sourceDbiResourceId(sourceDbiResourceId);
            return this;
        }

        /**
         * The ID of the region that contains the source DB instance for the read replica.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourceregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-sourceregion</a>
         * @param sourceRegion The ID of the region that contains the source DB instance for the read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRegion(final java.lang.String sourceRegion) {
            this.props().sourceRegion(sourceRegion);
            return this;
        }

        /**
         * The status of a read replica.
         * <p>
         * If the DB instance isn't a read replica, the value is blank.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-statusinfos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-statusinfos</a>
         * @param statusInfos The status of a read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusInfos(final software.amazon.awscdk.IResolvable statusInfos) {
            this.props().statusInfos(statusInfos);
            return this;
        }
        /**
         * The status of a read replica.
         * <p>
         * If the DB instance isn't a read replica, the value is blank.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-statusinfos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-statusinfos</a>
         * @param statusInfos The status of a read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusInfos(final java.util.List<? extends java.lang.Object> statusInfos) {
            this.props().statusInfos(statusInfos);
            return this;
        }

        /**
         * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         * <p>
         * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         * <p>
         * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>SourceDbiResourceId</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SourceDBInstanceAutomatedBackupsArn</code> property, don't specify this property. The value is inherited from the source DB instance automated backup.
         * <p>
         * If you specify <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the snapshot.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The encryption for DB instances is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storageencrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storageencrypted</a>
         * @param storageEncrypted A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }
        /**
         * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         * <p>
         * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         * <p>
         * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>SourceDbiResourceId</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SourceDBInstanceAutomatedBackupsArn</code> property, don't specify this property. The value is inherited from the source DB instance automated backup.
         * <p>
         * If you specify <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the snapshot.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The encryption for DB instances is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storageencrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storageencrypted</a>
         * @param storageEncrypted A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final software.amazon.awscdk.IResolvable storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance.
         * <p>
         * This setting applies only to the <code>gp3</code> storage type.
         * <p>
         * This setting doesn't apply to RDS Custom or Amazon Aurora.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storagethroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storagethroughput</a>
         * @param storageThroughput Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageThroughput(final java.lang.Number storageThroughput) {
            this.props().storageThroughput(storageThroughput);
            return this;
        }

        /**
         * The storage type to associate with the DB instance.
         * <p>
         * If you specify <code>io1</code> , <code>io2</code> , or <code>gp3</code> , you must also include a value for the <code>Iops</code> parameter.
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         * <p>
         * Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
         * <p>
         * Default: <code>io1</code> , if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-storagetype</a>
         * @param storageType The storage type to associate with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props().storageType(storageType);
            return this;
        }

        /**
         * Tags to assign to the DB instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tags</a>
         * @param tags Tags to assign to the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tdecredentialarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tdecredentialarn</a>
         * @deprecated this property has been deprecated
         * @param tdeCredentialArn This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder tdeCredentialArn(final java.lang.String tdeCredentialArn) {
            this.props().tdeCredentialArn(tdeCredentialArn);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tdecredentialpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-tdecredentialpassword</a>
         * @deprecated this property has been deprecated
         * @param tdeCredentialPassword This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder tdeCredentialPassword(final java.lang.String tdeCredentialPassword) {
            this.props().tdeCredentialPassword(tdeCredentialPassword);
            return this;
        }

        /**
         * The time zone of the DB instance.
         * <p>
         * The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone">RDS for Db2</a> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">RDS for SQL Server</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-timezone</a>
         * @param timezone The time zone of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(final java.lang.String timezone) {
            this.props().timezone(timezone);
            return this;
        }

        /**
         * Specifies whether the DB instance class of the DB instance uses its default processor features.
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures</a>
         * @param useDefaultProcessorFeatures Specifies whether the DB instance class of the DB instance uses its default processor features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaultProcessorFeatures(final java.lang.Boolean useDefaultProcessorFeatures) {
            this.props().useDefaultProcessorFeatures(useDefaultProcessorFeatures);
            return this;
        }
        /**
         * Specifies whether the DB instance class of the DB instance uses its default processor features.
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures</a>
         * @param useDefaultProcessorFeatures Specifies whether the DB instance class of the DB instance uses its default processor features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaultProcessorFeatures(final software.amazon.awscdk.IResolvable useDefaultProcessorFeatures) {
            this.props().useDefaultProcessorFeatures(useDefaultProcessorFeatures);
            return this;
        }

        /**
         * Specifies whether the DB instance is restored from the latest backup time.
         * <p>
         * By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html">Restoring a DB instance to a specified time</a> in the in the <em>Amazon RDS User Guide</em> .
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Can't be specified if the <code>RestoreTime</code> parameter is provided.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-uselatestrestorabletime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-uselatestrestorabletime</a>
         * @param useLatestRestorableTime Specifies whether the DB instance is restored from the latest backup time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(final java.lang.Boolean useLatestRestorableTime) {
            this.props().useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }
        /**
         * Specifies whether the DB instance is restored from the latest backup time.
         * <p>
         * By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html">Restoring a DB instance to a specified time</a> in the in the <em>Amazon RDS User Guide</em> .
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Can't be specified if the <code>RestoreTime</code> parameter is provided.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-uselatestrestorabletime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-uselatestrestorabletime</a>
         * @param useLatestRestorableTime Specifies whether the DB instance is restored from the latest backup time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(final software.amazon.awscdk.IResolvable useLatestRestorableTime) {
            this.props().useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        /**
         * A list of the VPC security group IDs to assign to the DB instance.
         * <p>
         * The list can include both the physical IDs of existing VPC security groups and references to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">AWS::EC2::SecurityGroup</a> resources created in the template.
         * <p>
         * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         * <p>
         * If you set <code>VPCSecurityGroups</code> , you must not set <a href="https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> , and vice versa.
         * <p>
         * <blockquote>
         * <p>
         * You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
         * <p>
         * <ul>
         * <li>You can't revert to using an RDS security group after you establish a VPC security group membership.</li>
         * <li>When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.</li>
         * <li>To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> property.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-vpcsecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#cfn-rds-dbinstance-vpcsecuritygroups</a>
         * @param vpcSecurityGroups A list of the VPC security group IDs to assign to the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroups(final java.util.List<java.lang.String> vpcSecurityGroups) {
            this.props().vpcSecurityGroups(vpcSecurityGroups);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBInstance build() {
            return new software.amazon.awscdk.services.rds.CfnDBInstance(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.rds.CfnDBInstanceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.rds.CfnDBInstanceProps.Builder();
            }
            return this.props;
        }
    }
}
