package software.amazon.awscdk.services.s3.deployment;

/**
 * Source information.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.s3.deployment.*;
 * Bucket bucket;
 * Object markers;
 * SourceConfig sourceConfig = SourceConfig.builder()
 *         .bucket(bucket)
 *         .zipObjectKey("zipObjectKey")
 *         // the properties below are optional
 *         .markers(Map.of(
 *                 "markersKey", markers))
 *         .markersConfig(MarkersConfig.builder()
 *                 .jsonEscape(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:23.334Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.SourceConfig")
@software.amazon.jsii.Jsii.Proxy(SourceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SourceConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The source bucket to deploy from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * An S3 object key in the source bucket that points to a zip file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getZipObjectKey();

    /**
     * A set of markers to substitute in the source content.
     * <p>
     * Default: - no markers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getMarkers() {
        return null;
    }

    /**
     * A configuration for markers substitution strategy.
     * <p>
     * Default: - no configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.MarkersConfig getMarkersConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SourceConfig> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String zipObjectKey;
        java.util.Map<java.lang.String, java.lang.Object> markers;
        software.amazon.awscdk.services.s3.deployment.MarkersConfig markersConfig;

        /**
         * Sets the value of {@link SourceConfig#getBucket}
         * @param bucket The source bucket to deploy from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfig#getZipObjectKey}
         * @param zipObjectKey An S3 object key in the source bucket that points to a zip file. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zipObjectKey(java.lang.String zipObjectKey) {
            this.zipObjectKey = zipObjectKey;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfig#getMarkers}
         * @param markers A set of markers to substitute in the source content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder markers(java.util.Map<java.lang.String, ? extends java.lang.Object> markers) {
            this.markers = (java.util.Map<java.lang.String, java.lang.Object>)markers;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfig#getMarkersConfig}
         * @param markersConfig A configuration for markers substitution strategy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder markersConfig(software.amazon.awscdk.services.s3.deployment.MarkersConfig markersConfig) {
            this.markersConfig = markersConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SourceConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfig {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String zipObjectKey;
        private final java.util.Map<java.lang.String, java.lang.Object> markers;
        private final software.amazon.awscdk.services.s3.deployment.MarkersConfig markersConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.zipObjectKey = software.amazon.jsii.Kernel.get(this, "zipObjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.markers = software.amazon.jsii.Kernel.get(this, "markers", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.markersConfig = software.amazon.jsii.Kernel.get(this, "markersConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.MarkersConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.zipObjectKey = java.util.Objects.requireNonNull(builder.zipObjectKey, "zipObjectKey is required");
            this.markers = (java.util.Map<java.lang.String, java.lang.Object>)builder.markers;
            this.markersConfig = builder.markersConfig;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getZipObjectKey() {
            return this.zipObjectKey;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getMarkers() {
            return this.markers;
        }

        @Override
        public final software.amazon.awscdk.services.s3.deployment.MarkersConfig getMarkersConfig() {
            return this.markersConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("zipObjectKey", om.valueToTree(this.getZipObjectKey()));
            if (this.getMarkers() != null) {
                data.set("markers", om.valueToTree(this.getMarkers()));
            }
            if (this.getMarkersConfig() != null) {
                data.set("markersConfig", om.valueToTree(this.getMarkersConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3_deployment.SourceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceConfig.Jsii$Proxy that = (SourceConfig.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (!zipObjectKey.equals(that.zipObjectKey)) return false;
            if (this.markers != null ? !this.markers.equals(that.markers) : that.markers != null) return false;
            return this.markersConfig != null ? this.markersConfig.equals(that.markersConfig) : that.markersConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.zipObjectKey.hashCode());
            result = 31 * result + (this.markers != null ? this.markers.hashCode() : 0);
            result = 31 * result + (this.markersConfig != null ? this.markersConfig.hashCode() : 0);
            return result;
        }
    }
}
