package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnNotebookInstance</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnNotebookInstanceProps cfnNotebookInstanceProps = CfnNotebookInstanceProps.builder()
 *         .instanceType("instanceType")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .acceleratorTypes(List.of("acceleratorTypes"))
 *         .additionalCodeRepositories(List.of("additionalCodeRepositories"))
 *         .defaultCodeRepository("defaultCodeRepository")
 *         .directInternetAccess("directInternetAccess")
 *         .instanceMetadataServiceConfiguration(InstanceMetadataServiceConfigurationProperty.builder()
 *                 .minimumInstanceMetadataServiceVersion("minimumInstanceMetadataServiceVersion")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .lifecycleConfigName("lifecycleConfigName")
 *         .notebookInstanceName("notebookInstanceName")
 *         .platformIdentifier("platformIdentifier")
 *         .rootAccess("rootAccess")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .subnetId("subnetId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .volumeSizeInGb(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:23.693Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnNotebookInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnNotebookInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNotebookInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of ML compute instance to launch for the notebook instance.
     * <p>
     * <blockquote>
     * <p>
     * Expect some interruption of service if this parameter is changed as CloudFormation stops a notebook instance and starts it up again to update it.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * When you send any requests to AWS resources from the notebook instance, SageMaker AI assumes this role to perform tasks on your behalf.
     * <p>
     * You must grant this role necessary permissions so SageMaker AI can perform these tasks. The policy must allow the SageMaker AI service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">SageMaker AI Roles</a> .
     * <p>
     * <blockquote>
     * <p>
     * To be able to pass this role to SageMaker AI, the caller of this API must have the <code>iam:PassRole</code> permission.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * A list of Amazon Elastic Inference (EI) instance types to associate with the notebook instance.
     * <p>
     * Currently, only one instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> .
     * <p>
     * <em>Valid Values:</em> <code>ml.eia1.medium | ml.eia1.large | ml.eia1.xlarge | ml.eia2.medium | ml.eia2.large | ml.eia2.xlarge</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
        return null;
    }

    /**
     * An array of up to three Git repositories associated with the notebook instance.
     * <p>
     * These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker AI Notebook Instances</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalCodeRepositories() {
        return null;
    }

    /**
     * The Git repository associated with the notebook instance as its default code repository.
     * <p>
     * This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker AI Notebook Instances</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultCodeRepository() {
        return null;
    }

    /**
     * Sets whether SageMaker AI provides internet access to the notebook instance.
     * <p>
     * If you set this to <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to connect to SageMaker AI training and endpoint services unless you configure a NAT Gateway in your VPC.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a> . You can set the value of this parameter to <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDirectInternetAccess() {
        return null;
    }

    /**
     * Information on the IMDS configuration of the notebook instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancemetadataserviceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancemetadataserviceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceMetadataServiceConfiguration() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of a AWS Key Management Service key that SageMaker AI uses to encrypt data on the storage volume attached to your notebook instance.
     * <p>
     * The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling Keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The name of a lifecycle configuration to associate with the notebook instance.
     * <p>
     * For information about lifecycle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Customize a Notebook Instance</a> in the <em>Amazon SageMaker Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLifecycleConfigName() {
        return null;
    }

    /**
     * The name of the new notebook instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotebookInstanceName() {
        return null;
    }

    /**
     * The platform identifier of the notebook instance runtime environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-platformidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-platformidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlatformIdentifier() {
        return null;
    }

    /**
     * Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code> .
     * <p>
     * <blockquote>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRootAccess() {
        return null;
    }

    /**
     * The VPC security group IDs, in the form sg-xxxxxxxx.
     * <p>
     * The security groups must be for the same VPC as specified in the subnet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return null;
    }

    /**
     * A list of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> .
     * <p>
     * You can add tags later by using the <code>CreateTags</code> API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The size, in GB, of the ML storage volume to attach to the notebook instance.
     * <p>
     * The default value is 5 GB.
     * <p>
     * <blockquote>
     * <p>
     * Expect some interruption of service if this parameter is changed as CloudFormation stops a notebook instance and starts it up again to update it.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSizeInGb() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNotebookInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNotebookInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNotebookInstanceProps> {
        java.lang.String instanceType;
        java.lang.String roleArn;
        java.util.List<java.lang.String> acceleratorTypes;
        java.util.List<java.lang.String> additionalCodeRepositories;
        java.lang.String defaultCodeRepository;
        java.lang.String directInternetAccess;
        java.lang.Object instanceMetadataServiceConfiguration;
        java.lang.String kmsKeyId;
        java.lang.String lifecycleConfigName;
        java.lang.String notebookInstanceName;
        java.lang.String platformIdentifier;
        java.lang.String rootAccess;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String subnetId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Number volumeSizeInGb;

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getInstanceType}
         * @param instanceType The type of ML compute instance to launch for the notebook instance. This parameter is required.
         *                     <blockquote>
         *                     <p>
         *                     Expect some interruption of service if this parameter is changed as CloudFormation stops a notebook instance and starts it up again to update it.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getRoleArn}
         * @param roleArn When you send any requests to AWS resources from the notebook instance, SageMaker AI assumes this role to perform tasks on your behalf. This parameter is required.
         *                You must grant this role necessary permissions so SageMaker AI can perform these tasks. The policy must allow the SageMaker AI service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">SageMaker AI Roles</a> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                To be able to pass this role to SageMaker AI, the caller of this API must have the <code>iam:PassRole</code> permission.
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getAcceleratorTypes}
         * @param acceleratorTypes A list of Amazon Elastic Inference (EI) instance types to associate with the notebook instance.
         *                         Currently, only one instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> .
         *                         <p>
         *                         <em>Valid Values:</em> <code>ml.eia1.medium | ml.eia1.large | ml.eia1.xlarge | ml.eia2.medium | ml.eia2.large | ml.eia2.xlarge</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
            this.acceleratorTypes = acceleratorTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getAdditionalCodeRepositories}
         * @param additionalCodeRepositories An array of up to three Git repositories associated with the notebook instance.
         *                                   These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker AI Notebook Instances</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalCodeRepositories(java.util.List<java.lang.String> additionalCodeRepositories) {
            this.additionalCodeRepositories = additionalCodeRepositories;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getDefaultCodeRepository}
         * @param defaultCodeRepository The Git repository associated with the notebook instance as its default code repository.
         *                              This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker AI Notebook Instances</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCodeRepository(java.lang.String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getDirectInternetAccess}
         * @param directInternetAccess Sets whether SageMaker AI provides internet access to the notebook instance.
         *                             If you set this to <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to connect to SageMaker AI training and endpoint services unless you configure a NAT Gateway in your VPC.
         *                             <p>
         *                             For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a> . You can set the value of this parameter to <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directInternetAccess(java.lang.String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getInstanceMetadataServiceConfiguration}
         * @param instanceMetadataServiceConfiguration Information on the IMDS configuration of the notebook instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMetadataServiceConfiguration(software.amazon.awscdk.IResolvable instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getInstanceMetadataServiceConfiguration}
         * @param instanceMetadataServiceConfiguration Information on the IMDS configuration of the notebook instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMetadataServiceConfiguration(software.amazon.awscdk.services.sagemaker.CfnNotebookInstance.InstanceMetadataServiceConfigurationProperty instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getKmsKeyId}
         * @param kmsKeyId The Amazon Resource Name (ARN) of a AWS Key Management Service key that SageMaker AI uses to encrypt data on the storage volume attached to your notebook instance.
         *                 The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling Keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getLifecycleConfigName}
         * @param lifecycleConfigName The name of a lifecycle configuration to associate with the notebook instance.
         *                            For information about lifecycle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Customize a Notebook Instance</a> in the <em>Amazon SageMaker Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfigName(java.lang.String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getNotebookInstanceName}
         * @param notebookInstanceName The name of the new notebook instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notebookInstanceName(java.lang.String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getPlatformIdentifier}
         * @param platformIdentifier The platform identifier of the notebook instance runtime environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformIdentifier(java.lang.String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getRootAccess}
         * @param rootAccess Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code> .
         *                   <blockquote>
         *                   <p>
         *                   Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootAccess(java.lang.String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getSecurityGroupIds}
         * @param securityGroupIds The VPC security group IDs, in the form sg-xxxxxxxx.
         *                         The security groups must be for the same VPC as specified in the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getSubnetId}
         * @param subnetId The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getTags}
         * @param tags A list of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> .
         *             <p>
         *             You can add tags later by using the <code>CreateTags</code> API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getVolumeSizeInGb}
         * @param volumeSizeInGb The size, in GB, of the ML storage volume to attach to the notebook instance.
         *                       The default value is 5 GB.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       Expect some interruption of service if this parameter is changed as CloudFormation stops a notebook instance and starts it up again to update it.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
            this.volumeSizeInGb = volumeSizeInGb;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNotebookInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNotebookInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNotebookInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNotebookInstanceProps {
        private final java.lang.String instanceType;
        private final java.lang.String roleArn;
        private final java.util.List<java.lang.String> acceleratorTypes;
        private final java.util.List<java.lang.String> additionalCodeRepositories;
        private final java.lang.String defaultCodeRepository;
        private final java.lang.String directInternetAccess;
        private final java.lang.Object instanceMetadataServiceConfiguration;
        private final java.lang.String kmsKeyId;
        private final java.lang.String lifecycleConfigName;
        private final java.lang.String notebookInstanceName;
        private final java.lang.String platformIdentifier;
        private final java.lang.String rootAccess;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String subnetId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Number volumeSizeInGb;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.acceleratorTypes = software.amazon.jsii.Kernel.get(this, "acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.additionalCodeRepositories = software.amazon.jsii.Kernel.get(this, "additionalCodeRepositories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.defaultCodeRepository = software.amazon.jsii.Kernel.get(this, "defaultCodeRepository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.directInternetAccess = software.amazon.jsii.Kernel.get(this, "directInternetAccess", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceMetadataServiceConfiguration = software.amazon.jsii.Kernel.get(this, "instanceMetadataServiceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lifecycleConfigName = software.amazon.jsii.Kernel.get(this, "lifecycleConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notebookInstanceName = software.amazon.jsii.Kernel.get(this, "notebookInstanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.platformIdentifier = software.amazon.jsii.Kernel.get(this, "platformIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rootAccess = software.amazon.jsii.Kernel.get(this, "rootAccess", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.acceleratorTypes = builder.acceleratorTypes;
            this.additionalCodeRepositories = builder.additionalCodeRepositories;
            this.defaultCodeRepository = builder.defaultCodeRepository;
            this.directInternetAccess = builder.directInternetAccess;
            this.instanceMetadataServiceConfiguration = builder.instanceMetadataServiceConfiguration;
            this.kmsKeyId = builder.kmsKeyId;
            this.lifecycleConfigName = builder.lifecycleConfigName;
            this.notebookInstanceName = builder.notebookInstanceName;
            this.platformIdentifier = builder.platformIdentifier;
            this.rootAccess = builder.rootAccess;
            this.securityGroupIds = builder.securityGroupIds;
            this.subnetId = builder.subnetId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.volumeSizeInGb = builder.volumeSizeInGb;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<java.lang.String> getAcceleratorTypes() {
            return this.acceleratorTypes;
        }

        @Override
        public final java.util.List<java.lang.String> getAdditionalCodeRepositories() {
            return this.additionalCodeRepositories;
        }

        @Override
        public final java.lang.String getDefaultCodeRepository() {
            return this.defaultCodeRepository;
        }

        @Override
        public final java.lang.String getDirectInternetAccess() {
            return this.directInternetAccess;
        }

        @Override
        public final java.lang.Object getInstanceMetadataServiceConfiguration() {
            return this.instanceMetadataServiceConfiguration;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getLifecycleConfigName() {
            return this.lifecycleConfigName;
        }

        @Override
        public final java.lang.String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        public final java.lang.String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        @Override
        public final java.lang.String getRootAccess() {
            return this.rootAccess;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getVolumeSizeInGb() {
            return this.volumeSizeInGb;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAcceleratorTypes() != null) {
                data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
            }
            if (this.getAdditionalCodeRepositories() != null) {
                data.set("additionalCodeRepositories", om.valueToTree(this.getAdditionalCodeRepositories()));
            }
            if (this.getDefaultCodeRepository() != null) {
                data.set("defaultCodeRepository", om.valueToTree(this.getDefaultCodeRepository()));
            }
            if (this.getDirectInternetAccess() != null) {
                data.set("directInternetAccess", om.valueToTree(this.getDirectInternetAccess()));
            }
            if (this.getInstanceMetadataServiceConfiguration() != null) {
                data.set("instanceMetadataServiceConfiguration", om.valueToTree(this.getInstanceMetadataServiceConfiguration()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLifecycleConfigName() != null) {
                data.set("lifecycleConfigName", om.valueToTree(this.getLifecycleConfigName()));
            }
            if (this.getNotebookInstanceName() != null) {
                data.set("notebookInstanceName", om.valueToTree(this.getNotebookInstanceName()));
            }
            if (this.getPlatformIdentifier() != null) {
                data.set("platformIdentifier", om.valueToTree(this.getPlatformIdentifier()));
            }
            if (this.getRootAccess() != null) {
                data.set("rootAccess", om.valueToTree(this.getRootAccess()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSubnetId() != null) {
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVolumeSizeInGb() != null) {
                data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnNotebookInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNotebookInstanceProps.Jsii$Proxy that = (CfnNotebookInstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
            if (this.additionalCodeRepositories != null ? !this.additionalCodeRepositories.equals(that.additionalCodeRepositories) : that.additionalCodeRepositories != null) return false;
            if (this.defaultCodeRepository != null ? !this.defaultCodeRepository.equals(that.defaultCodeRepository) : that.defaultCodeRepository != null) return false;
            if (this.directInternetAccess != null ? !this.directInternetAccess.equals(that.directInternetAccess) : that.directInternetAccess != null) return false;
            if (this.instanceMetadataServiceConfiguration != null ? !this.instanceMetadataServiceConfiguration.equals(that.instanceMetadataServiceConfiguration) : that.instanceMetadataServiceConfiguration != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.lifecycleConfigName != null ? !this.lifecycleConfigName.equals(that.lifecycleConfigName) : that.lifecycleConfigName != null) return false;
            if (this.notebookInstanceName != null ? !this.notebookInstanceName.equals(that.notebookInstanceName) : that.notebookInstanceName != null) return false;
            if (this.platformIdentifier != null ? !this.platformIdentifier.equals(that.platformIdentifier) : that.platformIdentifier != null) return false;
            if (this.rootAccess != null ? !this.rootAccess.equals(that.rootAccess) : that.rootAccess != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.volumeSizeInGb != null ? this.volumeSizeInGb.equals(that.volumeSizeInGb) : that.volumeSizeInGb == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
            result = 31 * result + (this.additionalCodeRepositories != null ? this.additionalCodeRepositories.hashCode() : 0);
            result = 31 * result + (this.defaultCodeRepository != null ? this.defaultCodeRepository.hashCode() : 0);
            result = 31 * result + (this.directInternetAccess != null ? this.directInternetAccess.hashCode() : 0);
            result = 31 * result + (this.instanceMetadataServiceConfiguration != null ? this.instanceMetadataServiceConfiguration.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.lifecycleConfigName != null ? this.lifecycleConfigName.hashCode() : 0);
            result = 31 * result + (this.notebookInstanceName != null ? this.notebookInstanceName.hashCode() : 0);
            result = 31 * result + (this.platformIdentifier != null ? this.platformIdentifier.hashCode() : 0);
            result = 31 * result + (this.rootAccess != null ? this.rootAccess.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.volumeSizeInGb != null ? this.volumeSizeInGb.hashCode() : 0);
            return result;
        }
    }
}
