package software.amazon.awscdk.services.secretsmanager;

/**
 * Creates a new secret in AWS SecretsManager.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stack stack;
 * User user = new User(this, "User");
 * AccessKey accessKey = AccessKey.Builder.create(this, "AccessKey").user(user).build();
 * Secret.Builder.create(this, "Secret")
 *         .secretObjectValue(Map.of(
 *                 "username", SecretValue.unsafePlainText(user.getUserName()),
 *                 "database", SecretValue.unsafePlainText("foo"),
 *                 "password", accessKey.getSecretAccessKey()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:23.970Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.Secret")
public class Secret extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.secretsmanager.ISecret {

    protected Secret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Secret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.Secret.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Secret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Secret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing secret into the Stack.
     * <p>
     * @param scope the scope of the import. This parameter is required.
     * @param id the ID of the imported Secret in the construct tree. This parameter is required.
     * @param attrs the attributes of the imported secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Imports a secret by complete ARN.
     * <p>
     * The complete ARN is the ARN with the Secrets Manager-supplied suffix.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secretCompleteArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretCompleteArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String secretCompleteArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretCompleteArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secretCompleteArn, "secretCompleteArn is required") });
    }

    /**
     * Imports a secret by secret name.
     * <p>
     * A secret with this name must exist in the same account &amp; region.
     * Replaces the deprecated <code>fromSecretName</code>.
     * Please note this method returns ISecret that only contains partial ARN and could lead to AccessDeniedException
     * when you pass the partial ARN to CLI or SDK to get the secret value. If your secret name ends with a hyphen and
     * 6 characters, you should always use fromSecretCompleteArn() to avoid potential AccessDeniedException.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen">https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen</a>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secretName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretNameV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String secretName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretNameV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secretName, "secretName is required") });
    }

    /**
     * Imports a secret by partial ARN.
     * <p>
     * The partial ARN is the ARN without the Secrets Manager-supplied suffix.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secretPartialArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretPartialArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String secretPartialArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretPartialArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secretPartialArn, "secretPartialArn is required") });
    }

    /**
     * Return whether the given object is a Secret.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isSecret(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "isSecret", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Adds a replica region for the secret.
     * <p>
     * @param region The name of the region. This parameter is required.
     * @param encryptionKey The customer-managed encryption key to use for encrypting the secret value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addReplicaRegion(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey encryptionKey) {
        software.amazon.jsii.Kernel.call(this, "addReplicaRegion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(region, "region is required"), encryptionKey });
    }

    /**
     * Adds a replica region for the secret.
     * <p>
     * @param region The name of the region. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addReplicaRegion(final @org.jetbrains.annotations.NotNull java.lang.String region) {
        software.amazon.jsii.Kernel.call(this, "addReplicaRegion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(region, "region is required") });
    }

    /**
     * Adds a rotation schedule to the secret.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationSchedule addRotationSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationScheduleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationSchedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.RotationSchedule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a statement to the IAM resource policy associated with this secret.
     * <p>
     * If this secret was created in this stack, a resource policy will be
     * automatically created upon the first call to <code>addToResourcePolicy</code>. If
     * the secret is imported, then this is a no-op.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Attach a target to this secret.
     * <p>
     * @return An attached secret
     * @param target The target to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret attach(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target) {
        return software.amazon.jsii.Kernel.call(this, "attach", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Denies the <code>DeleteSecret</code> action to all principals within the current account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void denyAccountRootDelete() {
        software.amazon.jsii.Kernel.call(this, "denyAccountRootDelete", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Grants reading the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     * @param versionStages
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> versionStages) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), versionStages });
    }

    /**
     * Grants reading the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants writing and updating the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Interpret the secret as a JSON object and return a field's value from it as a <code>SecretValue</code>.
     * <p>
     * @param jsonField This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue secretValueFromJson(final @org.jetbrains.annotations.NotNull java.lang.String jsonField) {
        return software.amazon.jsii.Kernel.call(this, "secretValueFromJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Provides an identifier for this secret for use in IAM policies.
     * <p>
     * If there is a full ARN, this is just the ARN;
     * if we have a partial ARN -- due to either importing by secret name or partial ARN --
     * then we need to add a suffix to capture the full ARN's format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getArnForPolicies() {
        return software.amazon.jsii.Kernel.get(this, "arnForPolicies", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "autoCreatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The ARN of the secret in AWS Secrets Manager.
     * <p>
     * Will return the full ARN if available, otherwise a partial arn.
     * For secrets imported by the deprecated <code>fromSecretName</code>, it will return the <code>secretName</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the secret.
     * <p>
     * For "owned" secrets, this will be the full resource name (secret name + suffix), unless the
     * '&#64;aws-cdk/aws-secretsmanager:parseOwnedSecretName' feature flag is set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretName() {
        return software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Retrieve the value of the stored secret as a <code>SecretValue</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getSecretValue() {
        return software.amazon.jsii.Kernel.get(this, "secretValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
    }

    /**
     * The customer-managed encryption key that is used to encrypt this secret, if any.
     * <p>
     * When not specified, the default
     * KMS key for the account and region is being used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * The string of the characters that are excluded in this secret when it is generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
        return software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full ARN of the secret in AWS Secrets Manager, which is the ARN including the Secrets Manager-supplied 6-character suffix.
     * <p>
     * This is equal to <code>secretArn</code> in most cases, but is undefined when a full ARN is not available (e.g., secrets imported by name).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecretFullArn() {
        return software.amazon.jsii.Kernel.get(this, "secretFullArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.Secret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.Secret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.secretsmanager.SecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An optional, human-friendly description of the secret.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description An optional, human-friendly description of the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The customer-managed encryption key to use for encrypting the secret value.
         * <p>
         * Default: - A default KMS key for the account and region is used.
         * <p>
         * @return {@code this}
         * @param encryptionKey The customer-managed encryption key to use for encrypting the secret value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Configuration for how to generate a secret value.
         * <p>
         * Only one of <code>secretString</code> and <code>generateSecretString</code> can be provided.
         * <p>
         * Default: - 32 characters with upper-case letters, lower-case letters, punctuation and numbers (at least one from each
         * category), per the default values of ``SecretStringGenerator``.
         * <p>
         * @return {@code this}
         * @param generateSecretString Configuration for how to generate a secret value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecretString(final software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString) {
            this.props().generateSecretString(generateSecretString);
            return this;
        }

        /**
         * Policy to apply when the secret is removed from this stack.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the secret is removed from this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * A list of regions where to replicate this secret.
         * <p>
         * Default: - Secret is not replicated
         * <p>
         * @return {@code this}
         * @param replicaRegions A list of regions where to replicate this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaRegions(final java.util.List<? extends software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions) {
            this.props().replicaRegions(replicaRegions);
            return this;
        }

        /**
         * A name for the secret.
         * <p>
         * Note that deleting secrets from SecretsManager does not happen immediately, but after a 7 to
         * 30 days blackout period. During that period, it is not possible to create another secret that shares the same name.
         * <p>
         * Default: - A name is generated by CloudFormation.
         * <p>
         * @return {@code this}
         * @param secretName A name for the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretName(final java.lang.String secretName) {
            this.props().secretName(secretName);
            return this;
        }

        /**
         * Initial value for a JSON secret.
         * <p>
         * <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
         * The secret object -- if provided -- will be included in the output of the cdk as part of synthesis,
         * and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
         * another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
         * to the CloudFormation template (via the AWS Console, SDKs, or CLI).
         * <p>
         * Specifies a JSON object that you want to encrypt and store in this new version of the secret.
         * To specify a simple string value instead, use <code>SecretProps.secretStringValue</code>
         * <p>
         * Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, 'secretObjectValue', and <code>generateSecretString</code> can be provided.
         * <p>
         * Default: - SecretsManager generates a new secret value.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * User user;
         * AccessKey accessKey;
         * Stack stack;
         * Secret.Builder.create(stack, "JSONSecret")
         *         .secretObjectValue(Map.of(
         *                 "username", SecretValue.unsafePlainText(user.getUserName()),  // intrinsic reference, not exposed as plaintext
         *                 "database", SecretValue.unsafePlainText("foo"),  // rendered as plain text, but not a secret
         *                 "password", accessKey.getSecretAccessKey()))
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param secretObjectValue Initial value for a JSON secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretObjectValue(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.SecretValue> secretObjectValue) {
            this.props().secretObjectValue(secretObjectValue);
            return this;
        }

        /**
         * (deprecated) Initial value for the secret.
         * <p>
         * <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
         * The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
         * and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
         * another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
         * to the CloudFormation template (via the AWS Console, SDKs, or CLI).
         * <p>
         * Specifies text data that you want to encrypt and store in this new version of the secret.
         * May be a simple string value, or a string representation of a JSON structure.
         * <p>
         * Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, and <code>generateSecretString</code> can be provided.
         * <p>
         * Default: - SecretsManager generates a new secret value.
         * <p>
         * @return {@code this}
         * @deprecated Use <code>secretStringValue</code> instead.
         * @param secretStringBeta1 Initial value for the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder secretStringBeta1(final software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 secretStringBeta1) {
            this.props().secretStringBeta1(secretStringBeta1);
            return this;
        }

        /**
         * Initial value for the secret.
         * <p>
         * <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
         * The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
         * and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
         * another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
         * to the CloudFormation template (via the AWS Console, SDKs, or CLI).
         * <p>
         * Specifies text data that you want to encrypt and store in this new version of the secret.
         * May be a simple string value. To provide a string representation of JSON structure, use <code>SecretProps.secretObjectValue</code> instead.
         * <p>
         * Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, 'secretObjectValue', and <code>generateSecretString</code> can be provided.
         * <p>
         * Default: - SecretsManager generates a new secret value.
         * <p>
         * @return {@code this}
         * @param secretStringValue Initial value for the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretStringValue(final software.amazon.awscdk.SecretValue secretStringValue) {
            this.props().secretStringValue(secretStringValue);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.Secret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.Secret build() {
            return new software.amazon.awscdk.services.secretsmanager.Secret(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.secretsmanager.SecretProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.secretsmanager.SecretProps.Builder();
            }
            return this.props;
        }
    }
}
