package software.amazon.awscdk.services.ses;

/**
 * Specifies an identity for using within SES.
 * <p>
 * An identity is an email address or domain that you use when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2 permission to send email from the identity.
 * <p>
 * When you verify an email address, SES sends an email to the address. Your email address is verified as soon as you follow the link in the verification email. When you verify a domain without specifying the <code>DkimSigningAttributes</code> properties, OR only the <code>NextSigningKeyLength</code> property of <code>DkimSigningAttributes</code> , this resource provides a set of CNAME token names and values ( <em>DkimDNSTokenName1</em> , <em>DkimDNSTokenValue1</em> , <em>DkimDNSTokenName2</em> , <em>DkimDNSTokenValue2</em> , <em>DkimDNSTokenName3</em> , <em>DkimDNSTokenValue3</em> ) as outputs. You can then add these to the DNS configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS configuration for your domain. This verification method is known as Easy DKIM.
 * <p>
 * Alternatively, you can perform the verification process by providing your own public-private key pair. This verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your resource must include <code>DkimSigningAttributes</code> properties <code>DomainSigningSelector</code> and <code>DomainSigningPrivateKey</code> . When you specify this object, you provide a selector ( <code>DomainSigningSelector</code> ) (a component of the DNS record name that identifies the public key to use for DKIM authentication) and a private key ( <code>DomainSigningPrivateKey</code> ).
 * <p>
 * Additionally, you can associate an existing configuration set with the email identity that you're verifying.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnEmailIdentity cfnEmailIdentity = CfnEmailIdentity.Builder.create(this, "MyCfnEmailIdentity")
 *         .emailIdentity("emailIdentity")
 *         // the properties below are optional
 *         .configurationSetAttributes(ConfigurationSetAttributesProperty.builder()
 *                 .configurationSetName("configurationSetName")
 *                 .build())
 *         .dkimAttributes(DkimAttributesProperty.builder()
 *                 .signingEnabled(false)
 *                 .build())
 *         .dkimSigningAttributes(DkimSigningAttributesProperty.builder()
 *                 .domainSigningPrivateKey("domainSigningPrivateKey")
 *                 .domainSigningSelector("domainSigningSelector")
 *                 .nextSigningKeyLength("nextSigningKeyLength")
 *                 .build())
 *         .feedbackAttributes(FeedbackAttributesProperty.builder()
 *                 .emailForwardingEnabled(false)
 *                 .build())
 *         .mailFromAttributes(MailFromAttributesProperty.builder()
 *                 .behaviorOnMxFailure("behaviorOnMxFailure")
 *                 .mailFromDomain("mailFromDomain")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:24.264Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity")
public class CfnEmailIdentity extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnEmailIdentity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEmailIdentity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnEmailIdentity.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEmailIdentity(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnEmailIdentityProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The host name for the first token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenName1() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenName1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The host name for the second token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenName2() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenName2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The host name for the third token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenName3() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenName3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the first token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenValue1() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenValue1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the second token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenValue2() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenValue2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the third token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenValue3() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenValue3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The email address or domain to verify.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEmailIdentity() {
        return software.amazon.jsii.Kernel.get(this, "emailIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The email address or domain to verify.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmailIdentity(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "emailIdentity", java.util.Objects.requireNonNull(value, "emailIdentity is required"));
    }

    /**
     * Used to associate a configuration set with an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationSetAttributes() {
        return software.amazon.jsii.Kernel.get(this, "configurationSetAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Used to associate a configuration set with an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationSetAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationSetAttributes", value);
    }

    /**
     * Used to associate a configuration set with an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationSetAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.ConfigurationSetAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "configurationSetAttributes", value);
    }

    /**
     * An object that contains information about the DKIM attributes for the identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDkimAttributes() {
        return software.amazon.jsii.Kernel.get(this, "dkimAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that contains information about the DKIM attributes for the identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dkimAttributes", value);
    }

    /**
     * An object that contains information about the DKIM attributes for the identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "dkimAttributes", value);
    }

    /**
     * If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDkimSigningAttributes() {
        return software.amazon.jsii.Kernel.get(this, "dkimSigningAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimSigningAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dkimSigningAttributes", value);
    }

    /**
     * If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimSigningAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimSigningAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "dkimSigningAttributes", value);
    }

    /**
     * Used to enable or disable feedback forwarding for an identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFeedbackAttributes() {
        return software.amazon.jsii.Kernel.get(this, "feedbackAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Used to enable or disable feedback forwarding for an identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeedbackAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "feedbackAttributes", value);
    }

    /**
     * Used to enable or disable feedback forwarding for an identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeedbackAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.FeedbackAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "feedbackAttributes", value);
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMailFromAttributes() {
        return software.amazon.jsii.Kernel.get(this, "mailFromAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMailFromAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mailFromAttributes", value);
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMailFromAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.MailFromAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "mailFromAttributes", value);
    }

    /**
     * An array of objects that define the tags (keys and values) to associate with the email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of objects that define the tags (keys and values) to associate with the email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Used to associate a configuration set with an email identity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * ConfigurationSetAttributesProperty configurationSetAttributesProperty = ConfigurationSetAttributesProperty.builder()
     *         .configurationSetName("configurationSetName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-configurationsetattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-configurationsetattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.ConfigurationSetAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationSetAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationSetAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration set to associate with an email identity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-configurationsetattributes.html#cfn-ses-emailidentity-configurationsetattributes-configurationsetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-configurationsetattributes.html#cfn-ses-emailidentity-configurationsetattributes-configurationsetname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSetName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationSetAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationSetAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationSetAttributesProperty> {
            java.lang.String configurationSetName;

            /**
             * Sets the value of {@link ConfigurationSetAttributesProperty#getConfigurationSetName}
             * @param configurationSetName The configuration set to associate with an email identity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationSetName(java.lang.String configurationSetName) {
                this.configurationSetName = configurationSetName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationSetAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationSetAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationSetAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationSetAttributesProperty {
            private final java.lang.String configurationSetName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationSetName = software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationSetName = builder.configurationSetName;
            }

            @Override
            public final java.lang.String getConfigurationSetName() {
                return this.configurationSetName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigurationSetName() != null) {
                    data.set("configurationSetName", om.valueToTree(this.getConfigurationSetName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.ConfigurationSetAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationSetAttributesProperty.Jsii$Proxy that = (ConfigurationSetAttributesProperty.Jsii$Proxy) o;

                return this.configurationSetName != null ? this.configurationSetName.equals(that.configurationSetName) : that.configurationSetName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationSetName != null ? this.configurationSetName.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Used to enable or disable DKIM authentication for an email identity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DkimAttributesProperty dkimAttributesProperty = DkimAttributesProperty.builder()
     *         .signingEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.DkimAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(DkimAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DkimAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets the DKIM signing configuration for the identity.
         * <p>
         * When you set this value <code>true</code> , then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code> , your messages are sent without DKIM signing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimattributes.html#cfn-ses-emailidentity-dkimattributes-signingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimattributes.html#cfn-ses-emailidentity-dkimattributes-signingenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSigningEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DkimAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DkimAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DkimAttributesProperty> {
            java.lang.Object signingEnabled;

            /**
             * Sets the value of {@link DkimAttributesProperty#getSigningEnabled}
             * @param signingEnabled Sets the DKIM signing configuration for the identity.
             *                       When you set this value <code>true</code> , then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code> , your messages are sent without DKIM signing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingEnabled(java.lang.Boolean signingEnabled) {
                this.signingEnabled = signingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DkimAttributesProperty#getSigningEnabled}
             * @param signingEnabled Sets the DKIM signing configuration for the identity.
             *                       When you set this value <code>true</code> , then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code> , your messages are sent without DKIM signing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingEnabled(software.amazon.awscdk.IResolvable signingEnabled) {
                this.signingEnabled = signingEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DkimAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DkimAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DkimAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DkimAttributesProperty {
            private final java.lang.Object signingEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.signingEnabled = software.amazon.jsii.Kernel.get(this, "signingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.signingEnabled = builder.signingEnabled;
            }

            @Override
            public final java.lang.Object getSigningEnabled() {
                return this.signingEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSigningEnabled() != null) {
                    data.set("signingEnabled", om.valueToTree(this.getSigningEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.DkimAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DkimAttributesProperty.Jsii$Proxy that = (DkimAttributesProperty.Jsii$Proxy) o;

                return this.signingEnabled != null ? this.signingEnabled.equals(that.signingEnabled) : that.signingEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.signingEnabled != null ? this.signingEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Used to configure or change the DKIM authentication settings for an email domain identity.
     * <p>
     * You can use this operation to do any of the following:
     * <p>
     * <ul>
     * <li>Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).</li>
     * <li>Update the key length that should be used for Easy DKIM.</li>
     * <li>Change from using no DKIM authentication to using Easy DKIM.</li>
     * <li>Change from using no DKIM authentication to using BYODKIM.</li>
     * <li>Change from using Easy DKIM to using BYODKIM.</li>
     * <li>Change from using BYODKIM to using Easy DKIM.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DkimSigningAttributesProperty dkimSigningAttributesProperty = DkimSigningAttributesProperty.builder()
     *         .domainSigningPrivateKey("domainSigningPrivateKey")
     *         .domainSigningSelector("domainSigningSelector")
     *         .nextSigningKeyLength("nextSigningKeyLength")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimsigningattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimsigningattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.DkimSigningAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(DkimSigningAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DkimSigningAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * [Bring Your Own DKIM] A private key that's used to generate a DKIM signature.
         * <p>
         * The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
         * <p>
         * <blockquote>
         * <p>
         * Rather than embedding sensitive information directly in your CFN templates, we recommend you use dynamic parameters in the stack template to reference sensitive information that is stored and managed outside of CFN, such as in the AWS Systems Manager Parameter Store or AWS Secrets Manager.
         * <p>
         * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/best-practices.html#creds">Do not embed credentials in your templates</a> best practice.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimsigningattributes.html#cfn-ses-emailidentity-dkimsigningattributes-domainsigningprivatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimsigningattributes.html#cfn-ses-emailidentity-dkimsigningattributes-domainsigningprivatekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainSigningPrivateKey() {
            return null;
        }

        /**
         * [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimsigningattributes.html#cfn-ses-emailidentity-dkimsigningattributes-domainsigningselector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimsigningattributes.html#cfn-ses-emailidentity-dkimsigningattributes-domainsigningselector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainSigningSelector() {
            return null;
        }

        /**
         * [Easy DKIM] The key length of the future DKIM key pair to be generated.
         * <p>
         * This can be changed at most once per day.
         * <p>
         * Valid Values: <code>RSA_1024_BIT | RSA_2048_BIT</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimsigningattributes.html#cfn-ses-emailidentity-dkimsigningattributes-nextsigningkeylength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-dkimsigningattributes.html#cfn-ses-emailidentity-dkimsigningattributes-nextsigningkeylength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNextSigningKeyLength() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DkimSigningAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DkimSigningAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DkimSigningAttributesProperty> {
            java.lang.String domainSigningPrivateKey;
            java.lang.String domainSigningSelector;
            java.lang.String nextSigningKeyLength;

            /**
             * Sets the value of {@link DkimSigningAttributesProperty#getDomainSigningPrivateKey}
             * @param domainSigningPrivateKey [Bring Your Own DKIM] A private key that's used to generate a DKIM signature.
             *                                The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
             *                                <p>
             *                                <blockquote>
             *                                <p>
             *                                Rather than embedding sensitive information directly in your CFN templates, we recommend you use dynamic parameters in the stack template to reference sensitive information that is stored and managed outside of CFN, such as in the AWS Systems Manager Parameter Store or AWS Secrets Manager.
             *                                <p>
             *                                For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/best-practices.html#creds">Do not embed credentials in your templates</a> best practice.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainSigningPrivateKey(java.lang.String domainSigningPrivateKey) {
                this.domainSigningPrivateKey = domainSigningPrivateKey;
                return this;
            }

            /**
             * Sets the value of {@link DkimSigningAttributesProperty#getDomainSigningSelector}
             * @param domainSigningSelector [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainSigningSelector(java.lang.String domainSigningSelector) {
                this.domainSigningSelector = domainSigningSelector;
                return this;
            }

            /**
             * Sets the value of {@link DkimSigningAttributesProperty#getNextSigningKeyLength}
             * @param nextSigningKeyLength [Easy DKIM] The key length of the future DKIM key pair to be generated.
             *                             This can be changed at most once per day.
             *                             <p>
             *                             Valid Values: <code>RSA_1024_BIT | RSA_2048_BIT</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextSigningKeyLength(java.lang.String nextSigningKeyLength) {
                this.nextSigningKeyLength = nextSigningKeyLength;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DkimSigningAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DkimSigningAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DkimSigningAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DkimSigningAttributesProperty {
            private final java.lang.String domainSigningPrivateKey;
            private final java.lang.String domainSigningSelector;
            private final java.lang.String nextSigningKeyLength;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainSigningPrivateKey = software.amazon.jsii.Kernel.get(this, "domainSigningPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domainSigningSelector = software.amazon.jsii.Kernel.get(this, "domainSigningSelector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nextSigningKeyLength = software.amazon.jsii.Kernel.get(this, "nextSigningKeyLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainSigningPrivateKey = builder.domainSigningPrivateKey;
                this.domainSigningSelector = builder.domainSigningSelector;
                this.nextSigningKeyLength = builder.nextSigningKeyLength;
            }

            @Override
            public final java.lang.String getDomainSigningPrivateKey() {
                return this.domainSigningPrivateKey;
            }

            @Override
            public final java.lang.String getDomainSigningSelector() {
                return this.domainSigningSelector;
            }

            @Override
            public final java.lang.String getNextSigningKeyLength() {
                return this.nextSigningKeyLength;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainSigningPrivateKey() != null) {
                    data.set("domainSigningPrivateKey", om.valueToTree(this.getDomainSigningPrivateKey()));
                }
                if (this.getDomainSigningSelector() != null) {
                    data.set("domainSigningSelector", om.valueToTree(this.getDomainSigningSelector()));
                }
                if (this.getNextSigningKeyLength() != null) {
                    data.set("nextSigningKeyLength", om.valueToTree(this.getNextSigningKeyLength()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.DkimSigningAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DkimSigningAttributesProperty.Jsii$Proxy that = (DkimSigningAttributesProperty.Jsii$Proxy) o;

                if (this.domainSigningPrivateKey != null ? !this.domainSigningPrivateKey.equals(that.domainSigningPrivateKey) : that.domainSigningPrivateKey != null) return false;
                if (this.domainSigningSelector != null ? !this.domainSigningSelector.equals(that.domainSigningSelector) : that.domainSigningSelector != null) return false;
                return this.nextSigningKeyLength != null ? this.nextSigningKeyLength.equals(that.nextSigningKeyLength) : that.nextSigningKeyLength == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainSigningPrivateKey != null ? this.domainSigningPrivateKey.hashCode() : 0;
                result = 31 * result + (this.domainSigningSelector != null ? this.domainSigningSelector.hashCode() : 0);
                result = 31 * result + (this.nextSigningKeyLength != null ? this.nextSigningKeyLength.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Used to enable or disable feedback forwarding for an identity.
     * <p>
     * This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * FeedbackAttributesProperty feedbackAttributesProperty = FeedbackAttributesProperty.builder()
     *         .emailForwardingEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-feedbackattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-feedbackattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.FeedbackAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(FeedbackAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FeedbackAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets the feedback forwarding configuration for the identity.
         * <p>
         * If the value is <code>true</code> , you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.
         * <p>
         * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-feedbackattributes.html#cfn-ses-emailidentity-feedbackattributes-emailforwardingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-feedbackattributes.html#cfn-ses-emailidentity-feedbackattributes-emailforwardingenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailForwardingEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FeedbackAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FeedbackAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FeedbackAttributesProperty> {
            java.lang.Object emailForwardingEnabled;

            /**
             * Sets the value of {@link FeedbackAttributesProperty#getEmailForwardingEnabled}
             * @param emailForwardingEnabled Sets the feedback forwarding configuration for the identity.
             *                               If the value is <code>true</code> , you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.
             *                               <p>
             *                               You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailForwardingEnabled(java.lang.Boolean emailForwardingEnabled) {
                this.emailForwardingEnabled = emailForwardingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link FeedbackAttributesProperty#getEmailForwardingEnabled}
             * @param emailForwardingEnabled Sets the feedback forwarding configuration for the identity.
             *                               If the value is <code>true</code> , you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.
             *                               <p>
             *                               You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailForwardingEnabled(software.amazon.awscdk.IResolvable emailForwardingEnabled) {
                this.emailForwardingEnabled = emailForwardingEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FeedbackAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FeedbackAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FeedbackAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FeedbackAttributesProperty {
            private final java.lang.Object emailForwardingEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailForwardingEnabled = software.amazon.jsii.Kernel.get(this, "emailForwardingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailForwardingEnabled = builder.emailForwardingEnabled;
            }

            @Override
            public final java.lang.Object getEmailForwardingEnabled() {
                return this.emailForwardingEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmailForwardingEnabled() != null) {
                    data.set("emailForwardingEnabled", om.valueToTree(this.getEmailForwardingEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.FeedbackAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FeedbackAttributesProperty.Jsii$Proxy that = (FeedbackAttributesProperty.Jsii$Proxy) o;

                return this.emailForwardingEnabled != null ? this.emailForwardingEnabled.equals(that.emailForwardingEnabled) : that.emailForwardingEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailForwardingEnabled != null ? this.emailForwardingEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * MailFromAttributesProperty mailFromAttributesProperty = MailFromAttributesProperty.builder()
     *         .behaviorOnMxFailure("behaviorOnMxFailure")
     *         .mailFromDomain("mailFromDomain")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-mailfromattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-mailfromattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.MailFromAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(MailFromAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MailFromAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to take if the required MX record isn't found when you send an email.
         * <p>
         * When you set this value to <code>USE_DEFAULT_VALUE</code> , the mail is sent using <em>amazonses.com</em> as the MAIL FROM domain. When you set this value to <code>REJECT_MESSAGE</code> , the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
         * <p>
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code> , <code>Failed</code> , and <code>TemporaryFailure</code> states.
         * <p>
         * Valid Values: <code>USE_DEFAULT_VALUE | REJECT_MESSAGE</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-mailfromattributes.html#cfn-ses-emailidentity-mailfromattributes-behavioronmxfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-mailfromattributes.html#cfn-ses-emailidentity-mailfromattributes-behavioronmxfailure</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBehaviorOnMxFailure() {
            return null;
        }

        /**
         * The custom MAIL FROM domain that you want the verified identity to use.
         * <p>
         * The MAIL FROM domain must meet the following criteria:
         * <p>
         * <ul>
         * <li>It has to be a subdomain of the verified identity.</li>
         * <li>It can't be used to receive email.</li>
         * <li>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-mailfromattributes.html#cfn-ses-emailidentity-mailfromattributes-mailfromdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-emailidentity-mailfromattributes.html#cfn-ses-emailidentity-mailfromattributes-mailfromdomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailFromDomain() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MailFromAttributesProperty> {
            java.lang.String behaviorOnMxFailure;
            java.lang.String mailFromDomain;

            /**
             * Sets the value of {@link MailFromAttributesProperty#getBehaviorOnMxFailure}
             * @param behaviorOnMxFailure The action to take if the required MX record isn't found when you send an email.
             *                            When you set this value to <code>USE_DEFAULT_VALUE</code> , the mail is sent using <em>amazonses.com</em> as the MAIL FROM domain. When you set this value to <code>REJECT_MESSAGE</code> , the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
             *                            <p>
             *                            These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code> , <code>Failed</code> , and <code>TemporaryFailure</code> states.
             *                            <p>
             *                            Valid Values: <code>USE_DEFAULT_VALUE | REJECT_MESSAGE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behaviorOnMxFailure(java.lang.String behaviorOnMxFailure) {
                this.behaviorOnMxFailure = behaviorOnMxFailure;
                return this;
            }

            /**
             * Sets the value of {@link MailFromAttributesProperty#getMailFromDomain}
             * @param mailFromDomain The custom MAIL FROM domain that you want the verified identity to use.
             *                       The MAIL FROM domain must meet the following criteria:
             *                       <p>
             *                       <ul>
             *                       <li>It has to be a subdomain of the verified identity.</li>
             *                       <li>It can't be used to receive email.</li>
             *                       <li>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailFromDomain(java.lang.String mailFromDomain) {
                this.mailFromDomain = mailFromDomain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MailFromAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MailFromAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MailFromAttributesProperty {
            private final java.lang.String behaviorOnMxFailure;
            private final java.lang.String mailFromDomain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behaviorOnMxFailure = software.amazon.jsii.Kernel.get(this, "behaviorOnMxFailure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailFromDomain = software.amazon.jsii.Kernel.get(this, "mailFromDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behaviorOnMxFailure = builder.behaviorOnMxFailure;
                this.mailFromDomain = builder.mailFromDomain;
            }

            @Override
            public final java.lang.String getBehaviorOnMxFailure() {
                return this.behaviorOnMxFailure;
            }

            @Override
            public final java.lang.String getMailFromDomain() {
                return this.mailFromDomain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBehaviorOnMxFailure() != null) {
                    data.set("behaviorOnMxFailure", om.valueToTree(this.getBehaviorOnMxFailure()));
                }
                if (this.getMailFromDomain() != null) {
                    data.set("mailFromDomain", om.valueToTree(this.getMailFromDomain()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.MailFromAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MailFromAttributesProperty.Jsii$Proxy that = (MailFromAttributesProperty.Jsii$Proxy) o;

                if (this.behaviorOnMxFailure != null ? !this.behaviorOnMxFailure.equals(that.behaviorOnMxFailure) : that.behaviorOnMxFailure != null) return false;
                return this.mailFromDomain != null ? this.mailFromDomain.equals(that.mailFromDomain) : that.mailFromDomain == null;
            }

            @Override
            public final int hashCode() {
                int result = this.behaviorOnMxFailure != null ? this.behaviorOnMxFailure.hashCode() : 0;
                result = 31 * result + (this.mailFromDomain != null ? this.mailFromDomain.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnEmailIdentity}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnEmailIdentity> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.CfnEmailIdentityProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.CfnEmailIdentityProps.Builder();
        }

        /**
         * The email address or domain to verify.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-emailidentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-emailidentity</a>
         * @param emailIdentity The email address or domain to verify. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailIdentity(final java.lang.String emailIdentity) {
            this.props.emailIdentity(emailIdentity);
            return this;
        }

        /**
         * Used to associate a configuration set with an email identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-configurationsetattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-configurationsetattributes</a>
         * @param configurationSetAttributes Used to associate a configuration set with an email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetAttributes(final software.amazon.awscdk.IResolvable configurationSetAttributes) {
            this.props.configurationSetAttributes(configurationSetAttributes);
            return this;
        }
        /**
         * Used to associate a configuration set with an email identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-configurationsetattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-configurationsetattributes</a>
         * @param configurationSetAttributes Used to associate a configuration set with an email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.ConfigurationSetAttributesProperty configurationSetAttributes) {
            this.props.configurationSetAttributes(configurationSetAttributes);
            return this;
        }

        /**
         * An object that contains information about the DKIM attributes for the identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimattributes</a>
         * @param dkimAttributes An object that contains information about the DKIM attributes for the identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimAttributes(final software.amazon.awscdk.IResolvable dkimAttributes) {
            this.props.dkimAttributes(dkimAttributes);
            return this;
        }
        /**
         * An object that contains information about the DKIM attributes for the identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimattributes</a>
         * @param dkimAttributes An object that contains information about the DKIM attributes for the identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimAttributesProperty dkimAttributes) {
            this.props.dkimAttributes(dkimAttributes);
            return this;
        }

        /**
         * If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> .
         * <p>
         * You can only specify this object if the email identity is a domain, as opposed to an address.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimsigningattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimsigningattributes</a>
         * @param dkimSigningAttributes If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningAttributes(final software.amazon.awscdk.IResolvable dkimSigningAttributes) {
            this.props.dkimSigningAttributes(dkimSigningAttributes);
            return this;
        }
        /**
         * If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> .
         * <p>
         * You can only specify this object if the email identity is a domain, as opposed to an address.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimsigningattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimsigningattributes</a>
         * @param dkimSigningAttributes If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimSigningAttributesProperty dkimSigningAttributes) {
            this.props.dkimSigningAttributes(dkimSigningAttributes);
            return this;
        }

        /**
         * Used to enable or disable feedback forwarding for an identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-feedbackattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-feedbackattributes</a>
         * @param feedbackAttributes Used to enable or disable feedback forwarding for an identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackAttributes(final software.amazon.awscdk.IResolvable feedbackAttributes) {
            this.props.feedbackAttributes(feedbackAttributes);
            return this;
        }
        /**
         * Used to enable or disable feedback forwarding for an identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-feedbackattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-feedbackattributes</a>
         * @param feedbackAttributes Used to enable or disable feedback forwarding for an identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.FeedbackAttributesProperty feedbackAttributes) {
            this.props.feedbackAttributes(feedbackAttributes);
            return this;
        }

        /**
         * Used to enable or disable the custom Mail-From domain configuration for an email identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-mailfromattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-mailfromattributes</a>
         * @param mailFromAttributes Used to enable or disable the custom Mail-From domain configuration for an email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(final software.amazon.awscdk.IResolvable mailFromAttributes) {
            this.props.mailFromAttributes(mailFromAttributes);
            return this;
        }
        /**
         * Used to enable or disable the custom Mail-From domain configuration for an email identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-mailfromattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-mailfromattributes</a>
         * @param mailFromAttributes Used to enable or disable the custom Mail-From domain configuration for an email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.MailFromAttributesProperty mailFromAttributes) {
            this.props.mailFromAttributes(mailFromAttributes);
            return this;
        }

        /**
         * An array of objects that define the tags (keys and values) to associate with the email identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-tags</a>
         * @param tags An array of objects that define the tags (keys and values) to associate with the email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.CfnEmailIdentity}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnEmailIdentity build() {
            return new software.amazon.awscdk.services.ses.CfnEmailIdentity(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
