package software.amazon.awscdk.services.ses;

/**
 * TLS policy for a configuration set.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Duration;
 * IDedicatedIpPool myPool;
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .tlsPolicy(ConfigurationSetTlsPolicy.REQUIRE)
 *         .dedicatedIpPool(myPool)
 *         // Specify maximum delivery time
 *         // This configuration can be useful in such cases as time-sensitive emails (like those containing a one-time-password),
 *         // transactional emails, and email that you want to ensure isn't delivered during non-business hours.
 *         .maxDeliveryDuration(Duration.minutes(10))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:24.347Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ConfigurationSetTlsPolicy")
public enum ConfigurationSetTlsPolicy {
    /**
     * Messages are only delivered if a TLS connection can be established.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRE,
    /**
     * Messages can be delivered in plain text if a TLS connection can't be established.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONAL,
}
