package software.amazon.awscdk.services.ssmcontacts;

/**
 * Specifies a rotation in an on-call schedule.
 * <p>
 * <blockquote>
 * <p>
 * <em>Template example</em> : We recommend creating all Incident Manager <code>Contacts</code> resources using a single AWS CloudFormation template. For a demonstration, see the examples for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-contact.html">AWS::SSMContacts::Contacts</a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmcontacts.*;
 * CfnRotation cfnRotation = CfnRotation.Builder.create(this, "MyCfnRotation")
 *         .contactIds(List.of("contactIds"))
 *         .name("name")
 *         .recurrence(RecurrenceSettingsProperty.builder()
 *                 .numberOfOnCalls(123)
 *                 .recurrenceMultiplier(123)
 *                 // the properties below are optional
 *                 .dailySettings(List.of("dailySettings"))
 *                 .monthlySettings(List.of(MonthlySettingProperty.builder()
 *                         .dayOfMonth(123)
 *                         .handOffTime("handOffTime")
 *                         .build()))
 *                 .shiftCoverages(List.of(ShiftCoverageProperty.builder()
 *                         .coverageTimes(List.of(CoverageTimeProperty.builder()
 *                                 .endTime("endTime")
 *                                 .startTime("startTime")
 *                                 .build()))
 *                         .dayOfWeek("dayOfWeek")
 *                         .build()))
 *                 .weeklySettings(List.of(WeeklySettingProperty.builder()
 *                         .dayOfWeek("dayOfWeek")
 *                         .handOffTime("handOffTime")
 *                         .build()))
 *                 .build())
 *         .startTime("startTime")
 *         .timeZoneId("timeZoneId")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:24.584Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnRotation")
public class CfnRotation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnRotation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRotation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssmcontacts.CfnRotation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRotation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssmcontacts.CfnRotationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the <code>Rotation</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getContactIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "contactIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContactIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "contactIds", java.util.Objects.requireNonNull(value, "contactIds is required"));
    }

    /**
     * The name for the rotation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the rotation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Information about the rule that specifies when shift team members rotate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRecurrence() {
        return software.amazon.jsii.Kernel.get(this, "recurrence", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the rule that specifies when shift team members rotate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecurrence(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recurrence", java.util.Objects.requireNonNull(value, "recurrence is required"));
    }

    /**
     * Information about the rule that specifies when shift team members rotate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecurrence(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssmcontacts.CfnRotation.RecurrenceSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "recurrence", java.util.Objects.requireNonNull(value, "recurrence is required"));
    }

    /**
     * The date and time the rotation goes into effect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStartTime() {
        return software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time the rotation goes into effect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartTime(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startTime", java.util.Objects.requireNonNull(value, "startTime is required"));
    }

    /**
     * The time zone to base the rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTimeZoneId() {
        return software.amazon.jsii.Kernel.get(this, "timeZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time zone to base the rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeZoneId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "timeZoneId", java.util.Objects.requireNonNull(value, "timeZoneId is required"));
    }

    /**
     * Optional metadata to assign to the rotation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Optional metadata to assign to the rotation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Information about when an on-call shift begins and ends.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * CoverageTimeProperty coverageTimeProperty = CoverageTimeProperty.builder()
     *         .endTime("endTime")
     *         .startTime("startTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-coveragetime.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-coveragetime.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnRotation.CoverageTimeProperty")
    @software.amazon.jsii.Jsii.Proxy(CoverageTimeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CoverageTimeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about when an on-call rotation shift ends.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-coveragetime.html#cfn-ssmcontacts-rotation-coveragetime-endtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-coveragetime.html#cfn-ssmcontacts-rotation-coveragetime-endtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndTime();

        /**
         * Information about when an on-call rotation shift begins.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-coveragetime.html#cfn-ssmcontacts-rotation-coveragetime-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-coveragetime.html#cfn-ssmcontacts-rotation-coveragetime-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartTime();

        /**
         * @return a {@link Builder} of {@link CoverageTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CoverageTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CoverageTimeProperty> {
            java.lang.String endTime;
            java.lang.String startTime;

            /**
             * Sets the value of {@link CoverageTimeProperty#getEndTime}
             * @param endTime Information about when an on-call rotation shift ends. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.lang.String endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link CoverageTimeProperty#getStartTime}
             * @param startTime Information about when an on-call rotation shift begins. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CoverageTimeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CoverageTimeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CoverageTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CoverageTimeProperty {
            private final java.lang.String endTime;
            private final java.lang.String startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endTime = java.util.Objects.requireNonNull(builder.endTime, "endTime is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            }

            @Override
            public final java.lang.String getEndTime() {
                return this.endTime;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endTime", om.valueToTree(this.getEndTime()));
                data.set("startTime", om.valueToTree(this.getStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnRotation.CoverageTimeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CoverageTimeProperty.Jsii$Proxy that = (CoverageTimeProperty.Jsii$Proxy) o;

                if (!endTime.equals(that.endTime)) return false;
                return this.startTime.equals(that.startTime);
            }

            @Override
            public final int hashCode() {
                int result = this.endTime.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about on-call rotations that recur monthly.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * MonthlySettingProperty monthlySettingProperty = MonthlySettingProperty.builder()
     *         .dayOfMonth(123)
     *         .handOffTime("handOffTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-monthlysetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-monthlysetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnRotation.MonthlySettingProperty")
    @software.amazon.jsii.Jsii.Proxy(MonthlySettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonthlySettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The day of the month when monthly recurring on-call rotations begin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-monthlysetting.html#cfn-ssmcontacts-rotation-monthlysetting-dayofmonth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-monthlysetting.html#cfn-ssmcontacts-rotation-monthlysetting-dayofmonth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDayOfMonth();

        /**
         * The time of day when a monthly recurring on-call shift rotation begins.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-monthlysetting.html#cfn-ssmcontacts-rotation-monthlysetting-handofftime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-monthlysetting.html#cfn-ssmcontacts-rotation-monthlysetting-handofftime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHandOffTime();

        /**
         * @return a {@link Builder} of {@link MonthlySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonthlySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonthlySettingProperty> {
            java.lang.Number dayOfMonth;
            java.lang.String handOffTime;

            /**
             * Sets the value of {@link MonthlySettingProperty#getDayOfMonth}
             * @param dayOfMonth The day of the month when monthly recurring on-call rotations begin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dayOfMonth(java.lang.Number dayOfMonth) {
                this.dayOfMonth = dayOfMonth;
                return this;
            }

            /**
             * Sets the value of {@link MonthlySettingProperty#getHandOffTime}
             * @param handOffTime The time of day when a monthly recurring on-call shift rotation begins. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder handOffTime(java.lang.String handOffTime) {
                this.handOffTime = handOffTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonthlySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonthlySettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonthlySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonthlySettingProperty {
            private final java.lang.Number dayOfMonth;
            private final java.lang.String handOffTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dayOfMonth = software.amazon.jsii.Kernel.get(this, "dayOfMonth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.handOffTime = software.amazon.jsii.Kernel.get(this, "handOffTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dayOfMonth = java.util.Objects.requireNonNull(builder.dayOfMonth, "dayOfMonth is required");
                this.handOffTime = java.util.Objects.requireNonNull(builder.handOffTime, "handOffTime is required");
            }

            @Override
            public final java.lang.Number getDayOfMonth() {
                return this.dayOfMonth;
            }

            @Override
            public final java.lang.String getHandOffTime() {
                return this.handOffTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dayOfMonth", om.valueToTree(this.getDayOfMonth()));
                data.set("handOffTime", om.valueToTree(this.getHandOffTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnRotation.MonthlySettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonthlySettingProperty.Jsii$Proxy that = (MonthlySettingProperty.Jsii$Proxy) o;

                if (!dayOfMonth.equals(that.dayOfMonth)) return false;
                return this.handOffTime.equals(that.handOffTime);
            }

            @Override
            public final int hashCode() {
                int result = this.dayOfMonth.hashCode();
                result = 31 * result + (this.handOffTime.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about when an on-call rotation is in effect and how long the rotation period lasts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * RecurrenceSettingsProperty recurrenceSettingsProperty = RecurrenceSettingsProperty.builder()
     *         .numberOfOnCalls(123)
     *         .recurrenceMultiplier(123)
     *         // the properties below are optional
     *         .dailySettings(List.of("dailySettings"))
     *         .monthlySettings(List.of(MonthlySettingProperty.builder()
     *                 .dayOfMonth(123)
     *                 .handOffTime("handOffTime")
     *                 .build()))
     *         .shiftCoverages(List.of(ShiftCoverageProperty.builder()
     *                 .coverageTimes(List.of(CoverageTimeProperty.builder()
     *                         .endTime("endTime")
     *                         .startTime("startTime")
     *                         .build()))
     *                 .dayOfWeek("dayOfWeek")
     *                 .build()))
     *         .weeklySettings(List.of(WeeklySettingProperty.builder()
     *                 .dayOfWeek("dayOfWeek")
     *                 .handOffTime("handOffTime")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnRotation.RecurrenceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RecurrenceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecurrenceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of contacts, or shift team members designated to be on call concurrently during a shift.
         * <p>
         * For example, in an on-call schedule that contains ten contacts, a value of <code>2</code> designates that two of them are on call at any given time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-numberofoncalls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-numberofoncalls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getNumberOfOnCalls();

        /**
         * The number of days, weeks, or months a single rotation lasts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-recurrencemultiplier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-recurrencemultiplier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRecurrenceMultiplier();

        /**
         * Information about on-call rotations that recur daily.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-dailysettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-dailysettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDailySettings() {
            return null;
        }

        /**
         * Information about on-call rotations that recur monthly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-monthlysettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-monthlysettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonthlySettings() {
            return null;
        }

        /**
         * Information about the days of the week included in on-call rotation coverage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-shiftcoverages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-shiftcoverages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShiftCoverages() {
            return null;
        }

        /**
         * Information about on-call rotations that recur weekly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-weeklysettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-recurrencesettings.html#cfn-ssmcontacts-rotation-recurrencesettings-weeklysettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWeeklySettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecurrenceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecurrenceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecurrenceSettingsProperty> {
            java.lang.Number numberOfOnCalls;
            java.lang.Number recurrenceMultiplier;
            java.util.List<java.lang.String> dailySettings;
            java.lang.Object monthlySettings;
            java.lang.Object shiftCoverages;
            java.lang.Object weeklySettings;

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getNumberOfOnCalls}
             * @param numberOfOnCalls The number of contacts, or shift team members designated to be on call concurrently during a shift. This parameter is required.
             *                        For example, in an on-call schedule that contains ten contacts, a value of <code>2</code> designates that two of them are on call at any given time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfOnCalls(java.lang.Number numberOfOnCalls) {
                this.numberOfOnCalls = numberOfOnCalls;
                return this;
            }

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getRecurrenceMultiplier}
             * @param recurrenceMultiplier The number of days, weeks, or months a single rotation lasts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recurrenceMultiplier(java.lang.Number recurrenceMultiplier) {
                this.recurrenceMultiplier = recurrenceMultiplier;
                return this;
            }

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getDailySettings}
             * @param dailySettings Information about on-call rotations that recur daily.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailySettings(java.util.List<java.lang.String> dailySettings) {
                this.dailySettings = dailySettings;
                return this;
            }

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getMonthlySettings}
             * @param monthlySettings Information about on-call rotations that recur monthly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monthlySettings(software.amazon.awscdk.IResolvable monthlySettings) {
                this.monthlySettings = monthlySettings;
                return this;
            }

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getMonthlySettings}
             * @param monthlySettings Information about on-call rotations that recur monthly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monthlySettings(java.util.List<? extends java.lang.Object> monthlySettings) {
                this.monthlySettings = monthlySettings;
                return this;
            }

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getShiftCoverages}
             * @param shiftCoverages Information about the days of the week included in on-call rotation coverage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shiftCoverages(software.amazon.awscdk.IResolvable shiftCoverages) {
                this.shiftCoverages = shiftCoverages;
                return this;
            }

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getShiftCoverages}
             * @param shiftCoverages Information about the days of the week included in on-call rotation coverage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shiftCoverages(java.util.List<? extends java.lang.Object> shiftCoverages) {
                this.shiftCoverages = shiftCoverages;
                return this;
            }

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getWeeklySettings}
             * @param weeklySettings Information about on-call rotations that recur weekly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeklySettings(software.amazon.awscdk.IResolvable weeklySettings) {
                this.weeklySettings = weeklySettings;
                return this;
            }

            /**
             * Sets the value of {@link RecurrenceSettingsProperty#getWeeklySettings}
             * @param weeklySettings Information about on-call rotations that recur weekly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeklySettings(java.util.List<? extends java.lang.Object> weeklySettings) {
                this.weeklySettings = weeklySettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecurrenceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecurrenceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecurrenceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecurrenceSettingsProperty {
            private final java.lang.Number numberOfOnCalls;
            private final java.lang.Number recurrenceMultiplier;
            private final java.util.List<java.lang.String> dailySettings;
            private final java.lang.Object monthlySettings;
            private final java.lang.Object shiftCoverages;
            private final java.lang.Object weeklySettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.numberOfOnCalls = software.amazon.jsii.Kernel.get(this, "numberOfOnCalls", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.recurrenceMultiplier = software.amazon.jsii.Kernel.get(this, "recurrenceMultiplier", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dailySettings = software.amazon.jsii.Kernel.get(this, "dailySettings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.monthlySettings = software.amazon.jsii.Kernel.get(this, "monthlySettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.shiftCoverages = software.amazon.jsii.Kernel.get(this, "shiftCoverages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weeklySettings = software.amazon.jsii.Kernel.get(this, "weeklySettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.numberOfOnCalls = java.util.Objects.requireNonNull(builder.numberOfOnCalls, "numberOfOnCalls is required");
                this.recurrenceMultiplier = java.util.Objects.requireNonNull(builder.recurrenceMultiplier, "recurrenceMultiplier is required");
                this.dailySettings = builder.dailySettings;
                this.monthlySettings = builder.monthlySettings;
                this.shiftCoverages = builder.shiftCoverages;
                this.weeklySettings = builder.weeklySettings;
            }

            @Override
            public final java.lang.Number getNumberOfOnCalls() {
                return this.numberOfOnCalls;
            }

            @Override
            public final java.lang.Number getRecurrenceMultiplier() {
                return this.recurrenceMultiplier;
            }

            @Override
            public final java.util.List<java.lang.String> getDailySettings() {
                return this.dailySettings;
            }

            @Override
            public final java.lang.Object getMonthlySettings() {
                return this.monthlySettings;
            }

            @Override
            public final java.lang.Object getShiftCoverages() {
                return this.shiftCoverages;
            }

            @Override
            public final java.lang.Object getWeeklySettings() {
                return this.weeklySettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("numberOfOnCalls", om.valueToTree(this.getNumberOfOnCalls()));
                data.set("recurrenceMultiplier", om.valueToTree(this.getRecurrenceMultiplier()));
                if (this.getDailySettings() != null) {
                    data.set("dailySettings", om.valueToTree(this.getDailySettings()));
                }
                if (this.getMonthlySettings() != null) {
                    data.set("monthlySettings", om.valueToTree(this.getMonthlySettings()));
                }
                if (this.getShiftCoverages() != null) {
                    data.set("shiftCoverages", om.valueToTree(this.getShiftCoverages()));
                }
                if (this.getWeeklySettings() != null) {
                    data.set("weeklySettings", om.valueToTree(this.getWeeklySettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnRotation.RecurrenceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecurrenceSettingsProperty.Jsii$Proxy that = (RecurrenceSettingsProperty.Jsii$Proxy) o;

                if (!numberOfOnCalls.equals(that.numberOfOnCalls)) return false;
                if (!recurrenceMultiplier.equals(that.recurrenceMultiplier)) return false;
                if (this.dailySettings != null ? !this.dailySettings.equals(that.dailySettings) : that.dailySettings != null) return false;
                if (this.monthlySettings != null ? !this.monthlySettings.equals(that.monthlySettings) : that.monthlySettings != null) return false;
                if (this.shiftCoverages != null ? !this.shiftCoverages.equals(that.shiftCoverages) : that.shiftCoverages != null) return false;
                return this.weeklySettings != null ? this.weeklySettings.equals(that.weeklySettings) : that.weeklySettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.numberOfOnCalls.hashCode();
                result = 31 * result + (this.recurrenceMultiplier.hashCode());
                result = 31 * result + (this.dailySettings != null ? this.dailySettings.hashCode() : 0);
                result = 31 * result + (this.monthlySettings != null ? this.monthlySettings.hashCode() : 0);
                result = 31 * result + (this.shiftCoverages != null ? this.shiftCoverages.hashCode() : 0);
                result = 31 * result + (this.weeklySettings != null ? this.weeklySettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the days of the week that the on-call rotation coverage includes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * ShiftCoverageProperty shiftCoverageProperty = ShiftCoverageProperty.builder()
     *         .coverageTimes(List.of(CoverageTimeProperty.builder()
     *                 .endTime("endTime")
     *                 .startTime("startTime")
     *                 .build()))
     *         .dayOfWeek("dayOfWeek")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-shiftcoverage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-shiftcoverage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnRotation.ShiftCoverageProperty")
    @software.amazon.jsii.Jsii.Proxy(ShiftCoverageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ShiftCoverageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The start and end times of the shift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-shiftcoverage.html#cfn-ssmcontacts-rotation-shiftcoverage-coveragetimes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-shiftcoverage.html#cfn-ssmcontacts-rotation-shiftcoverage-coveragetimes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCoverageTimes();

        /**
         * A list of days on which the schedule is active.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-shiftcoverage.html#cfn-ssmcontacts-rotation-shiftcoverage-dayofweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-shiftcoverage.html#cfn-ssmcontacts-rotation-shiftcoverage-dayofweek</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDayOfWeek();

        /**
         * @return a {@link Builder} of {@link ShiftCoverageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ShiftCoverageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ShiftCoverageProperty> {
            java.lang.Object coverageTimes;
            java.lang.String dayOfWeek;

            /**
             * Sets the value of {@link ShiftCoverageProperty#getCoverageTimes}
             * @param coverageTimes The start and end times of the shift. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coverageTimes(software.amazon.awscdk.IResolvable coverageTimes) {
                this.coverageTimes = coverageTimes;
                return this;
            }

            /**
             * Sets the value of {@link ShiftCoverageProperty#getCoverageTimes}
             * @param coverageTimes The start and end times of the shift. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coverageTimes(java.util.List<? extends java.lang.Object> coverageTimes) {
                this.coverageTimes = coverageTimes;
                return this;
            }

            /**
             * Sets the value of {@link ShiftCoverageProperty#getDayOfWeek}
             * @param dayOfWeek A list of days on which the schedule is active. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dayOfWeek(java.lang.String dayOfWeek) {
                this.dayOfWeek = dayOfWeek;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ShiftCoverageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ShiftCoverageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ShiftCoverageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShiftCoverageProperty {
            private final java.lang.Object coverageTimes;
            private final java.lang.String dayOfWeek;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coverageTimes = software.amazon.jsii.Kernel.get(this, "coverageTimes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dayOfWeek = software.amazon.jsii.Kernel.get(this, "dayOfWeek", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coverageTimes = java.util.Objects.requireNonNull(builder.coverageTimes, "coverageTimes is required");
                this.dayOfWeek = java.util.Objects.requireNonNull(builder.dayOfWeek, "dayOfWeek is required");
            }

            @Override
            public final java.lang.Object getCoverageTimes() {
                return this.coverageTimes;
            }

            @Override
            public final java.lang.String getDayOfWeek() {
                return this.dayOfWeek;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("coverageTimes", om.valueToTree(this.getCoverageTimes()));
                data.set("dayOfWeek", om.valueToTree(this.getDayOfWeek()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnRotation.ShiftCoverageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ShiftCoverageProperty.Jsii$Proxy that = (ShiftCoverageProperty.Jsii$Proxy) o;

                if (!coverageTimes.equals(that.coverageTimes)) return false;
                return this.dayOfWeek.equals(that.dayOfWeek);
            }

            @Override
            public final int hashCode() {
                int result = this.coverageTimes.hashCode();
                result = 31 * result + (this.dayOfWeek.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about rotations that recur weekly.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * WeeklySettingProperty weeklySettingProperty = WeeklySettingProperty.builder()
     *         .dayOfWeek("dayOfWeek")
     *         .handOffTime("handOffTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-weeklysetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-weeklysetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnRotation.WeeklySettingProperty")
    @software.amazon.jsii.Jsii.Proxy(WeeklySettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WeeklySettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The day of the week when weekly recurring on-call shift rotations begins.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-weeklysetting.html#cfn-ssmcontacts-rotation-weeklysetting-dayofweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-weeklysetting.html#cfn-ssmcontacts-rotation-weeklysetting-dayofweek</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDayOfWeek();

        /**
         * The time of day when a weekly recurring on-call shift rotation begins.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-weeklysetting.html#cfn-ssmcontacts-rotation-weeklysetting-handofftime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-rotation-weeklysetting.html#cfn-ssmcontacts-rotation-weeklysetting-handofftime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHandOffTime();

        /**
         * @return a {@link Builder} of {@link WeeklySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WeeklySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WeeklySettingProperty> {
            java.lang.String dayOfWeek;
            java.lang.String handOffTime;

            /**
             * Sets the value of {@link WeeklySettingProperty#getDayOfWeek}
             * @param dayOfWeek The day of the week when weekly recurring on-call shift rotations begins. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dayOfWeek(java.lang.String dayOfWeek) {
                this.dayOfWeek = dayOfWeek;
                return this;
            }

            /**
             * Sets the value of {@link WeeklySettingProperty#getHandOffTime}
             * @param handOffTime The time of day when a weekly recurring on-call shift rotation begins. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder handOffTime(java.lang.String handOffTime) {
                this.handOffTime = handOffTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WeeklySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WeeklySettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WeeklySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WeeklySettingProperty {
            private final java.lang.String dayOfWeek;
            private final java.lang.String handOffTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dayOfWeek = software.amazon.jsii.Kernel.get(this, "dayOfWeek", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.handOffTime = software.amazon.jsii.Kernel.get(this, "handOffTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dayOfWeek = java.util.Objects.requireNonNull(builder.dayOfWeek, "dayOfWeek is required");
                this.handOffTime = java.util.Objects.requireNonNull(builder.handOffTime, "handOffTime is required");
            }

            @Override
            public final java.lang.String getDayOfWeek() {
                return this.dayOfWeek;
            }

            @Override
            public final java.lang.String getHandOffTime() {
                return this.handOffTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dayOfWeek", om.valueToTree(this.getDayOfWeek()));
                data.set("handOffTime", om.valueToTree(this.getHandOffTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnRotation.WeeklySettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WeeklySettingProperty.Jsii$Proxy that = (WeeklySettingProperty.Jsii$Proxy) o;

                if (!dayOfWeek.equals(that.dayOfWeek)) return false;
                return this.handOffTime.equals(that.handOffTime);
            }

            @Override
            public final int hashCode() {
                int result = this.dayOfWeek.hashCode();
                result = 31 * result + (this.handOffTime.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssmcontacts.CfnRotation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssmcontacts.CfnRotation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssmcontacts.CfnRotationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssmcontacts.CfnRotationProps.Builder();
        }

        /**
         * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
         * <p>
         * <blockquote>
         * <p>
         * Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code> and <code>ONCALL_SCHEDULE</code> are not supported for this operation.
         * <p>
         * </blockquote>
         * <p>
         * The order in which you list the contacts is their shift order in the rotation schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-contactids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-contactids</a>
         * @param contactIds The Amazon Resource Names (ARNs) of the contacts to add to the rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactIds(final java.util.List<java.lang.String> contactIds) {
            this.props.contactIds(contactIds);
            return this;
        }

        /**
         * The name for the rotation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-name</a>
         * @param name The name for the rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Information about the rule that specifies when shift team members rotate.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-recurrence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-recurrence</a>
         * @param recurrence Information about the rule that specifies when shift team members rotate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recurrence(final software.amazon.awscdk.IResolvable recurrence) {
            this.props.recurrence(recurrence);
            return this;
        }
        /**
         * Information about the rule that specifies when shift team members rotate.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-recurrence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-recurrence</a>
         * @param recurrence Information about the rule that specifies when shift team members rotate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recurrence(final software.amazon.awscdk.services.ssmcontacts.CfnRotation.RecurrenceSettingsProperty recurrence) {
            this.props.recurrence(recurrence);
            return this;
        }

        /**
         * The date and time the rotation goes into effect.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-starttime</a>
         * @param startTime The date and time the rotation goes into effect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(final java.lang.String startTime) {
            this.props.startTime(startTime);
            return this;
        }

        /**
         * The time zone to base the rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format.
         * <p>
         * For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://docs.aws.amazon.com/https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
         * <p>
         * <blockquote>
         * <p>
         * Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time (PST), are not supported.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-timezoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-timezoneid</a>
         * @param timeZoneId The time zone to base the rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZoneId(final java.lang.String timeZoneId) {
            this.props.timeZoneId(timeZoneId);
            return this;
        }

        /**
         * Optional metadata to assign to the rotation.
         * <p>
         * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident Manager resources</a> in the <em>Incident Manager User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-tags</a>
         * @param tags Optional metadata to assign to the rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ssmcontacts.CfnRotation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssmcontacts.CfnRotation build() {
            return new software.amazon.awscdk.services.ssmcontacts.CfnRotation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
