package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for DynamoDeleteItem Task using JSONata.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * Object assign;
 * DynamoAttributeValue dynamoAttributeValue;
 * Object outputs;
 * Table table;
 * TaskRole taskRole;
 * Timeout timeout;
 * DynamoDeleteItemJsonataProps dynamoDeleteItemJsonataProps = DynamoDeleteItemJsonataProps.builder()
 *         .key(Map.of(
 *                 "keyKey", dynamoAttributeValue))
 *         .table(table)
 *         // the properties below are optional
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .comment("comment")
 *         .conditionExpression("conditionExpression")
 *         .credentials(Credentials.builder()
 *                 .role(taskRole)
 *                 .build())
 *         .expressionAttributeNames(Map.of(
 *                 "expressionAttributeNamesKey", "expressionAttributeNames"))
 *         .expressionAttributeValues(Map.of(
 *                 "expressionAttributeValuesKey", dynamoAttributeValue))
 *         .heartbeat(Duration.minutes(30))
 *         .heartbeatTimeout(timeout)
 *         .integrationPattern(IntegrationPattern.REQUEST_RESPONSE)
 *         .outputs(outputs)
 *         .queryLanguage(QueryLanguage.JSON_PATH)
 *         .returnConsumedCapacity(DynamoConsumedCapacity.INDEXES)
 *         .returnItemCollectionMetrics(DynamoItemCollectionMetrics.SIZE)
 *         .returnValues(DynamoReturnValues.NONE)
 *         .stateName("stateName")
 *         .taskTimeout(timeout)
 *         .timeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:24.963Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.DynamoDeleteItemJsonataProps")
@software.amazon.jsii.Jsii.Proxy(DynamoDeleteItemJsonataProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DynamoDeleteItemJsonataProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateJsonataBaseProps {

    /**
     * Primary key of the item to retrieve.
     * <p>
     * For the primary key, you must provide all of the attributes.
     * For example, with a simple primary key, you only need to provide a value for the partition key.
     * For a composite primary key, you must provide values for both the partition key and the sort key.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> getKey();

    /**
     * The name of the table containing the requested item.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable getTable();

    /**
     * A condition that must be satisfied in order for a conditional DeleteItem to succeed.
     * <p>
     * Default: - No condition expression
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ConditionExpression">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ConditionExpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConditionExpression() {
        return null;
    }

    /**
     * One or more substitution tokens for attribute names in an expression.
     * <p>
     * Default: - No expression attribute names
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeNames">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeNames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
        return null;
    }

    /**
     * One or more values that can be substituted in an expression.
     * <p>
     * Default: - No expression attribute values
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeValues">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeValues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> getExpressionAttributeValues() {
        return null;
    }

    /**
     * Determines the level of detail about provisioned throughput consumption that is returned in the response.
     * <p>
     * Default: DynamoConsumedCapacity.NONE
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnConsumedCapacity">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnConsumedCapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
        return null;
    }

    /**
     * Determines whether item collection metrics are returned.
     * <p>
     * If set to SIZE, the response includes statistics about item collections, if any,
     * that were modified during the operation are returned in the response.
     * If set to NONE (the default), no statistics are returned.
     * <p>
     * Default: DynamoItemCollectionMetrics.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
        return null;
    }

    /**
     * Use ReturnValues if you want to get the item attributes as they appeared before they were deleted.
     * <p>
     * Default: DynamoReturnValues.NONE
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnValues">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnValues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues getReturnValues() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DynamoDeleteItemJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DynamoDeleteItemJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DynamoDeleteItemJsonataProps> {
        java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> key;
        software.amazon.awscdk.services.dynamodb.ITable table;
        java.lang.String conditionExpression;
        java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> expressionAttributeValues;
        software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics;
        software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getKey}
         * @param key Primary key of the item to retrieve. This parameter is required.
         *            For the primary key, you must provide all of the attributes.
         *            For example, with a simple primary key, you only need to provide a value for the partition key.
         *            For a composite primary key, you must provide values for both the partition key and the sort key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder key(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> key) {
            this.key = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue>)key;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getTable}
         * @param table The name of the table containing the requested item. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(software.amazon.awscdk.services.dynamodb.ITable table) {
            this.table = table;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getConditionExpression}
         * @param conditionExpression A condition that must be satisfied in order for a conditional DeleteItem to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditionExpression(java.lang.String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getExpressionAttributeNames}
         * @param expressionAttributeNames One or more substitution tokens for attribute names in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expressionAttributeNames(java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames) {
            this.expressionAttributeNames = expressionAttributeNames;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getExpressionAttributeValues}
         * @param expressionAttributeValues One or more values that can be substituted in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder expressionAttributeValues(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue>)expressionAttributeValues;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getReturnConsumedCapacity}
         * @param returnConsumedCapacity Determines the level of detail about provisioned throughput consumption that is returned in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnConsumedCapacity(software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getReturnItemCollectionMetrics}
         * @param returnItemCollectionMetrics Determines whether item collection metrics are returned.
         *                                    If set to SIZE, the response includes statistics about item collections, if any,
         *                                    that were modified during the operation are returned in the response.
         *                                    If set to NONE (the default), no statistics are returned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnItemCollectionMetrics(software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getReturnValues}
         * @param returnValues Use ReturnValues if you want to get the item attributes as they appeared before they were deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnValues(software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemJsonataProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DynamoDeleteItemJsonataProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DynamoDeleteItemJsonataProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DynamoDeleteItemJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDeleteItemJsonataProps {
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> key;
        private final software.amazon.awscdk.services.dynamodb.ITable table;
        private final java.lang.String conditionExpression;
        private final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> expressionAttributeValues;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue.class)));
            this.table = software.amazon.jsii.Kernel.get(this, "table", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITable.class));
            this.conditionExpression = software.amazon.jsii.Kernel.get(this, "conditionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.expressionAttributeNames = software.amazon.jsii.Kernel.get(this, "expressionAttributeNames", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.expressionAttributeValues = software.amazon.jsii.Kernel.get(this, "expressionAttributeValues", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue.class)));
            this.returnConsumedCapacity = software.amazon.jsii.Kernel.get(this, "returnConsumedCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity.class));
            this.returnItemCollectionMetrics = software.amazon.jsii.Kernel.get(this, "returnItemCollectionMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics.class));
            this.returnValues = software.amazon.jsii.Kernel.get(this, "returnValues", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue>)java.util.Objects.requireNonNull(builder.key, "key is required");
            this.table = java.util.Objects.requireNonNull(builder.table, "table is required");
            this.conditionExpression = builder.conditionExpression;
            this.expressionAttributeNames = builder.expressionAttributeNames;
            this.expressionAttributeValues = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue>)builder.expressionAttributeValues;
            this.returnConsumedCapacity = builder.returnConsumedCapacity;
            this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
            this.returnValues = builder.returnValues;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.outputs = builder.outputs;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> getKey() {
            return this.key;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ITable getTable() {
            return this.table;
        }

        @Override
        public final java.lang.String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> getExpressionAttributeValues() {
            return this.expressionAttributeValues;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues getReturnValues() {
            return this.returnValues;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("table", om.valueToTree(this.getTable()));
            if (this.getConditionExpression() != null) {
                data.set("conditionExpression", om.valueToTree(this.getConditionExpression()));
            }
            if (this.getExpressionAttributeNames() != null) {
                data.set("expressionAttributeNames", om.valueToTree(this.getExpressionAttributeNames()));
            }
            if (this.getExpressionAttributeValues() != null) {
                data.set("expressionAttributeValues", om.valueToTree(this.getExpressionAttributeValues()));
            }
            if (this.getReturnConsumedCapacity() != null) {
                data.set("returnConsumedCapacity", om.valueToTree(this.getReturnConsumedCapacity()));
            }
            if (this.getReturnItemCollectionMetrics() != null) {
                data.set("returnItemCollectionMetrics", om.valueToTree(this.getReturnItemCollectionMetrics()));
            }
            if (this.getReturnValues() != null) {
                data.set("returnValues", om.valueToTree(this.getReturnValues()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.DynamoDeleteItemJsonataProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DynamoDeleteItemJsonataProps.Jsii$Proxy that = (DynamoDeleteItemJsonataProps.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!table.equals(that.table)) return false;
            if (this.conditionExpression != null ? !this.conditionExpression.equals(that.conditionExpression) : that.conditionExpression != null) return false;
            if (this.expressionAttributeNames != null ? !this.expressionAttributeNames.equals(that.expressionAttributeNames) : that.expressionAttributeNames != null) return false;
            if (this.expressionAttributeValues != null ? !this.expressionAttributeValues.equals(that.expressionAttributeValues) : that.expressionAttributeValues != null) return false;
            if (this.returnConsumedCapacity != null ? !this.returnConsumedCapacity.equals(that.returnConsumedCapacity) : that.returnConsumedCapacity != null) return false;
            if (this.returnItemCollectionMetrics != null ? !this.returnItemCollectionMetrics.equals(that.returnItemCollectionMetrics) : that.returnItemCollectionMetrics != null) return false;
            if (this.returnValues != null ? !this.returnValues.equals(that.returnValues) : that.returnValues != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.table.hashCode());
            result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeNames != null ? this.expressionAttributeNames.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeValues != null ? this.expressionAttributeValues.hashCode() : 0);
            result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
            result = 31 * result + (this.returnItemCollectionMetrics != null ? this.returnItemCollectionMetrics.hashCode() : 0);
            result = 31 * result + (this.returnValues != null ? this.returnValues.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
