package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A StepFunctions task to call DynamoUpdateItem.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table myTable;
 * DynamoUpdateItem.Builder.create(this, "UpdateItem")
 *         .key(Map.of(
 *                 "MessageId", DynamoAttributeValue.fromString("message-007")))
 *         .table(myTable)
 *         .expressionAttributeValues(Map.of(
 *                 ":val", DynamoAttributeValue.numberFromString(JsonPath.stringAt("$.Item.TotalCount.N")),
 *                 ":rand", DynamoAttributeValue.fromNumber(20)))
 *         .updateExpression("SET TotalCount = :val + :rand")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:24.986Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.DynamoUpdateItem")
public class DynamoUpdateItem extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected DynamoUpdateItem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DynamoUpdateItem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DynamoUpdateItem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A StepFunctions task using JSONata to call DynamoUpdateItem.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem jsonata(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItemJsonataProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem.class, "jsonata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A StepFunctions task using JSONPath to call DynamoUpdateItem.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem jsonPath(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItemJsonPathProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem.class, "jsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItemProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItemProps.Builder();
        }

        /**
         * A comment describing this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment A comment describing this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The name of the query language used by the state.
         * <p>
         * If the state does not contain a <code>queryLanguage</code> field,
         * then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * <p>
         * Default: - JSONPath
         * <p>
         * @return {@code this}
         * @param queryLanguage The name of the query language used by the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.props.queryLanguage(queryLanguage);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        /**
         * Credentials for an IAM Role that the State Machine assumes for executing the task.
         * <p>
         * This enables cross-account resource invocations.
         * <p>
         * Default: - None (Task is executed using the State Machine's execution role)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html</a>
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * (deprecated) Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>heartbeatTimeout</code>
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(final software.amazon.awscdk.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeatTimeout Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns.
         * <p>
         * Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * <p>
         * Default: - `IntegrationPattern.REQUEST_RESPONSE` for most tasks.
         * `IntegrationPattern.RUN_JOB` for the following exceptions:
         * `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html</a>
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * Timeout for the task.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param taskTimeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        /**
         * (deprecated) Timeout for the task.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>taskTimeout</code>
         * @param timeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * Workflow variables to store in this step.
         * <p>
         * Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * <p>
         * Default: - Not assign variables
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html">https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html</a>
         * @param assign Workflow variables to store in this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assign(final java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.props.assign(assign);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * Used to specify and transform output from the state.
         * <p>
         * When specified, the value overrides the state output default.
         * The output field accepts any JSON value (object, array, string, number, boolean, null).
         * Any string value, including those inside objects or arrays,
         * will be evaluated as JSONata if surrounded by {% %} characters.
         * Output also accepts a JSONata expression directly.
         * <p>
         * Default: - $states.result or $states.errorOutput
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html</a>
         * @param outputs Used to specify and transform output from the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.lang.Object outputs) {
            this.props.outputs(outputs);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * Primary key of the item to retrieve.
         * <p>
         * For the primary key, you must provide all of the attributes.
         * For example, with a simple primary key, you only need to provide a value for the partition key.
         * For a composite primary key, you must provide values for both the partition key and the sort key.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key</a>
         * @param key Primary key of the item to retrieve. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> key) {
            this.props.key(key);
            return this;
        }

        /**
         * The name of the table containing the requested item.
         * <p>
         * @return {@code this}
         * @param table The name of the table containing the requested item. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(final software.amazon.awscdk.services.dynamodb.ITable table) {
            this.props.table(table);
            return this;
        }

        /**
         * A condition that must be satisfied in order for a conditional DeleteItem to succeed.
         * <p>
         * Default: - No condition expression
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ConditionExpression">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ConditionExpression</a>
         * @param conditionExpression A condition that must be satisfied in order for a conditional DeleteItem to succeed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditionExpression(final java.lang.String conditionExpression) {
            this.props.conditionExpression(conditionExpression);
            return this;
        }

        /**
         * One or more substitution tokens for attribute names in an expression.
         * <p>
         * Default: - No expression attribute names
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ExpressionAttributeNames">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ExpressionAttributeNames</a>
         * @param expressionAttributeNames One or more substitution tokens for attribute names in an expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expressionAttributeNames(final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames) {
            this.props.expressionAttributeNames(expressionAttributeNames);
            return this;
        }

        /**
         * One or more values that can be substituted in an expression.
         * <p>
         * Default: - No expression attribute values
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ExpressionAttributeValues">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ExpressionAttributeValues</a>
         * @param expressionAttributeValues One or more values that can be substituted in an expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expressionAttributeValues(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> expressionAttributeValues) {
            this.props.expressionAttributeValues(expressionAttributeValues);
            return this;
        }

        /**
         * Determines the level of detail about provisioned throughput consumption that is returned in the response.
         * <p>
         * Default: DynamoConsumedCapacity.NONE
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ReturnConsumedCapacity">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ReturnConsumedCapacity</a>
         * @param returnConsumedCapacity Determines the level of detail about provisioned throughput consumption that is returned in the response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnConsumedCapacity(final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity) {
            this.props.returnConsumedCapacity(returnConsumedCapacity);
            return this;
        }

        /**
         * Determines whether item collection metrics are returned.
         * <p>
         * If set to SIZE, the response includes statistics about item collections, if any,
         * that were modified during the operation are returned in the response.
         * If set to NONE (the default), no statistics are returned.
         * <p>
         * Default: DynamoItemCollectionMetrics.NONE
         * <p>
         * @return {@code this}
         * @param returnItemCollectionMetrics Determines whether item collection metrics are returned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnItemCollectionMetrics(final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics) {
            this.props.returnItemCollectionMetrics(returnItemCollectionMetrics);
            return this;
        }

        /**
         * Use ReturnValues if you want to get the item attributes as they appeared before they were deleted.
         * <p>
         * Default: DynamoReturnValues.NONE
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ReturnValues">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ReturnValues</a>
         * @param returnValues Use ReturnValues if you want to get the item attributes as they appeared before they were deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnValues(final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues) {
            this.props.returnValues(returnValues);
            return this;
        }

        /**
         * An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.
         * <p>
         * Default: - No update expression
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-UpdateExpression">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-UpdateExpression</a>
         * @param updateExpression An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateExpression(final java.lang.String updateExpression) {
            this.props.updateExpression(updateExpression);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItem(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
