package software.amazon.awscdk.services.synthetics;

/**
 * Resources that tags applied to a canary should be replicated to.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_7_0)
 *         .resourcesToReplicateTags(List.of(ResourceToReplicateTags.LAMBDA_FUNCTION))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:25.340Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.ResourceToReplicateTags")
public enum ResourceToReplicateTags {
    /**
     * Replicate canary tags to the Lambda function.
     * <p>
     * When specified, CloudWatch Synthetics will keep the tags of the canary
     * and the Lambda function synchronized. Any future changes made to the
     * canary's tags will also be applied to the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA_FUNCTION,
}
