package software.amazon.awscdk.assertions;

/**
 * The result of <code>Match.test()</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.assertions.*;
 * Object target;
 * MatchResult matchResult = new MatchResult(target);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.090Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.MatchResult")
public class MatchResult extends software.amazon.jsii.JsiiObject {

    protected MatchResult(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MatchResult(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MatchResult(final @org.jetbrains.annotations.NotNull java.lang.Object target) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { target });
    }

    /**
     * Compose the results of a previous match as a subtree.
     * <p>
     * @param id the id of the parent tree. This parameter is required.
     * @param inner This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchResult compose(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchResult inner) {
        return software.amazon.jsii.Kernel.call(this, "compose", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.MatchResult.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(inner, "inner is required") });
    }

    /**
     * Prepare the result to be analyzed.
     * <p>
     * This API <em>must</em> be called prior to analyzing these results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchResult finished() {
        return software.amazon.jsii.Kernel.call(this, "finished", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.MatchResult.class));
    }

    /**
     * Does the result contain any failures.
     * <p>
     * If not, the result is a success
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean hasFailed() {
        return software.amazon.jsii.Kernel.call(this, "hasFailed", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (deprecated) DEPRECATED.
     * <p>
     * @deprecated use recordFailure()
     * @param matcher This parameter is required.
     * @param path This parameter is required.
     * @param message This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchResult push(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher matcher, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> path, final @org.jetbrains.annotations.NotNull java.lang.String message) {
        return software.amazon.jsii.Kernel.call(this, "push", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.MatchResult.class), new Object[] { java.util.Objects.requireNonNull(matcher, "matcher is required"), java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Record a capture against in this match result.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void recordCapture(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchCapture options) {
        software.amazon.jsii.Kernel.call(this, "recordCapture", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Record a new failure into this result at a specific path.
     * <p>
     * @param failure This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchResult recordFailure(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.MatchFailure failure) {
        return software.amazon.jsii.Kernel.call(this, "recordFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.MatchResult.class), new Object[] { java.util.Objects.requireNonNull(failure, "failure is required") });
    }

    /**
     * Do a deep render of the match result, showing the structure mismatches in context.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String renderMismatch() {
        return software.amazon.jsii.Kernel.call(this, "renderMismatch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Render the failed match in a presentable way.
     * <p>
     * Prefer using <code>renderMismatch</code> over this method. It is left for backwards
     * compatibility for test suites that expect it, but <code>renderMismatch()</code> will
     * produce better output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> toHumanStrings() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toHumanStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The cost of the failures so far.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getFailCost() {
        return software.amazon.jsii.Kernel.get(this, "failCost", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of failures.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getFailCount() {
        return software.amazon.jsii.Kernel.get(this, "failCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Whether the match is a success.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsSuccess() {
        return software.amazon.jsii.Kernel.get(this, "isSuccess", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The target for which this result was generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTarget() {
        return software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
