package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * Properties to initialize <code>HttpSqsIntegration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sqs.*;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegration;
 * IQueue queue;
 * HttpApi httpApi;
 * // default integration (send message)
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/default")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("defaultIntegration")
 *                 .queue(queue)
 *                 .build())
 *         .build());
 * // send message integration
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/send-message")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("sendMessageIntegration")
 *                 .queue(queue)
 *                 .subtype(HttpIntegrationSubtype.SQS_SEND_MESSAGE)
 *                 .build())
 *         .build());
 * // receive message integration
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/receive-message")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("receiveMessageIntegration")
 *                 .queue(queue)
 *                 .subtype(HttpIntegrationSubtype.SQS_RECEIVE_MESSAGE)
 *                 .build())
 *         .build());
 * // delete message integration
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/delete-message")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("deleteMessageIntegration")
 *                 .queue(queue)
 *                 .subtype(HttpIntegrationSubtype.SQS_DELETE_MESSAGE)
 *                 .build())
 *         .build());
 * // purge queue integration
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/purge-queue")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("purgeQueueIntegration")
 *                 .queue(queue)
 *                 .subtype(HttpIntegrationSubtype.SQS_PURGE_QUEUE)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.708Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.HttpSqsIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(HttpSqsIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpSqsIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * SQS queue that Integrates with API Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue getQueue();

    /**
     * Specifies how to transform HTTP requests before sending them to the backend.
     * <p>
     * Default: - specify `QueueUrl`. Additionally, set `MessageBody` to `$request.body.MessageBody` for `SQS_SEND_MESSAGE` subtype
     * and set `ReceiptHandle` to `$request.body.ReceiptHandle` for `SQS_DELETE_MESSAGE` subtype.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
        return null;
    }

    /**
     * The subtype of the HTTP integration.
     * <p>
     * Only subtypes starting with SQS_ can be specified.
     * <p>
     * Default: HttpIntegrationSubtype.SQS_SEND_MESSAGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype getSubtype() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpSqsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpSqsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpSqsIntegrationProps> {
        software.amazon.awscdk.services.sqs.IQueue queue;
        software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype;

        /**
         * Sets the value of {@link HttpSqsIntegrationProps#getQueue}
         * @param queue SQS queue that Integrates with API Gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queue(software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
            return this;
        }

        /**
         * Sets the value of {@link HttpSqsIntegrationProps#getParameterMapping}
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.parameterMapping = parameterMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpSqsIntegrationProps#getSubtype}
         * @param subtype The subtype of the HTTP integration.
         *                Only subtypes starting with SQS_ can be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subtype(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpSqsIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpSqsIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpSqsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpSqsIntegrationProps {
        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        private final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queue = software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.parameterMapping = software.amazon.jsii.Kernel.get(this, "parameterMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class));
            this.subtype = software.amazon.jsii.Kernel.get(this, "subtype", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queue = java.util.Objects.requireNonNull(builder.queue, "queue is required");
            this.parameterMapping = builder.parameterMapping;
            this.subtype = builder.subtype;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getQueue() {
            return this.queue;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
            return this.parameterMapping;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype getSubtype() {
            return this.subtype;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queue", om.valueToTree(this.getQueue()));
            if (this.getParameterMapping() != null) {
                data.set("parameterMapping", om.valueToTree(this.getParameterMapping()));
            }
            if (this.getSubtype() != null) {
                data.set("subtype", om.valueToTree(this.getSubtype()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2_integrations.HttpSqsIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpSqsIntegrationProps.Jsii$Proxy that = (HttpSqsIntegrationProps.Jsii$Proxy) o;

            if (!queue.equals(that.queue)) return false;
            if (this.parameterMapping != null ? !this.parameterMapping.equals(that.parameterMapping) : that.parameterMapping != null) return false;
            return this.subtype != null ? this.subtype.equals(that.subtype) : that.subtype == null;
        }

        @Override
        public final int hashCode() {
            int result = this.queue.hashCode();
            result = 31 * result + (this.parameterMapping != null ? this.parameterMapping.hashCode() : 0);
            result = 31 * result + (this.subtype != null ? this.subtype.hashCode() : 0);
            return result;
        }
    }
}
