package software.amazon.awscdk.customresources;

/**
 * Physical ID of the custom resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String crossAccountRoleArn = "arn:aws:iam::OTHERACCOUNT:role/CrossAccountRoleName"; // arn of role deployed in separate account
 * String callRegion = "us-west-1"; // sdk call to be made in specified region (optional)
 *  // sdk call to be made in specified region (optional)
 * AwsCustomResource.Builder.create(this, "CrossAccount")
 *         .onCreate(AwsSdkCall.builder()
 *                 .assumedRoleArn(crossAccountRoleArn)
 *                 .region(callRegion) // optional
 *                 .service("sts")
 *                 .action("GetCallerIdentity")
 *                 .physicalResourceId(PhysicalResourceId.of("id"))
 *                 .build())
 *         .policy(AwsCustomResourcePolicy.fromStatements(List.of(PolicyStatement.fromJson(Map.of(
 *                 "Effect", "Allow",
 *                 "Action", "sts:AssumeRole",
 *                 "Resource", crossAccountRoleArn)))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:42.407Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.PhysicalResourceId")
public class PhysicalResourceId extends software.amazon.jsii.JsiiObject {

    protected PhysicalResourceId(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PhysicalResourceId(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Extract the physical resource id from the path (dot notation) to the data in the API call response.
     * <p>
     * @param responsePath This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.PhysicalResourceId fromResponse(final @org.jetbrains.annotations.NotNull java.lang.String responsePath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.PhysicalResourceId.class, "fromResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.PhysicalResourceId.class), new Object[] { java.util.Objects.requireNonNull(responsePath, "responsePath is required") });
    }

    /**
     * Explicit physical resource id.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.PhysicalResourceId of(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.PhysicalResourceId.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.PhysicalResourceId.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Literal string to be used as the physical id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Path to a response data element to be used as the physical id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResponsePath() {
        return software.amazon.jsii.Kernel.get(this, "responsePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
