package software.amazon.awscdk.customresources;

/**
 * Reference to the physical resource id that can be passed to the AWS operation as a parameter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsCustomResource awsCustom = AwsCustomResource.Builder.create(this, "aws-custom")
 *         .onCreate(AwsSdkCall.builder()
 *                 .service("...")
 *                 .action("...")
 *                 .parameters(Map.of(
 *                         "text", "..."))
 *                 .physicalResourceId(PhysicalResourceId.of("..."))
 *                 .build())
 *         .onUpdate(AwsSdkCall.builder()
 *                 .service("...")
 *                 .action("...")
 *                 .parameters(Map.of(
 *                         "text", "...",
 *                         "resourceId", new PhysicalResourceIdReference()))
 *                 .build())
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:42.407Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.PhysicalResourceIdReference")
public class PhysicalResourceIdReference extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.IResolvable {

    protected PhysicalResourceIdReference(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PhysicalResourceIdReference(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PhysicalResourceIdReference() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Produce the Token's value at resolution time.
     * <p>
     * @param _context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext _context) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(_context, "_context is required") });
    }

    /**
     * toJSON serialization to replace <code>PhysicalResourceIdReference</code> with a magic string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return a string representation of this resolvable object.
     * <p>
     * Returns a reversible string representation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The creation stack of this resolvable which will be appended to errors thrown during resolution.
     * <p>
     * This may return an array with a single informational element indicating how
     * to get this property populated, if it was skipped for performance reasons.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }
}
