package software.amazon.awscdk.customresources;

/**
 * A very simple StateMachine construct highly customized to the provider framework.
 * <p>
 * We previously used <code>CfnResource</code> instead of <code>CfnStateMachine</code> to avoid depending
 * on <code>aws-stepfunctions</code> module, but now it is okay.
 * <p>
 * The state machine continuously calls the isCompleteHandler, until it succeeds or times out.
 * The handler is called <code>maxAttempts</code> times with an <code>interval</code> duration and a <code>backoffRate</code> rate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.customresources.*;
 * Function function_;
 * LogGroup logGroup;
 * WaiterStateMachine waiterStateMachine = WaiterStateMachine.Builder.create(this, "MyWaiterStateMachine")
 *         .backoffRate(123)
 *         .interval(Duration.minutes(30))
 *         .isCompleteHandler(function_)
 *         .maxAttempts(123)
 *         .timeoutHandler(function_)
 *         // the properties below are optional
 *         .disableLogging(false)
 *         .logOptions(LogOptions.builder()
 *                 .destination(logGroup)
 *                 .includeExecutionData(false)
 *                 .level(LogLevel.OFF)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:42.411Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.WaiterStateMachine")
public class WaiterStateMachine extends software.constructs.Construct {

    protected WaiterStateMachine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WaiterStateMachine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.customresources.WaiterStateMachine.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WaiterStateMachine(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.WaiterStateMachineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Grant the given identity permissions on StartExecution of the state machine.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantStartExecution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantStartExecution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of the state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStateMachineArn() {
        return software.amazon.jsii.Kernel.get(this, "stateMachineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.customresources.WaiterStateMachine}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.customresources.WaiterStateMachine> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.customresources.WaiterStateMachineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.customresources.WaiterStateMachineProps.Builder();
        }

        /**
         * Backoff between attempts.
         * <p>
         * @return {@code this}
         * @param backoffRate Backoff between attempts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backoffRate(final java.lang.Number backoffRate) {
            this.props.backoffRate(backoffRate);
            return this;
        }

        /**
         * The interval to wait between attempts.
         * <p>
         * @return {@code this}
         * @param interval The interval to wait between attempts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(final software.amazon.awscdk.Duration interval) {
            this.props.interval(interval);
            return this;
        }

        /**
         * The main handler that notifies if the waiter to decide 'complete' or 'incomplete'.
         * <p>
         * @return {@code this}
         * @param isCompleteHandler The main handler that notifies if the waiter to decide 'complete' or 'incomplete'. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isCompleteHandler(final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler) {
            this.props.isCompleteHandler(isCompleteHandler);
            return this;
        }

        /**
         * Number of attempts.
         * <p>
         * @return {@code this}
         * @param maxAttempts Number of attempts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAttempts(final java.lang.Number maxAttempts) {
            this.props.maxAttempts(maxAttempts);
            return this;
        }

        /**
         * The handler to call if the waiter times out and is incomplete.
         * <p>
         * @return {@code this}
         * @param timeoutHandler The handler to call if the waiter times out and is incomplete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutHandler(final software.amazon.awscdk.services.lambda.IFunction timeoutHandler) {
            this.props.timeoutHandler(timeoutHandler);
            return this;
        }

        /**
         * Whether logging for the state machine is disabled.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param disableLogging Whether logging for the state machine is disabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableLogging(final java.lang.Boolean disableLogging) {
            this.props.disableLogging(disableLogging);
            return this;
        }

        /**
         * Defines what execution history events are logged and where they are logged.
         * <p>
         * Default: - A default log group will be created if logging is enabled.
         * <p>
         * @return {@code this}
         * @param logOptions Defines what execution history events are logged and where they are logged. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logOptions(final software.amazon.awscdk.customresources.LogOptions logOptions) {
            this.props.logOptions(logOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.customresources.WaiterStateMachine}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.customresources.WaiterStateMachine build() {
            return new software.amazon.awscdk.customresources.WaiterStateMachine(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
