/**
 * <h1>Cloud Executable API</h1>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>V2 Feature Flags</h2>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-s3:createDefaultLoggingPolicy</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to create an S3 bucket policy by default in cases where
 * an AWS service would automatically create the Policy if one does not exist.
 * <p>
 * For example, in order to send VPC flow logs to an S3 bucket, there is a specific Bucket Policy
 * that needs to be attached to the bucket. If you create the bucket without a policy and then add the
 * bucket as the flow log destination, the service will automatically create the bucket policy with the
 * necessary permissions. If you were to then try and add your own bucket policy CloudFormation will throw
 * and error indicating that a bucket policy already exists.
 * <p>
 * In cases where we know what the required policy is we can go ahead and create the policy so we can
 * remain in control of it.
 * <p>
 * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-logs-infrastructure-S3">https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-logs-infrastructure-S3</a>
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-s3:createDefaultLoggingPolicy": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-sns-subscriptions:restrictSqsDescryption</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to restrict the decryption of a SQS queue, which is subscribed to a SNS topic, to
 * only the topic which it is subscribed to and not the whole SNS service of an account.
 * <p>
 * Previously the decryption was only restricted to the SNS service principal. To make the SQS subscription more
 * secure, it is a good practice to restrict the decryption further and only allow the connected SNS topic to decryption
 * the subscribed queue.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-sns-subscriptions:restrictSqsDescryption": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li>&#64;aws-cdk/aws-apigateway:disableCloudWatchRole</li>
 * </ul>
 * <p>
 * Enable this feature flag to change the default behavior for aws-apigateway.RestApi and aws-apigateway.SpecRestApi
 * to <em>not</em> create a CloudWatch role and Account. There is only a single ApiGateway account per AWS
 * environment which means that each time you create a RestApi in your account the ApiGateway account
 * is overwritten. If at some point the newest RestApi is deleted, the ApiGateway Account and CloudWatch
 * role will also be deleted, breaking any existing ApiGateways that were depending on them.
 * <p>
 * When this flag is enabled you should either create the ApiGateway account and CloudWatch role
 * separately <em>or</em> only enable the cloudWatchRole on a single RestApi.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-apigateway:disableCloudWatchRole": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/core:enablePartitionLiterals</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to have <code>Stack.partition</code> return a literal string for a stack's partition
 * when the stack has a known region configured.  If the region is undefined, or set to an unknown value, the
 * <code>Stack.partition</code> will be the CloudFormation intrinsic value <code>AWS::Partition</code>.  Without this feature flag,
 * <code>Stack.partition</code> always returns the CloudFormation intrinsic value <code>AWS::Partition</code>.
 * <p>
 * This feature will often simplify ARN strings in CDK generated templates, for example:
 * <p>
 * <blockquote><pre>
 *  Principal:
 *    AWS:
 *      Fn::Join:
 *        - ""
 *        - - "arn:"
 *          - Ref: AWS::Partition
 *          - :iam::123456789876:root
 * </pre></blockquote>
 * <p>
 * becomes:
 * <p>
 * <blockquote><pre>
 *  Principal:
 *    AWS: "arn:aws:iam::123456789876:root"
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to avoid setting the "ECS" deployment controller when adding a circuit breaker to an
 * ECS Service, as this will trigger a full replacement which fails to deploy when using set service names.
 * This does not change any behaviour as the default deployment controller when it is not defined is ECS.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to use S3 Bucket Policy for granting permission fo Server Access Logging
 * rather than using the canned <code>LogDeliveryWrite</code> ACL. ACLs do not work when Object Ownership is
 * enabled on the bucket.
 * <p>
 * This flag uses a Bucket Policy statement to allow Server Access Log delivery, following best
 * practices for S3.
 * <p>
 * <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html">https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html</a>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-rds:databaseProxyUniqueResourceName</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to use unique resource names for each <code>DatabaseProxy</code>.
 * <p>
 * Previously, the default behavior for <code>DatabaseProxy</code> was to use <code>id</code> of the constructor for <code>dbProxyName</code>.
 * In this case, users couldn't deploy <code>DatabaseProxy</code>s that have the same <code>id</code> in the same region.
 * <p>
 * This is a feature flag as the old behavior was technically incorrect, but users may have come to depend on it.
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-rds:databaseProxyUniqueResourceName": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-redshift:columnId</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to allow the CDK to track changes in Redshift columns through their <code>id</code> attribute. This is a breaking change, as the <code>name</code> attribute was currently being used to track changes to Redshift columns.
 * <p>
 * Enabling this feature flag comes at a risk for existing Redshift columns, as the <code>name</code> attribute of a redshift column was currently being used. Therefore, to change a Redshift columns' <code>name</code> will essentially create a new column and delete the old one. This will cause data loss. If you choose to enable this flag, ensure that upon intial deployment (the first deployment after setting this feature flag), the <code>name</code> attribute of every column is not changed. After the intial deployment, you can freely change the <code>name</code> attribute of a column.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-redshift:columnId": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to use the <code>AmazonEMRServicePolicy_v2</code> managed policies for the EMR service role.
 * <p>
 * This is a feature flag as the old behavior will be deprecated, but some resources may require manual
 * intervention since they might not have the appropriate tags propagated automatically.
 * <p>
 * <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html">https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html</a>
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/core:includePrefixInUniqueNameGeneration</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to include the stack's prefixes to the name generation process.
 * <p>
 * Not doing so can cause the name of stack to exceed 128 characters:
 * <p>
 * <ul>
 * <li>The name generation ensures it doesn't exceed 128 characters</li>
 * <li>Without this feature flag, the prefix is prepended to the generated name, which result can exceed 128 characters</li>
 * </ul>
 * <p>
 * This is a feature flag as it changes the name generated for stacks. Any CDK application deployed prior this fix will
 * most likely be generated with a new name, causing the stack to be recreated with the new name, and then deleting the old one.
 * For applications running on production environments this can be unmanageable.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/core:includePrefixInUniqueNameGeneration": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to automatically use the latest available NodeJS version in the aws-lambda-nodejse.Function construct.
 * <p>
 * This allows creation of new functions using a version that will automatically stay up to date without breaking bundling of existing functions that externalize packages included in their environemnt such as <code>aws-sdk</code>.
 * <p>
 * Functions defined previously will continue to function correctly as long as they pass an explicit runtime version, or do not exclude packages during bundling.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to update the default branch for CodeCommit source actions to <code>main</code>.
 * <p>
 * Previously, the default branch for CodeCommit source actions was set to <code>master</code>.
 * However, this convention is no longer supported, and repositories created after March 2021 now have <code>main</code> as
 * their default branch.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-cloudwatch-actions:changeLambdaPermissionLogicalIdForLambdaAction</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to change the logical ID of the <code>LambdaPermission</code> for the <code>LambdaAction</code> to include an alarm ID.
 * <p>
 * Previously, only one alarm with the <code>LambdaAction</code> could be created per Lambda.
 * This flag allows multiple alarms with the <code>LambdaAction</code> for the same Lambda to be created.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-cloudwatch-actions:changeLambdaPermissionLogicalIdForLambdaAction": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-codepipeline:crossAccountKeysDefaultValueToFalse</code></li>
 * </ul>
 * <p>
 * Enables Pipeline to set the default value for <code>crossAccountKeys</code> to false.
 * <p>
 * When this feature flag is enabled, and the <code>crossAccountKeys</code> property is not provided in a <code>Pipeline</code>
 * construct, the construct automatically defaults the value of this property to false.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-codepipeline:crossAccountKeysDefaultValueToFalse": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-codepipeline:defaultPipelineTypeToV2</code></li>
 * </ul>
 * <p>
 * Enables Pipeline to set the default pipeline type to V2.
 * <p>
 * When this feature flag is enabled, and the <code>pipelineType</code> property is not provided in a <code>Pipeline</code>
 * construct, the construct automatically defaults the value of this property to <code>PipelineType.V2</code>.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-codepipeline:defaultPipelineTypeToV2": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-kms:reduceCrossAccountRegionPolicyScope</code></li>
 * </ul>
 * <p>
 * Reduce resource scope of the IAM Policy created from KMS key grant to granting key only.
 * <p>
 * When this feature flag is enabled and calling KMS key grant method, the created IAM policy will reduce the resource scope from
 * '*' to this specific granting KMS key.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-kms:reduceCrossAccountRegionPolicyScope": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-kms:applyImportedAliasPermissionsToPrincipal</code></li>
 * </ul>
 * <p>
 * Enable grant methods on imported KMS Aliases to apply permissions scoped by the alias using the <code>kms:ResourceAliases</code> condition key. When this flag is disabled, grant* methods on <code>Alias.fromAliasName</code> remain no-ops to preserve existing behavior.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-kms:applyImportedAliasPermissionsToPrincipal": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-eks:nodegroupNameAttribute</code></li>
 * </ul>
 * <p>
 * When enabled, nodegroupName attribute of the provisioned EKS NodeGroup will not have the cluster name prefix.
 * <p>
 * When this feature flag is enabled, the nodegroupName attribute will be exactly the name of the nodegroup
 * without any prefix.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-eks:nodegroupNameAttribute": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ec2:ebsDefaultGp3Volume</code></li>
 * </ul>
 * <p>
 * When enabled, the default volume type of the EBS volume will be GP3.
 * <p>
 * When this featuer flag is enabled, the default volume type of the EBS volume will be <code>EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3</code>
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ec2:ebsDefaultGp3Volume": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ecs:removeDefaultDeploymentAlarm</code></li>
 * </ul>
 * <p>
 * When enabled, remove default deployment alarm settings.
 * <p>
 * When this featuer flag is enabled, remove the default deployment alarm settings when creating a AWS ECS service.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ec2:ebsDefaultGp3Volume": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-stepfunctions-tasks:ecsReduceRunTaskPermissions</code></li>
 * </ul>
 * <p>
 * When enabled, IAM Policy created to run tasks won't include the task definition ARN, only the revision ARN.
 * <p>
 * When this feature flag is enabled, the IAM Policy created to run tasks won't include the task definition ARN, only the revision ARN.
 * The revision ARN is more specific than the task definition ARN. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/ecs-iam.html">https://docs.aws.amazon.com/step-functions/latest/dg/ecs-iam.html</a>
 * for more details.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-stepfunctions-tasks:ecsReduceRunTaskPermissions": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-stepfunctions-taks:useNewS3UriParametersForBedrockInvokeModelTask</code></li>
 * </ul>
 * <p>
 * When enabled, use new props for S3 URI under <code>input</code> and <code>output</code> fields in task definition of state machine for bedrock invoke model.
 * <p>
 * When this feature flag is enabled, use newly introduced props <code>s3InputUri</code> and <code>s3OutputUri</code> to populate S3 uri under input and output fields in state machine task definition for Bedrock invoke model.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-stepfunctions-tasks:useNewS3UriParametersForBedrockInvokeModelTask": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ecs:reduceEc2FargateCloudWatchPermissions</code></li>
 * </ul>
 * <p>
 * Currently, we will automatically add a number of cloudwatch permissions to the task role when no cloudwatch log group is
 * specified as logConfiguration and it will grant 'Resources': ['*'] to the task role.
 * <p>
 * When this feature flag is enabled, we will only grant the necessary permissions when users specify cloudwatch log group.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ecs:reduceEc2FargateCloudWatchPermissions": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ec2:ec2SumTImeoutEnabled</code></li>
 * </ul>
 * <p>
 * Currently is both initOptions.timeout and resourceSignalTimeout are both specified in the options for creating an EC2 Instance, only the value from 'resourceSignalTimeout' will be used.
 * <p>
 * When this feature flag is enabled, if both initOptions.timeout and resourceSignalTimeout are specified, the values will to be summed together.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ec2:ec2SumTImeoutEnabled": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-appsync:appSyncGraphQLAPIScopeLambdaPermission</code></li>
 * </ul>
 * <p>
 * Currently, when using a Lambda authorizer with an AppSync GraphQL API, the AWS CDK automatically generates the necessary AWS::Lambda::Permission to allow the AppSync API to invoke the Lambda authorizer. This permission is overly permissive because it lacks a SourceArn, meaning it allows invocations from any source.
 * <p>
 * When this feature flag is enabled, the AWS::Lambda::Permission will be properly scoped with the SourceArn corresponding to the specific AppSync GraphQL API.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ec2:appSyncGraphQLAPIScopeLambdaPermission": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-rds:setCorrectValueForDatabaseInstanceReadReplicaInstanceResourceId</code></li>
 * </ul>
 * <p>
 * When enabled, the value of property <code>instanceResourceId</code> in construct <code>DatabaseInstanceReadReplica</code> will be set to the correct value which is <code>DbiResourceId</code> instead of currently <code>DbInstanceArn</code>* (fix)
 * <p>
 * When this feature flag is enabled, the value of that property will be as expected set to <code>DbiResourceId</code> attribute, and that will fix the grantConnect method.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-rds:setCorrectValueForDatabaseInstanceReadReplicaInstanceResourceId": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-lambda-nodejs:sdkV3ExcludeSmithyPackages</code></li>
 * </ul>
 * <p>
 * Currently, when bundling Lambda functions with the non-latest runtime that supports AWS SDK JavaScript (v3), only the <code>&#64;aws-sdk/*</code> packages are excluded by default.
 * However, this can cause version mismatches between the <code>&#64;aws-sdk/*</code> and <code>&#64;smithy/*</code> packages, as they are tightly coupled dependencies in AWS SDK v3.
 * <p>
 * When this feature flag is enabled, both <code>&#64;aws-sdk/*</code> and <code>&#64;smithy/*</code> packages will be excluded during the bundling process. This ensures that no mismatches
 * occur between these tightly coupled dependencies when using the AWS SDK v3 in Lambda functions.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-lambda-nodejs:sdkV3ExcludeSmithyPackages": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-dynamodb:resourcePolicyPerReplica</code></li>
 * </ul>
 * <p>
 * If this flag is not set, the default behavior for <code>TableV2</code> is to use a different <code>resourcePolicy</code> for each replica.
 * <p>
 * If this flag is set to false, the behavior is that each replica shares the same <code>resourcePolicy</code> as the source table.
 * This will prevent you from creating a new table which has an additional replica and a resource policy.
 * <p>
 * This is a feature flag as the old behavior was technically incorrect but users may have come to depend on it.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-dynamodb:resourcePolicyPerReplica": false,
 *   },
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-route53-targets:userPoolDomainNameMethodWithoutCustomResource</code></li>
 * </ul>
 * <p>
 * When enabled, use a new method for DNS Name of user pool domain target without creating a custom resource.
 * <p>
 * When this feature flag is enabled, a new method will be used to get the DNS Name of the user pool domain target. The old method
 * creates a custom resource internally, but the new method doesn't need a custom resource.
 * <p>
 * If the flag is set to false then a custom resource will be created when using <code>UserPoolDomainTarget</code>.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-route53-targets:userPoolDomainNameMethodWithoutCustomResource": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ecs:disableEcsImdsBlocking</code></li>
 * </ul>
 * <p>
 * When set to true, CDK synth will throw exception if canContainersAccessInstanceRole is false.
 * <p>
 * In an ECS Cluster with <code>MachineImageType.AMAZON_LINUX_2</code>, the canContainersAccessInstanceRole=false option attempts to add commands to block containers from
 * accessing IMDS. CDK cannot guarantee the correct execution of the feature in all platforms. Setting this feature flag
 * to true will ensure CDK does not attempt to implement IMDS blocking. By <ins><strong>end of 2025</strong></ins>, CDK will remove the
 * IMDS blocking feature. See <a href="https://github.com/aws/aws-cdk/discussions/32609">Github discussion</a> for more information.
 * <p>
 * <strong>It is recommended to follow ECS documentation to block IMDS for your specific platform and cluster configuration.</strong>
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ecs:disableEcsImdsBlocking": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ecs:enableImdsBlockingDeprecatedFeature</code></li>
 * </ul>
 * <p>
 * When set to true along with canContainersAccessInstanceRole=false in ECS cluster, new updated commands will be added to UserData to block container accessing IMDS. <strong>Applicable to Linux only.</strong>
 * <p>
 * In an ECS Cluster with <code>MachineImageType.AMAZON_LINUX_2</code>, the canContainersAccessInstanceRole=false option attempts to add commands to block containers from
 * accessing IMDS. Set this flag to true in order to use new and updated commands. Please note that this
 * feature alone with this feature flag will be deprecated by <ins>end of 2025</ins> as CDK cannot
 * guarantee the correct execution of the feature in all platforms. See <a href="https://github.com/aws/aws-cdk/discussions/32609">Github discussion</a> for more information.
 * <p>
 * <strong>It is recommended to follow ECS documentation to block IMDS for your specific platform and cluster configuration.</strong>
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ecs:enableImdsBlockingDeprecatedFeature": false,
 *   },
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-elasticloadbalancingV2:albDualstackWithoutPublicIpv4SecurityGroupRulesDefault</code></li>
 * </ul>
 * <p>
 * When enabled, the default security group ingress rules will allow IPv6 ingress from anywhere,
 * For internet facing ALBs with <code>dualstack-without-public-ipv4</code> IP address type, the default security group rules
 * will allow IPv6 ingress from anywhere (::/0). Previously, the default security group rules would only allow IPv4 ingress.
 * <p>
 * Using a feature flag to make sure existing customers who might be relying
 * on the overly restrictive permissions are not broken.,
 * <p>
 * If the flag is set to false then the default security group rules will only allow IPv4 ingress.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-elasticloadbalancingV2:albDualstackWithoutPublicIpv4SecurityGroupRulesDefault": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-iam:oidcRejectUnauthorizedConnections</code></li>
 * </ul>
 * <p>
 * When this feature flag is enabled, the default behaviour of OIDC Provider's custom resource handler will
 * default to reject unauthorized connections when downloading CA Certificates.
 * <p>
 * When this feature flag is disabled, the behaviour will be the same as current and will allow downloading
 * thumbprints from unsecure connnections.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-iam:oidcRejectUnauthorizedConnections": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/core:enableAdditionalMetadataCollection</code></li>
 * </ul>
 * <p>
 * When this feature flag is enabled, CDK expands the scope of usage data collection to include the:
 * <p>
 * <ul>
 * <li>L2 construct property keys - Collect which property keys you use from the L2 constructs in your app. This includes property keys nested in dictionary objects.</li>
 * <li>L2 construct property values of BOOL and ENUM types - Collect property key values of only BOOL and ENUM types. All other types, such as string values or construct references will be redacted.</li>
 * <li>L2 construct method usage - Collection method name, parameter keys and parameter values of BOOL and ENUM type.</li>
 * </ul>
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/core:enableAdditionalMetadataCollection": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-lambda:createNewPoliciesWithAddToRolePolicy</code></li>
 * </ul>
 * <p>
 * [Deprecated default feature] When this feature flag is enabled, Lambda will create new inline policies with AddToRolePolicy.
 * The purpose of this is to prevent lambda from creating a dependency on the Default Policy Statement.
 * This solves an issue where a circular dependency could occur if adding lambda to something like a Cognito Trigger, then adding the User Pool to the lambda execution role permissions.
 * However in the current implementation, we have removed a dependency of the lambda function on the policy. In addition to this, a Role will be attached to the Policy instead of an inline policy being attached to the role.
 * This will create a data race condition in the CloudFormation template because the creation of the Lambda function no longer waits for the policy to be created. Having said that, we are not deprecating the feature (we are defaulting the feature flag to false for new stacks) since this feature can still be used to get around the circular dependency issue (issue-7016) particularly in cases where the lambda resource creation doesnt need to depend on the policy resource creation.
 * We recommend to unset the feature flag if already set which will restore the original behavior.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-lambda:createNewPoliciesWithAddToRolePolicy": false
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-s3:setUniqueReplicationRoleName</code></li>
 * </ul>
 * <p>
 * When this feature flag is enabled, a unique role name is specified only when performing cross-account replication.
 * When disabled, 'CDKReplicationRole' is always specified.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-s3:setUniqueReplicationRoleName": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/pipelines:reduceStageRoleTrustScope</code></li>
 * </ul>
 * <p>
 * When this feature flag is enabled, the root account principal will not be added to the trust policy of stage role.
 * When this feature flag is disabled, it will keep the root account principal in the trust policy.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/pipelines:reduceStageRoleTrustScope": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-events:requireEventBusPolicySid</code></li>
 * </ul>
 * <p>
 * When this flag is enabled:
 * <p>
 * <ul>
 * <li>Resource policies will be created with Statement IDs for service principals</li>
 * <li>The operation will succeed as expected</li>
 * </ul>
 * <p>
 * When this flag is disabled:
 * <p>
 * <ul>
 * <li>A warning will be emitted</li>
 * <li>The grant operation will be dropped</li>
 * <li>No permissions will be added</li>
 * </ul>
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-events:requireEventBusPolicySid": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-dynamodb:retainTableReplica</code></li>
 * </ul>
 * <p>
 * Currently, table replica will always be deleted when stack deletes regardless of source table's deletion policy.
 * When enabled, table replica will be default to the removal policy of source table unless specified otherwise.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-dynamodb:retainTableReplica": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/cognito:logUserPoolClientSecretValue</code></li>
 * </ul>
 * <p>
 * When this feature flag is enabled, the SDK API call response to desribe user pool client values will be logged in the custom
 * resource lambda function logs.
 * <p>
 * When this feature flag is disabled, the SDK API call response to describe user pool client values will not be logged in the custom
 * resource lambda function logs.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/cognito:logUserPoolClientSecretValue": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-s3:publicAccessBlockedByDefault</code></li>
 * </ul>
 * <p>
 * When BlockPublicAccess is not set at all, s3's default behavior will be to set all options to true in aws console.
 * The previous behavior in cdk before this feature was; if only some of the BlockPublicAccessOptions were set (not all 4), then the ones undefined would default to false.
 * This is counter intuitive to the console behavior where the options would start in true state and a user would uncheck the boxes as needed.
 * The new behavior from this feature will allow a user, for example, to set 1 of the 4 BlockPublicAccessOpsions to false, and on deployment the other 3 will remain true.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-s3:publicAccessBlockedByDefault": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ec2:requirePrivateSubnetsForEgressOnlyInternetGateway</code></li>
 * </ul>
 * <p>
 * When this feature flag is enabled, EgressOnlyGateway is created only for dual-stack VPC with private subnets
 * <p>
 * When this feature flag is disabled, EgressOnlyGateway resource is created for all dual-stack VPC regardless of subnet type
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ec2:requirePrivateSubnetsForEgressOnlyInternetGateway": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-signer:signingProfileNamePassedToCfn</code></li>
 * </ul>
 * <p>
 * When this feature flag is enabled, the <code>signingProfileName</code> property is passed to the L1 <code>CfnSigningProfile</code> construct,
 * which ensures that the AWS Signer profile is created with the specified name.
 * <p>
 * When this feature flag is disabled, the <code>signingProfileName</code> is not passed to CloudFormation, maintaining backward
 * compatibility with existing deployments where CloudFormation auto-generated profile names.
 * <p>
 * This feature flag is needed because enabling it can cause existing signing profiles to be
 * replaced during deployment if a <code>signingProfileName</code> was specified but not previously used
 * in the CloudFormation template.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-signer:signingProfileNamePassedToCfn": true
 *   }
 * }
 * </pre></blockquote>
 */
package software.amazon.awscdk.cxapi;
