package software.amazon.awscdk.pipelines;

/**
 * Defines which stages of a pipeline require the specified credentials.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISecret dockerHubSecret = Secret.fromSecretCompleteArn(this, "DHSecret", "arn:aws:...");
 * // Only the image asset publishing actions will be granted read access to the secret.
 * DockerCredential creds = DockerCredential.dockerHub(dockerHubSecret, ExternalDockerCredentialOptions.builder()
 *         .usages(List.of(DockerCredentialUsage.ASSET_PUBLISHING))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:42.485Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.DockerCredentialUsage")
public enum DockerCredentialUsage {
    /**
     * Synth/Build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SYNTH,
    /**
     * Self-update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SELF_UPDATE,
    /**
     * Asset publishing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ASSET_PUBLISHING,
}
