package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a <code>CfnMethod</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnMethodProps cfnMethodProps = CfnMethodProps.builder()
 *         .httpMethod("httpMethod")
 *         .resourceId("resourceId")
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .apiKeyRequired(false)
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizationType("authorizationType")
 *         .authorizerId("authorizerId")
 *         .integration(IntegrationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .cacheKeyParameters(List.of("cacheKeyParameters"))
 *                 .cacheNamespace("cacheNamespace")
 *                 .connectionId("connectionId")
 *                 .connectionType("connectionType")
 *                 .contentHandling("contentHandling")
 *                 .credentials("credentials")
 *                 .integrationHttpMethod("integrationHttpMethod")
 *                 .integrationResponses(List.of(IntegrationResponseProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentHandling("contentHandling")
 *                         .responseParameters(Map.of(
 *                                 "responseParametersKey", "responseParameters"))
 *                         .responseTemplates(Map.of(
 *                                 "responseTemplatesKey", "responseTemplates"))
 *                         .selectionPattern("selectionPattern")
 *                         .build()))
 *                 .passthroughBehavior("passthroughBehavior")
 *                 .requestParameters(Map.of(
 *                         "requestParametersKey", "requestParameters"))
 *                 .requestTemplates(Map.of(
 *                         "requestTemplatesKey", "requestTemplates"))
 *                 .timeoutInMillis(123)
 *                 .uri("uri")
 *                 .build())
 *         .methodResponses(List.of(MethodResponseProperty.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .responseModels(Map.of(
 *                         "responseModelsKey", "responseModels"))
 *                 .responseParameters(Map.of(
 *                         "responseParametersKey", false))
 *                 .build()))
 *         .operationName("operationName")
 *         .requestModels(Map.of(
 *                 "requestModelsKey", "requestModels"))
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", false))
 *         .requestValidatorId("requestValidatorId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.348Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnMethodProps")
@software.amazon.jsii.Jsii.Proxy(CfnMethodProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMethodProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The method's HTTP verb.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpMethod();

    /**
     * The Resource identifier for the MethodResponse resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * The string identifier of the associated RestApi.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyRequired() {
        return null;
    }

    /**
     * A list of authorization scopes configured on the method.
     * <p>
     * The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return null;
    }

    /**
     * The method's authorization type.
     * <p>
     * This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html">Method</a> in the <em>API Gateway API Reference</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationType() {
        return null;
    }

    /**
     * The identifier of an authorizer to use on this method.
     * <p>
     * The method's authorization type must be <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerId() {
        return null;
    }

    /**
     * Represents an <code>HTTP</code> , <code>HTTP_PROXY</code> , <code>AWS</code> , <code>AWS_PROXY</code> , or Mock integration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIntegration() {
        return null;
    }

    /**
     * Gets a method response associated with a given HTTP status code.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMethodResponses() {
        return null;
    }

    /**
     * A human-friendly operation identifier for the method.
     * <p>
     * For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOperationName() {
        return null;
    }

    /**
     * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequestModels() {
        return null;
    }

    /**
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
     * <p>
     * A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( <code>true</code> ) or optional ( <code>false</code> ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
        return null;
    }

    /**
     * The identifier of a RequestValidator for request validation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRequestValidatorId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMethodProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMethodProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMethodProps> {
        java.lang.String httpMethod;
        java.lang.String resourceId;
        java.lang.String restApiId;
        java.lang.Object apiKeyRequired;
        java.util.List<java.lang.String> authorizationScopes;
        java.lang.String authorizationType;
        java.lang.String authorizerId;
        java.lang.Object integration;
        java.lang.Object methodResponses;
        java.lang.String operationName;
        java.lang.Object requestModels;
        java.lang.Object requestParameters;
        java.lang.String requestValidatorId;

        /**
         * Sets the value of {@link CfnMethodProps#getHttpMethod}
         * @param httpMethod The method's HTTP verb. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(java.lang.String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getResourceId}
         * @param resourceId The Resource identifier for the MethodResponse resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRestApiId}
         * @param restApiId The string identifier of the associated RestApi. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getApiKeyRequired}
         * @param apiKeyRequired A boolean flag specifying whether a valid ApiKey is required to invoke this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(java.lang.Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getApiKeyRequired}
         * @param apiKeyRequired A boolean flag specifying whether a valid ApiKey is required to invoke this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(software.amazon.awscdk.IResolvable apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getAuthorizationScopes}
         * @param authorizationScopes A list of authorization scopes configured on the method.
         *                            The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
            this.authorizationScopes = authorizationScopes;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getAuthorizationType}
         * @param authorizationType The method's authorization type.
         *                          This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html">Method</a> in the <em>API Gateway API Reference</em> .
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(java.lang.String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getAuthorizerId}
         * @param authorizerId The identifier of an authorizer to use on this method.
         *                     The method's authorization type must be <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerId(java.lang.String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getIntegration}
         * @param integration Represents an <code>HTTP</code> , <code>HTTP_PROXY</code> , <code>AWS</code> , <code>AWS_PROXY</code> , or Mock integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.IResolvable integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getIntegration}
         * @param integration Represents an <code>HTTP</code> , <code>HTTP_PROXY</code> , <code>AWS</code> , <code>AWS_PROXY</code> , or Mock integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getMethodResponses}
         * @param methodResponses Gets a method response associated with a given HTTP status code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(software.amazon.awscdk.IResolvable methodResponses) {
            this.methodResponses = methodResponses;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getMethodResponses}
         * @param methodResponses Gets a method response associated with a given HTTP status code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(java.util.List<? extends java.lang.Object> methodResponses) {
            this.methodResponses = methodResponses;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getOperationName}
         * @param operationName A human-friendly operation identifier for the method.
         *                      For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationName(java.lang.String operationName) {
            this.operationName = operationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestModels}
         * @param requestModels A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(java.util.Map<java.lang.String, java.lang.String> requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestModels}
         * @param requestModels A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(software.amazon.awscdk.IResolvable requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestParameters}
         * @param requestParameters A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
         *                          A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( <code>true</code> ) or optional ( <code>false</code> ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(software.amazon.awscdk.IResolvable requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestParameters}
         * @param requestParameters A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
         *                          A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code> , where <code>location</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( <code>true</code> ) or optional ( <code>false</code> ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestValidatorId}
         * @param requestValidatorId The identifier of a RequestValidator for request validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidatorId(java.lang.String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMethodProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMethodProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMethodProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMethodProps {
        private final java.lang.String httpMethod;
        private final java.lang.String resourceId;
        private final java.lang.String restApiId;
        private final java.lang.Object apiKeyRequired;
        private final java.util.List<java.lang.String> authorizationScopes;
        private final java.lang.String authorizationType;
        private final java.lang.String authorizerId;
        private final java.lang.Object integration;
        private final java.lang.Object methodResponses;
        private final java.lang.String operationName;
        private final java.lang.Object requestModels;
        private final java.lang.Object requestParameters;
        private final java.lang.String requestValidatorId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiKeyRequired = software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authorizationType = software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerId = software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.methodResponses = software.amazon.jsii.Kernel.get(this, "methodResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.operationName = software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestModels = software.amazon.jsii.Kernel.get(this, "requestModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requestValidatorId = software.amazon.jsii.Kernel.get(this, "requestValidatorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpMethod = java.util.Objects.requireNonNull(builder.httpMethod, "httpMethod is required");
            this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
            this.apiKeyRequired = builder.apiKeyRequired;
            this.authorizationScopes = builder.authorizationScopes;
            this.authorizationType = builder.authorizationType;
            this.authorizerId = builder.authorizerId;
            this.integration = builder.integration;
            this.methodResponses = builder.methodResponses;
            this.operationName = builder.operationName;
            this.requestModels = builder.requestModels;
            this.requestParameters = builder.requestParameters;
            this.requestValidatorId = builder.requestValidatorId;
        }

        @Override
        public final java.lang.String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final java.lang.Object getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthorizationScopes() {
            return this.authorizationScopes;
        }

        @Override
        public final java.lang.String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final java.lang.String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final java.lang.Object getIntegration() {
            return this.integration;
        }

        @Override
        public final java.lang.Object getMethodResponses() {
            return this.methodResponses;
        }

        @Override
        public final java.lang.String getOperationName() {
            return this.operationName;
        }

        @Override
        public final java.lang.Object getRequestModels() {
            return this.requestModels;
        }

        @Override
        public final java.lang.Object getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final java.lang.String getRequestValidatorId() {
            return this.requestValidatorId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("restApiId", om.valueToTree(this.getRestApiId()));
            if (this.getApiKeyRequired() != null) {
                data.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
            }
            if (this.getAuthorizationScopes() != null) {
                data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
            }
            if (this.getAuthorizationType() != null) {
                data.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
            }
            if (this.getAuthorizerId() != null) {
                data.set("authorizerId", om.valueToTree(this.getAuthorizerId()));
            }
            if (this.getIntegration() != null) {
                data.set("integration", om.valueToTree(this.getIntegration()));
            }
            if (this.getMethodResponses() != null) {
                data.set("methodResponses", om.valueToTree(this.getMethodResponses()));
            }
            if (this.getOperationName() != null) {
                data.set("operationName", om.valueToTree(this.getOperationName()));
            }
            if (this.getRequestModels() != null) {
                data.set("requestModels", om.valueToTree(this.getRequestModels()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestValidatorId() != null) {
                data.set("requestValidatorId", om.valueToTree(this.getRequestValidatorId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnMethodProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMethodProps.Jsii$Proxy that = (CfnMethodProps.Jsii$Proxy) o;

            if (!httpMethod.equals(that.httpMethod)) return false;
            if (!resourceId.equals(that.resourceId)) return false;
            if (!restApiId.equals(that.restApiId)) return false;
            if (this.apiKeyRequired != null ? !this.apiKeyRequired.equals(that.apiKeyRequired) : that.apiKeyRequired != null) return false;
            if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
            if (this.authorizationType != null ? !this.authorizationType.equals(that.authorizationType) : that.authorizationType != null) return false;
            if (this.authorizerId != null ? !this.authorizerId.equals(that.authorizerId) : that.authorizerId != null) return false;
            if (this.integration != null ? !this.integration.equals(that.integration) : that.integration != null) return false;
            if (this.methodResponses != null ? !this.methodResponses.equals(that.methodResponses) : that.methodResponses != null) return false;
            if (this.operationName != null ? !this.operationName.equals(that.operationName) : that.operationName != null) return false;
            if (this.requestModels != null ? !this.requestModels.equals(that.requestModels) : that.requestModels != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            return this.requestValidatorId != null ? this.requestValidatorId.equals(that.requestValidatorId) : that.requestValidatorId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpMethod.hashCode();
            result = 31 * result + (this.resourceId.hashCode());
            result = 31 * result + (this.restApiId.hashCode());
            result = 31 * result + (this.apiKeyRequired != null ? this.apiKeyRequired.hashCode() : 0);
            result = 31 * result + (this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0);
            result = 31 * result + (this.authorizationType != null ? this.authorizationType.hashCode() : 0);
            result = 31 * result + (this.authorizerId != null ? this.authorizerId.hashCode() : 0);
            result = 31 * result + (this.integration != null ? this.integration.hashCode() : 0);
            result = 31 * result + (this.methodResponses != null ? this.methodResponses.hashCode() : 0);
            result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
            result = 31 * result + (this.requestModels != null ? this.requestModels.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestValidatorId != null ? this.requestValidatorId.hashCode() : 0);
            return result;
        }
    }
}
