package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * Vpc vpc = new Vpc(this, "VPC");
 * NetworkLoadBalancer nlb = NetworkLoadBalancer.Builder.create(this, "NLB")
 *         .vpc(vpc)
 *         .build();
 * VpcLink link = VpcLink.Builder.create(this, "link")
 *         .targets(List.of(nlb))
 *         .build();
 * Integration integration = Integration.Builder.create()
 *         .type(IntegrationType.HTTP_PROXY)
 *         .integrationHttpMethod("ANY")
 *         .options(IntegrationOptions.builder()
 *                 .connectionType(ConnectionType.VPC_LINK)
 *                 .vpcLink(link)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.383Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.ConnectionType")
public enum ConnectionType {
    /**
     * For connections through the public routable internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INTERNET,
    /**
     * For private connections between API Gateway and a network load balancer in a VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VPC_LINK,
}
