package software.amazon.awscdk.services.apigateway;

/**
 * Container for defining throttling parameters to API stages or methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaIntegration integration;
 * RestApi api = new RestApi(this, "hello-api");
 * Resource v1 = api.root.addResource("v1");
 * Resource echo = v1.addResource("echo");
 * Method echoMethod = echo.addMethod("GET", integration, MethodOptions.builder().apiKeyRequired(true).build());
 * UsagePlan plan = api.addUsagePlan("UsagePlan", UsagePlanProps.builder()
 *         .name("Easy")
 *         .throttle(ThrottleSettings.builder()
 *                 .rateLimit(10)
 *                 .burstLimit(2)
 *                 .build())
 *         .build());
 * IApiKey key = api.addApiKey("ApiKey");
 * plan.addApiKey(key);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.500Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.ThrottleSettings")
@software.amazon.jsii.Jsii.Proxy(ThrottleSettings.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThrottleSettings extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum API request rate limit over a time ranging from one to a few seconds.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBurstLimit() {
        return null;
    }

    /**
     * The API request steady-state rate limit (average requests per second over an extended period of time).
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRateLimit() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ThrottleSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThrottleSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThrottleSettings> {
        java.lang.Number burstLimit;
        java.lang.Number rateLimit;

        /**
         * Sets the value of {@link ThrottleSettings#getBurstLimit}
         * @param burstLimit The maximum API request rate limit over a time ranging from one to a few seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder burstLimit(java.lang.Number burstLimit) {
            this.burstLimit = burstLimit;
            return this;
        }

        /**
         * Sets the value of {@link ThrottleSettings#getRateLimit}
         * @param rateLimit The API request steady-state rate limit (average requests per second over an extended period of time).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rateLimit(java.lang.Number rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottleSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThrottleSettings build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThrottleSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThrottleSettings {
        private final java.lang.Number burstLimit;
        private final java.lang.Number rateLimit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.burstLimit = software.amazon.jsii.Kernel.get(this, "burstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.rateLimit = software.amazon.jsii.Kernel.get(this, "rateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.burstLimit = builder.burstLimit;
            this.rateLimit = builder.rateLimit;
        }

        @Override
        public final java.lang.Number getBurstLimit() {
            return this.burstLimit;
        }

        @Override
        public final java.lang.Number getRateLimit() {
            return this.rateLimit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBurstLimit() != null) {
                data.set("burstLimit", om.valueToTree(this.getBurstLimit()));
            }
            if (this.getRateLimit() != null) {
                data.set("rateLimit", om.valueToTree(this.getRateLimit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.ThrottleSettings"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThrottleSettings.Jsii$Proxy that = (ThrottleSettings.Jsii$Proxy) o;

            if (this.burstLimit != null ? !this.burstLimit.equals(that.burstLimit) : that.burstLimit != null) return false;
            return this.rateLimit != null ? this.rateLimit.equals(that.rateLimit) : that.rateLimit == null;
        }

        @Override
        public final int hashCode() {
            int result = this.burstLimit != null ? this.burstLimit.hashCode() : 0;
            result = 31 * result + (this.rateLimit != null ? this.rateLimit.hashCode() : 0);
            return result;
        }
    }
}
