package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties for defining a <code>CfnRoutingRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * CfnRoutingRuleProps cfnRoutingRuleProps = CfnRoutingRuleProps.builder()
 *         .actions(List.of(ActionProperty.builder()
 *                 .invokeApi(ActionInvokeApiProperty.builder()
 *                         .apiId("apiId")
 *                         .stage("stage")
 *                         // the properties below are optional
 *                         .stripBasePath(false)
 *                         .build())
 *                 .build()))
 *         .conditions(List.of(ConditionProperty.builder()
 *                 .matchBasePaths(MatchBasePathsProperty.builder()
 *                         .anyOf(List.of("anyOf"))
 *                         .build())
 *                 .matchHeaders(MatchHeadersProperty.builder()
 *                         .anyOf(List.of(MatchHeaderValueProperty.builder()
 *                                 .header("header")
 *                                 .valueGlob("valueGlob")
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .domainNameArn("domainNameArn")
 *         .priority(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.580Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnRoutingRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRoutingRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRoutingRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The resulting action based on matching a routing rules condition.
     * <p>
     * Only InvokeApi is supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html#cfn-apigatewayv2-routingrule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html#cfn-apigatewayv2-routingrule-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActions();

    /**
     * The conditions of the routing rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html#cfn-apigatewayv2-routingrule-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html#cfn-apigatewayv2-routingrule-conditions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConditions();

    /**
     * The ARN of the domain name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html#cfn-apigatewayv2-routingrule-domainnamearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html#cfn-apigatewayv2-routingrule-domainnamearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainNameArn();

    /**
     * The order in which API Gateway evaluates a rule.
     * <p>
     * Priority is evaluated from the lowest value to the highest value. Rules can't have the same priority. Priority values 1-1,000,000 are supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html#cfn-apigatewayv2-routingrule-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routingrule.html#cfn-apigatewayv2-routingrule-priority</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * @return a {@link Builder} of {@link CfnRoutingRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRoutingRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRoutingRuleProps> {
        java.lang.Object actions;
        java.lang.Object conditions;
        java.lang.String domainNameArn;
        java.lang.Number priority;

        /**
         * Sets the value of {@link CfnRoutingRuleProps#getActions}
         * @param actions The resulting action based on matching a routing rules condition. This parameter is required.
         *                Only InvokeApi is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingRuleProps#getActions}
         * @param actions The resulting action based on matching a routing rules condition. This parameter is required.
         *                Only InvokeApi is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<? extends java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingRuleProps#getConditions}
         * @param conditions The conditions of the routing rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingRuleProps#getConditions}
         * @param conditions The conditions of the routing rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingRuleProps#getDomainNameArn}
         * @param domainNameArn The ARN of the domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameArn(java.lang.String domainNameArn) {
            this.domainNameArn = domainNameArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingRuleProps#getPriority}
         * @param priority The order in which API Gateway evaluates a rule. This parameter is required.
         *                 Priority is evaluated from the lowest value to the highest value. Rules can't have the same priority. Priority values 1-1,000,000 are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRoutingRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRoutingRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRoutingRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRoutingRuleProps {
        private final java.lang.Object actions;
        private final java.lang.Object conditions;
        private final java.lang.String domainNameArn;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainNameArn = software.amazon.jsii.Kernel.get(this, "domainNameArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.conditions = java.util.Objects.requireNonNull(builder.conditions, "conditions is required");
            this.domainNameArn = java.util.Objects.requireNonNull(builder.domainNameArn, "domainNameArn is required");
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.Object getConditions() {
            return this.conditions;
        }

        @Override
        public final java.lang.String getDomainNameArn() {
            return this.domainNameArn;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("conditions", om.valueToTree(this.getConditions()));
            data.set("domainNameArn", om.valueToTree(this.getDomainNameArn()));
            data.set("priority", om.valueToTree(this.getPriority()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnRoutingRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRoutingRuleProps.Jsii$Proxy that = (CfnRoutingRuleProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!conditions.equals(that.conditions)) return false;
            if (!domainNameArn.equals(that.domainNameArn)) return false;
            return this.priority.equals(that.priority);
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.conditions.hashCode());
            result = 31 * result + (this.domainNameArn.hashCode());
            result = 31 * result + (this.priority.hashCode());
            return result;
        }
    }
}
